/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.dylink.mybatis.plus.util;

import cn.net.vidyo.dylink.mybatis.plus.domain.GeoPoint;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class PointTypeHandler
extends BaseTypeHandler<GeoPoint> {
    public void setNonNullParameter(PreparedStatement ps, int i, GeoPoint parameter, JdbcType jdbcType) throws SQLException {
        ps.setBytes(i, PointTypeHandler.convertPointToWKB(parameter));
    }

    public GeoPoint getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return PointTypeHandler.parseWKBToPoint(rs.getBytes(columnName));
    }

    public GeoPoint getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return PointTypeHandler.parseWKBToPoint(rs.getBytes(columnIndex));
    }

    public GeoPoint getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return PointTypeHandler.parseWKBToPoint(cs.getBytes(columnIndex));
    }

    public static byte[] convertPointToWKB(GeoPoint point) {
        ByteBuffer buffer = ByteBuffer.allocate(25).order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)1);
        buffer.putInt(1);
        buffer.putDouble(point.getLongitude().doubleValue());
        buffer.putDouble(point.getLatitude().doubleValue());
        return buffer.array();
    }

    public static GeoPoint parseWKBToPoint(byte[] wkb) throws SQLException {
        if (wkb == null || wkb.length < 21) {
            return null;
        }
        int offset = wkb.length > 25 ? 4 : 0;
        boolean isLittleEndian = wkb[offset] == 1;
        ByteBuffer buffer = ByteBuffer.wrap(wkb, offset + 5, 16).order(isLittleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
        return new GeoPoint(BigDecimal.valueOf(buffer.getDouble()), BigDecimal.valueOf(buffer.getDouble()));
    }
}

