/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.sdk.vidyo.ws.logic;

import cn.net.vidyo.common.Result;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.MemberFilter;
import cn.net.vidyo.sdk.vidyo.ws.service.VidyoAdminService;
import cn.net.vidyo.sdk.vidyo.ws.service.VidyoUserService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class VidyoApiProxyService {
    String tenantUrl = "";
    String tenantExtension = "";
    String tenantAdminUsername = "";
    String tenantAdminPassword = "";
    VidyoAdminService vidyoAdminService;
    VidyoUserService vidyoUserService;

    public void addUser() {
    }

    public void initAdmin(String tenantUrl, String tenantExtension, String tenantAdminUsername, String tenantAdminPassword) {
        this.tenantUrl = tenantUrl;
        this.tenantExtension = tenantExtension;
        this.tenantAdminUsername = tenantAdminUsername;
        this.tenantAdminPassword = tenantAdminPassword;
        this.vidyoAdminService = this.createAdminService(tenantUrl, tenantAdminUsername, tenantAdminPassword);
    }

    public Result syncRoom(boolean forceUpdate, String subextension, String name) {
        String extension = this.tenantExtension + subextension;
        Result result = this.searchRooms(0, 100, extension);
        if (!result.isSuccess()) {
            return result;
        }
        List rooms = (List)result.getData();
        if (rooms.size() > 0) {
            if (forceUpdate) {
                double roomID = (Double)((Map)rooms.get(0)).get("roomID");
                this.updateRoom((int)roomID, name, extension, "Public", "Default", this.tenantAdminUsername, name, false, "", false, "", false);
                System.out.println("vidyo room exist");
            }
        } else {
            result = this.addRoom(name, extension, "Public", "Default", this.tenantAdminUsername, name, false, "", false, "", false);
            if (!result.isSuccess()) {
                return result;
            }
            result = this.searchRooms(0, 100, extension);
            if (!result.isSuccess()) {
                return result;
            }
            rooms = (List)result.getData();
            if (rooms.size() == 0) {
                return Result.Fail("ERROR add vidyo room fail", 20001);
            }
        }
        return Result.Success(rooms.get(0));
    }

    public Result syncMember(boolean forceUpdate, String subextension, String name, String description, String email, String password, String locationTag) {
        String extension = this.tenantExtension + subextension;
        Result result = this.searchMembers(0, 100, extension);
        if (!result.isSuccess()) {
            return result;
        }
        List members = (List)result.getData();
        String roleName = "Normal";
        String language = "zh_CN";
        if (members.size() > 0) {
            double id = (Double)((Map)members.get(0)).get("memberID");
            if (forceUpdate) {
                this.updateMember((int)id, extension, name, password, roleName, extension, "Default", "Default", locationTag, email, language, "", description, true, true, "");
                System.out.println("update vidyo member " + extension + "  LOCATION:" + locationTag);
                result = this.searchMembers(0, 100, extension);
                if (!result.isSuccess()) {
                    return result;
                }
                members = (List)result.getData();
            }
        } else {
            System.out.println("add vidyo member " + extension + "  LOCATION:" + locationTag);
            result = this.addMember(extension, name, password, roleName, extension, "Default", "Default", locationTag, email, language, "", description, true, true, "");
            if (!result.isSuccess()) {
                return result;
            }
            int memberId = (Integer)result.getData();
            if (memberId > 0) {
                result = this.searchMembers(0, 100, extension);
                if (!result.isSuccess()) {
                    return result;
                }
                members = (List)result.getData();
            }
        }
        if (members.size() == 0) {
            return Result.Fail("ERROR not find member " + extension, 20002);
        }
        return Result.Success(members.get(0));
    }

    public Result addRoom(String name, String extension, String roomType, String ownerName, String description, boolean hasModeratorPI, String moderatorPIN, boolean hasPIN, String roomPIN) {
        boolean islock = false;
        String groupName = "Default";
        return this.addRoom(name, extension, roomType, groupName, ownerName, description, hasModeratorPI, moderatorPIN, hasPIN, roomPIN, islock);
    }

    public Result addRoom(String name, String extension, String roomType, String groupName, String ownerName, String description, boolean hasModeratorPI, String moderatorPIN, boolean hasPIN, String roomPIN, boolean islock) {
        return this.vidyoAdminService.addRoom(name, extension, roomType, groupName, ownerName, description, hasModeratorPI, moderatorPIN, hasPIN, roomPIN, islock);
    }

    public Result updateRoom(int roomId, String name, String extension, String roomType, String ownerName, String description, boolean hasModeratorPI, String moderatorPIN, boolean hasPIN, String roomPIN) {
        boolean islock = false;
        String groupName = "Default";
        return this.updateRoom(roomId, name, extension, roomType, groupName, ownerName, description, hasModeratorPI, moderatorPIN, hasPIN, roomPIN, islock);
    }

    public Result updateRoom(int roomId, String name, String extension, String roomType, String groupName, String ownerName, String description, boolean hasModeratorPI, String moderatorPIN, boolean hasPIN, String roomPIN, boolean islock) {
        boolean b = this.vidyoAdminService.updateRoom(roomId, name, extension, roomType, groupName, ownerName, description, hasModeratorPI, moderatorPIN, hasPIN, roomPIN, islock);
        if (b) {
            return Result.Success();
        }
        return Result.Fail();
    }

    public Result deleteRoom(int roomId) {
        if (this.vidyoAdminService.deleteRoom(roomId)) {
            return Result.Success();
        }
        return Result.Fail();
    }

    public Result searchRooms(int start, int limit, String extension) {
        List<Map> maps = this.vidyoAdminService.getRooms(start, limit, extension);
        return Result.Success(maps);
    }

    public Result searchMembers(int start, int limit, String extension) {
        MemberFilter filter = new MemberFilter();
        filter.setRoomExtension(extension);
        List<Map> maps = this.vidyoAdminService.searchMembers(start, limit, filter);
        return Result.Success(maps);
    }

    public Result updateMember(int memberId, String username, String name, String password, String extension, String locationTag, String email) {
        String instantMessagerID = "";
        String description = "";
        boolean allowCallDirect = true;
        boolean allowPersonalMeeting = true;
        String department = "";
        String language = "zh_CN";
        String location = "";
        String groupName = "Default";
        String roleName = "Normal";
        return this.updateMember(memberId, username, name, password, roleName, extension, groupName, location, locationTag, email, language, instantMessagerID, description, allowCallDirect, allowPersonalMeeting, department);
    }

    public Result updateMember(int memberId, String username, String name, String password, String roleName, String extension, String groupName, String location, String locationTag, String email, String language, String instantMessagerID, String description, boolean allowCallDirect, boolean allowPersonalMeeting, String department) {
        boolean b = this.vidyoAdminService.updateMember(memberId, username, name, password, roleName, extension, groupName, location, locationTag, email, language, instantMessagerID, description, allowCallDirect, allowPersonalMeeting, department);
        if (b) {
            return Result.Success();
        }
        return Result.Fail();
    }

    public Result addMember(String username, String name, String password, String extension, String locationTag, String email) {
        String instantMessagerID = "";
        String description = "";
        boolean allowCallDirect = true;
        boolean allowPersonalMeeting = true;
        String department = "";
        String language = "zh_CN";
        String location = "";
        String groupName = "Default";
        String roleName = "Normal";
        return this.addMember(username, name, password, roleName, extension, groupName, location, locationTag, email, language, instantMessagerID, description, allowCallDirect, allowPersonalMeeting, department);
    }

    public Result addMember(String username, String name, String password, String roleName, String extension, String groupName, String location, String locationTag, String email, String language, String instantMessagerID, String description, boolean allowCallDirect, boolean allowPersonalMeeting, String department) {
        int member = this.vidyoAdminService.addMember(username, name, password, roleName, extension, groupName, location, locationTag, email, language, instantMessagerID, description, allowCallDirect, allowPersonalMeeting, department);
        if (member > 0) {
            return Result.Success();
        }
        return Result.Fail();
    }

    public Result deleteMember(int memberId) {
        if (this.vidyoAdminService.deleteMember(memberId)) {
            return Result.Success();
        }
        return Result.Fail();
    }

    public Result getParticipants(String portal, String adminUsername, String password, int conferenceId) {
        List<Map> participants = this.vidyoAdminService.getParticipants(conferenceId);
        return Result.Success(participants);
    }

    public Result inviteToConferences(String portal, String adminUsername, String password, int conferenceId, String entityIds) {
        List<Object> list = new ArrayList();
        if (entityIds == null) {
            return Result.Success(list);
        }
        VidyoAdminService adminService = this.createAdminService(portal, adminUsername, password);
        String[] values = entityIds.split(",");
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (String value : values) {
            ids.add(Integer.valueOf(value));
        }
        Integer[] array = list.toArray(new Integer[list.size()]);
        list = adminService.inviteToConferences(conferenceId, array);
        return Result.Success(list);
    }

    public Result leaveConferenceAll(String portal, String adminUsername, String password, int conferenceId) {
        ArrayList list = new ArrayList();
        VidyoAdminService adminService = this.createAdminService(portal, adminUsername, password);
        List<Map> participants = adminService.getParticipants(conferenceId);
        for (Map participant : participants) {
            Integer participantid = Integer.valueOf(participant.get("participantid").toString());
            adminService.leaveConference(conferenceId, participantid);
        }
        return Result.Success();
    }

    public Result leaveConference(int conferenceId, int participantid) {
        boolean b = this.vidyoAdminService.leaveConference(conferenceId, participantid);
        if (b) {
            return Result.Success();
        }
        return Result.Fail();
    }

    public Result getEntityIdByEID(String portal, String username, String password, String eid) {
        VidyoUserService userService = this.createUserService(portal, username, password);
        String entityIdByEID = userService.getEntityIdByEID(eid);
        if (entityIdByEID.length() == 0) {
            return Result.Fail();
        }
        return Result.Success(entityIdByEID);
    }

    public Result getConferencedByUsername(String portal, String adminUsername, String password, String username) {
        Map user = this.vidyoAdminService.getMemberByUserName(username);
        if (user == null) {
            return Result.Fail("not find user " + username, 20003);
        }
        String extension = user.get("extension").toString();
        Map map = this.vidyoAdminService.getPersonalRoomByRoomExtension(extension);
        if (map == null) {
            return Result.Fail("not find extension " + extension, 20004);
        }
        return Result.Success(map.get("entityID").toString().replace(".0", ""));
    }

    public VidyoAdminService createAdminService(String portal, String adminUsername, String password) {
        VidyoAdminService vidyoAdminService = new VidyoAdminService();
        vidyoAdminService.setPortal(portal);
        vidyoAdminService.setUsername(adminUsername);
        vidyoAdminService.setPassword(password);
        return vidyoAdminService;
    }

    public VidyoUserService createUserService(String portal, String usernmae, String password) {
        VidyoUserService vidyoUserService = new VidyoUserService();
        vidyoUserService.setPortal(portal);
        vidyoUserService.setUsername(usernmae);
        vidyoUserService.setPassword(password);
        return vidyoUserService;
    }
}

