/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.sdk.vidyo.ws.service;

import cn.net.vidyo.common.CommonErrorEnum;
import cn.net.vidyo.common.Result;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.AddMemberRequest;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.AddMemberResponse;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.AddRoomRequest;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.AddRoomResponse;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.CreateRoomPINRequest;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.CreateRoomPINResponse;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.CreateRoomURLRequest;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.CreateRoomURLResponse;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.DeleteMemberRequest;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.DeleteMemberResponse;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.DeleteRoomRequest;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.DeleteRoomResponse;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.Entity;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.Filter;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.GeneralFault_Element;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.GetLectureModeParticipantsRequest;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.GetLectureModeParticipantsResponse;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.GetMemberRequest;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.GetMemberResponse;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.GetMembersRequest;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.GetMembersResponse;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.GetParticipantsRequest;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.GetParticipantsResponse;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.GetPortalVersionResponse;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.GetRoomRequest;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.GetRoomResponse;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.GetRoomsRequest;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.GetRoomsResponse;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.InvalidArgumentFault_Element;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.InviteToConferenceRequest;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.InviteToConferenceResponse;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.Language;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.LeaveConferenceRequest;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.LeaveConferenceResponse;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.LectureModeParticipant;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.Member;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.MemberFilter;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.NotLicensedFault_Element;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.OK;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.RemovePresenterRequest;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.RemovePresenterResponse;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.RemoveRoomPINRequest;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.RemoveRoomPINResponse;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.ReturnObjectInResponse;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.RoleName;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.Room;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.RoomAlreadyExistsFault;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.RoomDetail;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.RoomMode;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.RoomType;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.SearchMembersRequest;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.SearchMembersResponse;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.SearchRoomsRequest;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.SearchRoomsResponse;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.SetPresenterRequest;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.SetPresenterResponse;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.StartLectureModeRequest;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.StartLectureModeResponse;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.StopLectureModeRequest;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.StopLectureModeResponse;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.UpdateMemberRequest;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.UpdateMemberResponse;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.UpdateRoomRequest;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.UpdateRoomResponse;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.VidyoPortalAdminServiceBindingStub;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.admin.VidyoPortalAdminServiceLocator;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.user.GetPortalVersionRequest;
import cn.net.vidyo.sdk.vidyo.ws.util.ObjectUtils;
import java.lang.constant.Constable;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.rpc.ServiceException;

public class VidyoAdminService {
    String portal;
    String username;
    String password;
    VidyoPortalAdminServiceBindingStub service;

    public boolean inviteToConference(int conferenceId, int entityId) {
        this.init();
        InviteToConferenceRequest request = new InviteToConferenceRequest();
        request.setConferenceID(conferenceId);
        request.setEntityID(entityId);
        new ArrayList();
        try {
            System.out.println("method:inviteToConference");
            InviteToConferenceResponse response = this.service.inviteToConference(request);
            if (response.getOK() == OK.OK) {
                return true;
            }
        }
        catch (NotLicensedFault_Element var6) {
            var6.printStackTrace();
        }
        catch (InvalidArgumentFault_Element var7) {
            var7.printStackTrace();
        }
        catch (GeneralFault_Element var8) {
            var8.printStackTrace();
        }
        catch (RemoteException var9) {
            var9.printStackTrace();
        }
        return false;
    }

    public List<Map> inviteToConferences(int conferenceId, Integer ... entityIds) {
        ArrayList<Map> list = new ArrayList<Map>();
        if (entityIds != null && entityIds.length > 0) {
            Integer[] var4 = entityIds;
            int var5 = entityIds.length;
            for (int var6 = 0; var6 < var5; ++var6) {
                int entityId = var4[var6];
                boolean b = this.inviteToConference(conferenceId, entityId);
                HashMap<String, Constable> map = new HashMap<String, Constable>();
                map.put("entityid", Integer.valueOf(entityId));
                map.put("status", Boolean.valueOf(b));
                list.add(map);
            }
        }
        return list;
    }

    public List<Map> findMember(int start, int limit, String query) {
        this.init();
        GetMembersRequest request = new GetMembersRequest();
        request.setFilter(this.createFilter(start, limit, query));
        ArrayList<Map> list = new ArrayList<Map>();
        try {
            System.out.println("method:getMembers");
            GetMembersResponse response = this.service.getMembers(request);
            if (response.getTotal() > 0) {
                for (Member member : response.getMember()) {
                    list.add(ObjectUtils.objectToMap(member));
                }
            }
        }
        catch (NotLicensedFault_Element var11) {
            var11.printStackTrace();
        }
        catch (InvalidArgumentFault_Element var12) {
            var12.printStackTrace();
        }
        catch (GeneralFault_Element var13) {
            var13.printStackTrace();
        }
        catch (RemoteException var14) {
            var14.printStackTrace();
        }
        return list;
    }

    public boolean startLectureMode(int conferenceId) {
        this.init();
        StartLectureModeRequest request = new StartLectureModeRequest();
        request.setConferenceID(conferenceId);
        new ArrayList();
        try {
            System.out.println("method:startLectureMode");
            StartLectureModeResponse response = this.service.startLectureMode(request);
            if (response.getOK() == OK.OK) {
                return true;
            }
        }
        catch (NotLicensedFault_Element var5) {
            var5.printStackTrace();
        }
        catch (InvalidArgumentFault_Element var6) {
            var6.printStackTrace();
        }
        catch (GeneralFault_Element var7) {
            var7.printStackTrace();
        }
        catch (RemoteException var8) {
            var8.printStackTrace();
        }
        return false;
    }

    public boolean stopLectureMode(int conferenceId) {
        this.init();
        StopLectureModeRequest request = new StopLectureModeRequest();
        request.setConferenceID(conferenceId);
        new ArrayList();
        try {
            System.out.println("method:stopLectureMode");
            StopLectureModeResponse response = this.service.stopLectureMode(request);
            if (response.getOK() == OK.OK) {
                return true;
            }
        }
        catch (NotLicensedFault_Element var5) {
            var5.printStackTrace();
        }
        catch (InvalidArgumentFault_Element var6) {
            var6.printStackTrace();
        }
        catch (GeneralFault_Element var7) {
            var7.printStackTrace();
        }
        catch (RemoteException var8) {
            var8.printStackTrace();
        }
        return false;
    }

    public boolean setPresenter(int conferenceId, int participantID) {
        this.init();
        SetPresenterRequest request = new SetPresenterRequest();
        request.setConferenceID(conferenceId);
        request.setParticipantID(participantID);
        new ArrayList();
        try {
            System.out.println("method:setPresenter");
            SetPresenterResponse response = this.service.setPresenter(request);
            if (response.getOK() == OK.OK) {
                return true;
            }
        }
        catch (NotLicensedFault_Element var6) {
            var6.printStackTrace();
        }
        catch (InvalidArgumentFault_Element var7) {
            var7.printStackTrace();
        }
        catch (GeneralFault_Element var8) {
            var8.printStackTrace();
        }
        catch (RemoteException var9) {
            var9.printStackTrace();
        }
        return false;
    }

    public boolean removePresenter(int conferenceId, int participantID) {
        this.init();
        RemovePresenterRequest request = new RemovePresenterRequest();
        request.setConferenceID(conferenceId);
        request.setParticipantID(participantID);
        new ArrayList();
        try {
            System.out.println("method:removePresenter");
            RemovePresenterResponse response = this.service.removePresenter(request);
            if (response.getOK() == OK.OK) {
                return true;
            }
        }
        catch (NotLicensedFault_Element var6) {
            var6.printStackTrace();
        }
        catch (InvalidArgumentFault_Element var7) {
            var7.printStackTrace();
        }
        catch (GeneralFault_Element var8) {
            var8.printStackTrace();
        }
        catch (RemoteException var9) {
            var9.printStackTrace();
        }
        return false;
    }

    public List<Map> searchRoomsByOwnerName(int start, int limit, String roomtype, String ownerName) {
        return this.searchRooms(start, limit, roomtype, "ownerName", ownerName);
    }

    public Map getPersonalRoomByOwnerName(String ownerName) {
        List<Map> list = this.searchRooms(0, 10, "personal", "roomNameOrExtension", ownerName);
        return list.size() > 0 ? list.get(0) : null;
    }

    public Map getPersonalRoomByRoomExtension(String roomextension) {
        List<Map> list = this.searchRooms(0, 10, "personal", "roomNameOrExtension", roomextension);
        return list.size() > 0 ? list.get(0) : null;
    }

    public Map getPublicRoomByroomName(String ownerName) {
        List<Map> list = this.searchRooms(0, 10, "public", "roomNameOrExtension", ownerName);
        return list.size() > 0 ? list.get(0) : null;
    }

    public Map getPublicRoomByRoomExtension(String roomextension) {
        List<Map> list = this.searchRooms(0, 10, "public", "roomNameOrExtension", roomextension);
        return list.size() > 0 ? list.get(0) : null;
    }

    public List<Map> searchRooms(int start, int limit, String roomtype, String queryField, String query) {
        this.init();
        SearchRoomsRequest request = new SearchRoomsRequest();
        request.setRoomType(roomtype);
        request.setStart(BigInteger.valueOf(start));
        request.setLimit(BigInteger.valueOf(limit));
        if (roomtype != null && roomtype.length() > 0) {
            request.setRoomType(roomtype);
        }
        request.setQuery(query);
        request.setQueryField(queryField);
        ArrayList<Map> list = new ArrayList<Map>();
        try {
            System.out.println("method:searchRooms");
            SearchRoomsResponse response = this.service.searchRooms(request);
            if (response.getTotal() > 0) {
                for (RoomDetail roomDetail : response.getRoomDetail()) {
                    list.add(ObjectUtils.objectToMap(roomDetail));
                }
            }
        }
        catch (NotLicensedFault_Element var13) {
            var13.printStackTrace();
        }
        catch (InvalidArgumentFault_Element var14) {
            var14.printStackTrace();
        }
        catch (GeneralFault_Element var15) {
            var15.printStackTrace();
        }
        catch (RemoteException var16) {
            var16.printStackTrace();
        }
        return list;
    }

    public Map getMemberByUserName(String username) {
        MemberFilter memberFilter = new MemberFilter();
        memberFilter.setMemberName(username);
        List<Map> list = this.searchMembers(0, 10, memberFilter);
        return list.size() > 0 ? list.get(0) : null;
    }

    public Map getMemberByExtension(String extension) {
        MemberFilter memberFilter = new MemberFilter();
        memberFilter.setRoomExtension(extension);
        List<Map> list = this.searchMembers(0, 10, memberFilter);
        return list.size() > 0 ? list.get(0) : null;
    }

    public List<Map> searchMembers(MemberFilter memberFilter, int limit) {
        return this.searchMembers(memberFilter, limit, 1);
    }

    public List<Map> searchMembers(MemberFilter memberFilter, int limit, int start) {
        this.init();
        SearchMembersRequest request = new SearchMembersRequest();
        request.setStart(BigInteger.valueOf(start));
        request.setLimit(BigInteger.valueOf(limit));
        request.setMemberFilter(memberFilter);
        ArrayList<Map> list = new ArrayList<Map>();
        try {
            System.out.println("method:searchMembers");
            SearchMembersResponse response = this.service.searchMembers(request);
            if (response.getTotal() > 0) {
                for (Member member : response.getMember()) {
                    list.add(ObjectUtils.objectToMap(member));
                }
            }
        }
        catch (NotLicensedFault_Element var11) {
            var11.printStackTrace();
        }
        catch (InvalidArgumentFault_Element var12) {
            var12.printStackTrace();
        }
        catch (GeneralFault_Element var13) {
            var13.printStackTrace();
        }
        catch (RemoteException var14) {
            var14.printStackTrace();
        }
        return list;
    }

    public List<Map> searchMembers(int start, int limit, MemberFilter memberFilter) {
        this.init();
        SearchMembersRequest request = new SearchMembersRequest();
        request.setStart(BigInteger.valueOf(start));
        request.setLimit(BigInteger.valueOf(limit));
        request.setMemberFilter(memberFilter);
        ArrayList<Map> list = new ArrayList<Map>();
        try {
            System.out.println("method:searchMembers");
            SearchMembersResponse response = this.service.searchMembers(request);
            if (response.getTotal() > 0) {
                for (Member member : response.getMember()) {
                    list.add(ObjectUtils.objectToMap(member));
                }
            }
        }
        catch (NotLicensedFault_Element var11) {
            var11.printStackTrace();
        }
        catch (InvalidArgumentFault_Element var12) {
            var12.printStackTrace();
        }
        catch (GeneralFault_Element var13) {
            var13.printStackTrace();
        }
        catch (RemoteException var14) {
            var14.printStackTrace();
        }
        return list;
    }

    public List<Map> getMembers(int start, int limit, String query) {
        this.init();
        GetMembersRequest request = new GetMembersRequest();
        request.setFilter(this.createFilter(start, limit, query));
        ArrayList<Map> list = new ArrayList<Map>();
        try {
            System.out.println("method:getMembers");
            GetMembersResponse response = this.service.getMembers(request);
            if (response.getTotal() > 0) {
                for (Member member : response.getMember()) {
                    list.add(ObjectUtils.objectToMap(member));
                }
            }
        }
        catch (NotLicensedFault_Element var11) {
            var11.printStackTrace();
        }
        catch (InvalidArgumentFault_Element var12) {
            var12.printStackTrace();
        }
        catch (GeneralFault_Element var13) {
            var13.printStackTrace();
        }
        catch (RemoteException var14) {
            var14.printStackTrace();
        }
        return list;
    }

    public Map getMember(int memberId) {
        this.init();
        GetMemberRequest request = new GetMemberRequest();
        request.setMemberID(memberId);
        try {
            System.out.println("method:getMember");
            GetMemberResponse response = this.service.getMember(request);
            if (response.getMember() != null) {
                return ObjectUtils.objectToMap(response.getMember());
            }
        }
        catch (NotLicensedFault_Element var4) {
            var4.printStackTrace();
        }
        catch (InvalidArgumentFault_Element var5) {
            var5.printStackTrace();
        }
        catch (GeneralFault_Element var6) {
            var6.printStackTrace();
        }
        catch (RemoteException var7) {
            var7.printStackTrace();
        }
        return null;
    }

    public int addMember(String username, String name, String description, String password, String extension, String locationTag, String email) {
        String instantMessagerID = "";
        boolean allowCallDirect = true;
        boolean allowPersonalMeeting = true;
        String department = "";
        String language = "zh_CN";
        String location = "";
        String groupName = "Default";
        String roleName = "Normal";
        return this.addMember(username, name, password, roleName, extension, groupName, location, locationTag, email, language, instantMessagerID, description, allowCallDirect, allowPersonalMeeting, department);
    }

    public int addMember(String username, String name, String password, String roleName, String extension, String groupName, String location, String locationTag, String email, String language, String instantMessagerID, String description, boolean allowCallDirect, boolean allowPersonalMeeting, String department) {
        this.init();
        Member member = new Member();
        member.setName(username);
        member.setDisplayName(name);
        member.setEmailAddress(email);
        member.setExtension(extension);
        member.setGroupName(groupName);
        member.setLocation(location);
        member.setLocationTag(locationTag);
        member.setDescription(description);
        member.setAllowCallDirect(allowCallDirect);
        member.setAllowPersonalMeeting(allowPersonalMeeting);
        member.setDepartment(department);
        member.setLanguage(Language.fromValue(language));
        member.setInstantMessagerID(instantMessagerID);
        member.setPassword(password);
        member.setRoleName(RoleName.fromValue(roleName));
        AddMemberRequest request = new AddMemberRequest();
        request.setMember(member);
        ReturnObjectInResponse inResponse = ReturnObjectInResponse.value1;
        request.setReturnObjectInResponse(inResponse);
        new ArrayList();
        try {
            AddMemberResponse response = this.service.addMember(request);
            if (response.getOK() == OK.OK) {
                return response.getMember().getMemberID();
            }
        }
        catch (RemoteException var21) {
            var21.printStackTrace();
        }
        return 0;
    }

    public boolean updateMember(int memberId, String username, String name, String password, String extension, String locationTag, String email) {
        String instantMessagerID = "";
        String description = "";
        boolean allowCallDirect = true;
        boolean allowPersonalMeeting = true;
        String department = "";
        String language = "zh_CN";
        String location = "";
        String groupName = "Default";
        String roleName = "Normal";
        return this.updateMember(memberId, username, name, password, roleName, extension, groupName, location, locationTag, email, language, instantMessagerID, description, allowCallDirect, allowPersonalMeeting, department);
    }

    public boolean updateMember(int memberId, String username, String name, String password, String roleName, String extension, String groupName, String location, String locationTag, String email, String language, String instantMessagerID, String description, boolean allowCallDirect, boolean allowPersonalMeeting, String department) {
        this.init();
        Member member = new Member();
        member.setName(username);
        member.setDisplayName(name);
        member.setEmailAddress(email);
        member.setExtension(extension);
        member.setGroupName(groupName);
        member.setLocation(location);
        member.setLocationTag(locationTag);
        member.setDescription(description);
        member.setAllowCallDirect(allowCallDirect);
        member.setAllowPersonalMeeting(allowPersonalMeeting);
        member.setDepartment(department);
        member.setLanguage(Language.fromValue(language));
        member.setInstantMessagerID(instantMessagerID);
        member.setPassword(password);
        member.setRoleName(RoleName.fromValue(roleName));
        UpdateMemberRequest request = new UpdateMemberRequest();
        request.setMember(member);
        request.setMemberID(memberId);
        new ArrayList();
        try {
            UpdateMemberResponse response = this.service.updateMember(request);
            if (response.getOK() == OK.OK) {
                return true;
            }
        }
        catch (RemoteException var21) {
            var21.printStackTrace();
        }
        return false;
    }

    public boolean deleteMember(int memberId) {
        this.init();
        DeleteMemberRequest request = new DeleteMemberRequest();
        request.setMemberID(memberId);
        try {
            DeleteMemberResponse response = this.service.deleteMember(request);
            if (response.getOK() == OK.OK) {
                return true;
            }
        }
        catch (RemoteException var4) {
            var4.printStackTrace();
        }
        return false;
    }

    public List<Map> getRooms(int start, int limit, String query) {
        this.init();
        GetRoomsRequest request = new GetRoomsRequest();
        request.setFilter(this.createFilter(start, limit, query));
        ArrayList<Map> list = new ArrayList<Map>();
        try {
            System.out.println("method:getRooms");
            GetRoomsResponse response = this.service.getRooms(request);
            if (response.getTotal() > 0) {
                for (Room room : response.getRoom()) {
                    list.add(ObjectUtils.objectToMap(room));
                }
            }
        }
        catch (NotLicensedFault_Element var11) {
            var11.printStackTrace();
        }
        catch (InvalidArgumentFault_Element var12) {
            var12.printStackTrace();
        }
        catch (GeneralFault_Element var13) {
            var13.printStackTrace();
        }
        catch (RemoteException var14) {
            var14.printStackTrace();
        }
        return list;
    }

    public Map getRoom(int roomid) {
        this.init();
        GetRoomRequest request = new GetRoomRequest();
        request.setRoomID(roomid);
        try {
            System.out.println("method:getRoom");
            GetRoomResponse response = this.service.getRoom(request);
            if (response.getRoom() != null) {
                Map<String, Object> stringObjectMap = ObjectUtils.objectToMap(response.getRoom());
                return stringObjectMap;
            }
        }
        catch (NotLicensedFault_Element var5) {
            var5.printStackTrace();
        }
        catch (InvalidArgumentFault_Element var6) {
            var6.printStackTrace();
        }
        catch (GeneralFault_Element var7) {
            var7.printStackTrace();
        }
        catch (RemoteException var8) {
            var8.printStackTrace();
        }
        return null;
    }

    public Result addRoom(String name, String extension, String roomType, String ownerName, String description, boolean hasModeratorPI, String moderatorPIN, boolean hasPIN, String roomPIN) {
        boolean islock = false;
        String groupName = "Default";
        return this.addRoom(name, extension, roomType, groupName, ownerName, description, hasModeratorPI, moderatorPIN, hasPIN, roomPIN, islock);
    }

    public Result addRoom(String name, String extension, String roomType, String groupName, String ownerName, String description, boolean hasModeratorPI, String moderatorPIN, boolean hasPIN, String roomPIN, boolean islock) {
        this.init();
        Room room = new Room();
        RoomMode roomMode = new RoomMode();
        roomMode.setHasModeratorPIN(hasModeratorPI);
        roomMode.setModeratorPIN(moderatorPIN);
        roomMode.setHasPIN(hasPIN);
        roomMode.setRoomPIN(roomPIN);
        roomMode.setIsLocked(islock);
        room.setRoomMode(roomMode);
        room.setGroupName(groupName);
        room.setName(name);
        room.setRoomType(RoomType.fromValue(roomType));
        room.setDescription(description);
        room.setOwnerName(ownerName);
        room.setExtension(extension);
        AddRoomRequest request = new AddRoomRequest();
        request.setRoom(room);
        try {
            AddRoomResponse response = this.service.addRoom(request);
            if (response.getOK() == OK.OK) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                if (response.getRoom() != null) {
                    map.put("roomid", response.getRoom().getRoomID());
                    map.put("roomurl", response.getRoom().getRoomMode().getRoomURL());
                } else {
                    map.put("roomid", 0);
                    map.put("roomurl", "");
                }
                return Result.Success(map);
            }
        }
        catch (RoomAlreadyExistsFault var18) {
            System.out.println("ERROR:Room exist for name");
            return Result.Fail(CommonErrorEnum.RoomAlreadyExists);
        }
        catch (RemoteException var19) {
            var19.printStackTrace();
        }
        return Result.Fail(CommonErrorEnum.RemoteException);
    }

    public boolean updateRoom(int roomId, String name, String extension, String roomType, String ownerName, String description, boolean hasModeratorPI, String moderatorPIN, boolean hasPIN, String roomPIN) {
        boolean islock = false;
        String groupName = "Default";
        return this.updateRoom(roomId, name, extension, roomType, groupName, ownerName, description, hasModeratorPI, moderatorPIN, hasPIN, roomPIN, islock);
    }

    public boolean updateRoom(int roomId, String name, String extension, String roomType, String groupName, String ownerName, String description, boolean hasModeratorPI, String moderatorPIN, boolean hasPIN, String roomPIN, boolean islock) {
        this.init();
        Room room = new Room();
        RoomMode roomMode = new RoomMode();
        roomMode.setHasModeratorPIN(hasModeratorPI);
        roomMode.setModeratorPIN(moderatorPIN);
        roomMode.setHasPIN(hasPIN);
        roomMode.setRoomPIN(roomPIN);
        roomMode.setIsLocked(islock);
        room.setRoomMode(roomMode);
        room.setGroupName(groupName);
        room.setName(name);
        room.setRoomType(RoomType.fromValue(roomType));
        room.setDescription(description);
        room.setOwnerName(ownerName);
        room.setExtension(extension);
        UpdateRoomRequest request = new UpdateRoomRequest();
        request.setRoom(room);
        request.setRoomID(roomId);
        new ArrayList();
        try {
            UpdateRoomResponse response = this.service.updateRoom(request);
            if (response.getOK() == OK.OK) {
                return true;
            }
        }
        catch (RemoteException var18) {
            var18.printStackTrace();
        }
        return false;
    }

    public boolean deleteRoom(int roomId) {
        this.init();
        DeleteRoomRequest request = new DeleteRoomRequest();
        request.setRoomID(roomId);
        try {
            DeleteRoomResponse response = this.service.deleteRoom(request);
            if (response.getOK() == OK.OK) {
                return true;
            }
        }
        catch (RemoteException var4) {
            var4.printStackTrace();
        }
        return false;
    }

    public List<Map> getParticipants(int conferenceId) {
        this.init();
        GetParticipantsRequest request = new GetParticipantsRequest();
        request.setFilter(this.createFilter(0, 200, ""));
        request.setConferenceID(conferenceId);
        ArrayList<Map> list = new ArrayList<Map>();
        try {
            System.out.println("method:getParticipants");
            GetParticipantsResponse response = this.service.getParticipants(request);
            if (response.getTotal() > 0) {
                for (Entity entity : response.getEntity()) {
                    list.add(ObjectUtils.objectToMap(entity));
                }
            }
        }
        catch (NotLicensedFault_Element var9) {
            var9.printStackTrace();
        }
        catch (InvalidArgumentFault_Element var10) {
            var10.printStackTrace();
        }
        catch (GeneralFault_Element var11) {
            var11.printStackTrace();
        }
        catch (RemoteException var12) {
            var12.printStackTrace();
        }
        return list;
    }

    public List<Map> getLectureModeParticipants(int conferenceId) {
        this.init();
        GetLectureModeParticipantsRequest request = new GetLectureModeParticipantsRequest();
        request.setFilter(this.createFilter(0, 200, ""));
        request.setConferenceID(conferenceId);
        ArrayList<Map> list = new ArrayList<Map>();
        try {
            System.out.println("method:getLectureModeParticipants");
            GetLectureModeParticipantsResponse response = this.service.getLectureModeParticipants(request);
            if (response.getTotal() > 0) {
                for (LectureModeParticipant lectureModeParticipant : response.getLectureModeParticipant()) {
                    list.add(ObjectUtils.objectToMap(lectureModeParticipant));
                }
            }
        }
        catch (NotLicensedFault_Element var9) {
            var9.printStackTrace();
        }
        catch (InvalidArgumentFault_Element var10) {
            var10.printStackTrace();
        }
        catch (GeneralFault_Element var11) {
            var11.printStackTrace();
        }
        catch (RemoteException var12) {
            var12.printStackTrace();
        }
        return list;
    }

    public boolean leaveConference(int conferenceId, int participantID) {
        this.init();
        LeaveConferenceRequest request = new LeaveConferenceRequest();
        request.setConferenceID(conferenceId);
        request.setParticipantID(participantID);
        new ArrayList();
        try {
            System.out.println("method:leaveConference");
            LeaveConferenceResponse response = this.service.leaveConference(request);
            if (response.getOK() == OK.OK) {
                return true;
            }
        }
        catch (NotLicensedFault_Element var6) {
            var6.printStackTrace();
        }
        catch (InvalidArgumentFault_Element var7) {
            var7.printStackTrace();
        }
        catch (GeneralFault_Element var8) {
            var8.printStackTrace();
        }
        catch (RemoteException var9) {
            var9.printStackTrace();
        }
        return false;
    }

    public boolean createRoomURL(int roomId) {
        this.init();
        CreateRoomURLRequest request = new CreateRoomURLRequest();
        request.setRoomID(roomId);
        try {
            CreateRoomURLResponse response = this.service.createRoomURL(request);
            if (response.getOK() == OK.OK) {
                return true;
            }
        }
        catch (RemoteException var4) {
            var4.printStackTrace();
        }
        return false;
    }

    public boolean createRoomPIN(int roomId, String pin) {
        this.init();
        CreateRoomPINRequest request = new CreateRoomPINRequest();
        request.setPIN(pin);
        request.setRoomID(roomId);
        new ArrayList();
        try {
            CreateRoomPINResponse response = this.service.createRoomPIN(request);
            if (response.getOK() == OK.OK) {
                return true;
            }
        }
        catch (RemoteException var6) {
            var6.printStackTrace();
        }
        return false;
    }

    public boolean removeRoomPIN(int roomId) {
        this.init();
        RemoveRoomPINRequest request = new RemoveRoomPINRequest();
        request.setRoomID(roomId);
        new ArrayList();
        try {
            RemoveRoomPINResponse response = this.service.removeRoomPIN(request);
            if (response.getOK() == OK.OK) {
                return true;
            }
        }
        catch (RemoteException var5) {
            var5.printStackTrace();
        }
        return false;
    }

    public String getPortalVersion() {
        this.init();
        new GetPortalVersionRequest();
        try {
            GetPortalVersionResponse response = this.service.getPortalVersion(null);
            return response.getPortalVersion();
        }
        catch (RemoteException var3) {
            var3.printStackTrace();
            return null;
        }
    }

    public boolean reinit() {
        return this.init(true);
    }

    public boolean init() {
        return this.init(false);
    }

    public boolean init(boolean isForce) {
        if (!isForce && this.service != null) {
            return true;
        }
        try {
            VidyoPortalAdminServiceLocator vidyoPortalAdminService = new VidyoPortalAdminServiceLocator();
            URL url = new URL(this.portal + "/services/v1_1/VidyoPortalAdminService/");
            System.out.println("ws url:" + url.toString());
            this.service = (VidyoPortalAdminServiceBindingStub)vidyoPortalAdminService.getVidyoPortalAdminServicePort(url);
            this.service.setUsername(this.username);
            this.service.setPassword(this.password);
            return true;
        }
        catch (MalformedURLException var4) {
            var4.printStackTrace();
        }
        catch (ServiceException var5) {
            var5.printStackTrace();
        }
        return false;
    }

    protected Filter createFilter(int start, int limit, String query) {
        Filter filter = new Filter();
        filter.setStart(start);
        filter.setLimit(limit);
        if (query.length() > 0) {
            filter.setQuery(query);
        }
        return filter;
    }

    public String getPortal() {
        return this.portal;
    }

    public void setPortal(String portal) {
        this.portal = portal;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

