/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.sdk.vidyo.ws.service;

import cn.net.vidyo.common.CommonErrorEnum;
import cn.net.vidyo.common.Result;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.superapi.GetLocationTagsRequest;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.superapi.ListTenantsRequest;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.superapi.LocationTag;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.superapi.SingleTenantDataType;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.superapi.VidyoPortalSuperServiceBindingStub;
import cn.net.vidyo.sdk.vidyo.ws.asix.v11.superapi.VidyoPortalSuperServiceLocator;
import cn.net.vidyo.sdk.vidyo.ws.util.ObjectUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.rpc.ServiceException;

public class VidyoSuperService {
    String portal;
    String username;
    String password;
    VidyoPortalSuperServiceBindingStub service;

    public Result getListOfTenants() {
        this.init();
        try {
            ListTenantsRequest request = new ListTenantsRequest();
            request.setLimit(100);
            request.setStart(0);
            SingleTenantDataType[] Response = this.service.getListOfTenants(request);
            if (Response != null && Response.length != 0) {
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
                SingleTenantDataType[] var4 = Response;
                int var5 = Response.length;
                for (int var6 = 0; var6 < var5; ++var6) {
                    SingleTenantDataType singleTenantDataType = var4[var6];
                    list.add(ObjectUtils.objectToMap(singleTenantDataType));
                }
                return Result.Success(list);
            }
            return Result.Fail(CommonErrorEnum.NullValue);
        }
        catch (RemoteException var8) {
            var8.printStackTrace();
            return Result.Fail(CommonErrorEnum.NullValue);
        }
    }

    public Result getLocationTags() {
        this.init();
        ArrayList<String> list = new ArrayList<String>();
        try {
            GetLocationTagsRequest request = new GetLocationTagsRequest();
            LocationTag[] response = this.service.getLocationTags(request);
            if (response == null || response.length == 0) {
                return Result.Success(list);
            }
            LocationTag[] var4 = response;
            int var5 = response.length;
            for (int var6 = 0; var6 < var5; ++var6) {
                LocationTag locationTag = var4[var6];
                list.add(locationTag.getLocationTagName());
            }
        }
        catch (RemoteException var8) {
            var8.printStackTrace();
            return Result.Fail(CommonErrorEnum.RemoteException);
        }
        return Result.Success(list);
    }

    public boolean reinit() {
        return this.init(true);
    }

    public boolean init() {
        return this.init(false);
    }

    public boolean init(boolean isForce) {
        if (!isForce && this.service != null) {
            return true;
        }
        try {
            VidyoPortalSuperServiceLocator vidyoPortalSuperService = new VidyoPortalSuperServiceLocator();
            URL url = new URL(this.portal + "/services/VidyoPortalSuperService/");
            System.out.println("ws url:" + url.toString());
            this.service = (VidyoPortalSuperServiceBindingStub)vidyoPortalSuperService.getVidyoPortalSuperServicePort(url);
            this.service.setUsername(this.username);
            this.service.setPassword(this.password);
            return true;
        }
        catch (MalformedURLException var4) {
            var4.printStackTrace();
        }
        catch (ServiceException var5) {
            var5.printStackTrace();
        }
        return false;
    }

    public String getPortal() {
        return this.portal;
    }

    public void setPortal(String portal) {
        this.portal = portal;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

