/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.sdk.vidyo.ws.util;

import java.math.BigDecimal;
import java.util.Map;

public class ValueUtils {
    public static String mapValueToString(Map map, String key) {
        return ValueUtils.mapValueToString(map, key, "");
    }

    public static String mapValueToString(Map map, String key, String defaultValue) {
        return map != null && map.containsKey(key) ? ValueUtils.toString(map.get(key), defaultValue) : defaultValue;
    }

    public static int mapValueToInt(Map map, String key) {
        return ValueUtils.mapValueToInt(map, key, 0);
    }

    public static int mapValueToInt(Map map, String key, int defaultValue) {
        String value = ValueUtils.mapValueToString(map, key, "");
        if (value == "") {
            return defaultValue;
        }
        value = value.replace(".0", "");
        return Integer.valueOf(value);
    }

    public static float mapValueToFloat(Map map, String key) {
        return ValueUtils.mapValueToFloat(map, key, 0);
    }

    public static float mapValueToFloat(Map map, String key, int defaultValue) {
        String value = ValueUtils.mapValueToString(map, key, "");
        if (value == "") {
            return defaultValue;
        }
        value = value.replace(".0", "");
        return Float.valueOf(value).floatValue();
    }

    public static long mapValueToLong(Map map, String key) {
        return ValueUtils.mapValueToLong(map, key, 0L);
    }

    public static long mapValueToLong(Map map, String key, long defaultValue) {
        String value = ValueUtils.mapValueToString(map, key, "");
        if (value == "") {
            return defaultValue;
        }
        value = value.replace(".0", "");
        return Long.valueOf(value);
    }

    public static double mapValueToDouble(Map map, String key) {
        return ValueUtils.mapValueToDouble(map, key, 0.0);
    }

    public static double mapValueToDouble(Map map, String key, double defaultValue) {
        String value = ValueUtils.mapValueToString(map, key, "");
        return value == "" ? defaultValue : Double.valueOf(value);
    }

    public static short mapValueToShort(Map map, String key) {
        short val = 0;
        return ValueUtils.mapValueToShort(map, key, val);
    }

    public static short mapValueToShort(Map map, String key, short defaultValue) {
        String value = ValueUtils.mapValueToString(map, key, "");
        if (value == "") {
            return defaultValue;
        }
        value = value.replace(".0", "");
        return Short.valueOf(value);
    }

    public static boolean mapValueToBoolean(Map map, String key) {
        return ValueUtils.mapValueToBoolean(map, key, false);
    }

    public static boolean mapValueToBoolean(Map map, String key, boolean defaultValue) {
        String value = ValueUtils.mapValueToString(map, key, "");
        return value == "" ? defaultValue : Boolean.valueOf(value);
    }

    public static byte mapValueToByte(Map map, String key) {
        byte val = 0;
        return ValueUtils.mapValueToByte(map, key, val);
    }

    public static byte mapValueToByte(Map map, String key, byte defaultValue) {
        String value = ValueUtils.mapValueToString(map, key, "");
        return value == "" ? defaultValue : Byte.parseByte(value);
    }

    public static <E extends Enum<E>> E mapValueToEnum(Map map, String key, Class<E> eClass, E defaultValue) {
        String value = ValueUtils.mapValueToString(map, key, "");
        return value == "" ? defaultValue : Enum.valueOf(eClass, value);
    }

    public static String toString(Object data) {
        return ValueUtils.toString(data, "");
    }

    public static String toString(Object data, String defaultValue) {
        return data == null ? defaultValue : data.toString();
    }

    public static int toInt(Object data) {
        return ValueUtils.toInt(data, 0);
    }

    public static int toInt(Object data, int defaultValue) {
        String value = ValueUtils.toString(data, "");
        if (value == "") {
            return defaultValue;
        }
        value = value.replace(".0", "");
        return Integer.valueOf(value);
    }

    public static float toFloat(Object data) {
        return ValueUtils.toFloat(data, 0);
    }

    public static float toFloat(Object data, int defaultValue) {
        String value = ValueUtils.toString(data, "");
        if (value == "") {
            return defaultValue;
        }
        value = value.replace(".0", "");
        return Float.valueOf(value).floatValue();
    }

    public static long toLong(Object data) {
        return ValueUtils.toLong(data, 0L);
    }

    public static long toLong(Object data, long defaultValue) {
        String value = ValueUtils.toString(data, "");
        if (value == "") {
            return defaultValue;
        }
        if ((value = value.replace(".0", "")).indexOf("E") > 0) {
            BigDecimal bd = new BigDecimal(value);
            return bd.longValue();
        }
        return Long.valueOf(value);
    }

    public static double toDouble(Object data) {
        return ValueUtils.toDouble(data, 0.0);
    }

    public static double toDouble(Object data, double defaultValue) {
        String value = ValueUtils.toString(data, "");
        return value == "" ? defaultValue : Double.valueOf(value);
    }

    public static short toShort(Object data) {
        short val = 0;
        return ValueUtils.toShort(data, val);
    }

    public static short toShort(Object data, short defaultValue) {
        String value = ValueUtils.toString(data, "");
        if (value == "") {
            return defaultValue;
        }
        value = value.replace(".0", "");
        return Short.valueOf(value);
    }

    public static boolean toBoolean(Object data) {
        return ValueUtils.toBoolean(data, false);
    }

    public static boolean toBoolean(Object data, boolean defaultValue) {
        String value = ValueUtils.toString(data, "");
        return value == "" ? defaultValue : Boolean.valueOf(value);
    }

    public static byte toByte(Object data) {
        byte val = 0;
        return ValueUtils.toByte(data, val);
    }

    public static byte toByte(Object data, byte defaultValue) {
        String value = ValueUtils.toString(data, "");
        return value == "" ? defaultValue : Byte.parseByte(value);
    }

    public static <E extends Enum<E>> E toEnum(Object data, Class<E> eClass, E defaultValue) {
        String value = ValueUtils.toString(data, "");
        return value == "" ? defaultValue : Enum.valueOf(eClass, value);
    }
}

