/*
 * Decompiled with CFR 0.152.
 */
package org.hy.microservice.common;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hy.common.Date;
import org.hy.common.Help;
import org.hy.common.StringHelp;
import org.hy.common.app.Param;
import org.hy.common.xml.XJava;
import org.hy.common.xml.log.Logger;
import org.hy.microservice.common.user.UserSSO;
import org.hy.microservice.common.user.UserService;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
public class CommonInterceptor
implements HandlerInterceptor {
    private static final Logger $Logger = new Logger(CommonInterceptor.class);

    public boolean preHandle(HttpServletRequest i_Request, HttpServletResponse i_Response, Object i_Handler) throws Exception {
        if (!this.attackJSCheck(i_Request, i_Response)) {
            return false;
        }
        if (!Help.isNull((Object[])i_Request.getCookies())) {
            int v_CSize = i_Request.getCookies().length;
            try {
                for (int i = 0; i < v_CSize; ++i) {
                    i_Request.getCookies()[i].setHttpOnly(true);
                }
            }
            catch (Exception exce) {
                exce.printStackTrace();
            }
        }
        this.corsCheck(i_Request, i_Response);
        return true;
    }

    private boolean attackJSCheck(HttpServletRequest i_Request, HttpServletResponse i_Response) {
        if (!Help.isNull((Map)i_Request.getParameterMap())) {
            for (Map.Entry v_Item : i_Request.getParameterMap().entrySet()) {
                if (StringHelp.isContains((String)((String)v_Item.getKey()), (String[])new String[]{"<", ">", "script", "alert", "console"})) {
                    this.attackJSSendAlarm(i_Request, StringHelp.replaceAll((String)((String)v_Item.getKey()), (String[])new String[]{"<", ">"}, (String[])new String[]{"@"}));
                    return false;
                }
                if (Help.isNull((Object[])((String[])v_Item.getValue()))) continue;
                for (String v_Value : (String[])v_Item.getValue()) {
                    if (!StringHelp.isContains((String)v_Value, (String[])new String[]{"<", ">", "script", "alert", "console"})) continue;
                    this.attackJSSendAlarm(i_Request, StringHelp.replaceAll((String)v_Value, (String[])new String[]{"<", ">"}, (String[])new String[]{"@"}));
                    return false;
                }
            }
        }
        return true;
    }

    private void attackJSSendAlarm(HttpServletRequest i_Request, String i_ParamInfo) {
        UserSSO v_LoginUser = ((UserService)XJava.getObject((String)"UserService")).sessionGetUser(i_Request.getSession());
        String v_UserName = "\u533f\u540d\u7528\u6237";
        String v_UserCode = "\u672a\u767b\u5f55";
        if (v_LoginUser != null) {
            v_UserName = Help.NVL((String)v_LoginUser.getUserName());
            v_UserCode = Help.NVL((String)v_LoginUser.getUserCode());
        }
        String v_Msg = v_UserName + "(" + v_UserCode + ") \u8bf7\u6c42\u9875\u9762\uff1a" + i_Request.getRequestURL().toString() + ":" + Help.NVL((String)i_Request.getQueryString()) + ":" + i_ParamInfo + "\u3002" + Date.getNowTime().getFull();
        $Logger.warn(XJava.getParam((String)"MS_Common_ServiceName").getValue() + "\uff1a\u6ce8\u5165\u653b\u51fb\uff1a" + v_Msg);
    }

    private void corsSendAlarm(HttpServletRequest i_Request, String i_ParamInfo) {
        UserSSO v_LoginUser = ((UserService)XJava.getObject((String)"UserService")).sessionGetUser(i_Request.getSession());
        String v_UserName = "\u533f\u540d\u7528\u6237";
        String v_UserCode = "\u672a\u767b\u5f55";
        if (v_LoginUser != null) {
            v_UserName = v_LoginUser.getUserName();
            v_UserCode = v_LoginUser.getUserCode();
        }
        String v_Msg = v_UserName + "(" + v_UserCode + ") \u8bf7\u6c42\u9875\u9762\uff1a" + i_Request.getRequestURL().toString() + ":" + Help.NVL((String)i_Request.getQueryString()) + ":" + i_ParamInfo + "\u3002" + Date.getNowTime().getFull();
        $Logger.warn(XJava.getParam((String)"MS_Common_ServiceName").getValue() + "\uff1a\u975e\u6cd5\u8de8\u57df\uff1a" + v_Msg);
    }

    private void corsCheck(HttpServletRequest i_Request, HttpServletResponse i_Response) {
        try {
            String v_OriginHead = i_Request.getHeader("Origin");
            if (!Help.isNull((String)v_OriginHead)) {
                String v_OriginHeadLC = StringHelp.replaceAll((String)v_OriginHead.toLowerCase().trim(), (String[])new String[]{"https://", "http://"}, (String[])StringHelp.$ReplaceNil);
                if (this.corsIsAllowDNS(v_OriginHeadLC) || this.corsIsAllowIP(v_OriginHeadLC)) {
                    i_Response.setHeader("Access-Control-Allow-Origin", v_OriginHead);
                    i_Response.setHeader("Access-Control-Allow-Credentials", "true");
                    i_Response.setHeader("Access-Control-Allow-Methods", "*");
                    i_Response.setHeader("Access-Control-Allow-Headers", "Authorization,Origin, X-Requested-With, Content-Type, Accept,Access-Token");
                } else {
                    this.corsSendAlarm(i_Request, v_OriginHead);
                }
            }
        }
        catch (Exception exce) {
            $Logger.error((Throwable)exce);
        }
    }

    private boolean corsIsAllowDNS(String i_OriginHeadLC) {
        Map v_DNSMap = (Map)XJava.getObject((String)"MS_Common_DNSConfigs");
        if (Help.isNull((Map)v_DNSMap)) {
            return true;
        }
        return v_DNSMap.containsKey(i_OriginHeadLC);
    }

    private boolean corsIsAllowIP(String i_OriginHeadLC) {
        List v_DNSIPList = (List)XJava.getObject((String)"MS_Common_DNSIPConfigs");
        if (Help.isNull((List)v_DNSIPList)) {
            return true;
        }
        for (Param v_Item : v_DNSIPList) {
            if (!i_OriginHeadLC.startsWith(v_Item.getName())) continue;
            return true;
        }
        return false;
    }

    public void postHandle(HttpServletRequest i_Request, HttpServletResponse i_Response, Object i_Handler, ModelAndView i_ModelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }
}

