/*
 * Decompiled with CFR 0.152.
 */
package org.hy.microservice.common.operationLog;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.hy.common.Date;
import org.hy.microservice.common.BaseViewMode;

public class OperationLog
extends BaseViewMode {
    private static final long serialVersionUID = -5413499847764917172L;
    private String id;
    private String systemCode;
    private String moduleCode;
    private String url;
    private String urlRequest;
    private String urlRequestBody;
    private String urlResponse;
    private String resultCode;
    private String userID;
    private String userIP;
    private Long requestTime = new Date().getTime();
    private Long responseTime;
    private Long timeLen;
    private String attackType;
    private int cacheToDBFlag = 0;
    private int cacheToDBErrCount = 0;

    public String getIpSafeKey() {
        StringBuilder v_Buffer = new StringBuilder();
        v_Buffer.append(this.userIP);
        v_Buffer.append("@");
        v_Buffer.append(this.moduleCode);
        v_Buffer.append("@");
        v_Buffer.append(this.url);
        return v_Buffer.toString();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String i_Id) {
        this.id = i_Id;
    }

    public String getSystemCode() {
        return this.systemCode;
    }

    public void setSystemCode(String i_SystemCode) {
        this.systemCode = i_SystemCode;
    }

    public String getModuleCode() {
        return this.moduleCode;
    }

    public void setModuleCode(String i_ModuleCode) {
        this.moduleCode = i_ModuleCode;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String i_Url) {
        this.url = i_Url;
    }

    public String getUrlRequest() {
        return this.urlRequest;
    }

    public void setUrlRequest(String i_UrlRequest) {
        this.urlRequest = i_UrlRequest;
    }

    public String getUrlRequestBody() {
        return this.urlRequestBody;
    }

    public void setUrlRequestBody(String i_UrlRequestBody) {
        this.urlRequestBody = i_UrlRequestBody;
    }

    public String getUrlResponse() {
        return this.urlResponse;
    }

    public void setUrlResponse(String i_UrlResponse) {
        this.urlResponse = i_UrlResponse;
    }

    public String getResultCode() {
        return this.resultCode;
    }

    public void setResultCode(String i_ResultCode) {
        this.resultCode = i_ResultCode;
    }

    public String getUserID() {
        return this.userID;
    }

    public void setUserID(String i_UserID) {
        this.userID = i_UserID;
    }

    public String getUserIP() {
        return this.userIP;
    }

    public void setUserIP(String i_UserIP) {
        this.userIP = i_UserIP;
    }

    public Long getRequestTime() {
        return this.requestTime;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss.SSS", timezone="GMT+8")
    public Date getRequestDate() {
        return new Date(this.requestTime.longValue());
    }

    public void setRequestTime(Long i_RequestTime) {
        this.requestTime = i_RequestTime;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss.SSS", timezone="GMT+8")
    public Date getResponseDate() {
        if (this.responseTime == null || this.responseTime == 0L) {
            return null;
        }
        return new Date(this.responseTime.longValue());
    }

    public Long getResponseTime() {
        return this.responseTime;
    }

    public void setResponseTime(Long i_ResponseTime) {
        this.responseTime = i_ResponseTime;
    }

    public Long getTimeLen() {
        return this.timeLen;
    }

    public void setTimeLen(Long i_TimeLen) {
        this.timeLen = i_TimeLen;
    }

    public String getAttackType() {
        return this.attackType;
    }

    public void setAttackType(String i_AttackType) {
        this.attackType = i_AttackType;
    }

    public synchronized int getCacheToDBFlag() {
        return this.cacheToDBFlag;
    }

    public synchronized void appendCacheToDBFlag(int i_CacheToDBFlag) {
        this.cacheToDBFlag += i_CacheToDBFlag;
    }

    public int getCacheToDBErrCount() {
        return this.cacheToDBErrCount;
    }

    public void setCacheToDBErrCount(int i_CacheToDBErrCount) {
        this.cacheToDBErrCount = i_CacheToDBErrCount;
    }
}

