/*
 * Decompiled with CFR 0.152.
 */
package org.hy.microservice.common.webSocket;

import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import org.hy.common.Help;
import org.hy.common.xml.log.Logger;
import org.hy.microservice.common.webSocket.WebSocketConfig;
import org.hy.microservice.common.webSocket.WebSocketServer;

@ClientEndpoint
public class WebSocketProxy {
    private static Logger $Logger = Logger.getLogger(WebSocketProxy.class);
    private String serviceType;
    private WebSocketConfig remoteConfig;

    public WebSocketProxy(String i_ServiceType, WebSocketConfig i_RemoteConfig) {
        if (i_RemoteConfig == null) {
            throw new NullPointerException("WebSocketConfig is null.");
        }
        if (Help.isNull((String)i_RemoteConfig.getServiceType())) {
            throw new NullPointerException("RemoteConfig.serviceType is null.");
        }
        this.remoteConfig = i_RemoteConfig;
        this.serviceType = Help.NVL((String)i_ServiceType, (String)this.remoteConfig.getServiceType());
    }

    @OnOpen
    public void onOpen(Session i_Session) {
        $Logger.info("\u6210\u529f\u8fde\u63a5\u8fdc\u7a0bWebSocket[" + this.remoteConfig + "]");
    }

    @OnMessage
    public void onMessage(String i_Message) {
        WebSocketServer.pushMessages((String)this.serviceType, (String)i_Message);
    }

    @OnClose
    public void onClose(Session i_Session, CloseReason i_CloseReason) {
        $Logger.info("\u5173\u95ed\u8fdc\u7a0bWebSocket[" + this.remoteConfig + "]\uff0c\u539f\u56e0\uff1a" + i_CloseReason.getReasonPhrase());
    }

    @OnError
    public void onError(Session i_Session, Throwable i_Throwable) {
        $Logger.error("\u8fdc\u7a0bWebSocket\u901a\u4fe1\u9519\u8bef[" + this.remoteConfig + "]: " + i_Throwable.getMessage(), i_Throwable);
    }
}

