/*
 * Decompiled with CFR 0.152.
 */
package org.hy.microservice.common;

import java.util.ArrayList;
import java.util.List;
import org.hy.common.Help;
import org.hy.common.StringHelp;
import org.hy.common.app.Param;
import org.hy.common.xml.annotation.Xjava;
import org.hy.common.xml.log.Logger;
import org.lionsoul.ip2region.xdb.Searcher;

@Xjava
public class IP2Region {
    private static final Logger $Logger = new Logger(IP2Region.class);
    private static boolean $IsInit = false;
    @Xjava(ref="MS_Common_ApiUseIP2Region")
    private Param apiUseIP2Region;
    private Searcher searcher;
    private List<String[]> regions;

    public IP2Region() {
        this.initIP2Region();
    }

    private synchronized void initIP2Region() {
        if ($IsInit) {
            return;
        }
        String dbPath = Help.getClassHomePath() + "lib/ip2region_v4.xdb";
        byte[] cBuff = new byte[]{};
        try {
            cBuff = Searcher.loadContentFromFile((String)dbPath);
        }
        catch (Exception e) {
            $Logger.error((Object)"failed to load content from `%s`: %s\n", dbPath, (Throwable)e);
        }
        if (cBuff != null && cBuff.length > 0) {
            try {
                this.searcher = Searcher.newWithBuffer((byte[])cBuff);
            }
            catch (Exception e) {
                $Logger.error("failed to create content cached searcher: %s\n", (Throwable)e);
            }
        }
    }

    private synchronized void initAllowRegion() {
        if (Help.isNull((List)this.regions)) {
            String[] v_Countrys;
            this.regions = new ArrayList();
            this.regions.add(new String[]{"\u5185\u7f51"});
            for (String v_Country : v_Countrys = this.apiUseIP2Region.getValue().split(";")) {
                String[] v_Regions = v_Country.split(",");
                this.regions.add(v_Regions);
            }
        }
    }

    public boolean isAllow(String i_IP) {
        if (Help.isNull((String)i_IP)) {
            return true;
        }
        String v_Region = this.search(i_IP);
        if (Help.isNull((String)v_Region)) {
            return true;
        }
        this.initAllowRegion();
        for (String[] v_AllowRegion : this.regions) {
            if (!StringHelp.isContains((String)v_Region, (boolean)true, (String[])v_AllowRegion)) continue;
            return true;
        }
        return false;
    }

    public String search(String i_IP) {
        if (this.searcher != null) {
            try {
                return this.searcher.search(i_IP);
            }
            catch (Exception exce) {
                $Logger.error((Object)"failed to search(%s): %s\n", i_IP, (Throwable)exce);
            }
        }
        return null;
    }
}

