/*
 * Decompiled with CFR 0.152.
 */
package org.hy.microservice.common.ipSafe;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hy.common.Help;
import org.hy.common.StringHelp;
import org.hy.common.TablePartitionRID;
import org.hy.common.app.Param;
import org.hy.common.xml.annotation.Xjava;
import org.hy.common.xml.log.Logger;
import org.hy.microservice.common.ipSafe.IIPSafeConfigDAO;
import org.hy.microservice.common.ipSafe.IIPSafeConfigService;
import org.hy.microservice.common.ipSafe.IPSafeConfig;

/*
 * Exception performing whole class analysis ignored.
 */
@Xjava
public class IPSafeConfigService
implements IIPSafeConfigService,
Serializable {
    private static final long serialVersionUID = -8491749740722409103L;
    private static final Logger $Logger = new Logger(IPSafeConfigService.class);
    private static TablePartitionRID<String, IPSafeConfig> $CacheIPSafes = new TablePartitionRID();
    private static final Map<String, String> $IPSafeHits = new HashMap();
    @Xjava
    private IIPSafeConfigDAO ipSafeConfigDAO;
    @Xjava(ref="MS_Common_PagePerCount")
    private Param pagePerCount;

    public IPSafeConfig insert(IPSafeConfig io_IPSafeConfig) {
        io_IPSafeConfig.setId(StringHelp.getUUID());
        io_IPSafeConfig.setCreateUserID(Help.NVL((String)io_IPSafeConfig.getCreateUserID(), (String)io_IPSafeConfig.getUserID()));
        io_IPSafeConfig.setIsDel(Help.NVL((Integer)io_IPSafeConfig.getIsDel(), (Integer)0));
        int v_Ret = this.ipSafeConfigDAO.insert(io_IPSafeConfig);
        if (v_Ret == 1) {
            this.cacheIPSafesRefurbish();
            return io_IPSafeConfig;
        }
        return null;
    }

    public IPSafeConfig update(IPSafeConfig i_IPSafeConfig) {
        int v_Ret = this.ipSafeConfigDAO.update(i_IPSafeConfig);
        if (v_Ret == 1) {
            this.cacheIPSafesRefurbish();
            return i_IPSafeConfig;
        }
        return null;
    }

    public IPSafeConfig queryByID(IPSafeConfig i_IPSafeConfig) {
        return this.ipSafeConfigDAO.queryByID(i_IPSafeConfig);
    }

    public IPSafeConfig queryByID(String i_ID) {
        IPSafeConfig v_IPSafeConfig = new IPSafeConfig();
        v_IPSafeConfig.setId(i_ID);
        return this.ipSafeConfigDAO.queryByID(v_IPSafeConfig);
    }

    public IPSafeConfig queryByByIPTypeIP(IPSafeConfig i_IPSafeConfig) {
        return this.ipSafeConfigDAO.queryByByIPTypeIP(i_IPSafeConfig);
    }

    public List<IPSafeConfig> queryByIPType(IPSafeConfig i_IPSafeConfig) {
        return this.ipSafeConfigDAO.queryByIPType(i_IPSafeConfig);
    }

    public List<IPSafeConfig> queryByIPTypeByPage(IPSafeConfig io_IPSafeConfig) {
        long v_DefPagePerCount = this.pagePerCount.getValueLong();
        io_IPSafeConfig.setPageIndex(Help.NVL((Long)io_IPSafeConfig.getPageIndex(), (Long)1L));
        io_IPSafeConfig.setPagePerCount(Help.min((Long)Help.NVL((Long)io_IPSafeConfig.getPagePerCount(), (Long)v_DefPagePerCount), (Long[])new Long[]{v_DefPagePerCount}));
        return this.ipSafeConfigDAO.queryByIPTypeByPage(io_IPSafeConfig);
    }

    public Long queryByIPTypeCount(IPSafeConfig i_IPSafeConfig) {
        return this.ipSafeConfigDAO.queryByIPTypeCount(i_IPSafeConfig);
    }

    public TablePartitionRID<String, IPSafeConfig> queryAll() {
        if (Help.isNull((Map)$CacheIPSafes)) {
            return this.cacheIPSafesRefurbish();
        }
        return $CacheIPSafes;
    }

    private void putIPs(TablePartitionRID<String, IPSafeConfig> io_IPs, Map<String, IPSafeConfig> i_IPDatas) {
        for (IPSafeConfig v_IP : i_IPDatas.values()) {
            IPSafeConfig v_New;
            long v_IPEnd;
            long v_IPStart;
            if (Help.isNull((String)v_IP.getIpMax())) {
                io_IPs.putRow((Object)v_IP.getIpType(), v_IP.getIpSafeKey(), (Object)v_IP);
                continue;
            }
            if (v_IP.getIp().endsWith(".0") && v_IP.getIpMax().endsWith(".255")) {
                v_IPStart = IPSafeConfigService.ipToLong((String)v_IP.getIp());
                v_IPEnd = IPSafeConfigService.ipToLong((String)v_IP.getIpMax());
                do {
                    v_New = new IPSafeConfig();
                    v_New.setId(v_IP.getId());
                    v_New.setIpType(v_IP.getIpType());
                    v_New.setIp(IPSafeConfigService.ipToString3((long)v_IPStart));
                    v_New.setModuleCode(v_IP.getModuleCode());
                    v_New.setUrl(v_IP.getUrl());
                    io_IPs.putRow((Object)v_New.getIpType(), v_New.getIpSafeKey(), (Object)v_New);
                } while ((v_IPStart += 256L) < v_IPEnd);
                continue;
            }
            v_IPStart = IPSafeConfigService.ipToLong((String)v_IP.getIp());
            v_IPEnd = IPSafeConfigService.ipToLong((String)v_IP.getIpMax());
            if (v_IP.getIp().endsWith(".0")) {
                while (v_IPStart + 256L < v_IPEnd) {
                    v_New = new IPSafeConfig();
                    v_New.setId(v_IP.getId());
                    v_New.setIpType(v_IP.getIpType());
                    v_New.setIp(IPSafeConfigService.ipToString3((long)v_IPStart));
                    v_New.setModuleCode(v_IP.getModuleCode());
                    v_New.setUrl(v_IP.getUrl());
                    io_IPs.putRow((Object)v_New.getIpType(), v_New.getIpSafeKey(), (Object)v_New);
                    v_IPStart += 256L;
                }
            } else if (v_IP.getIpMax().endsWith(".255")) {
                while (v_IPStart < v_IPEnd - 256L) {
                    v_New = new IPSafeConfig();
                    v_New.setId(v_IP.getId());
                    v_New.setIpType(v_IP.getIpType());
                    v_New.setIp(IPSafeConfigService.ipToString3((long)v_IPEnd));
                    v_New.setModuleCode(v_IP.getModuleCode());
                    v_New.setUrl(v_IP.getUrl());
                    io_IPs.putRow((Object)v_New.getIpType(), v_New.getIpSafeKey(), (Object)v_New);
                    v_IPEnd -= 256L;
                }
            }
            for (long v_IPIndex = v_IPStart; v_IPIndex <= v_IPEnd; ++v_IPIndex) {
                IPSafeConfig v_New2 = new IPSafeConfig();
                v_New2.setId(v_IP.getId());
                v_New2.setIpType(v_IP.getIpType());
                v_New2.setIp(IPSafeConfigService.ipToString((long)v_IPIndex));
                v_New2.setModuleCode(v_IP.getModuleCode());
                v_New2.setUrl(v_IP.getUrl());
                io_IPs.putRow((Object)v_New2.getIpType(), v_New2.getIpSafeKey(), (Object)v_New2);
            }
        }
    }

    public synchronized TablePartitionRID<String, IPSafeConfig> cacheIPSafesRefurbish() {
        $Logger.info("\u5f00\u59cb\uff1a\u5237\u65b0\u9ed1\u767d\u540d\u5355\u7f13\u5b58");
        TablePartitionRID v_Datas = this.ipSafeConfigDAO.queryAll();
        TablePartitionRID v_IPs = new TablePartitionRID();
        this.putIPs(v_IPs, (Map)v_Datas.get((Object)"blacklist"));
        this.putIPs(v_IPs, (Map)v_Datas.get((Object)"whitelist"));
        $Logger.info("\u5b8c\u6210\uff1a\u5237\u65b0\u9ed1\u767d\u540d\u5355\u7f13\u5b58\uff1a\u5e93\u884c\u6570" + v_Datas.rowCount() + "\uff0c\u7f13\u5b58\u884c\u6570" + v_IPs.rowCount());
        v_Datas.clear();
        v_Datas = null;
        $CacheIPSafes = v_IPs;
        $IPSafeHits.clear();
        return $CacheIPSafes;
    }

    public static final long ipToLong(String i_IP) {
        String[] v_Parts = i_IP.split("\\.");
        long v_Value = 0L;
        for (int i = 0; i < 4; ++i) {
            v_Value = v_Value << 8 | (long)Integer.parseInt(v_Parts[i]);
        }
        return v_Value;
    }

    public static final String ipToString(long i_IP) {
        return (i_IP >> 24 & 0xFFL) + "." + (i_IP >> 16 & 0xFFL) + "." + (i_IP >> 8 & 0xFFL) + "." + (i_IP & 0xFFL);
    }

    public static final String ipToString3(long i_IP) {
        return (i_IP >> 24 & 0xFFL) + "." + (i_IP >> 16 & 0xFFL) + "." + (i_IP >> 8 & 0xFFL) + ".";
    }

    public void putIPSafeHit(String i_IpSafeKey, String i_IPSafeType) {
        $IPSafeHits.put(i_IpSafeKey, i_IPSafeType);
    }

    public String getIPSafeHit(String i_IpSafeKey) {
        return (String)$IPSafeHits.get(i_IpSafeKey);
    }
}

