/*
 * Decompiled with CFR 0.152.
 */
package org.hy.microservice.common.rocketMQ;

import org.hy.common.Date;
import org.hy.microservice.common.BaseData;

public class MessageEntity
extends BaseData {
    private static final long serialVersionUID = 9179169560460186309L;
    private String id;
    private String topic;
    private String tag;
    private String content;
    private int retryCount = 0;
    private Date createTime;
    private Date lastRetryTime;
    private int maxRetryCount = 5;

    public MessageEntity() {
    }

    public MessageEntity(String id, String topic, String tag, String content) {
        this.id = id;
        this.topic = topic;
        this.tag = tag;
        this.content = content;
        this.createTime = new Date();
    }

    public boolean canRetry() {
        return this.retryCount < this.maxRetryCount;
    }

    public void incrementRetryCount() {
        ++this.retryCount;
        this.lastRetryTime = new Date();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getLastRetryTime() {
        return this.lastRetryTime;
    }

    public void setLastRetryTime(Date lastRetryTime) {
        this.lastRetryTime = lastRetryTime;
    }

    public int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    public void setMaxRetryCount(int maxRetryCount) {
        this.maxRetryCount = maxRetryCount;
    }
}

