/*
 * Decompiled with CFR 0.152.
 */
package org.hy.microservice.common.webSocket;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.hy.common.Help;
import org.hy.common.TablePartitionRID;
import org.hy.common.xml.log.Logger;
import org.hy.microservice.common.webSocket.WebSocketClient;
import org.hy.microservice.common.webSocket.WebSocketMessage;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@ServerEndpoint(value="/report/{serviceType}/{userID}")
@Component
public class WebSocketServer {
    private static Logger $Logger = Logger.getLogger(WebSocketServer.class);
    private static TablePartitionRID<String, WebSocketClient> $WebSocketMap = new TablePartitionRID();
    private static Map<String, WebSocketMessage> $WebSocketEvents = new HashMap();
    private WebSocketClient client;

    @OnOpen
    public void onOpen(Session i_Session, @PathParam(value="serviceType") String i_ServiceType, @PathParam(value="userID") String i_UserID) {
        String v_InitMsg;
        if (i_Session == null) {
            return;
        }
        if (Help.isNull((String)i_ServiceType)) {
            return;
        }
        if (Help.isNull((String)i_UserID)) {
            return;
        }
        this.client = new WebSocketClient(i_UserID, i_Session.getId(), i_Session, i_ServiceType, this);
        if (i_Session.getRequestParameterMap() != null && !Help.isNull((List)((List)i_Session.getRequestParameterMap().get("token")))) {
            this.client.setToken((String)((List)i_Session.getRequestParameterMap().get("token")).get(0));
        }
        $WebSocketMap.putRow((Object)i_ServiceType, this.client.getSessionID(), (Object)this.client);
        $Logger.info("WebSocket onOpen\uff1a" + this.client.getServiceType() + ":" + this.client.getSessionID() + ":" + this.client.getUserID());
        WebSocketMessage v_WebSocketMessage = (WebSocketMessage)$WebSocketEvents.get(i_ServiceType);
        if (v_WebSocketMessage != null && !Help.isNull((String)(v_InitMsg = v_WebSocketMessage.getInitMessage()))) {
            this.client.pushMessage(v_InitMsg);
        }
    }

    @OnClose
    public void onClose(@PathParam(value="serviceType") String i_ServiceType, @PathParam(value="userID") String i_UserID, @PathParam(value="token") String i_Token) {
        if (this.client == null) {
            return;
        }
        if (Help.isNull((String)i_ServiceType)) {
            return;
        }
        if (Help.isNull((String)i_UserID)) {
            return;
        }
        WebSocketClient v_WebSocketClient = (WebSocketClient)((Map)$WebSocketMap.get((Object)i_ServiceType)).get(this.client.getSessionID());
        if (v_WebSocketClient != null) {
            $WebSocketMap.removeRow((Object)i_ServiceType, this.client.getSessionID());
        }
        $Logger.info("WebSocket onClose\uff1a" + this.client.getServiceType() + ":" + this.client.getSessionID() + ":" + this.client.getUserID());
    }

    @OnMessage
    public void onMessage(String i_Message) {
        if (Help.isNull((String)i_Message)) {
            return;
        }
        try {
            this.client.getSession().getBasicRemote().sendText(i_Message);
        }
        catch (Exception exce) {
            $Logger.error((Throwable)exce);
        }
        $Logger.debug("WebSocket onMessage\uff1a" + this.client.getServiceType() + "=" + i_Message);
    }

    @OnError
    public void onError(Session i_Session, Throwable i_Error, @PathParam(value="serviceType") String i_ServiceType, @PathParam(value="userID") String i_UserID) {
        $Logger.error("WebSocket error\uff1a" + this.client.getServiceType() + ":" + this.client.getSessionID() + ":" + this.client.getUserID(), i_Error);
    }

    public static boolean addInitEventListener(WebSocketMessage i_WebSocketMessage) {
        if (i_WebSocketMessage == null) {
            return false;
        }
        if (Help.isNull((String)i_WebSocketMessage.getServiceType())) {
            return false;
        }
        $WebSocketEvents.put(i_WebSocketMessage.getServiceType(), i_WebSocketMessage);
        return true;
    }

    public static void removeInitEventListener(WebSocketMessage i_WebSocketMessage) {
        if (i_WebSocketMessage == null) {
            return;
        }
        if (Help.isNull((String)i_WebSocketMessage.getServiceType())) {
            return;
        }
        $WebSocketEvents.remove(i_WebSocketMessage.getServiceType());
    }

    public static Map<String, WebSocketClient> getClients(String i_ServiceType) {
        if (Help.isNull((String)i_ServiceType)) {
            return null;
        }
        return (Map)$WebSocketMap.get((Object)i_ServiceType);
    }

    public static void pushMessages(String i_ServiceType, String i_NewMessage) {
        WebSocketServer.pushMessages((String)i_ServiceType, (String)i_NewMessage, (String)i_NewMessage);
    }

    public static void pushMessages(String i_ServiceType, String i_NewMessage, String i_AllMessage) {
        if (Help.isNull((String)i_ServiceType)) {
            return;
        }
        Map v_Clients = (Map)$WebSocketMap.get((Object)i_ServiceType);
        if (Help.isNull((Map)v_Clients)) {
            return;
        }
        for (WebSocketClient v_Client : v_Clients.values()) {
            if (v_Client.getSendCount() <= 0L) {
                v_Client.pushMessage(Help.NVL((String)i_AllMessage));
                continue;
            }
            v_Client.pushMessage(Help.NVL((String)i_NewMessage));
        }
    }

    public static void pushMessages(WebSocketMessage i_Message) {
        if (i_Message == null) {
            return;
        }
        if (Help.isNull((String)i_Message.getServiceType())) {
            return;
        }
        Map v_Clients = (Map)$WebSocketMap.get((Object)i_Message.getServiceType());
        if (Help.isNull((Map)v_Clients)) {
            return;
        }
        for (WebSocketClient v_Client : v_Clients.values()) {
            if (v_Client.getSendCount() <= 0L) {
                v_Client.pushMessage(Help.NVL((String)i_Message.getAllMessage()));
                continue;
            }
            v_Client.pushMessage(Help.NVL((String)i_Message.getMessage()));
        }
    }
}

