/*
 * Copyright (c) 2019 - present Jiahang Li, All rights reserved.
 *
 *   https://kit.orionsec.cn
 *
 * Members:
 *   Jiahang Li - ljh1553488six@139.com - author
 *
 * The MIT License (MIT)
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package cn.orionsec.kit.generator.addres;

import cn.orionsec.kit.lang.define.collect.WeightRandomMap;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

/**
 * 中国3级地址
 *
 * @author Jiahang Li
 * @version 1.0.0
 * @since 2021/8/11 14:59
 */
public class AddressArea {

    /**
     * 省人口权重
     */
    protected static final WeightRandomMap<Integer> POPULATION;

    /**
     * 省
     */
    protected static final Map<Integer, String> PROVINCE;

    /**
     * 市
     */
    protected static final Map<Integer, String> CITY;

    /**
     * 县
     */
    protected static final Map<Integer, String> COUNTY;

    private AddressArea() {
    }

    static {
        POPULATION = new WeightRandomMap<>();
        POPULATION.put(37, 8D);
        POPULATION.put(44, 7.1D);
        POPULATION.put(41, 6.8D);
        POPULATION.put(51, 5.9D);
        POPULATION.put(32, 5.7D);
        POPULATION.put(13, 5.3D);
        POPULATION.put(43, 4.9D);
        POPULATION.put(34, 4.5D);
        POPULATION.put(42, 4.2D);
        POPULATION.put(33, 4.0D);
        POPULATION.put(45, 3.5D);
        POPULATION.put(53, 3.42D);
        POPULATION.put(36, 3.28D);
        POPULATION.put(21, 3.07D);
        POPULATION.put(35, 2.81D);
        POPULATION.put(61, 2.76D);
        POPULATION.put(23, 2.69D);
        POPULATION.put(14, 2.65D);
        POPULATION.put(52, 2.57D);
        POPULATION.put(50, 2.21D);
        POPULATION.put(22, 1.92D);
        POPULATION.put(62, 1.85D);
        POPULATION.put(15, 1.78D);
        POPULATION.put(65, 1.77D);
        POPULATION.put(31, 1.73D);
        POPULATION.put(11, 1.53D);
        POPULATION.put(12, 1.11D);
        POPULATION.put(46, 0.066D);
        POPULATION.put(64, 0.049D);
        POPULATION.put(63, 0.0422D);
        POPULATION.put(54, 0.02D);
    }

    static {
        TreeMap<Integer, String> tempProvince = new TreeMap<>();
        tempProvince.put(11, "北京市");
        tempProvince.put(12, "天津市");
        tempProvince.put(13, "河北省");
        tempProvince.put(14, "山西省");
        tempProvince.put(15, "内蒙古自治区");
        tempProvince.put(21, "辽宁省");
        tempProvince.put(22, "吉林省");
        tempProvince.put(23, "黑龙江省");
        tempProvince.put(31, "上海市");
        tempProvince.put(32, "江苏省");
        tempProvince.put(33, "浙江省");
        tempProvince.put(34, "安徽省");
        tempProvince.put(35, "福建省");
        tempProvince.put(36, "江西省");
        tempProvince.put(37, "山东省");
        tempProvince.put(41, "河南省");
        tempProvince.put(42, "湖北省");
        tempProvince.put(43, "湖南省");
        tempProvince.put(44, "广东省");
        tempProvince.put(45, "广西壮族自治区");
        tempProvince.put(46, "海南省");
        tempProvince.put(50, "重庆市");
        tempProvince.put(51, "四川省");
        tempProvince.put(52, "贵州省");
        tempProvince.put(53, "云南省");
        tempProvince.put(54, "西藏自治区");
        tempProvince.put(61, "陕西省");
        tempProvince.put(62, "甘肃省");
        tempProvince.put(63, "青海省");
        tempProvince.put(64, "宁夏回族自治区");
        tempProvince.put(65, "新疆维吾尔自治区");
        PROVINCE = Collections.unmodifiableSortedMap(tempProvince);
    }

    static {
        TreeMap<Integer, String> tempCity = new TreeMap<>();
        tempCity.put(1101, "北京市");
        tempCity.put(1201, "天津市");
        tempCity.put(1301, "石家庄市");
        tempCity.put(1302, "唐山市");
        tempCity.put(1303, "秦皇岛市");
        tempCity.put(1304, "邯郸市");
        tempCity.put(1305, "邢台市");
        tempCity.put(1306, "保定市");
        tempCity.put(1307, "张家口市");
        tempCity.put(1308, "承德市");
        tempCity.put(1309, "沧州市");
        tempCity.put(1310, "廊坊市");
        tempCity.put(1311, "衡水市");
        tempCity.put(1401, "太原市");
        tempCity.put(1402, "大同市");
        tempCity.put(1403, "阳泉市");
        tempCity.put(1404, "长治市");
        tempCity.put(1405, "晋城市");
        tempCity.put(1406, "朔州市");
        tempCity.put(1407, "晋中市");
        tempCity.put(1408, "运城市");
        tempCity.put(1409, "忻州市");
        tempCity.put(1410, "临汾市");
        tempCity.put(1411, "吕梁市");
        tempCity.put(1501, "呼和浩特市");
        tempCity.put(1502, "包头市");
        tempCity.put(1503, "乌海市");
        tempCity.put(1504, "赤峰市");
        tempCity.put(1505, "通辽市");
        tempCity.put(1506, "鄂尔多斯市");
        tempCity.put(1507, "呼伦贝尔市");
        tempCity.put(1508, "巴彦淖尔市");
        tempCity.put(1509, "乌兰察布市");
        tempCity.put(1522, "兴安盟");
        tempCity.put(1525, "锡林郭勒盟");
        tempCity.put(1529, "阿拉善盟");
        tempCity.put(2101, "沈阳市");
        tempCity.put(2102, "大连市");
        tempCity.put(2103, "鞍山市");
        tempCity.put(2104, "抚顺市");
        tempCity.put(2105, "本溪市");
        tempCity.put(2106, "丹东市");
        tempCity.put(2107, "锦州市");
        tempCity.put(2108, "营口市");
        tempCity.put(2109, "阜新市");
        tempCity.put(2110, "辽阳市");
        tempCity.put(2111, "盘锦市");
        tempCity.put(2112, "铁岭市");
        tempCity.put(2113, "朝阳市");
        tempCity.put(2114, "葫芦岛市");
        tempCity.put(2201, "长春市");
        tempCity.put(2202, "吉林市");
        tempCity.put(2203, "四平市");
        tempCity.put(2204, "辽源市");
        tempCity.put(2205, "通化市");
        tempCity.put(2206, "白山市");
        tempCity.put(2207, "松原市");
        tempCity.put(2208, "白城市");
        tempCity.put(2224, "延边朝鲜族自治州");
        tempCity.put(2301, "哈尔滨市");
        tempCity.put(2302, "齐齐哈尔市");
        tempCity.put(2303, "鸡西市");
        tempCity.put(2304, "鹤岗市");
        tempCity.put(2305, "双鸭山市");
        tempCity.put(2306, "大庆市");
        tempCity.put(2307, "伊春市");
        tempCity.put(2308, "佳木斯市");
        tempCity.put(2309, "七台河市");
        tempCity.put(2310, "牡丹江市");
        tempCity.put(2311, "黑河市");
        tempCity.put(2312, "绥化市");
        tempCity.put(2327, "大兴安岭地区");
        tempCity.put(3101, "上海市");
        tempCity.put(3201, "南京市");
        tempCity.put(3202, "无锡市");
        tempCity.put(3203, "徐州市");
        tempCity.put(3204, "常州市");
        tempCity.put(3205, "苏州市");
        tempCity.put(3206, "南通市");
        tempCity.put(3207, "连云港市");
        tempCity.put(3208, "淮安市");
        tempCity.put(3209, "盐城市");
        tempCity.put(3210, "扬州市");
        tempCity.put(3211, "镇江市");
        tempCity.put(3212, "泰州市");
        tempCity.put(3213, "宿迁市");
        tempCity.put(3301, "杭州市");
        tempCity.put(3302, "宁波市");
        tempCity.put(3303, "温州市");
        tempCity.put(3304, "嘉兴市");
        tempCity.put(3305, "湖州市");
        tempCity.put(3306, "绍兴市");
        tempCity.put(3307, "金华市");
        tempCity.put(3308, "衢州市");
        tempCity.put(3309, "舟山市");
        tempCity.put(3310, "台州市");
        tempCity.put(3311, "丽水市");
        tempCity.put(3401, "合肥市");
        tempCity.put(3402, "芜湖市");
        tempCity.put(3403, "蚌埠市");
        tempCity.put(3404, "淮南市");
        tempCity.put(3405, "马鞍山市");
        tempCity.put(3406, "淮北市");
        tempCity.put(3407, "铜陵市");
        tempCity.put(3408, "安庆市");
        tempCity.put(3410, "黄山市");
        tempCity.put(3411, "滁州市");
        tempCity.put(3412, "阜阳市");
        tempCity.put(3413, "宿州市");
        tempCity.put(3415, "六安市");
        tempCity.put(3416, "亳州市");
        tempCity.put(3417, "池州市");
        tempCity.put(3418, "宣城市");
        tempCity.put(3501, "福州市");
        tempCity.put(3502, "厦门市");
        tempCity.put(3503, "莆田市");
        tempCity.put(3504, "三明市");
        tempCity.put(3505, "泉州市");
        tempCity.put(3506, "漳州市");
        tempCity.put(3507, "南平市");
        tempCity.put(3508, "龙岩市");
        tempCity.put(3509, "宁德市");
        tempCity.put(3601, "南昌市");
        tempCity.put(3602, "景德镇市");
        tempCity.put(3603, "萍乡市");
        tempCity.put(3604, "九江市");
        tempCity.put(3605, "新余市");
        tempCity.put(3606, "鹰潭市");
        tempCity.put(3607, "赣州市");
        tempCity.put(3608, "吉安市");
        tempCity.put(3609, "宜春市");
        tempCity.put(3610, "抚州市");
        tempCity.put(3611, "上饶市");
        tempCity.put(3701, "济南市");
        tempCity.put(3702, "青岛市");
        tempCity.put(3703, "淄博市");
        tempCity.put(3704, "枣庄市");
        tempCity.put(3705, "东营市");
        tempCity.put(3706, "烟台市");
        tempCity.put(3707, "潍坊市");
        tempCity.put(3708, "济宁市");
        tempCity.put(3709, "泰安市");
        tempCity.put(3710, "威海市");
        tempCity.put(3711, "日照市");
        tempCity.put(3713, "临沂市");
        tempCity.put(3714, "德州市");
        tempCity.put(3715, "聊城市");
        tempCity.put(3716, "滨州市");
        tempCity.put(3717, "菏泽市");
        tempCity.put(4101, "郑州市");
        tempCity.put(4102, "开封市");
        tempCity.put(4103, "洛阳市");
        tempCity.put(4104, "平顶山市");
        tempCity.put(4105, "安阳市");
        tempCity.put(4106, "鹤壁市");
        tempCity.put(4107, "新乡市");
        tempCity.put(4108, "焦作市");
        tempCity.put(4109, "濮阳市");
        tempCity.put(4110, "许昌市");
        tempCity.put(4111, "漯河市");
        tempCity.put(4112, "三门峡市");
        tempCity.put(4113, "南阳市");
        tempCity.put(4114, "商丘市");
        tempCity.put(4115, "信阳市");
        tempCity.put(4116, "周口市");
        tempCity.put(4117, "驻马店市");
        tempCity.put(4190, "省直辖县级行政区划");
        tempCity.put(4201, "武汉市");
        tempCity.put(4202, "黄石市");
        tempCity.put(4203, "十堰市");
        tempCity.put(4205, "宜昌市");
        tempCity.put(4206, "襄阳市");
        tempCity.put(4207, "鄂州市");
        tempCity.put(4208, "荆门市");
        tempCity.put(4209, "孝感市");
        tempCity.put(4210, "荆州市");
        tempCity.put(4211, "黄冈市");
        tempCity.put(4212, "咸宁市");
        tempCity.put(4213, "随州市");
        tempCity.put(4228, "恩施土家族苗族自治州");
        tempCity.put(4290, "省直辖县级行政区划");
        tempCity.put(4301, "长沙市");
        tempCity.put(4302, "株洲市");
        tempCity.put(4303, "湘潭市");
        tempCity.put(4304, "衡阳市");
        tempCity.put(4305, "邵阳市");
        tempCity.put(4306, "岳阳市");
        tempCity.put(4307, "常德市");
        tempCity.put(4308, "张家界市");
        tempCity.put(4309, "益阳市");
        tempCity.put(4310, "郴州市");
        tempCity.put(4311, "永州市");
        tempCity.put(4312, "怀化市");
        tempCity.put(4313, "娄底市");
        tempCity.put(4331, "湘西土家族苗族自治州");
        tempCity.put(4401, "广州市");
        tempCity.put(4402, "韶关市");
        tempCity.put(4403, "深圳市");
        tempCity.put(4404, "珠海市");
        tempCity.put(4405, "汕头市");
        tempCity.put(4406, "佛山市");
        tempCity.put(4407, "江门市");
        tempCity.put(4408, "湛江市");
        tempCity.put(4409, "茂名市");
        tempCity.put(4412, "肇庆市");
        tempCity.put(4413, "惠州市");
        tempCity.put(4414, "梅州市");
        tempCity.put(4415, "汕尾市");
        tempCity.put(4416, "河源市");
        tempCity.put(4417, "阳江市");
        tempCity.put(4418, "清远市");
        tempCity.put(4419, "东莞市");
        tempCity.put(4420, "中山市");
        tempCity.put(4451, "潮州市");
        tempCity.put(4452, "揭阳市");
        tempCity.put(4453, "云浮市");
        tempCity.put(4501, "南宁市");
        tempCity.put(4502, "柳州市");
        tempCity.put(4503, "桂林市");
        tempCity.put(4504, "梧州市");
        tempCity.put(4505, "北海市");
        tempCity.put(4506, "防城港市");
        tempCity.put(4507, "钦州市");
        tempCity.put(4508, "贵港市");
        tempCity.put(4509, "玉林市");
        tempCity.put(4510, "百色市");
        tempCity.put(4511, "贺州市");
        tempCity.put(4512, "河池市");
        tempCity.put(4513, "来宾市");
        tempCity.put(4514, "崇左市");
        tempCity.put(4601, "海口市");
        tempCity.put(4602, "三亚市");
        tempCity.put(4603, "三沙市");
        tempCity.put(4604, "儋州市");
        tempCity.put(4690, "省直辖县级行政区划");
        tempCity.put(5001, "重庆市");
        tempCity.put(5002, "县");
        tempCity.put(5101, "成都市");
        tempCity.put(5103, "自贡市");
        tempCity.put(5104, "攀枝花市");
        tempCity.put(5105, "泸州市");
        tempCity.put(5106, "德阳市");
        tempCity.put(5107, "绵阳市");
        tempCity.put(5108, "广元市");
        tempCity.put(5109, "遂宁市");
        tempCity.put(5110, "内江市");
        tempCity.put(5111, "乐山市");
        tempCity.put(5113, "南充市");
        tempCity.put(5114, "眉山市");
        tempCity.put(5115, "宜宾市");
        tempCity.put(5116, "广安市");
        tempCity.put(5117, "达州市");
        tempCity.put(5118, "雅安市");
        tempCity.put(5119, "巴中市");
        tempCity.put(5120, "资阳市");
        tempCity.put(5132, "阿坝藏族羌族自治州");
        tempCity.put(5133, "甘孜藏族自治州");
        tempCity.put(5134, "凉山彝族自治州");
        tempCity.put(5201, "贵阳市");
        tempCity.put(5202, "六盘水市");
        tempCity.put(5203, "遵义市");
        tempCity.put(5204, "安顺市");
        tempCity.put(5205, "毕节市");
        tempCity.put(5206, "铜仁市");
        tempCity.put(5223, "黔西南布依族苗族自治州");
        tempCity.put(5226, "黔东南苗族侗族自治州");
        tempCity.put(5227, "黔南布依族苗族自治州");
        tempCity.put(5301, "昆明市");
        tempCity.put(5303, "曲靖市");
        tempCity.put(5304, "玉溪市");
        tempCity.put(5305, "保山市");
        tempCity.put(5306, "昭通市");
        tempCity.put(5307, "丽江市");
        tempCity.put(5308, "普洱市");
        tempCity.put(5309, "临沧市");
        tempCity.put(5323, "楚雄彝族自治州");
        tempCity.put(5325, "红河哈尼族彝族自治州");
        tempCity.put(5326, "文山壮族苗族自治州");
        tempCity.put(5328, "西双版纳傣族自治州");
        tempCity.put(5329, "大理白族自治州");
        tempCity.put(5331, "德宏傣族景颇族自治州");
        tempCity.put(5333, "怒江傈僳族自治州");
        tempCity.put(5334, "迪庆藏族自治州");
        tempCity.put(5401, "拉萨市");
        tempCity.put(5402, "日喀则市");
        tempCity.put(5403, "昌都市");
        tempCity.put(5404, "林芝市");
        tempCity.put(5405, "山南市");
        tempCity.put(5406, "那曲市");
        tempCity.put(5425, "阿里地区");
        tempCity.put(6101, "西安市");
        tempCity.put(6102, "铜川市");
        tempCity.put(6103, "宝鸡市");
        tempCity.put(6104, "咸阳市");
        tempCity.put(6105, "渭南市");
        tempCity.put(6106, "延安市");
        tempCity.put(6107, "汉中市");
        tempCity.put(6108, "榆林市");
        tempCity.put(6109, "安康市");
        tempCity.put(6110, "商洛市");
        tempCity.put(6201, "兰州市");
        tempCity.put(6202, "嘉峪关市");
        tempCity.put(6203, "金昌市");
        tempCity.put(6204, "白银市");
        tempCity.put(6205, "天水市");
        tempCity.put(6206, "武威市");
        tempCity.put(6207, "张掖市");
        tempCity.put(6208, "平凉市");
        tempCity.put(6209, "酒泉市");
        tempCity.put(6210, "庆阳市");
        tempCity.put(6211, "定西市");
        tempCity.put(6212, "陇南市");
        tempCity.put(6229, "临夏回族自治州");
        tempCity.put(6230, "甘南藏族自治州");
        tempCity.put(6301, "西宁市");
        tempCity.put(6302, "海东市");
        tempCity.put(6322, "海北藏族自治州");
        tempCity.put(6323, "黄南藏族自治州");
        tempCity.put(6325, "海南藏族自治州");
        tempCity.put(6326, "果洛藏族自治州");
        tempCity.put(6327, "玉树藏族自治州");
        tempCity.put(6328, "海西蒙古族藏族自治州");
        tempCity.put(6401, "银川市");
        tempCity.put(6402, "石嘴山市");
        tempCity.put(6403, "吴忠市");
        tempCity.put(6404, "固原市");
        tempCity.put(6405, "中卫市");
        tempCity.put(6501, "乌鲁木齐市");
        tempCity.put(6502, "克拉玛依市");
        tempCity.put(6504, "吐鲁番市");
        tempCity.put(6505, "哈密市");
        tempCity.put(6523, "昌吉回族自治州");
        tempCity.put(6527, "博尔塔拉蒙古自治州");
        tempCity.put(6528, "巴音郭楞蒙古自治州");
        tempCity.put(6529, "阿克苏地区");
        tempCity.put(6530, "克孜勒苏柯尔克孜自治州");
        tempCity.put(6531, "喀什地区");
        tempCity.put(6532, "和田地区");
        tempCity.put(6540, "伊犁哈萨克自治州");
        tempCity.put(6542, "塔城地区");
        tempCity.put(6543, "阿勒泰地区");
        tempCity.put(6590, "自治区直辖县级行政区划");
        CITY = Collections.unmodifiableSortedMap(tempCity);
    }

    static {
        TreeMap<Integer, String> tempCounty = new TreeMap<>();
        tempCounty.put(110101, "东城区");
        tempCounty.put(110102, "西城区");
        tempCounty.put(110105, "朝阳区");
        tempCounty.put(110106, "丰台区");
        tempCounty.put(110107, "石景山区");
        tempCounty.put(110108, "海淀区");
        tempCounty.put(110109, "门头沟区");
        tempCounty.put(110111, "房山区");
        tempCounty.put(110112, "通州区");
        tempCounty.put(110113, "顺义区");
        tempCounty.put(110114, "昌平区");
        tempCounty.put(110115, "大兴区");
        tempCounty.put(110116, "怀柔区");
        tempCounty.put(110117, "平谷区");
        tempCounty.put(110118, "密云区");
        tempCounty.put(110119, "延庆区");
        tempCounty.put(120101, "和平区");
        tempCounty.put(120102, "河东区");
        tempCounty.put(120103, "河西区");
        tempCounty.put(120104, "南开区");
        tempCounty.put(120105, "河北区");
        tempCounty.put(120106, "红桥区");
        tempCounty.put(120110, "东丽区");
        tempCounty.put(120111, "西青区");
        tempCounty.put(120112, "津南区");
        tempCounty.put(120113, "北辰区");
        tempCounty.put(120114, "武清区");
        tempCounty.put(120115, "宝坻区");
        tempCounty.put(120116, "滨海新区");
        tempCounty.put(120117, "宁河区");
        tempCounty.put(120118, "静海区");
        tempCounty.put(120119, "蓟州区");
        tempCounty.put(130102, "长安区");
        tempCounty.put(130104, "桥西区");
        tempCounty.put(130105, "新华区");
        tempCounty.put(130107, "井陉矿区");
        tempCounty.put(130108, "裕华区");
        tempCounty.put(130109, "藁城区");
        tempCounty.put(130110, "鹿泉区");
        tempCounty.put(130111, "栾城区");
        tempCounty.put(130121, "井陉县");
        tempCounty.put(130123, "正定县");
        tempCounty.put(130125, "行唐县");
        tempCounty.put(130126, "灵寿县");
        tempCounty.put(130127, "高邑县");
        tempCounty.put(130128, "深泽县");
        tempCounty.put(130129, "赞皇县");
        tempCounty.put(130130, "无极县");
        tempCounty.put(130131, "平山县");
        tempCounty.put(130132, "元氏县");
        tempCounty.put(130133, "赵县");
        tempCounty.put(130171, "石家庄高新技术产业开发区");
        tempCounty.put(130172, "石家庄循环化工园区");
        tempCounty.put(130181, "辛集市");
        tempCounty.put(130183, "晋州市");
        tempCounty.put(130184, "新乐市");
        tempCounty.put(130202, "路南区");
        tempCounty.put(130203, "路北区");
        tempCounty.put(130204, "古冶区");
        tempCounty.put(130205, "开平区");
        tempCounty.put(130207, "丰南区");
        tempCounty.put(130208, "丰润区");
        tempCounty.put(130209, "曹妃甸区");
        tempCounty.put(130224, "滦南县");
        tempCounty.put(130225, "乐亭县");
        tempCounty.put(130227, "迁西县");
        tempCounty.put(130229, "玉田县");
        tempCounty.put(130271, "河北唐山芦台经济开发区");
        tempCounty.put(130272, "唐山市汉沽管理区");
        tempCounty.put(130273, "唐山高新技术产业开发区");
        tempCounty.put(130274, "河北唐山海港经济开发区");
        tempCounty.put(130281, "遵化市");
        tempCounty.put(130283, "迁安市");
        tempCounty.put(130284, "滦州市");
        tempCounty.put(130302, "海港区");
        tempCounty.put(130303, "山海关区");
        tempCounty.put(130304, "北戴河区");
        tempCounty.put(130306, "抚宁区");
        tempCounty.put(130321, "青龙满族自治县");
        tempCounty.put(130322, "昌黎县");
        tempCounty.put(130324, "卢龙县");
        tempCounty.put(130371, "秦皇岛市经济技术开发区");
        tempCounty.put(130372, "北戴河新区");
        tempCounty.put(130402, "邯山区");
        tempCounty.put(130403, "丛台区");
        tempCounty.put(130404, "复兴区");
        tempCounty.put(130406, "峰峰矿区");
        tempCounty.put(130407, "肥乡区");
        tempCounty.put(130408, "永年区");
        tempCounty.put(130423, "临漳县");
        tempCounty.put(130424, "成安县");
        tempCounty.put(130425, "大名县");
        tempCounty.put(130426, "涉县");
        tempCounty.put(130427, "磁县");
        tempCounty.put(130430, "邱县");
        tempCounty.put(130431, "鸡泽县");
        tempCounty.put(130432, "广平县");
        tempCounty.put(130433, "馆陶县");
        tempCounty.put(130434, "魏县");
        tempCounty.put(130435, "曲周县");
        tempCounty.put(130471, "邯郸经济技术开发区");
        tempCounty.put(130473, "邯郸冀南新区");
        tempCounty.put(130481, "武安市");
        tempCounty.put(130502, "襄都区");
        tempCounty.put(130503, "信都区");
        tempCounty.put(130505, "任泽区");
        tempCounty.put(130506, "南和区");
        tempCounty.put(130522, "临城县");
        tempCounty.put(130523, "内丘县");
        tempCounty.put(130524, "柏乡县");
        tempCounty.put(130525, "隆尧县");
        tempCounty.put(130528, "宁晋县");
        tempCounty.put(130529, "巨鹿县");
        tempCounty.put(130530, "新河县");
        tempCounty.put(130531, "广宗县");
        tempCounty.put(130532, "平乡县");
        tempCounty.put(130533, "威县");
        tempCounty.put(130534, "清河县");
        tempCounty.put(130535, "临西县");
        tempCounty.put(130571, "河北邢台经济开发区");
        tempCounty.put(130581, "南宫市");
        tempCounty.put(130582, "沙河市");
        tempCounty.put(130602, "竞秀区");
        tempCounty.put(130606, "莲池区");
        tempCounty.put(130607, "满城区");
        tempCounty.put(130608, "清苑区");
        tempCounty.put(130609, "徐水区");
        tempCounty.put(130623, "涞水县");
        tempCounty.put(130624, "阜平县");
        tempCounty.put(130626, "定兴县");
        tempCounty.put(130627, "唐县");
        tempCounty.put(130628, "高阳县");
        tempCounty.put(130629, "容城县");
        tempCounty.put(130630, "涞源县");
        tempCounty.put(130631, "望都县");
        tempCounty.put(130632, "安新县");
        tempCounty.put(130633, "易县");
        tempCounty.put(130634, "曲阳县");
        tempCounty.put(130635, "蠡县");
        tempCounty.put(130636, "顺平县");
        tempCounty.put(130637, "博野县");
        tempCounty.put(130638, "雄县");
        tempCounty.put(130671, "保定高新技术产业开发区");
        tempCounty.put(130672, "保定白沟新城");
        tempCounty.put(130681, "涿州市");
        tempCounty.put(130682, "定州市");
        tempCounty.put(130683, "安国市");
        tempCounty.put(130684, "高碑店市");
        tempCounty.put(130702, "桥东区");
        tempCounty.put(130703, "桥西区");
        tempCounty.put(130705, "宣化区");
        tempCounty.put(130706, "下花园区");
        tempCounty.put(130708, "万全区");
        tempCounty.put(130709, "崇礼区");
        tempCounty.put(130722, "张北县");
        tempCounty.put(130723, "康保县");
        tempCounty.put(130724, "沽源县");
        tempCounty.put(130725, "尚义县");
        tempCounty.put(130726, "蔚县");
        tempCounty.put(130727, "阳原县");
        tempCounty.put(130728, "怀安县");
        tempCounty.put(130730, "怀来县");
        tempCounty.put(130731, "涿鹿县");
        tempCounty.put(130732, "赤城县");
        tempCounty.put(130771, "张家口经济开发区");
        tempCounty.put(130772, "张家口市察北管理区");
        tempCounty.put(130773, "张家口市塞北管理区");
        tempCounty.put(130802, "双桥区");
        tempCounty.put(130803, "双滦区");
        tempCounty.put(130804, "鹰手营子矿区");
        tempCounty.put(130821, "承德县");
        tempCounty.put(130822, "兴隆县");
        tempCounty.put(130824, "滦平县");
        tempCounty.put(130825, "隆化县");
        tempCounty.put(130826, "丰宁满族自治县");
        tempCounty.put(130827, "宽城满族自治县");
        tempCounty.put(130828, "围场满族蒙古族自治县");
        tempCounty.put(130871, "承德高新技术产业开发区");
        tempCounty.put(130881, "平泉市");
        tempCounty.put(130902, "新华区");
        tempCounty.put(130903, "运河区");
        tempCounty.put(130921, "沧县");
        tempCounty.put(130922, "青县");
        tempCounty.put(130923, "东光县");
        tempCounty.put(130924, "海兴县");
        tempCounty.put(130925, "盐山县");
        tempCounty.put(130926, "肃宁县");
        tempCounty.put(130927, "南皮县");
        tempCounty.put(130928, "吴桥县");
        tempCounty.put(130929, "献县");
        tempCounty.put(130930, "孟村回族自治县");
        tempCounty.put(130971, "河北沧州经济开发区");
        tempCounty.put(130972, "沧州高新技术产业开发区");
        tempCounty.put(130973, "沧州渤海新区");
        tempCounty.put(130981, "泊头市");
        tempCounty.put(130982, "任丘市");
        tempCounty.put(130983, "黄骅市");
        tempCounty.put(130984, "河间市");
        tempCounty.put(131002, "安次区");
        tempCounty.put(131003, "广阳区");
        tempCounty.put(131022, "固安县");
        tempCounty.put(131023, "永清县");
        tempCounty.put(131024, "香河县");
        tempCounty.put(131025, "大城县");
        tempCounty.put(131026, "文安县");
        tempCounty.put(131028, "大厂回族自治县");
        tempCounty.put(131071, "廊坊经济技术开发区");
        tempCounty.put(131081, "霸州市");
        tempCounty.put(131082, "三河市");
        tempCounty.put(131102, "桃城区");
        tempCounty.put(131103, "冀州区");
        tempCounty.put(131121, "枣强县");
        tempCounty.put(131122, "武邑县");
        tempCounty.put(131123, "武强县");
        tempCounty.put(131124, "饶阳县");
        tempCounty.put(131125, "安平县");
        tempCounty.put(131126, "故城县");
        tempCounty.put(131127, "景县");
        tempCounty.put(131128, "阜城县");
        tempCounty.put(131171, "河北衡水高新技术产业开发区");
        tempCounty.put(131172, "衡水滨湖新区");
        tempCounty.put(131182, "深州市");
        tempCounty.put(140105, "小店区");
        tempCounty.put(140106, "迎泽区");
        tempCounty.put(140107, "杏花岭区");
        tempCounty.put(140108, "尖草坪区");
        tempCounty.put(140109, "万柏林区");
        tempCounty.put(140110, "晋源区");
        tempCounty.put(140121, "清徐县");
        tempCounty.put(140122, "阳曲县");
        tempCounty.put(140123, "娄烦县");
        tempCounty.put(140171, "山西转型综合改革示范区");
        tempCounty.put(140181, "古交市");
        tempCounty.put(140212, "新荣区");
        tempCounty.put(140213, "平城区");
        tempCounty.put(140214, "云冈区");
        tempCounty.put(140215, "云州区");
        tempCounty.put(140221, "阳高县");
        tempCounty.put(140222, "天镇县");
        tempCounty.put(140223, "广灵县");
        tempCounty.put(140224, "灵丘县");
        tempCounty.put(140225, "浑源县");
        tempCounty.put(140226, "左云县");
        tempCounty.put(140271, "山西大同经济开发区");
        tempCounty.put(140302, "城区");
        tempCounty.put(140303, "矿区");
        tempCounty.put(140311, "郊区");
        tempCounty.put(140321, "平定县");
        tempCounty.put(140322, "盂县");
        tempCounty.put(140403, "潞州区");
        tempCounty.put(140404, "上党区");
        tempCounty.put(140405, "屯留区");
        tempCounty.put(140406, "潞城区");
        tempCounty.put(140423, "襄垣县");
        tempCounty.put(140425, "平顺县");
        tempCounty.put(140426, "黎城县");
        tempCounty.put(140427, "壶关县");
        tempCounty.put(140428, "长子县");
        tempCounty.put(140429, "武乡县");
        tempCounty.put(140430, "沁县");
        tempCounty.put(140431, "沁源县");
        tempCounty.put(140471, "山西长治高新技术产业园区");
        tempCounty.put(140502, "城区");
        tempCounty.put(140521, "沁水县");
        tempCounty.put(140522, "阳城县");
        tempCounty.put(140524, "陵川县");
        tempCounty.put(140525, "泽州县");
        tempCounty.put(140581, "高平市");
        tempCounty.put(140602, "朔城区");
        tempCounty.put(140603, "平鲁区");
        tempCounty.put(140621, "山阴县");
        tempCounty.put(140622, "应县");
        tempCounty.put(140623, "右玉县");
        tempCounty.put(140671, "山西朔州经济开发区");
        tempCounty.put(140681, "怀仁市");
        tempCounty.put(140702, "榆次区");
        tempCounty.put(140703, "太谷区");
        tempCounty.put(140721, "榆社县");
        tempCounty.put(140722, "左权县");
        tempCounty.put(140723, "和顺县");
        tempCounty.put(140724, "昔阳县");
        tempCounty.put(140725, "寿阳县");
        tempCounty.put(140727, "祁县");
        tempCounty.put(140728, "平遥县");
        tempCounty.put(140729, "灵石县");
        tempCounty.put(140781, "介休市");
        tempCounty.put(140802, "盐湖区");
        tempCounty.put(140821, "临猗县");
        tempCounty.put(140822, "万荣县");
        tempCounty.put(140823, "闻喜县");
        tempCounty.put(140824, "稷山县");
        tempCounty.put(140825, "新绛县");
        tempCounty.put(140826, "绛县");
        tempCounty.put(140827, "垣曲县");
        tempCounty.put(140828, "夏县");
        tempCounty.put(140829, "平陆县");
        tempCounty.put(140830, "芮城县");
        tempCounty.put(140881, "永济市");
        tempCounty.put(140882, "河津市");
        tempCounty.put(140902, "忻府区");
        tempCounty.put(140921, "定襄县");
        tempCounty.put(140922, "五台县");
        tempCounty.put(140923, "代县");
        tempCounty.put(140924, "繁峙县");
        tempCounty.put(140925, "宁武县");
        tempCounty.put(140926, "静乐县");
        tempCounty.put(140927, "神池县");
        tempCounty.put(140928, "五寨县");
        tempCounty.put(140929, "岢岚县");
        tempCounty.put(140930, "河曲县");
        tempCounty.put(140931, "保德县");
        tempCounty.put(140932, "偏关县");
        tempCounty.put(140971, "五台山风景名胜区");
        tempCounty.put(140981, "原平市");
        tempCounty.put(141002, "尧都区");
        tempCounty.put(141021, "曲沃县");
        tempCounty.put(141022, "翼城县");
        tempCounty.put(141023, "襄汾县");
        tempCounty.put(141024, "洪洞县");
        tempCounty.put(141025, "古县");
        tempCounty.put(141026, "安泽县");
        tempCounty.put(141027, "浮山县");
        tempCounty.put(141028, "吉县");
        tempCounty.put(141029, "乡宁县");
        tempCounty.put(141030, "大宁县");
        tempCounty.put(141031, "隰县");
        tempCounty.put(141032, "永和县");
        tempCounty.put(141033, "蒲县");
        tempCounty.put(141034, "汾西县");
        tempCounty.put(141081, "侯马市");
        tempCounty.put(141082, "霍州市");
        tempCounty.put(141102, "离石区");
        tempCounty.put(141121, "文水县");
        tempCounty.put(141122, "交城县");
        tempCounty.put(141123, "兴县");
        tempCounty.put(141124, "临县");
        tempCounty.put(141125, "柳林县");
        tempCounty.put(141126, "石楼县");
        tempCounty.put(141127, "岚县");
        tempCounty.put(141128, "方山县");
        tempCounty.put(141129, "中阳县");
        tempCounty.put(141130, "交口县");
        tempCounty.put(141181, "孝义市");
        tempCounty.put(141182, "汾阳市");
        tempCounty.put(150102, "新城区");
        tempCounty.put(150103, "回民区");
        tempCounty.put(150104, "玉泉区");
        tempCounty.put(150105, "赛罕区");
        tempCounty.put(150121, "土默特左旗");
        tempCounty.put(150122, "托克托县");
        tempCounty.put(150123, "和林格尔县");
        tempCounty.put(150124, "清水河县");
        tempCounty.put(150125, "武川县");
        tempCounty.put(150172, "呼和浩特经济技术开发区");
        tempCounty.put(150202, "东河区");
        tempCounty.put(150203, "昆都仑区");
        tempCounty.put(150204, "青山区");
        tempCounty.put(150205, "石拐区");
        tempCounty.put(150206, "白云鄂博矿区");
        tempCounty.put(150207, "九原区");
        tempCounty.put(150221, "土默特右旗");
        tempCounty.put(150222, "固阳县");
        tempCounty.put(150223, "达尔罕茂明安联合旗");
        tempCounty.put(150271, "包头稀土高新技术产业开发区");
        tempCounty.put(150302, "海勃湾区");
        tempCounty.put(150303, "海南区");
        tempCounty.put(150304, "乌达区");
        tempCounty.put(150402, "红山区");
        tempCounty.put(150403, "元宝山区");
        tempCounty.put(150404, "松山区");
        tempCounty.put(150421, "阿鲁科尔沁旗");
        tempCounty.put(150422, "巴林左旗");
        tempCounty.put(150423, "巴林右旗");
        tempCounty.put(150424, "林西县");
        tempCounty.put(150425, "克什克腾旗");
        tempCounty.put(150426, "翁牛特旗");
        tempCounty.put(150428, "喀喇沁旗");
        tempCounty.put(150429, "宁城县");
        tempCounty.put(150430, "敖汉旗");
        tempCounty.put(150502, "科尔沁区");
        tempCounty.put(150521, "科尔沁左翼中旗");
        tempCounty.put(150522, "科尔沁左翼后旗");
        tempCounty.put(150523, "开鲁县");
        tempCounty.put(150524, "库伦旗");
        tempCounty.put(150525, "奈曼旗");
        tempCounty.put(150526, "扎鲁特旗");
        tempCounty.put(150571, "通辽经济技术开发区");
        tempCounty.put(150581, "霍林郭勒市");
        tempCounty.put(150602, "东胜区");
        tempCounty.put(150603, "康巴什区");
        tempCounty.put(150621, "达拉特旗");
        tempCounty.put(150622, "准格尔旗");
        tempCounty.put(150623, "鄂托克前旗");
        tempCounty.put(150624, "鄂托克旗");
        tempCounty.put(150625, "杭锦旗");
        tempCounty.put(150626, "乌审旗");
        tempCounty.put(150627, "伊金霍洛旗");
        tempCounty.put(150702, "海拉尔区");
        tempCounty.put(150703, "扎赉诺尔区");
        tempCounty.put(150721, "阿荣旗");
        tempCounty.put(150722, "莫力达瓦达斡尔族自治旗");
        tempCounty.put(150723, "鄂伦春自治旗");
        tempCounty.put(150724, "鄂温克族自治旗");
        tempCounty.put(150725, "陈巴尔虎旗");
        tempCounty.put(150726, "新巴尔虎左旗");
        tempCounty.put(150727, "新巴尔虎右旗");
        tempCounty.put(150781, "满洲里市");
        tempCounty.put(150782, "牙克石市");
        tempCounty.put(150783, "扎兰屯市");
        tempCounty.put(150784, "额尔古纳市");
        tempCounty.put(150785, "根河市");
        tempCounty.put(150802, "临河区");
        tempCounty.put(150821, "五原县");
        tempCounty.put(150822, "磴口县");
        tempCounty.put(150823, "乌拉特前旗");
        tempCounty.put(150824, "乌拉特中旗");
        tempCounty.put(150825, "乌拉特后旗");
        tempCounty.put(150826, "杭锦后旗");
        tempCounty.put(150902, "集宁区");
        tempCounty.put(150921, "卓资县");
        tempCounty.put(150922, "化德县");
        tempCounty.put(150923, "商都县");
        tempCounty.put(150924, "兴和县");
        tempCounty.put(150925, "凉城县");
        tempCounty.put(150926, "察哈尔右翼前旗");
        tempCounty.put(150927, "察哈尔右翼中旗");
        tempCounty.put(150928, "察哈尔右翼后旗");
        tempCounty.put(150929, "四子王旗");
        tempCounty.put(150981, "丰镇市");
        tempCounty.put(152201, "乌兰浩特市");
        tempCounty.put(152202, "阿尔山市");
        tempCounty.put(152221, "科尔沁右翼前旗");
        tempCounty.put(152222, "科尔沁右翼中旗");
        tempCounty.put(152223, "扎赉特旗");
        tempCounty.put(152224, "突泉县");
        tempCounty.put(152501, "二连浩特市");
        tempCounty.put(152502, "锡林浩特市");
        tempCounty.put(152522, "阿巴嘎旗");
        tempCounty.put(152523, "苏尼特左旗");
        tempCounty.put(152524, "苏尼特右旗");
        tempCounty.put(152525, "东乌珠穆沁旗");
        tempCounty.put(152526, "西乌珠穆沁旗");
        tempCounty.put(152527, "太仆寺旗");
        tempCounty.put(152528, "镶黄旗");
        tempCounty.put(152529, "正镶白旗");
        tempCounty.put(152530, "正蓝旗");
        tempCounty.put(152531, "多伦县");
        tempCounty.put(152571, "乌拉盖管委会");
        tempCounty.put(152921, "阿拉善左旗");
        tempCounty.put(152922, "阿拉善右旗");
        tempCounty.put(152923, "额济纳旗");
        tempCounty.put(152971, "内蒙古阿拉善经济开发区");
        tempCounty.put(210102, "和平区");
        tempCounty.put(210103, "沈河区");
        tempCounty.put(210104, "大东区");
        tempCounty.put(210105, "皇姑区");
        tempCounty.put(210106, "铁西区");
        tempCounty.put(210111, "苏家屯区");
        tempCounty.put(210112, "浑南区");
        tempCounty.put(210113, "沈北新区");
        tempCounty.put(210114, "于洪区");
        tempCounty.put(210115, "辽中区");
        tempCounty.put(210123, "康平县");
        tempCounty.put(210124, "法库县");
        tempCounty.put(210181, "新民市");
        tempCounty.put(210202, "中山区");
        tempCounty.put(210203, "西岗区");
        tempCounty.put(210204, "沙河口区");
        tempCounty.put(210211, "甘井子区");
        tempCounty.put(210212, "旅顺口区");
        tempCounty.put(210213, "金州区");
        tempCounty.put(210214, "普兰店区");
        tempCounty.put(210224, "长海县");
        tempCounty.put(210281, "瓦房店市");
        tempCounty.put(210283, "庄河市");
        tempCounty.put(210302, "铁东区");
        tempCounty.put(210303, "铁西区");
        tempCounty.put(210304, "立山区");
        tempCounty.put(210311, "千山区");
        tempCounty.put(210321, "台安县");
        tempCounty.put(210323, "岫岩满族自治县");
        tempCounty.put(210381, "海城市");
        tempCounty.put(210402, "新抚区");
        tempCounty.put(210403, "东洲区");
        tempCounty.put(210404, "望花区");
        tempCounty.put(210411, "顺城区");
        tempCounty.put(210421, "抚顺县");
        tempCounty.put(210422, "新宾满族自治县");
        tempCounty.put(210423, "清原满族自治县");
        tempCounty.put(210502, "平山区");
        tempCounty.put(210503, "溪湖区");
        tempCounty.put(210504, "明山区");
        tempCounty.put(210505, "南芬区");
        tempCounty.put(210521, "本溪满族自治县");
        tempCounty.put(210522, "桓仁满族自治县");
        tempCounty.put(210602, "元宝区");
        tempCounty.put(210603, "振兴区");
        tempCounty.put(210604, "振安区");
        tempCounty.put(210624, "宽甸满族自治县");
        tempCounty.put(210681, "东港市");
        tempCounty.put(210682, "凤城市");
        tempCounty.put(210702, "古塔区");
        tempCounty.put(210703, "凌河区");
        tempCounty.put(210711, "太和区");
        tempCounty.put(210726, "黑山县");
        tempCounty.put(210727, "义县");
        tempCounty.put(210781, "凌海市");
        tempCounty.put(210782, "北镇市");
        tempCounty.put(210802, "站前区");
        tempCounty.put(210803, "西市区");
        tempCounty.put(210804, "鲅鱼圈区");
        tempCounty.put(210811, "老边区");
        tempCounty.put(210881, "盖州市");
        tempCounty.put(210882, "大石桥市");
        tempCounty.put(210902, "海州区");
        tempCounty.put(210903, "新邱区");
        tempCounty.put(210904, "太平区");
        tempCounty.put(210905, "清河门区");
        tempCounty.put(210911, "细河区");
        tempCounty.put(210921, "阜新蒙古族自治县");
        tempCounty.put(210922, "彰武县");
        tempCounty.put(211002, "白塔区");
        tempCounty.put(211003, "文圣区");
        tempCounty.put(211004, "宏伟区");
        tempCounty.put(211005, "弓长岭区");
        tempCounty.put(211011, "太子河区");
        tempCounty.put(211021, "辽阳县");
        tempCounty.put(211081, "灯塔市");
        tempCounty.put(211102, "双台子区");
        tempCounty.put(211103, "兴隆台区");
        tempCounty.put(211104, "大洼区");
        tempCounty.put(211122, "盘山县");
        tempCounty.put(211202, "银州区");
        tempCounty.put(211204, "清河区");
        tempCounty.put(211221, "铁岭县");
        tempCounty.put(211223, "西丰县");
        tempCounty.put(211224, "昌图县");
        tempCounty.put(211281, "调兵山市");
        tempCounty.put(211282, "开原市");
        tempCounty.put(211302, "双塔区");
        tempCounty.put(211303, "龙城区");
        tempCounty.put(211321, "朝阳县");
        tempCounty.put(211322, "建平县");
        tempCounty.put(211324, "喀喇沁左翼蒙古族自治县");
        tempCounty.put(211381, "北票市");
        tempCounty.put(211382, "凌源市");
        tempCounty.put(211402, "连山区");
        tempCounty.put(211403, "龙港区");
        tempCounty.put(211404, "南票区");
        tempCounty.put(211421, "绥中县");
        tempCounty.put(211422, "建昌县");
        tempCounty.put(211481, "兴城市");
        tempCounty.put(220102, "南关区");
        tempCounty.put(220103, "宽城区");
        tempCounty.put(220104, "朝阳区");
        tempCounty.put(220105, "二道区");
        tempCounty.put(220106, "绿园区");
        tempCounty.put(220112, "双阳区");
        tempCounty.put(220113, "九台区");
        tempCounty.put(220122, "农安县");
        tempCounty.put(220171, "长春经济技术开发区");
        tempCounty.put(220172, "长春净月高新技术产业开发区");
        tempCounty.put(220173, "长春高新技术产业开发区");
        tempCounty.put(220174, "长春汽车经济技术开发区");
        tempCounty.put(220182, "榆树市");
        tempCounty.put(220183, "德惠市");
        tempCounty.put(220184, "公主岭市");
        tempCounty.put(220202, "昌邑区");
        tempCounty.put(220203, "龙潭区");
        tempCounty.put(220204, "船营区");
        tempCounty.put(220211, "丰满区");
        tempCounty.put(220221, "永吉县");
        tempCounty.put(220271, "吉林经济开发区");
        tempCounty.put(220272, "吉林高新技术产业开发区");
        tempCounty.put(220273, "吉林中国新加坡食品区");
        tempCounty.put(220281, "蛟河市");
        tempCounty.put(220282, "桦甸市");
        tempCounty.put(220283, "舒兰市");
        tempCounty.put(220284, "磐石市");
        tempCounty.put(220302, "铁西区");
        tempCounty.put(220303, "铁东区");
        tempCounty.put(220322, "梨树县");
        tempCounty.put(220323, "伊通满族自治县");
        tempCounty.put(220382, "双辽市");
        tempCounty.put(220402, "龙山区");
        tempCounty.put(220403, "西安区");
        tempCounty.put(220421, "东丰县");
        tempCounty.put(220422, "东辽县");
        tempCounty.put(220502, "东昌区");
        tempCounty.put(220503, "二道江区");
        tempCounty.put(220521, "通化县");
        tempCounty.put(220523, "辉南县");
        tempCounty.put(220524, "柳河县");
        tempCounty.put(220581, "梅河口市");
        tempCounty.put(220582, "集安市");
        tempCounty.put(220602, "浑江区");
        tempCounty.put(220605, "江源区");
        tempCounty.put(220621, "抚松县");
        tempCounty.put(220622, "靖宇县");
        tempCounty.put(220623, "长白朝鲜族自治县");
        tempCounty.put(220681, "临江市");
        tempCounty.put(220702, "宁江区");
        tempCounty.put(220721, "前郭尔罗斯蒙古族自治县");
        tempCounty.put(220722, "长岭县");
        tempCounty.put(220723, "乾安县");
        tempCounty.put(220771, "吉林松原经济开发区");
        tempCounty.put(220781, "扶余市");
        tempCounty.put(220802, "洮北区");
        tempCounty.put(220821, "镇赉县");
        tempCounty.put(220822, "通榆县");
        tempCounty.put(220871, "吉林白城经济开发区");
        tempCounty.put(220881, "洮南市");
        tempCounty.put(220882, "大安市");
        tempCounty.put(222401, "延吉市");
        tempCounty.put(222402, "图们市");
        tempCounty.put(222403, "敦化市");
        tempCounty.put(222404, "珲春市");
        tempCounty.put(222405, "龙井市");
        tempCounty.put(222406, "和龙市");
        tempCounty.put(222424, "汪清县");
        tempCounty.put(222426, "安图县");
        tempCounty.put(230102, "道里区");
        tempCounty.put(230103, "南岗区");
        tempCounty.put(230104, "道外区");
        tempCounty.put(230108, "平房区");
        tempCounty.put(230109, "松北区");
        tempCounty.put(230110, "香坊区");
        tempCounty.put(230111, "呼兰区");
        tempCounty.put(230112, "阿城区");
        tempCounty.put(230113, "双城区");
        tempCounty.put(230123, "依兰县");
        tempCounty.put(230124, "方正县");
        tempCounty.put(230125, "宾县");
        tempCounty.put(230126, "巴彦县");
        tempCounty.put(230127, "木兰县");
        tempCounty.put(230128, "通河县");
        tempCounty.put(230129, "延寿县");
        tempCounty.put(230183, "尚志市");
        tempCounty.put(230184, "五常市");
        tempCounty.put(230202, "龙沙区");
        tempCounty.put(230203, "建华区");
        tempCounty.put(230204, "铁锋区");
        tempCounty.put(230205, "昂昂溪区");
        tempCounty.put(230206, "富拉尔基区");
        tempCounty.put(230207, "碾子山区");
        tempCounty.put(230208, "梅里斯达斡尔族区");
        tempCounty.put(230221, "龙江县");
        tempCounty.put(230223, "依安县");
        tempCounty.put(230224, "泰来县");
        tempCounty.put(230225, "甘南县");
        tempCounty.put(230227, "富裕县");
        tempCounty.put(230229, "克山县");
        tempCounty.put(230230, "克东县");
        tempCounty.put(230231, "拜泉县");
        tempCounty.put(230281, "讷河市");
        tempCounty.put(230302, "鸡冠区");
        tempCounty.put(230303, "恒山区");
        tempCounty.put(230304, "滴道区");
        tempCounty.put(230305, "梨树区");
        tempCounty.put(230306, "城子河区");
        tempCounty.put(230307, "麻山区");
        tempCounty.put(230321, "鸡东县");
        tempCounty.put(230381, "虎林市");
        tempCounty.put(230382, "密山市");
        tempCounty.put(230402, "向阳区");
        tempCounty.put(230403, "工农区");
        tempCounty.put(230404, "南山区");
        tempCounty.put(230405, "兴安区");
        tempCounty.put(230406, "东山区");
        tempCounty.put(230407, "兴山区");
        tempCounty.put(230421, "萝北县");
        tempCounty.put(230422, "绥滨县");
        tempCounty.put(230502, "尖山区");
        tempCounty.put(230503, "岭东区");
        tempCounty.put(230505, "四方台区");
        tempCounty.put(230506, "宝山区");
        tempCounty.put(230521, "集贤县");
        tempCounty.put(230522, "友谊县");
        tempCounty.put(230523, "宝清县");
        tempCounty.put(230524, "饶河县");
        tempCounty.put(230602, "萨尔图区");
        tempCounty.put(230603, "龙凤区");
        tempCounty.put(230604, "让胡路区");
        tempCounty.put(230605, "红岗区");
        tempCounty.put(230606, "大同区");
        tempCounty.put(230621, "肇州县");
        tempCounty.put(230622, "肇源县");
        tempCounty.put(230623, "林甸县");
        tempCounty.put(230624, "杜尔伯特蒙古族自治县");
        tempCounty.put(230671, "大庆高新技术产业开发区");
        tempCounty.put(230717, "伊美区");
        tempCounty.put(230718, "乌翠区");
        tempCounty.put(230719, "友好区");
        tempCounty.put(230722, "嘉荫县");
        tempCounty.put(230723, "汤旺县");
        tempCounty.put(230724, "丰林县");
        tempCounty.put(230725, "大箐山县");
        tempCounty.put(230726, "南岔县");
        tempCounty.put(230751, "金林区");
        tempCounty.put(230781, "铁力市");
        tempCounty.put(230803, "向阳区");
        tempCounty.put(230804, "前进区");
        tempCounty.put(230805, "东风区");
        tempCounty.put(230811, "郊区");
        tempCounty.put(230822, "桦南县");
        tempCounty.put(230826, "桦川县");
        tempCounty.put(230828, "汤原县");
        tempCounty.put(230881, "同江市");
        tempCounty.put(230882, "富锦市");
        tempCounty.put(230883, "抚远市");
        tempCounty.put(230902, "新兴区");
        tempCounty.put(230903, "桃山区");
        tempCounty.put(230904, "茄子河区");
        tempCounty.put(230921, "勃利县");
        tempCounty.put(231002, "东安区");
        tempCounty.put(231003, "阳明区");
        tempCounty.put(231004, "爱民区");
        tempCounty.put(231005, "西安区");
        tempCounty.put(231025, "林口县");
        tempCounty.put(231071, "牡丹江经济技术开发区");
        tempCounty.put(231081, "绥芬河市");
        tempCounty.put(231083, "海林市");
        tempCounty.put(231084, "宁安市");
        tempCounty.put(231085, "穆棱市");
        tempCounty.put(231086, "东宁市");
        tempCounty.put(231102, "爱辉区");
        tempCounty.put(231123, "逊克县");
        tempCounty.put(231124, "孙吴县");
        tempCounty.put(231181, "北安市");
        tempCounty.put(231182, "五大连池市");
        tempCounty.put(231183, "嫩江市");
        tempCounty.put(231202, "北林区");
        tempCounty.put(231221, "望奎县");
        tempCounty.put(231222, "兰西县");
        tempCounty.put(231223, "青冈县");
        tempCounty.put(231224, "庆安县");
        tempCounty.put(231225, "明水县");
        tempCounty.put(231226, "绥棱县");
        tempCounty.put(231281, "安达市");
        tempCounty.put(231282, "肇东市");
        tempCounty.put(231283, "海伦市");
        tempCounty.put(232701, "漠河市");
        tempCounty.put(232721, "呼玛县");
        tempCounty.put(232722, "塔河县");
        tempCounty.put(232761, "加格达奇区");
        tempCounty.put(232762, "松岭区");
        tempCounty.put(232763, "新林区");
        tempCounty.put(232764, "呼中区");
        tempCounty.put(310101, "黄浦区");
        tempCounty.put(310104, "徐汇区");
        tempCounty.put(310105, "长宁区");
        tempCounty.put(310106, "静安区");
        tempCounty.put(310107, "普陀区");
        tempCounty.put(310109, "虹口区");
        tempCounty.put(310110, "杨浦区");
        tempCounty.put(310112, "闵行区");
        tempCounty.put(310113, "宝山区");
        tempCounty.put(310114, "嘉定区");
        tempCounty.put(310115, "浦东新区");
        tempCounty.put(310116, "金山区");
        tempCounty.put(310117, "松江区");
        tempCounty.put(310118, "青浦区");
        tempCounty.put(310120, "奉贤区");
        tempCounty.put(310151, "崇明区");
        tempCounty.put(320102, "玄武区");
        tempCounty.put(320104, "秦淮区");
        tempCounty.put(320105, "建邺区");
        tempCounty.put(320106, "鼓楼区");
        tempCounty.put(320111, "浦口区");
        tempCounty.put(320113, "栖霞区");
        tempCounty.put(320114, "雨花台区");
        tempCounty.put(320115, "江宁区");
        tempCounty.put(320116, "六合区");
        tempCounty.put(320117, "溧水区");
        tempCounty.put(320118, "高淳区");
        tempCounty.put(320205, "锡山区");
        tempCounty.put(320206, "惠山区");
        tempCounty.put(320211, "滨湖区");
        tempCounty.put(320213, "梁溪区");
        tempCounty.put(320214, "新吴区");
        tempCounty.put(320281, "江阴市");
        tempCounty.put(320282, "宜兴市");
        tempCounty.put(320302, "鼓楼区");
        tempCounty.put(320303, "云龙区");
        tempCounty.put(320305, "贾汪区");
        tempCounty.put(320311, "泉山区");
        tempCounty.put(320312, "铜山区");
        tempCounty.put(320321, "丰县");
        tempCounty.put(320322, "沛县");
        tempCounty.put(320324, "睢宁县");
        tempCounty.put(320371, "徐州经济技术开发区");
        tempCounty.put(320381, "新沂市");
        tempCounty.put(320382, "邳州市");
        tempCounty.put(320402, "天宁区");
        tempCounty.put(320404, "钟楼区");
        tempCounty.put(320411, "新北区");
        tempCounty.put(320412, "武进区");
        tempCounty.put(320413, "金坛区");
        tempCounty.put(320481, "溧阳市");
        tempCounty.put(320505, "虎丘区");
        tempCounty.put(320506, "吴中区");
        tempCounty.put(320507, "相城区");
        tempCounty.put(320508, "姑苏区");
        tempCounty.put(320509, "吴江区");
        tempCounty.put(320571, "苏州工业园区");
        tempCounty.put(320581, "常熟市");
        tempCounty.put(320582, "张家港市");
        tempCounty.put(320583, "昆山市");
        tempCounty.put(320585, "太仓市");
        tempCounty.put(320602, "崇川区");
        tempCounty.put(320611, "港闸区");
        tempCounty.put(320612, "通州区");
        tempCounty.put(320623, "如东县");
        tempCounty.put(320671, "南通经济技术开发区");
        tempCounty.put(320681, "启东市");
        tempCounty.put(320682, "如皋市");
        tempCounty.put(320684, "海门市");
        tempCounty.put(320685, "海安市");
        tempCounty.put(320703, "连云区");
        tempCounty.put(320706, "海州区");
        tempCounty.put(320707, "赣榆区");
        tempCounty.put(320722, "东海县");
        tempCounty.put(320723, "灌云县");
        tempCounty.put(320724, "灌南县");
        tempCounty.put(320771, "连云港经济技术开发区");
        tempCounty.put(320772, "连云港高新技术产业开发区");
        tempCounty.put(320803, "淮安区");
        tempCounty.put(320804, "淮阴区");
        tempCounty.put(320812, "清江浦区");
        tempCounty.put(320813, "洪泽区");
        tempCounty.put(320826, "涟水县");
        tempCounty.put(320830, "盱眙县");
        tempCounty.put(320831, "金湖县");
        tempCounty.put(320871, "淮安经济技术开发区");
        tempCounty.put(320902, "亭湖区");
        tempCounty.put(320903, "盐都区");
        tempCounty.put(320904, "大丰区");
        tempCounty.put(320921, "响水县");
        tempCounty.put(320922, "滨海县");
        tempCounty.put(320923, "阜宁县");
        tempCounty.put(320924, "射阳县");
        tempCounty.put(320925, "建湖县");
        tempCounty.put(320971, "盐城经济技术开发区");
        tempCounty.put(320981, "东台市");
        tempCounty.put(321002, "广陵区");
        tempCounty.put(321003, "邗江区");
        tempCounty.put(321012, "江都区");
        tempCounty.put(321023, "宝应县");
        tempCounty.put(321071, "扬州经济技术开发区");
        tempCounty.put(321081, "仪征市");
        tempCounty.put(321084, "高邮市");
        tempCounty.put(321102, "京口区");
        tempCounty.put(321111, "润州区");
        tempCounty.put(321112, "丹徒区");
        tempCounty.put(321171, "镇江新区");
        tempCounty.put(321181, "丹阳市");
        tempCounty.put(321182, "扬中市");
        tempCounty.put(321183, "句容市");
        tempCounty.put(321202, "海陵区");
        tempCounty.put(321203, "高港区");
        tempCounty.put(321204, "姜堰区");
        tempCounty.put(321271, "泰州医药高新技术产业开发区");
        tempCounty.put(321281, "兴化市");
        tempCounty.put(321282, "靖江市");
        tempCounty.put(321283, "泰兴市");
        tempCounty.put(321302, "宿城区");
        tempCounty.put(321311, "宿豫区");
        tempCounty.put(321322, "沭阳县");
        tempCounty.put(321323, "泗阳县");
        tempCounty.put(321324, "泗洪县");
        tempCounty.put(321371, "宿迁经济技术开发区");
        tempCounty.put(330102, "上城区");
        tempCounty.put(330103, "下城区");
        tempCounty.put(330104, "江干区");
        tempCounty.put(330105, "拱墅区");
        tempCounty.put(330106, "西湖区");
        tempCounty.put(330108, "滨江区");
        tempCounty.put(330109, "萧山区");
        tempCounty.put(330110, "余杭区");
        tempCounty.put(330111, "富阳区");
        tempCounty.put(330112, "临安区");
        tempCounty.put(330122, "桐庐县");
        tempCounty.put(330127, "淳安县");
        tempCounty.put(330182, "建德市");
        tempCounty.put(330203, "海曙区");
        tempCounty.put(330205, "江北区");
        tempCounty.put(330206, "北仑区");
        tempCounty.put(330211, "镇海区");
        tempCounty.put(330212, "鄞州区");
        tempCounty.put(330213, "奉化区");
        tempCounty.put(330225, "象山县");
        tempCounty.put(330226, "宁海县");
        tempCounty.put(330281, "余姚市");
        tempCounty.put(330282, "慈溪市");
        tempCounty.put(330302, "鹿城区");
        tempCounty.put(330303, "龙湾区");
        tempCounty.put(330304, "瓯海区");
        tempCounty.put(330305, "洞头区");
        tempCounty.put(330324, "永嘉县");
        tempCounty.put(330326, "平阳县");
        tempCounty.put(330327, "苍南县");
        tempCounty.put(330328, "文成县");
        tempCounty.put(330329, "泰顺县");
        tempCounty.put(330371, "温州经济技术开发区");
        tempCounty.put(330381, "瑞安市");
        tempCounty.put(330382, "乐清市");
        tempCounty.put(330383, "龙港市");
        tempCounty.put(330402, "南湖区");
        tempCounty.put(330411, "秀洲区");
        tempCounty.put(330421, "嘉善县");
        tempCounty.put(330424, "海盐县");
        tempCounty.put(330481, "海宁市");
        tempCounty.put(330482, "平湖市");
        tempCounty.put(330483, "桐乡市");
        tempCounty.put(330502, "吴兴区");
        tempCounty.put(330503, "南浔区");
        tempCounty.put(330521, "德清县");
        tempCounty.put(330522, "长兴县");
        tempCounty.put(330523, "安吉县");
        tempCounty.put(330602, "越城区");
        tempCounty.put(330603, "柯桥区");
        tempCounty.put(330604, "上虞区");
        tempCounty.put(330624, "新昌县");
        tempCounty.put(330681, "诸暨市");
        tempCounty.put(330683, "嵊州市");
        tempCounty.put(330702, "婺城区");
        tempCounty.put(330703, "金东区");
        tempCounty.put(330723, "武义县");
        tempCounty.put(330726, "浦江县");
        tempCounty.put(330727, "磐安县");
        tempCounty.put(330781, "兰溪市");
        tempCounty.put(330782, "义乌市");
        tempCounty.put(330783, "东阳市");
        tempCounty.put(330784, "永康市");
        tempCounty.put(330802, "柯城区");
        tempCounty.put(330803, "衢江区");
        tempCounty.put(330822, "常山县");
        tempCounty.put(330824, "开化县");
        tempCounty.put(330825, "龙游县");
        tempCounty.put(330881, "江山市");
        tempCounty.put(330902, "定海区");
        tempCounty.put(330903, "普陀区");
        tempCounty.put(330921, "岱山县");
        tempCounty.put(330922, "嵊泗县");
        tempCounty.put(331002, "椒江区");
        tempCounty.put(331003, "黄岩区");
        tempCounty.put(331004, "路桥区");
        tempCounty.put(331022, "三门县");
        tempCounty.put(331023, "天台县");
        tempCounty.put(331024, "仙居县");
        tempCounty.put(331081, "温岭市");
        tempCounty.put(331082, "临海市");
        tempCounty.put(331083, "玉环市");
        tempCounty.put(331102, "莲都区");
        tempCounty.put(331121, "青田县");
        tempCounty.put(331122, "缙云县");
        tempCounty.put(331123, "遂昌县");
        tempCounty.put(331124, "松阳县");
        tempCounty.put(331125, "云和县");
        tempCounty.put(331126, "庆元县");
        tempCounty.put(331127, "景宁畲族自治县");
        tempCounty.put(331181, "龙泉市");
        tempCounty.put(340102, "瑶海区");
        tempCounty.put(340103, "庐阳区");
        tempCounty.put(340104, "蜀山区");
        tempCounty.put(340111, "包河区");
        tempCounty.put(340121, "长丰县");
        tempCounty.put(340122, "肥东县");
        tempCounty.put(340123, "肥西县");
        tempCounty.put(340124, "庐江县");
        tempCounty.put(340171, "合肥高新技术产业开发区");
        tempCounty.put(340172, "合肥经济技术开发区");
        tempCounty.put(340173, "合肥新站高新技术产业开发区");
        tempCounty.put(340181, "巢湖市");
        tempCounty.put(340202, "镜湖区");
        tempCounty.put(340203, "弋江区");
        tempCounty.put(340207, "鸠江区");
        tempCounty.put(340208, "三山区");
        tempCounty.put(340221, "芜湖县");
        tempCounty.put(340222, "繁昌县");
        tempCounty.put(340223, "南陵县");
        tempCounty.put(340271, "芜湖经济技术开发区");
        tempCounty.put(340272, "安徽芜湖长江大桥经济开发区");
        tempCounty.put(340281, "无为市");
        tempCounty.put(340302, "龙子湖区");
        tempCounty.put(340303, "蚌山区");
        tempCounty.put(340304, "禹会区");
        tempCounty.put(340311, "淮上区");
        tempCounty.put(340321, "怀远县");
        tempCounty.put(340322, "五河县");
        tempCounty.put(340323, "固镇县");
        tempCounty.put(340371, "蚌埠市高新技术开发区");
        tempCounty.put(340372, "蚌埠市经济开发区");
        tempCounty.put(340402, "大通区");
        tempCounty.put(340403, "田家庵区");
        tempCounty.put(340404, "谢家集区");
        tempCounty.put(340405, "八公山区");
        tempCounty.put(340406, "潘集区");
        tempCounty.put(340421, "凤台县");
        tempCounty.put(340422, "寿县");
        tempCounty.put(340503, "花山区");
        tempCounty.put(340504, "雨山区");
        tempCounty.put(340506, "博望区");
        tempCounty.put(340521, "当涂县");
        tempCounty.put(340522, "含山县");
        tempCounty.put(340523, "和县");
        tempCounty.put(340602, "杜集区");
        tempCounty.put(340603, "相山区");
        tempCounty.put(340604, "烈山区");
        tempCounty.put(340621, "濉溪县");
        tempCounty.put(340705, "铜官区");
        tempCounty.put(340706, "义安区");
        tempCounty.put(340711, "郊区");
        tempCounty.put(340722, "枞阳县");
        tempCounty.put(340802, "迎江区");
        tempCounty.put(340803, "大观区");
        tempCounty.put(340811, "宜秀区");
        tempCounty.put(340822, "怀宁县");
        tempCounty.put(340825, "太湖县");
        tempCounty.put(340826, "宿松县");
        tempCounty.put(340827, "望江县");
        tempCounty.put(340828, "岳西县");
        tempCounty.put(340871, "安徽安庆经济开发区");
        tempCounty.put(340881, "桐城市");
        tempCounty.put(340882, "潜山市");
        tempCounty.put(341002, "屯溪区");
        tempCounty.put(341003, "黄山区");
        tempCounty.put(341004, "徽州区");
        tempCounty.put(341021, "歙县");
        tempCounty.put(341022, "休宁县");
        tempCounty.put(341023, "黟县");
        tempCounty.put(341024, "祁门县");
        tempCounty.put(341102, "琅琊区");
        tempCounty.put(341103, "南谯区");
        tempCounty.put(341122, "来安县");
        tempCounty.put(341124, "全椒县");
        tempCounty.put(341125, "定远县");
        tempCounty.put(341126, "凤阳县");
        tempCounty.put(341171, "苏滁现代产业园");
        tempCounty.put(341172, "滁州经济技术开发区");
        tempCounty.put(341181, "天长市");
        tempCounty.put(341182, "明光市");
        tempCounty.put(341202, "颍州区");
        tempCounty.put(341203, "颍东区");
        tempCounty.put(341204, "颍泉区");
        tempCounty.put(341221, "临泉县");
        tempCounty.put(341222, "太和县");
        tempCounty.put(341225, "阜南县");
        tempCounty.put(341226, "颍上县");
        tempCounty.put(341271, "阜阳合肥现代产业园区");
        tempCounty.put(341272, "阜阳经济技术开发区");
        tempCounty.put(341282, "界首市");
        tempCounty.put(341302, "埇桥区");
        tempCounty.put(341321, "砀山县");
        tempCounty.put(341322, "萧县");
        tempCounty.put(341323, "灵璧县");
        tempCounty.put(341324, "泗县");
        tempCounty.put(341371, "宿州马鞍山现代产业园区");
        tempCounty.put(341372, "宿州经济技术开发区");
        tempCounty.put(341502, "金安区");
        tempCounty.put(341503, "裕安区");
        tempCounty.put(341504, "叶集区");
        tempCounty.put(341522, "霍邱县");
        tempCounty.put(341523, "舒城县");
        tempCounty.put(341524, "金寨县");
        tempCounty.put(341525, "霍山县");
        tempCounty.put(341602, "谯城区");
        tempCounty.put(341621, "涡阳县");
        tempCounty.put(341622, "蒙城县");
        tempCounty.put(341623, "利辛县");
        tempCounty.put(341702, "贵池区");
        tempCounty.put(341721, "东至县");
        tempCounty.put(341722, "石台县");
        tempCounty.put(341723, "青阳县");
        tempCounty.put(341802, "宣州区");
        tempCounty.put(341821, "郎溪县");
        tempCounty.put(341823, "泾县");
        tempCounty.put(341824, "绩溪县");
        tempCounty.put(341825, "旌德县");
        tempCounty.put(341871, "宣城市经济开发区");
        tempCounty.put(341881, "宁国市");
        tempCounty.put(341882, "广德市");
        tempCounty.put(350102, "鼓楼区");
        tempCounty.put(350103, "台江区");
        tempCounty.put(350104, "仓山区");
        tempCounty.put(350105, "马尾区");
        tempCounty.put(350111, "晋安区");
        tempCounty.put(350112, "长乐区");
        tempCounty.put(350121, "闽侯县");
        tempCounty.put(350122, "连江县");
        tempCounty.put(350123, "罗源县");
        tempCounty.put(350124, "闽清县");
        tempCounty.put(350125, "永泰县");
        tempCounty.put(350128, "平潭县");
        tempCounty.put(350181, "福清市");
        tempCounty.put(350203, "思明区");
        tempCounty.put(350205, "海沧区");
        tempCounty.put(350206, "湖里区");
        tempCounty.put(350211, "集美区");
        tempCounty.put(350212, "同安区");
        tempCounty.put(350213, "翔安区");
        tempCounty.put(350302, "城厢区");
        tempCounty.put(350303, "涵江区");
        tempCounty.put(350304, "荔城区");
        tempCounty.put(350305, "秀屿区");
        tempCounty.put(350322, "仙游县");
        tempCounty.put(350402, "梅列区");
        tempCounty.put(350403, "三元区");
        tempCounty.put(350421, "明溪县");
        tempCounty.put(350423, "清流县");
        tempCounty.put(350424, "宁化县");
        tempCounty.put(350425, "大田县");
        tempCounty.put(350426, "尤溪县");
        tempCounty.put(350427, "沙县");
        tempCounty.put(350428, "将乐县");
        tempCounty.put(350429, "泰宁县");
        tempCounty.put(350430, "建宁县");
        tempCounty.put(350481, "永安市");
        tempCounty.put(350502, "鲤城区");
        tempCounty.put(350503, "丰泽区");
        tempCounty.put(350504, "洛江区");
        tempCounty.put(350505, "泉港区");
        tempCounty.put(350521, "惠安县");
        tempCounty.put(350524, "安溪县");
        tempCounty.put(350525, "永春县");
        tempCounty.put(350526, "德化县");
        tempCounty.put(350527, "金门县");
        tempCounty.put(350581, "石狮市");
        tempCounty.put(350582, "晋江市");
        tempCounty.put(350583, "南安市");
        tempCounty.put(350602, "芗城区");
        tempCounty.put(350603, "龙文区");
        tempCounty.put(350622, "云霄县");
        tempCounty.put(350623, "漳浦县");
        tempCounty.put(350624, "诏安县");
        tempCounty.put(350625, "长泰县");
        tempCounty.put(350626, "东山县");
        tempCounty.put(350627, "南靖县");
        tempCounty.put(350628, "平和县");
        tempCounty.put(350629, "华安县");
        tempCounty.put(350681, "龙海市");
        tempCounty.put(350702, "延平区");
        tempCounty.put(350703, "建阳区");
        tempCounty.put(350721, "顺昌县");
        tempCounty.put(350722, "浦城县");
        tempCounty.put(350723, "光泽县");
        tempCounty.put(350724, "松溪县");
        tempCounty.put(350725, "政和县");
        tempCounty.put(350781, "邵武市");
        tempCounty.put(350782, "武夷山市");
        tempCounty.put(350783, "建瓯市");
        tempCounty.put(350802, "新罗区");
        tempCounty.put(350803, "永定区");
        tempCounty.put(350821, "长汀县");
        tempCounty.put(350823, "上杭县");
        tempCounty.put(350824, "武平县");
        tempCounty.put(350825, "连城县");
        tempCounty.put(350881, "漳平市");
        tempCounty.put(350902, "蕉城区");
        tempCounty.put(350921, "霞浦县");
        tempCounty.put(350922, "古田县");
        tempCounty.put(350923, "屏南县");
        tempCounty.put(350924, "寿宁县");
        tempCounty.put(350925, "周宁县");
        tempCounty.put(350926, "柘荣县");
        tempCounty.put(350981, "福安市");
        tempCounty.put(350982, "福鼎市");
        tempCounty.put(360102, "东湖区");
        tempCounty.put(360103, "西湖区");
        tempCounty.put(360104, "青云谱区");
        tempCounty.put(360111, "青山湖区");
        tempCounty.put(360112, "新建区");
        tempCounty.put(360113, "红谷滩区");
        tempCounty.put(360121, "南昌县");
        tempCounty.put(360123, "安义县");
        tempCounty.put(360124, "进贤县");
        tempCounty.put(360202, "昌江区");
        tempCounty.put(360203, "珠山区");
        tempCounty.put(360222, "浮梁县");
        tempCounty.put(360281, "乐平市");
        tempCounty.put(360302, "安源区");
        tempCounty.put(360313, "湘东区");
        tempCounty.put(360321, "莲花县");
        tempCounty.put(360322, "上栗县");
        tempCounty.put(360323, "芦溪县");
        tempCounty.put(360402, "濂溪区");
        tempCounty.put(360403, "浔阳区");
        tempCounty.put(360404, "柴桑区");
        tempCounty.put(360423, "武宁县");
        tempCounty.put(360424, "修水县");
        tempCounty.put(360425, "永修县");
        tempCounty.put(360426, "德安县");
        tempCounty.put(360428, "都昌县");
        tempCounty.put(360429, "湖口县");
        tempCounty.put(360430, "彭泽县");
        tempCounty.put(360481, "瑞昌市");
        tempCounty.put(360482, "共青城市");
        tempCounty.put(360483, "庐山市");
        tempCounty.put(360502, "渝水区");
        tempCounty.put(360521, "分宜县");
        tempCounty.put(360602, "月湖区");
        tempCounty.put(360603, "余江区");
        tempCounty.put(360681, "贵溪市");
        tempCounty.put(360702, "章贡区");
        tempCounty.put(360703, "南康区");
        tempCounty.put(360704, "赣县区");
        tempCounty.put(360722, "信丰县");
        tempCounty.put(360723, "大余县");
        tempCounty.put(360724, "上犹县");
        tempCounty.put(360725, "崇义县");
        tempCounty.put(360726, "安远县");
        tempCounty.put(360728, "定南县");
        tempCounty.put(360729, "全南县");
        tempCounty.put(360730, "宁都县");
        tempCounty.put(360731, "于都县");
        tempCounty.put(360732, "兴国县");
        tempCounty.put(360733, "会昌县");
        tempCounty.put(360734, "寻乌县");
        tempCounty.put(360735, "石城县");
        tempCounty.put(360781, "瑞金市");
        tempCounty.put(360783, "龙南市");
        tempCounty.put(360802, "吉州区");
        tempCounty.put(360803, "青原区");
        tempCounty.put(360821, "吉安县");
        tempCounty.put(360822, "吉水县");
        tempCounty.put(360823, "峡江县");
        tempCounty.put(360824, "新干县");
        tempCounty.put(360825, "永丰县");
        tempCounty.put(360826, "泰和县");
        tempCounty.put(360827, "遂川县");
        tempCounty.put(360828, "万安县");
        tempCounty.put(360829, "安福县");
        tempCounty.put(360830, "永新县");
        tempCounty.put(360881, "井冈山市");
        tempCounty.put(360902, "袁州区");
        tempCounty.put(360921, "奉新县");
        tempCounty.put(360922, "万载县");
        tempCounty.put(360923, "上高县");
        tempCounty.put(360924, "宜丰县");
        tempCounty.put(360925, "靖安县");
        tempCounty.put(360926, "铜鼓县");
        tempCounty.put(360981, "丰城市");
        tempCounty.put(360982, "樟树市");
        tempCounty.put(360983, "高安市");
        tempCounty.put(361002, "临川区");
        tempCounty.put(361003, "东乡区");
        tempCounty.put(361021, "南城县");
        tempCounty.put(361022, "黎川县");
        tempCounty.put(361023, "南丰县");
        tempCounty.put(361024, "崇仁县");
        tempCounty.put(361025, "乐安县");
        tempCounty.put(361026, "宜黄县");
        tempCounty.put(361027, "金溪县");
        tempCounty.put(361028, "资溪县");
        tempCounty.put(361030, "广昌县");
        tempCounty.put(361102, "信州区");
        tempCounty.put(361103, "广丰区");
        tempCounty.put(361104, "广信区");
        tempCounty.put(361123, "玉山县");
        tempCounty.put(361124, "铅山县");
        tempCounty.put(361125, "横峰县");
        tempCounty.put(361126, "弋阳县");
        tempCounty.put(361127, "余干县");
        tempCounty.put(361128, "鄱阳县");
        tempCounty.put(361129, "万年县");
        tempCounty.put(361130, "婺源县");
        tempCounty.put(361181, "德兴市");
        tempCounty.put(370102, "历下区");
        tempCounty.put(370103, "市中区");
        tempCounty.put(370104, "槐荫区");
        tempCounty.put(370105, "天桥区");
        tempCounty.put(370112, "历城区");
        tempCounty.put(370113, "长清区");
        tempCounty.put(370114, "章丘区");
        tempCounty.put(370115, "济阳区");
        tempCounty.put(370116, "莱芜区");
        tempCounty.put(370117, "钢城区");
        tempCounty.put(370124, "平阴县");
        tempCounty.put(370126, "商河县");
        tempCounty.put(370171, "济南高新技术产业开发区");
        tempCounty.put(370202, "市南区");
        tempCounty.put(370203, "市北区");
        tempCounty.put(370211, "黄岛区");
        tempCounty.put(370212, "崂山区");
        tempCounty.put(370213, "李沧区");
        tempCounty.put(370214, "城阳区");
        tempCounty.put(370215, "即墨区");
        tempCounty.put(370271, "青岛高新技术产业开发区");
        tempCounty.put(370281, "胶州市");
        tempCounty.put(370283, "平度市");
        tempCounty.put(370285, "莱西市");
        tempCounty.put(370302, "淄川区");
        tempCounty.put(370303, "张店区");
        tempCounty.put(370304, "博山区");
        tempCounty.put(370305, "临淄区");
        tempCounty.put(370306, "周村区");
        tempCounty.put(370321, "桓台县");
        tempCounty.put(370322, "高青县");
        tempCounty.put(370323, "沂源县");
        tempCounty.put(370402, "市中区");
        tempCounty.put(370403, "薛城区");
        tempCounty.put(370404, "峄城区");
        tempCounty.put(370405, "台儿庄区");
        tempCounty.put(370406, "山亭区");
        tempCounty.put(370481, "滕州市");
        tempCounty.put(370502, "东营区");
        tempCounty.put(370503, "河口区");
        tempCounty.put(370505, "垦利区");
        tempCounty.put(370522, "利津县");
        tempCounty.put(370523, "广饶县");
        tempCounty.put(370571, "东营经济技术开发区");
        tempCounty.put(370572, "东营港经济开发区");
        tempCounty.put(370602, "芝罘区");
        tempCounty.put(370611, "福山区");
        tempCounty.put(370612, "牟平区");
        tempCounty.put(370613, "莱山区");
        tempCounty.put(370614, "蓬莱区");
        tempCounty.put(370671, "烟台高新技术产业开发区");
        tempCounty.put(370672, "烟台经济技术开发区");
        tempCounty.put(370681, "龙口市");
        tempCounty.put(370682, "莱阳市");
        tempCounty.put(370683, "莱州市");
        tempCounty.put(370685, "招远市");
        tempCounty.put(370686, "栖霞市");
        tempCounty.put(370687, "海阳市");
        tempCounty.put(370702, "潍城区");
        tempCounty.put(370703, "寒亭区");
        tempCounty.put(370704, "坊子区");
        tempCounty.put(370705, "奎文区");
        tempCounty.put(370724, "临朐县");
        tempCounty.put(370725, "昌乐县");
        tempCounty.put(370772, "潍坊滨海经济技术开发区");
        tempCounty.put(370781, "青州市");
        tempCounty.put(370782, "诸城市");
        tempCounty.put(370783, "寿光市");
        tempCounty.put(370784, "安丘市");
        tempCounty.put(370785, "高密市");
        tempCounty.put(370786, "昌邑市");
        tempCounty.put(370811, "任城区");
        tempCounty.put(370812, "兖州区");
        tempCounty.put(370826, "微山县");
        tempCounty.put(370827, "鱼台县");
        tempCounty.put(370828, "金乡县");
        tempCounty.put(370829, "嘉祥县");
        tempCounty.put(370830, "汶上县");
        tempCounty.put(370831, "泗水县");
        tempCounty.put(370832, "梁山县");
        tempCounty.put(370871, "济宁高新技术产业开发区");
        tempCounty.put(370881, "曲阜市");
        tempCounty.put(370883, "邹城市");
        tempCounty.put(370902, "泰山区");
        tempCounty.put(370911, "岱岳区");
        tempCounty.put(370921, "宁阳县");
        tempCounty.put(370923, "东平县");
        tempCounty.put(370982, "新泰市");
        tempCounty.put(370983, "肥城市");
        tempCounty.put(371002, "环翠区");
        tempCounty.put(371003, "文登区");
        tempCounty.put(371071, "威海火炬高技术产业开发区");
        tempCounty.put(371072, "威海经济技术开发区");
        tempCounty.put(371073, "威海临港经济技术开发区");
        tempCounty.put(371082, "荣成市");
        tempCounty.put(371083, "乳山市");
        tempCounty.put(371102, "东港区");
        tempCounty.put(371103, "岚山区");
        tempCounty.put(371121, "五莲县");
        tempCounty.put(371122, "莒县");
        tempCounty.put(371171, "日照经济技术开发区");
        tempCounty.put(371302, "兰山区");
        tempCounty.put(371311, "罗庄区");
        tempCounty.put(371312, "河东区");
        tempCounty.put(371321, "沂南县");
        tempCounty.put(371322, "郯城县");
        tempCounty.put(371323, "沂水县");
        tempCounty.put(371324, "兰陵县");
        tempCounty.put(371325, "费县");
        tempCounty.put(371326, "平邑县");
        tempCounty.put(371327, "莒南县");
        tempCounty.put(371328, "蒙阴县");
        tempCounty.put(371329, "临沭县");
        tempCounty.put(371371, "临沂高新技术产业开发区");
        tempCounty.put(371402, "德城区");
        tempCounty.put(371403, "陵城区");
        tempCounty.put(371422, "宁津县");
        tempCounty.put(371423, "庆云县");
        tempCounty.put(371424, "临邑县");
        tempCounty.put(371425, "齐河县");
        tempCounty.put(371426, "平原县");
        tempCounty.put(371427, "夏津县");
        tempCounty.put(371428, "武城县");
        tempCounty.put(371471, "德州经济技术开发区");
        tempCounty.put(371472, "德州运河经济开发区");
        tempCounty.put(371481, "乐陵市");
        tempCounty.put(371482, "禹城市");
        tempCounty.put(371502, "东昌府区");
        tempCounty.put(371503, "茌平区");
        tempCounty.put(371521, "阳谷县");
        tempCounty.put(371522, "莘县");
        tempCounty.put(371524, "东阿县");
        tempCounty.put(371525, "冠县");
        tempCounty.put(371526, "高唐县");
        tempCounty.put(371581, "临清市");
        tempCounty.put(371602, "滨城区");
        tempCounty.put(371603, "沾化区");
        tempCounty.put(371621, "惠民县");
        tempCounty.put(371622, "阳信县");
        tempCounty.put(371623, "无棣县");
        tempCounty.put(371625, "博兴县");
        tempCounty.put(371681, "邹平市");
        tempCounty.put(371702, "牡丹区");
        tempCounty.put(371703, "定陶区");
        tempCounty.put(371721, "曹县");
        tempCounty.put(371722, "单县");
        tempCounty.put(371723, "成武县");
        tempCounty.put(371724, "巨野县");
        tempCounty.put(371725, "郓城县");
        tempCounty.put(371726, "鄄城县");
        tempCounty.put(371728, "东明县");
        tempCounty.put(371771, "菏泽经济技术开发区");
        tempCounty.put(371772, "菏泽高新技术开发区");
        tempCounty.put(410102, "中原区");
        tempCounty.put(410103, "二七区");
        tempCounty.put(410104, "管城回族区");
        tempCounty.put(410105, "金水区");
        tempCounty.put(410106, "上街区");
        tempCounty.put(410108, "惠济区");
        tempCounty.put(410122, "中牟县");
        tempCounty.put(410171, "郑州经济技术开发区");
        tempCounty.put(410172, "郑州高新技术产业开发区");
        tempCounty.put(410173, "郑州航空港经济综合实验区");
        tempCounty.put(410181, "巩义市");
        tempCounty.put(410182, "荥阳市");
        tempCounty.put(410183, "新密市");
        tempCounty.put(410184, "新郑市");
        tempCounty.put(410185, "登封市");
        tempCounty.put(410202, "龙亭区");
        tempCounty.put(410203, "顺河回族区");
        tempCounty.put(410204, "鼓楼区");
        tempCounty.put(410205, "禹王台区");
        tempCounty.put(410212, "祥符区");
        tempCounty.put(410221, "杞县");
        tempCounty.put(410222, "通许县");
        tempCounty.put(410223, "尉氏县");
        tempCounty.put(410225, "兰考县");
        tempCounty.put(410302, "老城区");
        tempCounty.put(410303, "西工区");
        tempCounty.put(410304, "瀍河回族区");
        tempCounty.put(410305, "涧西区");
        tempCounty.put(410306, "吉利区");
        tempCounty.put(410311, "洛龙区");
        tempCounty.put(410322, "孟津县");
        tempCounty.put(410323, "新安县");
        tempCounty.put(410324, "栾川县");
        tempCounty.put(410325, "嵩县");
        tempCounty.put(410326, "汝阳县");
        tempCounty.put(410327, "宜阳县");
        tempCounty.put(410328, "洛宁县");
        tempCounty.put(410329, "伊川县");
        tempCounty.put(410371, "洛阳高新技术产业开发区");
        tempCounty.put(410381, "偃师市");
        tempCounty.put(410402, "新华区");
        tempCounty.put(410403, "卫东区");
        tempCounty.put(410404, "石龙区");
        tempCounty.put(410411, "湛河区");
        tempCounty.put(410421, "宝丰县");
        tempCounty.put(410422, "叶县");
        tempCounty.put(410423, "鲁山县");
        tempCounty.put(410425, "郏县");
        tempCounty.put(410471, "平顶山高新技术产业开发区");
        tempCounty.put(410472, "平顶山市城乡一体化示范区");
        tempCounty.put(410481, "舞钢市");
        tempCounty.put(410482, "汝州市");
        tempCounty.put(410502, "文峰区");
        tempCounty.put(410503, "北关区");
        tempCounty.put(410505, "殷都区");
        tempCounty.put(410506, "龙安区");
        tempCounty.put(410522, "安阳县");
        tempCounty.put(410523, "汤阴县");
        tempCounty.put(410526, "滑县");
        tempCounty.put(410527, "内黄县");
        tempCounty.put(410571, "安阳高新技术产业开发区");
        tempCounty.put(410581, "林州市");
        tempCounty.put(410602, "鹤山区");
        tempCounty.put(410603, "山城区");
        tempCounty.put(410611, "淇滨区");
        tempCounty.put(410621, "浚县");
        tempCounty.put(410622, "淇县");
        tempCounty.put(410671, "鹤壁经济技术开发区");
        tempCounty.put(410702, "红旗区");
        tempCounty.put(410703, "卫滨区");
        tempCounty.put(410704, "凤泉区");
        tempCounty.put(410711, "牧野区");
        tempCounty.put(410721, "新乡县");
        tempCounty.put(410724, "获嘉县");
        tempCounty.put(410725, "原阳县");
        tempCounty.put(410726, "延津县");
        tempCounty.put(410727, "封丘县");
        tempCounty.put(410771, "新乡高新技术产业开发区");
        tempCounty.put(410772, "新乡经济技术开发区");
        tempCounty.put(410773, "新乡市平原城乡一体化示范区");
        tempCounty.put(410781, "卫辉市");
        tempCounty.put(410782, "辉县市");
        tempCounty.put(410783, "长垣市");
        tempCounty.put(410802, "解放区");
        tempCounty.put(410803, "中站区");
        tempCounty.put(410804, "马村区");
        tempCounty.put(410811, "山阳区");
        tempCounty.put(410821, "修武县");
        tempCounty.put(410822, "博爱县");
        tempCounty.put(410823, "武陟县");
        tempCounty.put(410825, "温县");
        tempCounty.put(410871, "焦作城乡一体化示范区");
        tempCounty.put(410882, "沁阳市");
        tempCounty.put(410883, "孟州市");
        tempCounty.put(410902, "华龙区");
        tempCounty.put(410922, "清丰县");
        tempCounty.put(410923, "南乐县");
        tempCounty.put(410926, "范县");
        tempCounty.put(410927, "台前县");
        tempCounty.put(410928, "濮阳县");
        tempCounty.put(410971, "河南濮阳工业园区");
        tempCounty.put(410972, "濮阳经济技术开发区");
        tempCounty.put(411002, "魏都区");
        tempCounty.put(411003, "建安区");
        tempCounty.put(411024, "鄢陵县");
        tempCounty.put(411025, "襄城县");
        tempCounty.put(411071, "许昌经济技术开发区");
        tempCounty.put(411081, "禹州市");
        tempCounty.put(411082, "长葛市");
        tempCounty.put(411102, "源汇区");
        tempCounty.put(411103, "郾城区");
        tempCounty.put(411104, "召陵区");
        tempCounty.put(411121, "舞阳县");
        tempCounty.put(411122, "临颍县");
        tempCounty.put(411171, "漯河经济技术开发区");
        tempCounty.put(411202, "湖滨区");
        tempCounty.put(411203, "陕州区");
        tempCounty.put(411221, "渑池县");
        tempCounty.put(411224, "卢氏县");
        tempCounty.put(411271, "河南三门峡经济开发区");
        tempCounty.put(411281, "义马市");
        tempCounty.put(411282, "灵宝市");
        tempCounty.put(411302, "宛城区");
        tempCounty.put(411303, "卧龙区");
        tempCounty.put(411321, "南召县");
        tempCounty.put(411322, "方城县");
        tempCounty.put(411323, "西峡县");
        tempCounty.put(411324, "镇平县");
        tempCounty.put(411325, "内乡县");
        tempCounty.put(411326, "淅川县");
        tempCounty.put(411327, "社旗县");
        tempCounty.put(411328, "唐河县");
        tempCounty.put(411329, "新野县");
        tempCounty.put(411330, "桐柏县");
        tempCounty.put(411371, "南阳高新技术产业开发区");
        tempCounty.put(411372, "南阳市城乡一体化示范区");
        tempCounty.put(411381, "邓州市");
        tempCounty.put(411402, "梁园区");
        tempCounty.put(411403, "睢阳区");
        tempCounty.put(411421, "民权县");
        tempCounty.put(411422, "睢县");
        tempCounty.put(411423, "宁陵县");
        tempCounty.put(411424, "柘城县");
        tempCounty.put(411425, "虞城县");
        tempCounty.put(411426, "夏邑县");
        tempCounty.put(411471, "豫东综合物流产业聚集区");
        tempCounty.put(411472, "河南商丘经济开发区");
        tempCounty.put(411481, "永城市");
        tempCounty.put(411502, "浉河区");
        tempCounty.put(411503, "平桥区");
        tempCounty.put(411521, "罗山县");
        tempCounty.put(411522, "光山县");
        tempCounty.put(411523, "新县");
        tempCounty.put(411524, "商城县");
        tempCounty.put(411525, "固始县");
        tempCounty.put(411526, "潢川县");
        tempCounty.put(411527, "淮滨县");
        tempCounty.put(411528, "息县");
        tempCounty.put(411571, "信阳高新技术产业开发区");
        tempCounty.put(411602, "川汇区");
        tempCounty.put(411603, "淮阳区");
        tempCounty.put(411621, "扶沟县");
        tempCounty.put(411622, "西华县");
        tempCounty.put(411623, "商水县");
        tempCounty.put(411624, "沈丘县");
        tempCounty.put(411625, "郸城县");
        tempCounty.put(411627, "太康县");
        tempCounty.put(411628, "鹿邑县");
        tempCounty.put(411671, "河南周口经济开发区");
        tempCounty.put(411681, "项城市");
        tempCounty.put(411702, "驿城区");
        tempCounty.put(411721, "西平县");
        tempCounty.put(411722, "上蔡县");
        tempCounty.put(411723, "平舆县");
        tempCounty.put(411724, "正阳县");
        tempCounty.put(411725, "确山县");
        tempCounty.put(411726, "泌阳县");
        tempCounty.put(411727, "汝南县");
        tempCounty.put(411728, "遂平县");
        tempCounty.put(411729, "新蔡县");
        tempCounty.put(411771, "河南驻马店经济开发区");
        tempCounty.put(419001, "济源市");
        tempCounty.put(420102, "江岸区");
        tempCounty.put(420103, "江汉区");
        tempCounty.put(420104, "硚口区");
        tempCounty.put(420105, "汉阳区");
        tempCounty.put(420106, "武昌区");
        tempCounty.put(420107, "青山区");
        tempCounty.put(420111, "洪山区");
        tempCounty.put(420112, "东西湖区");
        tempCounty.put(420113, "汉南区");
        tempCounty.put(420114, "蔡甸区");
        tempCounty.put(420115, "江夏区");
        tempCounty.put(420116, "黄陂区");
        tempCounty.put(420117, "新洲区");
        tempCounty.put(420202, "黄石港区");
        tempCounty.put(420203, "西塞山区");
        tempCounty.put(420204, "下陆区");
        tempCounty.put(420205, "铁山区");
        tempCounty.put(420222, "阳新县");
        tempCounty.put(420281, "大冶市");
        tempCounty.put(420302, "茅箭区");
        tempCounty.put(420303, "张湾区");
        tempCounty.put(420304, "郧阳区");
        tempCounty.put(420322, "郧西县");
        tempCounty.put(420323, "竹山县");
        tempCounty.put(420324, "竹溪县");
        tempCounty.put(420325, "房县");
        tempCounty.put(420381, "丹江口市");
        tempCounty.put(420502, "西陵区");
        tempCounty.put(420503, "伍家岗区");
        tempCounty.put(420504, "点军区");
        tempCounty.put(420505, "猇亭区");
        tempCounty.put(420506, "夷陵区");
        tempCounty.put(420525, "远安县");
        tempCounty.put(420526, "兴山县");
        tempCounty.put(420527, "秭归县");
        tempCounty.put(420528, "长阳土家族自治县");
        tempCounty.put(420529, "五峰土家族自治县");
        tempCounty.put(420581, "宜都市");
        tempCounty.put(420582, "当阳市");
        tempCounty.put(420583, "枝江市");
        tempCounty.put(420602, "襄城区");
        tempCounty.put(420606, "樊城区");
        tempCounty.put(420607, "襄州区");
        tempCounty.put(420624, "南漳县");
        tempCounty.put(420625, "谷城县");
        tempCounty.put(420626, "保康县");
        tempCounty.put(420682, "老河口市");
        tempCounty.put(420683, "枣阳市");
        tempCounty.put(420684, "宜城市");
        tempCounty.put(420702, "梁子湖区");
        tempCounty.put(420703, "华容区");
        tempCounty.put(420704, "鄂城区");
        tempCounty.put(420802, "东宝区");
        tempCounty.put(420804, "掇刀区");
        tempCounty.put(420822, "沙洋县");
        tempCounty.put(420881, "钟祥市");
        tempCounty.put(420882, "京山市");
        tempCounty.put(420902, "孝南区");
        tempCounty.put(420921, "孝昌县");
        tempCounty.put(420922, "大悟县");
        tempCounty.put(420923, "云梦县");
        tempCounty.put(420981, "应城市");
        tempCounty.put(420982, "安陆市");
        tempCounty.put(420984, "汉川市");
        tempCounty.put(421002, "沙市区");
        tempCounty.put(421003, "荆州区");
        tempCounty.put(421022, "公安县");
        tempCounty.put(421023, "监利县");
        tempCounty.put(421024, "江陵县");
        tempCounty.put(421071, "荆州经济技术开发区");
        tempCounty.put(421081, "石首市");
        tempCounty.put(421083, "洪湖市");
        tempCounty.put(421087, "松滋市");
        tempCounty.put(421102, "黄州区");
        tempCounty.put(421121, "团风县");
        tempCounty.put(421122, "红安县");
        tempCounty.put(421123, "罗田县");
        tempCounty.put(421124, "英山县");
        tempCounty.put(421125, "浠水县");
        tempCounty.put(421126, "蕲春县");
        tempCounty.put(421127, "黄梅县");
        tempCounty.put(421171, "龙感湖管理区");
        tempCounty.put(421181, "麻城市");
        tempCounty.put(421182, "武穴市");
        tempCounty.put(421202, "咸安区");
        tempCounty.put(421221, "嘉鱼县");
        tempCounty.put(421222, "通城县");
        tempCounty.put(421223, "崇阳县");
        tempCounty.put(421224, "通山县");
        tempCounty.put(421281, "赤壁市");
        tempCounty.put(421303, "曾都区");
        tempCounty.put(421321, "随县");
        tempCounty.put(421381, "广水市");
        tempCounty.put(422801, "恩施市");
        tempCounty.put(422802, "利川市");
        tempCounty.put(422822, "建始县");
        tempCounty.put(422823, "巴东县");
        tempCounty.put(422825, "宣恩县");
        tempCounty.put(422826, "咸丰县");
        tempCounty.put(422827, "来凤县");
        tempCounty.put(422828, "鹤峰县");
        tempCounty.put(429004, "仙桃市");
        tempCounty.put(429005, "潜江市");
        tempCounty.put(429006, "天门市");
        tempCounty.put(429021, "神农架林区");
        tempCounty.put(430102, "芙蓉区");
        tempCounty.put(430103, "天心区");
        tempCounty.put(430104, "岳麓区");
        tempCounty.put(430105, "开福区");
        tempCounty.put(430111, "雨花区");
        tempCounty.put(430112, "望城区");
        tempCounty.put(430121, "长沙县");
        tempCounty.put(430181, "浏阳市");
        tempCounty.put(430182, "宁乡市");
        tempCounty.put(430202, "荷塘区");
        tempCounty.put(430203, "芦淞区");
        tempCounty.put(430204, "石峰区");
        tempCounty.put(430211, "天元区");
        tempCounty.put(430212, "渌口区");
        tempCounty.put(430223, "攸县");
        tempCounty.put(430224, "茶陵县");
        tempCounty.put(430225, "炎陵县");
        tempCounty.put(430271, "云龙示范区");
        tempCounty.put(430281, "醴陵市");
        tempCounty.put(430302, "雨湖区");
        tempCounty.put(430304, "岳塘区");
        tempCounty.put(430321, "湘潭县");
        tempCounty.put(430371, "湖南湘潭高新技术产业园区");
        tempCounty.put(430372, "湘潭昭山示范区");
        tempCounty.put(430373, "湘潭九华示范区");
        tempCounty.put(430381, "湘乡市");
        tempCounty.put(430382, "韶山市");
        tempCounty.put(430405, "珠晖区");
        tempCounty.put(430406, "雁峰区");
        tempCounty.put(430407, "石鼓区");
        tempCounty.put(430408, "蒸湘区");
        tempCounty.put(430412, "南岳区");
        tempCounty.put(430421, "衡阳县");
        tempCounty.put(430422, "衡南县");
        tempCounty.put(430423, "衡山县");
        tempCounty.put(430424, "衡东县");
        tempCounty.put(430426, "祁东县");
        tempCounty.put(430471, "衡阳综合保税区");
        tempCounty.put(430472, "湖南衡阳高新技术产业园区");
        tempCounty.put(430473, "湖南衡阳松木经济开发区");
        tempCounty.put(430481, "耒阳市");
        tempCounty.put(430482, "常宁市");
        tempCounty.put(430502, "双清区");
        tempCounty.put(430503, "大祥区");
        tempCounty.put(430511, "北塔区");
        tempCounty.put(430522, "新邵县");
        tempCounty.put(430523, "邵阳县");
        tempCounty.put(430524, "隆回县");
        tempCounty.put(430525, "洞口县");
        tempCounty.put(430527, "绥宁县");
        tempCounty.put(430528, "新宁县");
        tempCounty.put(430529, "城步苗族自治县");
        tempCounty.put(430581, "武冈市");
        tempCounty.put(430582, "邵东市");
        tempCounty.put(430602, "岳阳楼区");
        tempCounty.put(430603, "云溪区");
        tempCounty.put(430611, "君山区");
        tempCounty.put(430621, "岳阳县");
        tempCounty.put(430623, "华容县");
        tempCounty.put(430624, "湘阴县");
        tempCounty.put(430626, "平江县");
        tempCounty.put(430671, "岳阳市屈原管理区");
        tempCounty.put(430681, "汨罗市");
        tempCounty.put(430682, "临湘市");
        tempCounty.put(430702, "武陵区");
        tempCounty.put(430703, "鼎城区");
        tempCounty.put(430721, "安乡县");
        tempCounty.put(430722, "汉寿县");
        tempCounty.put(430723, "澧县");
        tempCounty.put(430724, "临澧县");
        tempCounty.put(430725, "桃源县");
        tempCounty.put(430726, "石门县");
        tempCounty.put(430771, "常德市西洞庭管理区");
        tempCounty.put(430781, "津市市");
        tempCounty.put(430802, "永定区");
        tempCounty.put(430811, "武陵源区");
        tempCounty.put(430821, "慈利县");
        tempCounty.put(430822, "桑植县");
        tempCounty.put(430902, "资阳区");
        tempCounty.put(430903, "赫山区");
        tempCounty.put(430921, "南县");
        tempCounty.put(430922, "桃江县");
        tempCounty.put(430923, "安化县");
        tempCounty.put(430971, "益阳市大通湖管理区");
        tempCounty.put(430972, "湖南益阳高新技术产业园区");
        tempCounty.put(430981, "沅江市");
        tempCounty.put(431002, "北湖区");
        tempCounty.put(431003, "苏仙区");
        tempCounty.put(431021, "桂阳县");
        tempCounty.put(431022, "宜章县");
        tempCounty.put(431023, "永兴县");
        tempCounty.put(431024, "嘉禾县");
        tempCounty.put(431025, "临武县");
        tempCounty.put(431026, "汝城县");
        tempCounty.put(431027, "桂东县");
        tempCounty.put(431028, "安仁县");
        tempCounty.put(431081, "资兴市");
        tempCounty.put(431102, "零陵区");
        tempCounty.put(431103, "冷水滩区");
        tempCounty.put(431121, "祁阳县");
        tempCounty.put(431122, "东安县");
        tempCounty.put(431123, "双牌县");
        tempCounty.put(431124, "道县");
        tempCounty.put(431125, "江永县");
        tempCounty.put(431126, "宁远县");
        tempCounty.put(431127, "蓝山县");
        tempCounty.put(431128, "新田县");
        tempCounty.put(431129, "江华瑶族自治县");
        tempCounty.put(431171, "永州经济技术开发区");
        tempCounty.put(431172, "永州市金洞管理区");
        tempCounty.put(431173, "永州市回龙圩管理区");
        tempCounty.put(431202, "鹤城区");
        tempCounty.put(431221, "中方县");
        tempCounty.put(431222, "沅陵县");
        tempCounty.put(431223, "辰溪县");
        tempCounty.put(431224, "溆浦县");
        tempCounty.put(431225, "会同县");
        tempCounty.put(431226, "麻阳苗族自治县");
        tempCounty.put(431227, "新晃侗族自治县");
        tempCounty.put(431228, "芷江侗族自治县");
        tempCounty.put(431229, "靖州苗族侗族自治县");
        tempCounty.put(431230, "通道侗族自治县");
        tempCounty.put(431271, "怀化市洪江管理区");
        tempCounty.put(431281, "洪江市");
        tempCounty.put(431302, "娄星区");
        tempCounty.put(431321, "双峰县");
        tempCounty.put(431322, "新化县");
        tempCounty.put(431381, "冷水江市");
        tempCounty.put(431382, "涟源市");
        tempCounty.put(433101, "吉首市");
        tempCounty.put(433122, "泸溪县");
        tempCounty.put(433123, "凤凰县");
        tempCounty.put(433124, "花垣县");
        tempCounty.put(433125, "保靖县");
        tempCounty.put(433126, "古丈县");
        tempCounty.put(433127, "永顺县");
        tempCounty.put(433130, "龙山县");
        tempCounty.put(440103, "荔湾区");
        tempCounty.put(440104, "越秀区");
        tempCounty.put(440105, "海珠区");
        tempCounty.put(440106, "天河区");
        tempCounty.put(440111, "白云区");
        tempCounty.put(440112, "黄埔区");
        tempCounty.put(440113, "番禺区");
        tempCounty.put(440114, "花都区");
        tempCounty.put(440115, "南沙区");
        tempCounty.put(440117, "从化区");
        tempCounty.put(440118, "增城区");
        tempCounty.put(440203, "武江区");
        tempCounty.put(440204, "浈江区");
        tempCounty.put(440205, "曲江区");
        tempCounty.put(440222, "始兴县");
        tempCounty.put(440224, "仁化县");
        tempCounty.put(440229, "翁源县");
        tempCounty.put(440232, "乳源瑶族自治县");
        tempCounty.put(440233, "新丰县");
        tempCounty.put(440281, "乐昌市");
        tempCounty.put(440282, "南雄市");
        tempCounty.put(440303, "罗湖区");
        tempCounty.put(440304, "福田区");
        tempCounty.put(440305, "南山区");
        tempCounty.put(440306, "宝安区");
        tempCounty.put(440307, "龙岗区");
        tempCounty.put(440308, "盐田区");
        tempCounty.put(440309, "龙华区");
        tempCounty.put(440310, "坪山区");
        tempCounty.put(440311, "光明区");
        tempCounty.put(440402, "香洲区");
        tempCounty.put(440403, "斗门区");
        tempCounty.put(440404, "金湾区");
        tempCounty.put(440507, "龙湖区");
        tempCounty.put(440511, "金平区");
        tempCounty.put(440512, "濠江区");
        tempCounty.put(440513, "潮阳区");
        tempCounty.put(440514, "潮南区");
        tempCounty.put(440515, "澄海区");
        tempCounty.put(440523, "南澳县");
        tempCounty.put(440604, "禅城区");
        tempCounty.put(440605, "南海区");
        tempCounty.put(440606, "顺德区");
        tempCounty.put(440607, "三水区");
        tempCounty.put(440608, "高明区");
        tempCounty.put(440703, "蓬江区");
        tempCounty.put(440704, "江海区");
        tempCounty.put(440705, "新会区");
        tempCounty.put(440781, "台山市");
        tempCounty.put(440783, "开平市");
        tempCounty.put(440784, "鹤山市");
        tempCounty.put(440785, "恩平市");
        tempCounty.put(440802, "赤坎区");
        tempCounty.put(440803, "霞山区");
        tempCounty.put(440804, "坡头区");
        tempCounty.put(440811, "麻章区");
        tempCounty.put(440823, "遂溪县");
        tempCounty.put(440825, "徐闻县");
        tempCounty.put(440881, "廉江市");
        tempCounty.put(440882, "雷州市");
        tempCounty.put(440883, "吴川市");
        tempCounty.put(440902, "茂南区");
        tempCounty.put(440904, "电白区");
        tempCounty.put(440981, "高州市");
        tempCounty.put(440982, "化州市");
        tempCounty.put(440983, "信宜市");
        tempCounty.put(441202, "端州区");
        tempCounty.put(441203, "鼎湖区");
        tempCounty.put(441204, "高要区");
        tempCounty.put(441223, "广宁县");
        tempCounty.put(441224, "怀集县");
        tempCounty.put(441225, "封开县");
        tempCounty.put(441226, "德庆县");
        tempCounty.put(441284, "四会市");
        tempCounty.put(441302, "惠城区");
        tempCounty.put(441303, "惠阳区");
        tempCounty.put(441322, "博罗县");
        tempCounty.put(441323, "惠东县");
        tempCounty.put(441324, "龙门县");
        tempCounty.put(441402, "梅江区");
        tempCounty.put(441403, "梅县区");
        tempCounty.put(441422, "大埔县");
        tempCounty.put(441423, "丰顺县");
        tempCounty.put(441424, "五华县");
        tempCounty.put(441426, "平远县");
        tempCounty.put(441427, "蕉岭县");
        tempCounty.put(441481, "兴宁市");
        tempCounty.put(441502, "城区");
        tempCounty.put(441521, "海丰县");
        tempCounty.put(441523, "陆河县");
        tempCounty.put(441581, "陆丰市");
        tempCounty.put(441602, "源城区");
        tempCounty.put(441621, "紫金县");
        tempCounty.put(441622, "龙川县");
        tempCounty.put(441623, "连平县");
        tempCounty.put(441624, "和平县");
        tempCounty.put(441625, "东源县");
        tempCounty.put(441702, "江城区");
        tempCounty.put(441704, "阳东区");
        tempCounty.put(441721, "阳西县");
        tempCounty.put(441781, "阳春市");
        tempCounty.put(441802, "清城区");
        tempCounty.put(441803, "清新区");
        tempCounty.put(441821, "佛冈县");
        tempCounty.put(441823, "阳山县");
        tempCounty.put(441825, "连山壮族瑶族自治县");
        tempCounty.put(441826, "连南瑶族自治县");
        tempCounty.put(441881, "英德市");
        tempCounty.put(441882, "连州市");
        tempCounty.put(441900, "常平镇");
        tempCounty.put(442000, "横栏镇");
        tempCounty.put(445102, "湘桥区");
        tempCounty.put(445103, "潮安区");
        tempCounty.put(445122, "饶平县");
        tempCounty.put(445202, "榕城区");
        tempCounty.put(445203, "揭东区");
        tempCounty.put(445222, "揭西县");
        tempCounty.put(445224, "惠来县");
        tempCounty.put(445281, "普宁市");
        tempCounty.put(445302, "云城区");
        tempCounty.put(445303, "云安区");
        tempCounty.put(445321, "新兴县");
        tempCounty.put(445322, "郁南县");
        tempCounty.put(445381, "罗定市");
        tempCounty.put(450102, "兴宁区");
        tempCounty.put(450103, "青秀区");
        tempCounty.put(450105, "江南区");
        tempCounty.put(450107, "西乡塘区");
        tempCounty.put(450108, "良庆区");
        tempCounty.put(450109, "邕宁区");
        tempCounty.put(450110, "武鸣区");
        tempCounty.put(450123, "隆安县");
        tempCounty.put(450124, "马山县");
        tempCounty.put(450125, "上林县");
        tempCounty.put(450126, "宾阳县");
        tempCounty.put(450127, "横县");
        tempCounty.put(450202, "城中区");
        tempCounty.put(450203, "鱼峰区");
        tempCounty.put(450204, "柳南区");
        tempCounty.put(450205, "柳北区");
        tempCounty.put(450206, "柳江区");
        tempCounty.put(450222, "柳城县");
        tempCounty.put(450223, "鹿寨县");
        tempCounty.put(450224, "融安县");
        tempCounty.put(450225, "融水苗族自治县");
        tempCounty.put(450226, "三江侗族自治县");
        tempCounty.put(450302, "秀峰区");
        tempCounty.put(450303, "叠彩区");
        tempCounty.put(450304, "象山区");
        tempCounty.put(450305, "七星区");
        tempCounty.put(450311, "雁山区");
        tempCounty.put(450312, "临桂区");
        tempCounty.put(450321, "阳朔县");
        tempCounty.put(450323, "灵川县");
        tempCounty.put(450324, "全州县");
        tempCounty.put(450325, "兴安县");
        tempCounty.put(450326, "永福县");
        tempCounty.put(450327, "灌阳县");
        tempCounty.put(450328, "龙胜各族自治县");
        tempCounty.put(450329, "资源县");
        tempCounty.put(450330, "平乐县");
        tempCounty.put(450332, "恭城瑶族自治县");
        tempCounty.put(450381, "荔浦市");
        tempCounty.put(450403, "万秀区");
        tempCounty.put(450405, "长洲区");
        tempCounty.put(450406, "龙圩区");
        tempCounty.put(450421, "苍梧县");
        tempCounty.put(450422, "藤县");
        tempCounty.put(450423, "蒙山县");
        tempCounty.put(450481, "岑溪市");
        tempCounty.put(450502, "海城区");
        tempCounty.put(450503, "银海区");
        tempCounty.put(450512, "铁山港区");
        tempCounty.put(450521, "合浦县");
        tempCounty.put(450602, "港口区");
        tempCounty.put(450603, "防城区");
        tempCounty.put(450621, "上思县");
        tempCounty.put(450681, "东兴市");
        tempCounty.put(450702, "钦南区");
        tempCounty.put(450703, "钦北区");
        tempCounty.put(450721, "灵山县");
        tempCounty.put(450722, "浦北县");
        tempCounty.put(450802, "港北区");
        tempCounty.put(450803, "港南区");
        tempCounty.put(450804, "覃塘区");
        tempCounty.put(450821, "平南县");
        tempCounty.put(450881, "桂平市");
        tempCounty.put(450902, "玉州区");
        tempCounty.put(450903, "福绵区");
        tempCounty.put(450921, "容县");
        tempCounty.put(450922, "陆川县");
        tempCounty.put(450923, "博白县");
        tempCounty.put(450924, "兴业县");
        tempCounty.put(450981, "北流市");
        tempCounty.put(451002, "右江区");
        tempCounty.put(451003, "田阳区");
        tempCounty.put(451022, "田东县");
        tempCounty.put(451024, "德保县");
        tempCounty.put(451026, "那坡县");
        tempCounty.put(451027, "凌云县");
        tempCounty.put(451028, "乐业县");
        tempCounty.put(451029, "田林县");
        tempCounty.put(451030, "西林县");
        tempCounty.put(451031, "隆林各族自治县");
        tempCounty.put(451081, "靖西市");
        tempCounty.put(451082, "平果市");
        tempCounty.put(451102, "八步区");
        tempCounty.put(451103, "平桂区");
        tempCounty.put(451121, "昭平县");
        tempCounty.put(451122, "钟山县");
        tempCounty.put(451123, "富川瑶族自治县");
        tempCounty.put(451202, "金城江区");
        tempCounty.put(451203, "宜州区");
        tempCounty.put(451221, "南丹县");
        tempCounty.put(451222, "天峨县");
        tempCounty.put(451223, "凤山县");
        tempCounty.put(451224, "东兰县");
        tempCounty.put(451225, "罗城仫佬族自治县");
        tempCounty.put(451226, "环江毛南族自治县");
        tempCounty.put(451227, "巴马瑶族自治县");
        tempCounty.put(451228, "都安瑶族自治县");
        tempCounty.put(451229, "大化瑶族自治县");
        tempCounty.put(451302, "兴宾区");
        tempCounty.put(451321, "忻城县");
        tempCounty.put(451322, "象州县");
        tempCounty.put(451323, "武宣县");
        tempCounty.put(451324, "金秀瑶族自治县");
        tempCounty.put(451381, "合山市");
        tempCounty.put(451402, "江州区");
        tempCounty.put(451421, "扶绥县");
        tempCounty.put(451422, "宁明县");
        tempCounty.put(451423, "龙州县");
        tempCounty.put(451424, "大新县");
        tempCounty.put(451425, "天等县");
        tempCounty.put(451481, "凭祥市");
        tempCounty.put(460105, "秀英区");
        tempCounty.put(460106, "龙华区");
        tempCounty.put(460107, "琼山区");
        tempCounty.put(460108, "美兰区");
        tempCounty.put(460202, "海棠区");
        tempCounty.put(460203, "吉阳区");
        tempCounty.put(460204, "天涯区");
        tempCounty.put(460205, "崖州区");
        tempCounty.put(460321, "西沙群岛");
        tempCounty.put(460322, "南沙群岛");
        tempCounty.put(460323, "中沙群岛的岛礁及其海域");
        tempCounty.put(460400, "那大镇");
        tempCounty.put(469001, "五指山市");
        tempCounty.put(469002, "琼海市");
        tempCounty.put(469005, "文昌市");
        tempCounty.put(469006, "万宁市");
        tempCounty.put(469007, "东方市");
        tempCounty.put(469021, "定安县");
        tempCounty.put(469022, "屯昌县");
        tempCounty.put(469023, "澄迈县");
        tempCounty.put(469024, "临高县");
        tempCounty.put(469025, "白沙黎族自治县");
        tempCounty.put(469026, "昌江黎族自治县");
        tempCounty.put(469027, "乐东黎族自治县");
        tempCounty.put(469028, "陵水黎族自治县");
        tempCounty.put(469029, "保亭黎族苗族自治县");
        tempCounty.put(469030, "琼中黎族苗族自治县");
        tempCounty.put(500101, "万州区");
        tempCounty.put(500102, "涪陵区");
        tempCounty.put(500103, "渝中区");
        tempCounty.put(500104, "大渡口区");
        tempCounty.put(500105, "江北区");
        tempCounty.put(500106, "沙坪坝区");
        tempCounty.put(500107, "九龙坡区");
        tempCounty.put(500108, "南岸区");
        tempCounty.put(500109, "北碚区");
        tempCounty.put(500110, "綦江区");
        tempCounty.put(500111, "大足区");
        tempCounty.put(500112, "渝北区");
        tempCounty.put(500113, "巴南区");
        tempCounty.put(500114, "黔江区");
        tempCounty.put(500115, "长寿区");
        tempCounty.put(500116, "江津区");
        tempCounty.put(500117, "合川区");
        tempCounty.put(500118, "永川区");
        tempCounty.put(500119, "南川区");
        tempCounty.put(500120, "璧山区");
        tempCounty.put(500151, "铜梁区");
        tempCounty.put(500152, "潼南区");
        tempCounty.put(500153, "荣昌区");
        tempCounty.put(500154, "开州区");
        tempCounty.put(500155, "梁平区");
        tempCounty.put(500156, "武隆区");
        tempCounty.put(500229, "城口县");
        tempCounty.put(500230, "丰都县");
        tempCounty.put(500231, "垫江县");
        tempCounty.put(500233, "忠县");
        tempCounty.put(500235, "云阳县");
        tempCounty.put(500236, "奉节县");
        tempCounty.put(500237, "巫山县");
        tempCounty.put(500238, "巫溪县");
        tempCounty.put(500240, "石柱土家族自治县");
        tempCounty.put(500241, "秀山土家族苗族自治县");
        tempCounty.put(500242, "酉阳土家族苗族自治县");
        tempCounty.put(500243, "彭水苗族土家族自治县");
        tempCounty.put(510104, "锦江区");
        tempCounty.put(510105, "青羊区");
        tempCounty.put(510106, "金牛区");
        tempCounty.put(510107, "武侯区");
        tempCounty.put(510108, "成华区");
        tempCounty.put(510112, "龙泉驿区");
        tempCounty.put(510113, "青白江区");
        tempCounty.put(510114, "新都区");
        tempCounty.put(510115, "温江区");
        tempCounty.put(510116, "双流区");
        tempCounty.put(510117, "郫都区");
        tempCounty.put(510118, "新津区");
        tempCounty.put(510121, "金堂县");
        tempCounty.put(510129, "大邑县");
        tempCounty.put(510131, "蒲江县");
        tempCounty.put(510181, "都江堰市");
        tempCounty.put(510182, "彭州市");
        tempCounty.put(510183, "邛崃市");
        tempCounty.put(510184, "崇州市");
        tempCounty.put(510185, "简阳市");
        tempCounty.put(510302, "自流井区");
        tempCounty.put(510303, "贡井区");
        tempCounty.put(510304, "大安区");
        tempCounty.put(510311, "沿滩区");
        tempCounty.put(510321, "荣县");
        tempCounty.put(510322, "富顺县");
        tempCounty.put(510402, "东区");
        tempCounty.put(510403, "西区");
        tempCounty.put(510411, "仁和区");
        tempCounty.put(510421, "米易县");
        tempCounty.put(510422, "盐边县");
        tempCounty.put(510502, "江阳区");
        tempCounty.put(510503, "纳溪区");
        tempCounty.put(510504, "龙马潭区");
        tempCounty.put(510521, "泸县");
        tempCounty.put(510522, "合江县");
        tempCounty.put(510524, "叙永县");
        tempCounty.put(510525, "古蔺县");
        tempCounty.put(510603, "旌阳区");
        tempCounty.put(510604, "罗江区");
        tempCounty.put(510623, "中江县");
        tempCounty.put(510681, "广汉市");
        tempCounty.put(510682, "什邡市");
        tempCounty.put(510683, "绵竹市");
        tempCounty.put(510703, "涪城区");
        tempCounty.put(510704, "游仙区");
        tempCounty.put(510705, "安州区");
        tempCounty.put(510722, "三台县");
        tempCounty.put(510723, "盐亭县");
        tempCounty.put(510725, "梓潼县");
        tempCounty.put(510726, "北川羌族自治县");
        tempCounty.put(510727, "平武县");
        tempCounty.put(510781, "江油市");
        tempCounty.put(510802, "利州区");
        tempCounty.put(510811, "昭化区");
        tempCounty.put(510812, "朝天区");
        tempCounty.put(510821, "旺苍县");
        tempCounty.put(510822, "青川县");
        tempCounty.put(510823, "剑阁县");
        tempCounty.put(510824, "苍溪县");
        tempCounty.put(510903, "船山区");
        tempCounty.put(510904, "安居区");
        tempCounty.put(510921, "蓬溪县");
        tempCounty.put(510923, "大英县");
        tempCounty.put(510981, "射洪市");
        tempCounty.put(511002, "市中区");
        tempCounty.put(511011, "东兴区");
        tempCounty.put(511024, "威远县");
        tempCounty.put(511025, "资中县");
        tempCounty.put(511071, "内江经济开发区");
        tempCounty.put(511083, "隆昌市");
        tempCounty.put(511102, "市中区");
        tempCounty.put(511111, "沙湾区");
        tempCounty.put(511112, "五通桥区");
        tempCounty.put(511113, "金口河区");
        tempCounty.put(511123, "犍为县");
        tempCounty.put(511124, "井研县");
        tempCounty.put(511126, "夹江县");
        tempCounty.put(511129, "沐川县");
        tempCounty.put(511132, "峨边彝族自治县");
        tempCounty.put(511133, "马边彝族自治县");
        tempCounty.put(511181, "峨眉山市");
        tempCounty.put(511302, "顺庆区");
        tempCounty.put(511303, "高坪区");
        tempCounty.put(511304, "嘉陵区");
        tempCounty.put(511321, "南部县");
        tempCounty.put(511322, "营山县");
        tempCounty.put(511323, "蓬安县");
        tempCounty.put(511324, "仪陇县");
        tempCounty.put(511325, "西充县");
        tempCounty.put(511381, "阆中市");
        tempCounty.put(511402, "东坡区");
        tempCounty.put(511403, "彭山区");
        tempCounty.put(511421, "仁寿县");
        tempCounty.put(511423, "洪雅县");
        tempCounty.put(511424, "丹棱县");
        tempCounty.put(511425, "青神县");
        tempCounty.put(511502, "翠屏区");
        tempCounty.put(511503, "南溪区");
        tempCounty.put(511504, "叙州区");
        tempCounty.put(511523, "江安县");
        tempCounty.put(511524, "长宁县");
        tempCounty.put(511525, "高县");
        tempCounty.put(511526, "珙县");
        tempCounty.put(511527, "筠连县");
        tempCounty.put(511528, "兴文县");
        tempCounty.put(511529, "屏山县");
        tempCounty.put(511602, "广安区");
        tempCounty.put(511603, "前锋区");
        tempCounty.put(511621, "岳池县");
        tempCounty.put(511622, "武胜县");
        tempCounty.put(511623, "邻水县");
        tempCounty.put(511681, "华蓥市");
        tempCounty.put(511702, "通川区");
        tempCounty.put(511703, "达川区");
        tempCounty.put(511722, "宣汉县");
        tempCounty.put(511723, "开江县");
        tempCounty.put(511724, "大竹县");
        tempCounty.put(511725, "渠县");
        tempCounty.put(511771, "达州经济开发区");
        tempCounty.put(511781, "万源市");
        tempCounty.put(511802, "雨城区");
        tempCounty.put(511803, "名山区");
        tempCounty.put(511822, "荥经县");
        tempCounty.put(511823, "汉源县");
        tempCounty.put(511824, "石棉县");
        tempCounty.put(511825, "天全县");
        tempCounty.put(511826, "芦山县");
        tempCounty.put(511827, "宝兴县");
        tempCounty.put(511902, "巴州区");
        tempCounty.put(511903, "恩阳区");
        tempCounty.put(511921, "通江县");
        tempCounty.put(511922, "南江县");
        tempCounty.put(511923, "平昌县");
        tempCounty.put(511971, "巴中经济开发区");
        tempCounty.put(512002, "雁江区");
        tempCounty.put(512021, "安岳县");
        tempCounty.put(512022, "乐至县");
        tempCounty.put(513201, "马尔康市");
        tempCounty.put(513221, "汶川县");
        tempCounty.put(513222, "理县");
        tempCounty.put(513223, "茂县");
        tempCounty.put(513224, "松潘县");
        tempCounty.put(513225, "九寨沟县");
        tempCounty.put(513226, "金川县");
        tempCounty.put(513227, "小金县");
        tempCounty.put(513228, "黑水县");
        tempCounty.put(513230, "壤塘县");
        tempCounty.put(513231, "阿坝县");
        tempCounty.put(513232, "若尔盖县");
        tempCounty.put(513233, "红原县");
        tempCounty.put(513301, "康定市");
        tempCounty.put(513322, "泸定县");
        tempCounty.put(513323, "丹巴县");
        tempCounty.put(513324, "九龙县");
        tempCounty.put(513325, "雅江县");
        tempCounty.put(513326, "道孚县");
        tempCounty.put(513327, "炉霍县");
        tempCounty.put(513328, "甘孜县");
        tempCounty.put(513329, "新龙县");
        tempCounty.put(513330, "德格县");
        tempCounty.put(513331, "白玉县");
        tempCounty.put(513332, "石渠县");
        tempCounty.put(513333, "色达县");
        tempCounty.put(513334, "理塘县");
        tempCounty.put(513335, "巴塘县");
        tempCounty.put(513336, "乡城县");
        tempCounty.put(513337, "稻城县");
        tempCounty.put(513338, "得荣县");
        tempCounty.put(513401, "西昌市");
        tempCounty.put(513422, "木里藏族自治县");
        tempCounty.put(513423, "盐源县");
        tempCounty.put(513424, "德昌县");
        tempCounty.put(513425, "会理县");
        tempCounty.put(513426, "会东县");
        tempCounty.put(513427, "宁南县");
        tempCounty.put(513428, "普格县");
        tempCounty.put(513429, "布拖县");
        tempCounty.put(513430, "金阳县");
        tempCounty.put(513431, "昭觉县");
        tempCounty.put(513432, "喜德县");
        tempCounty.put(513433, "冕宁县");
        tempCounty.put(513434, "越西县");
        tempCounty.put(513435, "甘洛县");
        tempCounty.put(513436, "美姑县");
        tempCounty.put(513437, "雷波县");
        tempCounty.put(520102, "南明区");
        tempCounty.put(520103, "云岩区");
        tempCounty.put(520111, "花溪区");
        tempCounty.put(520112, "乌当区");
        tempCounty.put(520113, "白云区");
        tempCounty.put(520115, "观山湖区");
        tempCounty.put(520121, "开阳县");
        tempCounty.put(520122, "息烽县");
        tempCounty.put(520123, "修文县");
        tempCounty.put(520181, "清镇市");
        tempCounty.put(520201, "钟山区");
        tempCounty.put(520203, "六枝特区");
        tempCounty.put(520221, "水城县");
        tempCounty.put(520281, "盘州市");
        tempCounty.put(520302, "红花岗区");
        tempCounty.put(520303, "汇川区");
        tempCounty.put(520304, "播州区");
        tempCounty.put(520322, "桐梓县");
        tempCounty.put(520323, "绥阳县");
        tempCounty.put(520324, "正安县");
        tempCounty.put(520325, "道真仡佬族苗族自治县");
        tempCounty.put(520326, "务川仡佬族苗族自治县");
        tempCounty.put(520327, "凤冈县");
        tempCounty.put(520328, "湄潭县");
        tempCounty.put(520329, "余庆县");
        tempCounty.put(520330, "习水县");
        tempCounty.put(520381, "赤水市");
        tempCounty.put(520382, "仁怀市");
        tempCounty.put(520402, "西秀区");
        tempCounty.put(520403, "平坝区");
        tempCounty.put(520422, "普定县");
        tempCounty.put(520423, "镇宁布依族苗族自治县");
        tempCounty.put(520424, "关岭布依族苗族自治县");
        tempCounty.put(520425, "紫云苗族布依族自治县");
        tempCounty.put(520502, "七星关区");
        tempCounty.put(520521, "大方县");
        tempCounty.put(520522, "黔西县");
        tempCounty.put(520523, "金沙县");
        tempCounty.put(520524, "织金县");
        tempCounty.put(520525, "纳雍县");
        tempCounty.put(520526, "威宁彝族回族苗族自治县");
        tempCounty.put(520527, "赫章县");
        tempCounty.put(520602, "碧江区");
        tempCounty.put(520603, "万山区");
        tempCounty.put(520621, "江口县");
        tempCounty.put(520622, "玉屏侗族自治县");
        tempCounty.put(520623, "石阡县");
        tempCounty.put(520624, "思南县");
        tempCounty.put(520625, "印江土家族苗族自治县");
        tempCounty.put(520626, "德江县");
        tempCounty.put(520627, "沿河土家族自治县");
        tempCounty.put(520628, "松桃苗族自治县");
        tempCounty.put(522301, "兴义市");
        tempCounty.put(522302, "兴仁市");
        tempCounty.put(522323, "普安县");
        tempCounty.put(522324, "晴隆县");
        tempCounty.put(522325, "贞丰县");
        tempCounty.put(522326, "望谟县");
        tempCounty.put(522327, "册亨县");
        tempCounty.put(522328, "安龙县");
        tempCounty.put(522601, "凯里市");
        tempCounty.put(522622, "黄平县");
        tempCounty.put(522623, "施秉县");
        tempCounty.put(522624, "三穗县");
        tempCounty.put(522625, "镇远县");
        tempCounty.put(522626, "岑巩县");
        tempCounty.put(522627, "天柱县");
        tempCounty.put(522628, "锦屏县");
        tempCounty.put(522629, "剑河县");
        tempCounty.put(522630, "台江县");
        tempCounty.put(522631, "黎平县");
        tempCounty.put(522632, "榕江县");
        tempCounty.put(522633, "从江县");
        tempCounty.put(522634, "雷山县");
        tempCounty.put(522635, "麻江县");
        tempCounty.put(522636, "丹寨县");
        tempCounty.put(522701, "都匀市");
        tempCounty.put(522702, "福泉市");
        tempCounty.put(522722, "荔波县");
        tempCounty.put(522723, "贵定县");
        tempCounty.put(522725, "瓮安县");
        tempCounty.put(522726, "独山县");
        tempCounty.put(522727, "平塘县");
        tempCounty.put(522728, "罗甸县");
        tempCounty.put(522729, "长顺县");
        tempCounty.put(522730, "龙里县");
        tempCounty.put(522731, "惠水县");
        tempCounty.put(522732, "三都水族自治县");
        tempCounty.put(530102, "五华区");
        tempCounty.put(530103, "盘龙区");
        tempCounty.put(530111, "官渡区");
        tempCounty.put(530112, "西山区");
        tempCounty.put(530113, "东川区");
        tempCounty.put(530114, "呈贡区");
        tempCounty.put(530115, "晋宁区");
        tempCounty.put(530124, "富民县");
        tempCounty.put(530125, "宜良县");
        tempCounty.put(530126, "石林彝族自治县");
        tempCounty.put(530127, "嵩明县");
        tempCounty.put(530128, "禄劝彝族苗族自治县");
        tempCounty.put(530129, "寻甸回族彝族自治县");
        tempCounty.put(530181, "安宁市");
        tempCounty.put(530302, "麒麟区");
        tempCounty.put(530303, "沾益区");
        tempCounty.put(530304, "马龙区");
        tempCounty.put(530322, "陆良县");
        tempCounty.put(530323, "师宗县");
        tempCounty.put(530324, "罗平县");
        tempCounty.put(530325, "富源县");
        tempCounty.put(530326, "会泽县");
        tempCounty.put(530381, "宣威市");
        tempCounty.put(530402, "红塔区");
        tempCounty.put(530403, "江川区");
        tempCounty.put(530423, "通海县");
        tempCounty.put(530424, "华宁县");
        tempCounty.put(530425, "易门县");
        tempCounty.put(530426, "峨山彝族自治县");
        tempCounty.put(530427, "新平彝族傣族自治县");
        tempCounty.put(530428, "元江哈尼族彝族傣族自治县");
        tempCounty.put(530481, "澄江市");
        tempCounty.put(530502, "隆阳区");
        tempCounty.put(530521, "施甸县");
        tempCounty.put(530523, "龙陵县");
        tempCounty.put(530524, "昌宁县");
        tempCounty.put(530581, "腾冲市");
        tempCounty.put(530602, "昭阳区");
        tempCounty.put(530621, "鲁甸县");
        tempCounty.put(530622, "巧家县");
        tempCounty.put(530623, "盐津县");
        tempCounty.put(530624, "大关县");
        tempCounty.put(530625, "永善县");
        tempCounty.put(530626, "绥江县");
        tempCounty.put(530627, "镇雄县");
        tempCounty.put(530628, "彝良县");
        tempCounty.put(530629, "威信县");
        tempCounty.put(530681, "水富市");
        tempCounty.put(530702, "古城区");
        tempCounty.put(530721, "玉龙纳西族自治县");
        tempCounty.put(530722, "永胜县");
        tempCounty.put(530723, "华坪县");
        tempCounty.put(530724, "宁蒗彝族自治县");
        tempCounty.put(530802, "思茅区");
        tempCounty.put(530821, "宁洱哈尼族彝族自治县");
        tempCounty.put(530822, "墨江哈尼族自治县");
        tempCounty.put(530823, "景东彝族自治县");
        tempCounty.put(530824, "景谷傣族彝族自治县");
        tempCounty.put(530825, "镇沅彝族哈尼族拉祜族自治县");
        tempCounty.put(530826, "江城哈尼族彝族自治县");
        tempCounty.put(530827, "孟连傣族拉祜族佤族自治县");
        tempCounty.put(530828, "澜沧拉祜族自治县");
        tempCounty.put(530829, "西盟佤族自治县");
        tempCounty.put(530902, "临翔区");
        tempCounty.put(530921, "凤庆县");
        tempCounty.put(530922, "云县");
        tempCounty.put(530923, "永德县");
        tempCounty.put(530924, "镇康县");
        tempCounty.put(530925, "双江拉祜族佤族布朗族傣族自治县");
        tempCounty.put(530926, "耿马傣族佤族自治县");
        tempCounty.put(530927, "沧源佤族自治县");
        tempCounty.put(532301, "楚雄市");
        tempCounty.put(532322, "双柏县");
        tempCounty.put(532323, "牟定县");
        tempCounty.put(532324, "南华县");
        tempCounty.put(532325, "姚安县");
        tempCounty.put(532326, "大姚县");
        tempCounty.put(532327, "永仁县");
        tempCounty.put(532328, "元谋县");
        tempCounty.put(532329, "武定县");
        tempCounty.put(532331, "禄丰县");
        tempCounty.put(532501, "个旧市");
        tempCounty.put(532502, "开远市");
        tempCounty.put(532503, "蒙自市");
        tempCounty.put(532504, "弥勒市");
        tempCounty.put(532523, "屏边苗族自治县");
        tempCounty.put(532524, "建水县");
        tempCounty.put(532525, "石屏县");
        tempCounty.put(532527, "泸西县");
        tempCounty.put(532528, "元阳县");
        tempCounty.put(532529, "红河县");
        tempCounty.put(532530, "金平苗族瑶族傣族自治县");
        tempCounty.put(532531, "绿春县");
        tempCounty.put(532532, "河口瑶族自治县");
        tempCounty.put(532601, "文山市");
        tempCounty.put(532622, "砚山县");
        tempCounty.put(532623, "西畴县");
        tempCounty.put(532624, "麻栗坡县");
        tempCounty.put(532625, "马关县");
        tempCounty.put(532626, "丘北县");
        tempCounty.put(532627, "广南县");
        tempCounty.put(532628, "富宁县");
        tempCounty.put(532801, "景洪市");
        tempCounty.put(532822, "勐海县");
        tempCounty.put(532823, "勐腊县");
        tempCounty.put(532901, "大理市");
        tempCounty.put(532922, "漾濞彝族自治县");
        tempCounty.put(532923, "祥云县");
        tempCounty.put(532924, "宾川县");
        tempCounty.put(532925, "弥渡县");
        tempCounty.put(532926, "南涧彝族自治县");
        tempCounty.put(532927, "巍山彝族回族自治县");
        tempCounty.put(532928, "永平县");
        tempCounty.put(532929, "云龙县");
        tempCounty.put(532930, "洱源县");
        tempCounty.put(532931, "剑川县");
        tempCounty.put(532932, "鹤庆县");
        tempCounty.put(533102, "瑞丽市");
        tempCounty.put(533103, "芒市");
        tempCounty.put(533122, "梁河县");
        tempCounty.put(533123, "盈江县");
        tempCounty.put(533124, "陇川县");
        tempCounty.put(533301, "泸水市");
        tempCounty.put(533323, "福贡县");
        tempCounty.put(533324, "贡山独龙族怒族自治县");
        tempCounty.put(533325, "兰坪白族普米族自治县");
        tempCounty.put(533401, "香格里拉市");
        tempCounty.put(533422, "德钦县");
        tempCounty.put(533423, "维西傈僳族自治县");
        tempCounty.put(540102, "城关区");
        tempCounty.put(540103, "堆龙德庆区");
        tempCounty.put(540104, "达孜区");
        tempCounty.put(540121, "林周县");
        tempCounty.put(540122, "当雄县");
        tempCounty.put(540123, "尼木县");
        tempCounty.put(540124, "曲水县");
        tempCounty.put(540127, "墨竹工卡县");
        tempCounty.put(540171, "格尔木藏青工业园区");
        tempCounty.put(540172, "拉萨经济技术开发区");
        tempCounty.put(540173, "西藏文化旅游创意园区");
        tempCounty.put(540174, "达孜工业园区");
        tempCounty.put(540202, "桑珠孜区");
        tempCounty.put(540221, "南木林县");
        tempCounty.put(540222, "江孜县");
        tempCounty.put(540223, "定日县");
        tempCounty.put(540224, "萨迦县");
        tempCounty.put(540225, "拉孜县");
        tempCounty.put(540226, "昂仁县");
        tempCounty.put(540227, "谢通门县");
        tempCounty.put(540228, "白朗县");
        tempCounty.put(540229, "仁布县");
        tempCounty.put(540230, "康马县");
        tempCounty.put(540231, "定结县");
        tempCounty.put(540232, "仲巴县");
        tempCounty.put(540233, "亚东县");
        tempCounty.put(540234, "吉隆县");
        tempCounty.put(540235, "聂拉木县");
        tempCounty.put(540236, "萨嘎县");
        tempCounty.put(540237, "岗巴县");
        tempCounty.put(540302, "卡若区");
        tempCounty.put(540321, "江达县");
        tempCounty.put(540322, "贡觉县");
        tempCounty.put(540323, "类乌齐县");
        tempCounty.put(540324, "丁青县");
        tempCounty.put(540325, "察雅县");
        tempCounty.put(540326, "八宿县");
        tempCounty.put(540327, "左贡县");
        tempCounty.put(540328, "芒康县");
        tempCounty.put(540329, "洛隆县");
        tempCounty.put(540330, "边坝县");
        tempCounty.put(540402, "巴宜区");
        tempCounty.put(540421, "工布江达县");
        tempCounty.put(540422, "米林县");
        tempCounty.put(540423, "墨脱县");
        tempCounty.put(540424, "波密县");
        tempCounty.put(540425, "察隅县");
        tempCounty.put(540426, "朗县");
        tempCounty.put(540502, "乃东区");
        tempCounty.put(540521, "扎囊县");
        tempCounty.put(540522, "贡嘎县");
        tempCounty.put(540523, "桑日县");
        tempCounty.put(540524, "琼结县");
        tempCounty.put(540525, "曲松县");
        tempCounty.put(540526, "措美县");
        tempCounty.put(540527, "洛扎县");
        tempCounty.put(540528, "加查县");
        tempCounty.put(540529, "隆子县");
        tempCounty.put(540530, "错那县");
        tempCounty.put(540531, "浪卡子县");
        tempCounty.put(540602, "色尼区");
        tempCounty.put(540621, "嘉黎县");
        tempCounty.put(540622, "比如县");
        tempCounty.put(540623, "聂荣县");
        tempCounty.put(540624, "安多县");
        tempCounty.put(540625, "申扎县");
        tempCounty.put(540626, "索县");
        tempCounty.put(540627, "班戈县");
        tempCounty.put(540628, "巴青县");
        tempCounty.put(540629, "尼玛县");
        tempCounty.put(540630, "双湖县");
        tempCounty.put(542521, "普兰县");
        tempCounty.put(542522, "札达县");
        tempCounty.put(542523, "噶尔县");
        tempCounty.put(542524, "日土县");
        tempCounty.put(542525, "革吉县");
        tempCounty.put(542526, "改则县");
        tempCounty.put(542527, "措勤县");
        tempCounty.put(610102, "新城区");
        tempCounty.put(610103, "碑林区");
        tempCounty.put(610104, "莲湖区");
        tempCounty.put(610111, "灞桥区");
        tempCounty.put(610112, "未央区");
        tempCounty.put(610113, "雁塔区");
        tempCounty.put(610114, "阎良区");
        tempCounty.put(610115, "临潼区");
        tempCounty.put(610116, "长安区");
        tempCounty.put(610117, "高陵区");
        tempCounty.put(610118, "鄠邑区");
        tempCounty.put(610122, "蓝田县");
        tempCounty.put(610124, "周至县");
        tempCounty.put(610202, "王益区");
        tempCounty.put(610203, "印台区");
        tempCounty.put(610204, "耀州区");
        tempCounty.put(610222, "宜君县");
        tempCounty.put(610302, "渭滨区");
        tempCounty.put(610303, "金台区");
        tempCounty.put(610304, "陈仓区");
        tempCounty.put(610322, "凤翔县");
        tempCounty.put(610323, "岐山县");
        tempCounty.put(610324, "扶风县");
        tempCounty.put(610326, "眉县");
        tempCounty.put(610327, "陇县");
        tempCounty.put(610328, "千阳县");
        tempCounty.put(610329, "麟游县");
        tempCounty.put(610330, "凤县");
        tempCounty.put(610331, "太白县");
        tempCounty.put(610402, "秦都区");
        tempCounty.put(610403, "杨陵区");
        tempCounty.put(610404, "渭城区");
        tempCounty.put(610422, "三原县");
        tempCounty.put(610423, "泾阳县");
        tempCounty.put(610424, "乾县");
        tempCounty.put(610425, "礼泉县");
        tempCounty.put(610426, "永寿县");
        tempCounty.put(610428, "长武县");
        tempCounty.put(610429, "旬邑县");
        tempCounty.put(610430, "淳化县");
        tempCounty.put(610431, "武功县");
        tempCounty.put(610481, "兴平市");
        tempCounty.put(610482, "彬州市");
        tempCounty.put(610502, "临渭区");
        tempCounty.put(610503, "华州区");
        tempCounty.put(610522, "潼关县");
        tempCounty.put(610523, "大荔县");
        tempCounty.put(610524, "合阳县");
        tempCounty.put(610525, "澄城县");
        tempCounty.put(610526, "蒲城县");
        tempCounty.put(610527, "白水县");
        tempCounty.put(610528, "富平县");
        tempCounty.put(610581, "韩城市");
        tempCounty.put(610582, "华阴市");
        tempCounty.put(610602, "宝塔区");
        tempCounty.put(610603, "安塞区");
        tempCounty.put(610621, "延长县");
        tempCounty.put(610622, "延川县");
        tempCounty.put(610625, "志丹县");
        tempCounty.put(610626, "吴起县");
        tempCounty.put(610627, "甘泉县");
        tempCounty.put(610628, "富县");
        tempCounty.put(610629, "洛川县");
        tempCounty.put(610630, "宜川县");
        tempCounty.put(610631, "黄龙县");
        tempCounty.put(610632, "黄陵县");
        tempCounty.put(610681, "子长市");
        tempCounty.put(610702, "汉台区");
        tempCounty.put(610703, "南郑区");
        tempCounty.put(610722, "城固县");
        tempCounty.put(610723, "洋县");
        tempCounty.put(610724, "西乡县");
        tempCounty.put(610725, "勉县");
        tempCounty.put(610726, "宁强县");
        tempCounty.put(610727, "略阳县");
        tempCounty.put(610728, "镇巴县");
        tempCounty.put(610729, "留坝县");
        tempCounty.put(610730, "佛坪县");
        tempCounty.put(610802, "榆阳区");
        tempCounty.put(610803, "横山区");
        tempCounty.put(610822, "府谷县");
        tempCounty.put(610824, "靖边县");
        tempCounty.put(610825, "定边县");
        tempCounty.put(610826, "绥德县");
        tempCounty.put(610827, "米脂县");
        tempCounty.put(610828, "佳县");
        tempCounty.put(610829, "吴堡县");
        tempCounty.put(610830, "清涧县");
        tempCounty.put(610831, "子洲县");
        tempCounty.put(610881, "神木市");
        tempCounty.put(610902, "汉滨区");
        tempCounty.put(610921, "汉阴县");
        tempCounty.put(610922, "石泉县");
        tempCounty.put(610923, "宁陕县");
        tempCounty.put(610924, "紫阳县");
        tempCounty.put(610925, "岚皋县");
        tempCounty.put(610926, "平利县");
        tempCounty.put(610927, "镇坪县");
        tempCounty.put(610928, "旬阳县");
        tempCounty.put(610929, "白河县");
        tempCounty.put(611002, "商州区");
        tempCounty.put(611021, "洛南县");
        tempCounty.put(611022, "丹凤县");
        tempCounty.put(611023, "商南县");
        tempCounty.put(611024, "山阳县");
        tempCounty.put(611025, "镇安县");
        tempCounty.put(611026, "柞水县");
        tempCounty.put(620102, "城关区");
        tempCounty.put(620103, "七里河区");
        tempCounty.put(620104, "西固区");
        tempCounty.put(620105, "安宁区");
        tempCounty.put(620111, "红古区");
        tempCounty.put(620121, "永登县");
        tempCounty.put(620122, "皋兰县");
        tempCounty.put(620123, "榆中县");
        tempCounty.put(620171, "兰州新区");
        tempCounty.put(620201, "市辖区");
        tempCounty.put(620302, "金川区");
        tempCounty.put(620321, "永昌县");
        tempCounty.put(620402, "白银区");
        tempCounty.put(620403, "平川区");
        tempCounty.put(620421, "靖远县");
        tempCounty.put(620422, "会宁县");
        tempCounty.put(620423, "景泰县");
        tempCounty.put(620502, "秦州区");
        tempCounty.put(620503, "麦积区");
        tempCounty.put(620521, "清水县");
        tempCounty.put(620522, "秦安县");
        tempCounty.put(620523, "甘谷县");
        tempCounty.put(620524, "武山县");
        tempCounty.put(620525, "张家川回族自治县");
        tempCounty.put(620602, "凉州区");
        tempCounty.put(620621, "民勤县");
        tempCounty.put(620622, "古浪县");
        tempCounty.put(620623, "天祝藏族自治县");
        tempCounty.put(620702, "甘州区");
        tempCounty.put(620721, "肃南裕固族自治县");
        tempCounty.put(620722, "民乐县");
        tempCounty.put(620723, "临泽县");
        tempCounty.put(620724, "高台县");
        tempCounty.put(620725, "山丹县");
        tempCounty.put(620802, "崆峒区");
        tempCounty.put(620821, "泾川县");
        tempCounty.put(620822, "灵台县");
        tempCounty.put(620823, "崇信县");
        tempCounty.put(620825, "庄浪县");
        tempCounty.put(620826, "静宁县");
        tempCounty.put(620881, "华亭市");
        tempCounty.put(620902, "肃州区");
        tempCounty.put(620921, "金塔县");
        tempCounty.put(620922, "瓜州县");
        tempCounty.put(620923, "肃北蒙古族自治县");
        tempCounty.put(620924, "阿克塞哈萨克族自治县");
        tempCounty.put(620981, "玉门市");
        tempCounty.put(620982, "敦煌市");
        tempCounty.put(621002, "西峰区");
        tempCounty.put(621021, "庆城县");
        tempCounty.put(621022, "环县");
        tempCounty.put(621023, "华池县");
        tempCounty.put(621024, "合水县");
        tempCounty.put(621025, "正宁县");
        tempCounty.put(621026, "宁县");
        tempCounty.put(621027, "镇原县");
        tempCounty.put(621102, "安定区");
        tempCounty.put(621121, "通渭县");
        tempCounty.put(621122, "陇西县");
        tempCounty.put(621123, "渭源县");
        tempCounty.put(621124, "临洮县");
        tempCounty.put(621125, "漳县");
        tempCounty.put(621126, "岷县");
        tempCounty.put(621202, "武都区");
        tempCounty.put(621221, "成县");
        tempCounty.put(621222, "文县");
        tempCounty.put(621223, "宕昌县");
        tempCounty.put(621224, "康县");
        tempCounty.put(621225, "西和县");
        tempCounty.put(621226, "礼县");
        tempCounty.put(621227, "徽县");
        tempCounty.put(621228, "两当县");
        tempCounty.put(622901, "临夏市");
        tempCounty.put(622921, "临夏县");
        tempCounty.put(622922, "康乐县");
        tempCounty.put(622923, "永靖县");
        tempCounty.put(622924, "广河县");
        tempCounty.put(622925, "和政县");
        tempCounty.put(622926, "东乡族自治县");
        tempCounty.put(622927, "积石山保安族东乡族撒拉族自治县");
        tempCounty.put(623001, "合作市");
        tempCounty.put(623021, "临潭县");
        tempCounty.put(623022, "卓尼县");
        tempCounty.put(623023, "舟曲县");
        tempCounty.put(623024, "迭部县");
        tempCounty.put(623025, "玛曲县");
        tempCounty.put(623026, "碌曲县");
        tempCounty.put(623027, "夏河县");
        tempCounty.put(630102, "城东区");
        tempCounty.put(630103, "城中区");
        tempCounty.put(630104, "城西区");
        tempCounty.put(630105, "城北区");
        tempCounty.put(630106, "湟中区");
        tempCounty.put(630121, "大通回族土族自治县");
        tempCounty.put(630123, "湟源县");
        tempCounty.put(630202, "乐都区");
        tempCounty.put(630203, "平安区");
        tempCounty.put(630222, "民和回族土族自治县");
        tempCounty.put(630223, "互助土族自治县");
        tempCounty.put(630224, "化隆回族自治县");
        tempCounty.put(630225, "循化撒拉族自治县");
        tempCounty.put(632221, "门源回族自治县");
        tempCounty.put(632222, "祁连县");
        tempCounty.put(632223, "海晏县");
        tempCounty.put(632224, "刚察县");
        tempCounty.put(632321, "同仁县");
        tempCounty.put(632322, "尖扎县");
        tempCounty.put(632323, "泽库县");
        tempCounty.put(632324, "河南蒙古族自治县");
        tempCounty.put(632521, "共和县");
        tempCounty.put(632522, "同德县");
        tempCounty.put(632523, "贵德县");
        tempCounty.put(632524, "兴海县");
        tempCounty.put(632525, "贵南县");
        tempCounty.put(632621, "玛沁县");
        tempCounty.put(632622, "班玛县");
        tempCounty.put(632623, "甘德县");
        tempCounty.put(632624, "达日县");
        tempCounty.put(632625, "久治县");
        tempCounty.put(632626, "玛多县");
        tempCounty.put(632701, "玉树市");
        tempCounty.put(632722, "杂多县");
        tempCounty.put(632723, "称多县");
        tempCounty.put(632724, "治多县");
        tempCounty.put(632725, "囊谦县");
        tempCounty.put(632726, "曲麻莱县");
        tempCounty.put(632801, "格尔木市");
        tempCounty.put(632802, "德令哈市");
        tempCounty.put(632803, "茫崖市");
        tempCounty.put(632821, "乌兰县");
        tempCounty.put(632822, "都兰县");
        tempCounty.put(632823, "天峻县");
        tempCounty.put(632857, "大柴旦行政委员会");
        tempCounty.put(640104, "兴庆区");
        tempCounty.put(640105, "西夏区");
        tempCounty.put(640106, "金凤区");
        tempCounty.put(640121, "永宁县");
        tempCounty.put(640122, "贺兰县");
        tempCounty.put(640181, "灵武市");
        tempCounty.put(640202, "大武口区");
        tempCounty.put(640205, "惠农区");
        tempCounty.put(640221, "平罗县");
        tempCounty.put(640302, "利通区");
        tempCounty.put(640303, "红寺堡区");
        tempCounty.put(640323, "盐池县");
        tempCounty.put(640324, "同心县");
        tempCounty.put(640381, "青铜峡市");
        tempCounty.put(640402, "原州区");
        tempCounty.put(640422, "西吉县");
        tempCounty.put(640423, "隆德县");
        tempCounty.put(640424, "泾源县");
        tempCounty.put(640425, "彭阳县");
        tempCounty.put(640502, "沙坡头区");
        tempCounty.put(640521, "中宁县");
        tempCounty.put(640522, "海原县");
        tempCounty.put(650102, "天山区");
        tempCounty.put(650103, "沙依巴克区");
        tempCounty.put(650104, "新市区");
        tempCounty.put(650105, "水磨沟区");
        tempCounty.put(650106, "头屯河区");
        tempCounty.put(650107, "达坂城区");
        tempCounty.put(650109, "米东区");
        tempCounty.put(650121, "乌鲁木齐县");
        tempCounty.put(650202, "独山子区");
        tempCounty.put(650203, "克拉玛依区");
        tempCounty.put(650204, "白碱滩区");
        tempCounty.put(650205, "乌尔禾区");
        tempCounty.put(650402, "高昌区");
        tempCounty.put(650421, "鄯善县");
        tempCounty.put(650422, "托克逊县");
        tempCounty.put(650502, "伊州区");
        tempCounty.put(650521, "巴里坤哈萨克自治县");
        tempCounty.put(650522, "伊吾县");
        tempCounty.put(652301, "昌吉市");
        tempCounty.put(652302, "阜康市");
        tempCounty.put(652323, "呼图壁县");
        tempCounty.put(652324, "玛纳斯县");
        tempCounty.put(652325, "奇台县");
        tempCounty.put(652327, "吉木萨尔县");
        tempCounty.put(652328, "木垒哈萨克自治县");
        tempCounty.put(652701, "博乐市");
        tempCounty.put(652702, "阿拉山口市");
        tempCounty.put(652722, "精河县");
        tempCounty.put(652723, "温泉县");
        tempCounty.put(652801, "库尔勒市");
        tempCounty.put(652822, "轮台县");
        tempCounty.put(652823, "尉犁县");
        tempCounty.put(652824, "若羌县");
        tempCounty.put(652825, "且末县");
        tempCounty.put(652826, "焉耆回族自治县");
        tempCounty.put(652827, "和静县");
        tempCounty.put(652828, "和硕县");
        tempCounty.put(652829, "博湖县");
        tempCounty.put(652871, "库尔勒经济技术开发区");
        tempCounty.put(652901, "阿克苏市");
        tempCounty.put(652902, "库车市");
        tempCounty.put(652922, "温宿县");
        tempCounty.put(652924, "沙雅县");
        tempCounty.put(652925, "新和县");
        tempCounty.put(652926, "拜城县");
        tempCounty.put(652927, "乌什县");
        tempCounty.put(652928, "阿瓦提县");
        tempCounty.put(652929, "柯坪县");
        tempCounty.put(653001, "阿图什市");
        tempCounty.put(653022, "阿克陶县");
        tempCounty.put(653023, "阿合奇县");
        tempCounty.put(653024, "乌恰县");
        tempCounty.put(653101, "喀什市");
        tempCounty.put(653121, "疏附县");
        tempCounty.put(653122, "疏勒县");
        tempCounty.put(653123, "英吉沙县");
        tempCounty.put(653124, "泽普县");
        tempCounty.put(653125, "莎车县");
        tempCounty.put(653126, "叶城县");
        tempCounty.put(653127, "麦盖提县");
        tempCounty.put(653128, "岳普湖县");
        tempCounty.put(653129, "伽师县");
        tempCounty.put(653130, "巴楚县");
        tempCounty.put(653131, "塔什库尔干塔吉克自治县");
        tempCounty.put(653201, "和田市");
        tempCounty.put(653221, "和田县");
        tempCounty.put(653222, "墨玉县");
        tempCounty.put(653223, "皮山县");
        tempCounty.put(653224, "洛浦县");
        tempCounty.put(653225, "策勒县");
        tempCounty.put(653226, "于田县");
        tempCounty.put(653227, "民丰县");
        tempCounty.put(654002, "伊宁市");
        tempCounty.put(654003, "奎屯市");
        tempCounty.put(654004, "霍尔果斯市");
        tempCounty.put(654021, "伊宁县");
        tempCounty.put(654022, "察布查尔锡伯自治县");
        tempCounty.put(654023, "霍城县");
        tempCounty.put(654024, "巩留县");
        tempCounty.put(654025, "新源县");
        tempCounty.put(654026, "昭苏县");
        tempCounty.put(654027, "特克斯县");
        tempCounty.put(654028, "尼勒克县");
        tempCounty.put(654201, "塔城市");
        tempCounty.put(654202, "乌苏市");
        tempCounty.put(654221, "额敏县");
        tempCounty.put(654223, "沙湾县");
        tempCounty.put(654224, "托里县");
        tempCounty.put(654225, "裕民县");
        tempCounty.put(654226, "和布克赛尔蒙古自治县");
        tempCounty.put(654301, "阿勒泰市");
        tempCounty.put(654321, "布尔津县");
        tempCounty.put(654322, "富蕴县");
        tempCounty.put(654323, "福海县");
        tempCounty.put(654324, "哈巴河县");
        tempCounty.put(654325, "青河县");
        tempCounty.put(654326, "吉木乃县");
        tempCounty.put(659001, "石河子市");
        tempCounty.put(659002, "阿拉尔市");
        tempCounty.put(659003, "图木舒克市");
        tempCounty.put(659004, "五家渠市");
        tempCounty.put(659005, "北屯市");
        tempCounty.put(659006, "铁门关市");
        tempCounty.put(659007, "双河市");
        tempCounty.put(659008, "可克达拉市");
        tempCounty.put(659009, "昆玉市");
        tempCounty.put(659010, "胡杨河市");
        COUNTY = Collections.unmodifiableSortedMap(tempCounty);
    }

}
