/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.generator.addres;

import cn.orionsec.kit.generator.addres.AddressType;
import cn.orionsec.kit.lang.utils.Arrays1;
import cn.orionsec.kit.lang.utils.Strings;
import cn.orionsec.kit.lang.utils.random.Randoms;

public class AddressGenerator {
    private static final String[] ADDRESS_CHAR = new String[]{"\u95e8", "\u666f", "\u5c71", "\u4ea4", "\u9053", "\u53e3", "\u5b89", "\u5b9a", "\u6865", "\u4e66", "\u65e7", "\u98de", "\u7fd4", "\u6811", "\u534e", "\u7ea2", "\u6e90", "\u6c99", "\u6768", "\u5b8b", "\u671d", "\u9633", "\u5efa", "\u56fd", "\u9752", "\u548c", "\u6e05", "\u9999", "\u82b1", "\u957f", "\u5b89", "\u65b9", "\u4e91", "\u5e73", "\u884c", "\u660c", "\u6d41", "\u5b98", "\u5404", "\u9a6c", "\u9f99", "\u6f6d", "\u6d77", "\u5927", "\u5c0f", "\u4e1c", "\u5357", "\u897f", "\u5317", "\u4e2d", "\u4e0a", "\u4e0b", "\u82d1", "\u78a7", "\u817e", "\u8f69", "\u57ce", "\u524d", "\u8f9b", "\u56ed", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341", "\u5343", "\u4e07", "\u5de6", "\u53f3", "\u738b", "\u77f3", "\u5f20", "\u674e", "\u767d", "\u987a", "\u7389", "\u91d1", "\u94f6", "\u6e14", "\u98ce", "\u4e30", "\u6cc9", "\u4ea6", "\u65b0", "\u5c71", "\u5bab", "\u5584", "\u826f", "\u8d24", "\u535a", "\u8363", "\u5174", "\u6000", "\u5b9d", "\u5174", "\u519b", "\u798f", "\u8377", "\u6cb3", "\u676d", "\u98de", "\u6d91", "\u6c34", "\u5bb6", "\u6625", "\u590f", "\u79cb", "\u51ac", "\u5c1a", "\u5f69", "\u8679", "\u5bcc", "\u6c11", "\u767b", "\u98ce"};
    private static final String[] COMMUNITY = new String[]{"\u91d1\u878d", "\u5929\u6865", "\u4f53\u80b2", "\u9999\u6cb3", "\u5b66\u9662", "\u66d9\u5149", "\u6e29\u6cc9", "\u56db\u5b63", "\u8f66\u7ad9", "\u80dc\u5229", "\u9ea6\u5b50", "\u4e1c\u8857", "\u897f\u8857", "\u5357\u8857", "\u673a\u573a", "\u6cb3\u6ee8", "\u7480\u74a8", "\u78a7\u6c34", "\u7389\u6865", "\u4e1c\u98ce", "\u5357\u98ce", "\u897f\u98ce", "\u5317\u98ce", "\u7a7a\u6e2f", "\u65b0\u534e", "\u5411\u9633", "\u8fce\u98ce", "\u80dc\u5229", "\u661f\u57ce", "\u7ecf\u6d4e", "\u4ec1\u548c", "\u516c\u56ed", "\u957f\u8679", "\u53cc\u8857", "\u5927\u9053", "\u5bcc\u5f3a", "\u5317\u8857", "\u9ad8\u5730", "\u7ea2\u95e8", "\u5927\u8857", "\u5e73\u5b89", "\u6587\u5316", "\u6587\u827a", "\u5e78\u798f", "\u592a\u5e73", "\u57ce\u5173", "\u901a\u8fd0", "\u6986\u6811", "\u67f3\u6811", "\u5c0f\u8425", "\u5168\u8425", "\u8363\u534e", "\u76db\u4e16", "\u6c5f\u5357", "\u822a\u7a7a", "\u7efc\u5408", "\u5f69\u8679", "\u5149\u660e", "\u98de\u7fd4", "\u6625\u6c5f", "\u6469\u5361", "\u6ee1\u5ead", "\u4e16\u4ee3", "\u96c5\u6d77", "\u592a\u5e73", "\u846b\u82a6", "\u6587\u660e"};

    private AddressGenerator() {
    }

    public static String generatorAddress() {
        int i = Randoms.randomInt((int)3);
        if (i == 0) {
            return AddressGenerator.generatorAddress(AddressType.COMMUNITY);
        }
        if (i == 1) {
            return AddressGenerator.generatorAddress(AddressType.VILLAGE);
        }
        return AddressGenerator.generatorAddress(AddressType.STREET);
    }

    public static String generatorAddress(AddressType type) {
        if (AddressType.COMMUNITY.equals((Object)type)) {
            return AddressGenerator.generatorCommunityAddress();
        }
        if (AddressType.VILLAGE.equals((Object)type)) {
            return AddressGenerator.generatorVillageAddress();
        }
        if (AddressType.STREET.equals((Object)type)) {
            return AddressGenerator.generatorStreetAddress();
        }
        return "";
    }

    public static String generatorCommunityAddress() {
        int i = Randoms.randomInt((int)8);
        StringBuilder sb = new StringBuilder(AddressGenerator.generatorName(AddressType.COMMUNITY));
        if (i >= 2) {
            sb.append(Randoms.randomInt((int)19) + 1);
            int floor = Randoms.randomInt((int)3);
            if (floor == 0) {
                sb.append("\u680b");
            } else if (floor == 1) {
                sb.append("\u53f7\u697c");
            } else if (floor == 2) {
                sb.append("\u53f7\u9662");
            }
        }
        if (i >= 4) {
            sb.append(Randoms.randomInt((int)29) + 1).append("\u5355\u5143");
        }
        if (i >= 6) {
            sb.append(Randoms.randomInt((int)101, (int)2500));
            if (Randoms.randomBoolean()) {
                sb.append("\u5ba4");
            }
        }
        return sb.toString();
    }

    public static String generatorVillageAddress() {
        int i = Randoms.randomInt((int)6);
        StringBuilder sb = new StringBuilder(AddressGenerator.generatorName(AddressType.VILLAGE));
        if (i == 0) {
            sb.append(Randoms.randomInt((int)200) + 1).append("\u6237");
        } else if (i == 1) {
            sb.append(Randoms.randomInt((int)200) + 1).append("\u53f7");
        } else if (i == 2) {
            sb.append(Randoms.randomInt((int)30) + 1).append("\u7ec4");
        } else if (i == 3) {
            sb.append(Randoms.randomInt((int)30) + 1).append("\u7ec4").append(Randoms.randomInt((int)200) + 1).append("\u53f7");
        } else if (i == 4) {
            sb.append(Randoms.randomInt((int)30) + 1).append('-').append(Randoms.randomInt((int)200) + 1);
        }
        return sb.toString();
    }

    public static String generatorStreetAddress() {
        int i = Randoms.randomInt((int)4);
        StringBuilder sb = new StringBuilder(AddressGenerator.generatorName(AddressType.STREET));
        if (i == 0) {
            sb.append(Randoms.randomInt((int)400) + 1).append("\u6237");
        } else if (i == 1) {
            sb.append(Randoms.randomInt((int)400) + 1).append("\u53f7");
        } else if (i == 2) {
            sb.append(Randoms.randomInt((int)50) + 1).append('-').append(Randoms.randomInt((int)400) + 1);
        }
        return sb.toString();
    }

    public static String generatorIdCardAddress() {
        StringBuilder sb;
        int i = Randoms.randomInt((int)3);
        if (i == 0) {
            sb = new StringBuilder(AddressGenerator.generatorName(AddressType.COMMUNITY)).append(Randoms.randomInt((int)19) + 1);
            int floor = Randoms.randomInt((int)3);
            if (floor == 0) {
                sb.append("\u680b");
            } else if (floor == 1) {
                sb.append("\u53f7\u697c");
            } else if (floor == 2) {
                sb.append("\u53f7\u9662");
            }
            sb.append(Randoms.randomInt((int)29) + 1).append("\u5355\u5143").append(Randoms.randomInt((int)101, (int)2500)).append("\u5ba4");
        } else if (i == 1) {
            sb = new StringBuilder(AddressGenerator.generatorName(AddressType.VILLAGE));
            int no = Randoms.randomInt((int)4);
            if (no == 0) {
                sb.append(Randoms.randomInt((int)200) + 1).append("\u6237");
            } else if (no == 1) {
                sb.append(Randoms.randomInt((int)200) + 1).append("\u53f7");
            } else if (no == 2) {
                sb.append(Randoms.randomInt((int)30) + 1).append("\u7ec4");
            } else if (no == 3) {
                sb.append(Randoms.randomInt((int)30) + 1).append("\u7ec4").append(Randoms.randomInt((int)200) + 1).append("\u53f7");
            }
        } else {
            sb = new StringBuilder(AddressGenerator.generatorName(AddressType.STREET));
            int no = Randoms.randomInt((int)2);
            if (no == 0) {
                sb.append(Randoms.randomInt((int)400) + 1).append("\u53f7");
            } else if (no == 1) {
                sb.append(Randoms.randomInt((int)50) + 1).append('-').append(Randoms.randomInt((int)400) + 1).append("\u53f7");
            }
        }
        return sb.toString();
    }

    public static String generatorName() {
        int i = Randoms.randomInt((int)3);
        if (i == 0) {
            return AddressGenerator.generatorName(AddressType.COMMUNITY);
        }
        if (i == 1) {
            return AddressGenerator.generatorName(AddressType.VILLAGE);
        }
        return AddressGenerator.generatorName(AddressType.STREET);
    }

    public static String generatorName(AddressType type) {
        return AddressGenerator.genName() + (String)Arrays1.random((Object[])type.getSuffix());
    }

    private static String genName() {
        int i = Randoms.randomInt((int)100);
        if (i <= 10) {
            return Strings.randomChars((int)Randoms.randomInt((int)2, (int)6));
        }
        if (i <= 20) {
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < Randoms.randomInt((int)2, (int)5) + 1; ++j) {
                sb.append((String)Arrays1.random((Object[])ADDRESS_CHAR));
            }
            return sb.toString();
        }
        if (i <= 30) {
            return (String)Arrays1.random((Object[])COMMUNITY) + (String)Arrays1.random((Object[])COMMUNITY);
        }
        if (i <= 55) {
            return (String)Arrays1.random((Object[])ADDRESS_CHAR) + (String)Arrays1.random((Object[])COMMUNITY);
        }
        if (i <= 80) {
            return (String)Arrays1.random((Object[])COMMUNITY) + (String)Arrays1.random((Object[])ADDRESS_CHAR);
        }
        return (String)Arrays1.random((Object[])COMMUNITY);
    }
}

