/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.generator.bank;

import cn.orionsec.kit.lang.utils.Strings;

public class BankCardSupport {
    private BankCardSupport() {
    }

    public static boolean valid(String cardNo) {
        if (Strings.isBlank((String)cardNo)) {
            return false;
        }
        if (!Strings.isInteger((String)cardNo)) {
            return false;
        }
        if (cardNo.length() > 19 || cardNo.length() < 16) {
            return false;
        }
        char cardCheckCode = BankCardSupport.getCheckCode(cardNo.substring(0, cardNo.length() - 1).toCharArray());
        return cardNo.charAt(cardNo.length() - 1) == cardCheckCode;
    }

    public static int getLuhnSum(char[] chs) {
        int luhnSum = 0;
        int i = chs.length - 1;
        int j = 0;
        while (i >= 0) {
            int k = chs[i] - 48;
            if (j % 2 == 0) {
                k *= 2;
                k = k / 10 + k % 10;
            }
            luhnSum += k;
            --i;
            ++j;
        }
        return luhnSum;
    }

    public static char getCheckCode(char[] chs) {
        int luhnSum = BankCardSupport.getLuhnSum(chs);
        return luhnSum % 10 == 0 ? (char)'0' : (char)(10 - luhnSum % 10 + 48);
    }
}

