/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.generator.plate;

import cn.orionsec.kit.generator.addres.AddressSupport;
import cn.orionsec.kit.lang.utils.Arrays1;
import cn.orionsec.kit.lang.utils.random.Randoms;
import cn.orionsec.kit.lang.utils.regexp.Matches;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class LicensePlateGenerator {
    private static final Map<Integer, Character> PROVINCE_ABBR;
    private static final char[] LETTER;

    private LicensePlateGenerator() {
    }

    public static String generator() {
        return LicensePlateGenerator.generator(AddressSupport.randomProvinceCode());
    }

    public static String generator(int provinceCode) {
        Character province = PROVINCE_ABBR.get(provinceCode);
        if (province == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder().append(province).append(Arrays1.random((char[])LETTER));
        int letterNum = 0;
        for (int i = 0; i < 5; ++i) {
            if (letterNum >= 2) {
                sb.append(Randoms.randomInt((int)10));
                continue;
            }
            if (Randoms.randomBoolean()) {
                sb.append(Arrays1.random((char[])LETTER));
                ++letterNum;
                continue;
            }
            if (i == 4 && letterNum == 0) {
                sb.append(Arrays1.random((char[])LETTER));
                ++letterNum;
                continue;
            }
            sb.append(Randoms.randomInt((int)10));
        }
        String plat = sb.toString();
        return Matches.isPlateNumber((String)plat) ? plat : LicensePlateGenerator.generator(provinceCode);
    }

    static {
        HashMap<Integer, Character> provinceAbbr = new HashMap<Integer, Character>();
        provinceAbbr.put(11, Character.valueOf('\u4eac'));
        provinceAbbr.put(31, Character.valueOf('\u6caa'));
        provinceAbbr.put(12, Character.valueOf('\u6d25'));
        provinceAbbr.put(50, Character.valueOf('\u6e1d'));
        provinceAbbr.put(23, Character.valueOf('\u9ed1'));
        provinceAbbr.put(22, Character.valueOf('\u5409'));
        provinceAbbr.put(21, Character.valueOf('\u8fbd'));
        provinceAbbr.put(15, Character.valueOf('\u8499'));
        provinceAbbr.put(13, Character.valueOf('\u5180'));
        provinceAbbr.put(65, Character.valueOf('\u65b0'));
        provinceAbbr.put(62, Character.valueOf('\u7518'));
        provinceAbbr.put(63, Character.valueOf('\u9752'));
        provinceAbbr.put(61, Character.valueOf('\u9655'));
        provinceAbbr.put(64, Character.valueOf('\u5b81'));
        provinceAbbr.put(41, Character.valueOf('\u8c6b'));
        provinceAbbr.put(37, Character.valueOf('\u9c81'));
        provinceAbbr.put(14, Character.valueOf('\u664b'));
        provinceAbbr.put(34, Character.valueOf('\u7696'));
        provinceAbbr.put(42, Character.valueOf('\u9102'));
        provinceAbbr.put(43, Character.valueOf('\u6e58'));
        provinceAbbr.put(32, Character.valueOf('\u82cf'));
        provinceAbbr.put(51, Character.valueOf('\u5ddd'));
        provinceAbbr.put(52, Character.valueOf('\u8d35'));
        provinceAbbr.put(53, Character.valueOf('\u4e91'));
        provinceAbbr.put(45, Character.valueOf('\u6842'));
        provinceAbbr.put(54, Character.valueOf('\u85cf'));
        provinceAbbr.put(33, Character.valueOf('\u6d59'));
        provinceAbbr.put(36, Character.valueOf('\u8d63'));
        provinceAbbr.put(44, Character.valueOf('\u7ca4'));
        provinceAbbr.put(35, Character.valueOf('\u95fd'));
        provinceAbbr.put(46, Character.valueOf('\u743c'));
        provinceAbbr.put(81, Character.valueOf('\u6e2f'));
        provinceAbbr.put(82, Character.valueOf('\u6fb3'));
        PROVINCE_ABBR = Collections.unmodifiableMap(provinceAbbr);
        LETTER = "ABCDEFGHJKLMNPQRSTUVWXYZ".toCharArray();
    }
}

