/*
 * Copyright (c) 2019 - present Jiahang Li, All rights reserved.
 *
 *   https://kit.orionsec.cn
 *
 * Members:
 *   Jiahang Li - ljh1553488six@139.com - author
 *
 * The MIT License (MIT)
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package cn.orionsec.kit.generator.bank;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * 17大银行类型枚举
 *
 * @author Jiahang Li
 * @version 1.0.0
 * @since 2021/8/9 18:54
 */
public enum BankNameType {

    /**
     * 中国工商银行
     */
    ICBC("中国工商银行", "ICBC", new LinkedHashMap<String, Integer>() {{
        put("620406", 18);
        put("620407", 18);
        put("620409", 18);
        put("620410", 18);
        put("620411", 18);
        put("620412", 18);
        put("620502", 18);
        put("620503", 18);
        put("620405", 18);
        put("620408", 18);
        put("620512", 18);
        put("620602", 18);
        put("620604", 18);
        put("620607", 18);
        put("620611", 18);
        put("620612", 18);
        put("620704", 18);
        put("620706", 18);
        put("620707", 18);
        put("620708", 18);
        put("620709", 18);
        put("620710", 18);
        put("620609", 18);
        put("620712", 18);
        put("620713", 18);
        put("620714", 18);
        put("620802", 18);
        put("620711", 18);
        put("620904", 18);
        put("620905", 18);
        put("621001", 18);
        put("620902", 18);
        put("621103", 18);
        put("621105", 18);
        put("621106", 18);
        put("621107", 18);
        put("621102", 18);
        put("621203", 18);
        put("621204", 18);
        put("621205", 18);
        put("621206", 18);
        put("621207", 18);
        put("621208", 18);
        put("621209", 18);
        put("621210", 18);
        put("621302", 18);
        put("621303", 18);
        put("621202", 18);
        put("621305", 18);
        put("621306", 18);
        put("621307", 18);
        put("621309", 18);
        put("621311", 18);
        put("621313", 18);
        put("621211", 18);
        put("621315", 18);
        put("621304", 18);
        put("621402", 18);
        put("621404", 18);
        put("621405", 18);
        put("621406", 18);
        put("621407", 18);
        put("621408", 18);
        put("621409", 18);
        put("621410", 18);
        put("621502", 18);
        put("621317", 18);
        put("621511", 18);
        put("621602", 18);
        put("621603", 18);
        put("621604", 18);
        put("621605", 18);
        put("621608", 18);
        put("621609", 18);
        put("621610", 18);
        put("621611", 18);
        put("621612", 18);
        put("621613", 18);
        put("621614", 18);
        put("621615", 18);
        put("621616", 18);
        put("621617", 18);
        put("621607", 18);
        put("621606", 18);
        put("621804", 18);
        put("621807", 18);
        put("621813", 18);
        put("621814", 18);
        put("621817", 18);
        put("621901", 18);
        put("621904", 18);
        put("621905", 18);
        put("621906", 18);
        put("621907", 18);
        put("621908", 18);
        put("621909", 18);
        put("621910", 18);
        put("621911", 18);
        put("621912", 18);
        put("621913", 18);
        put("621915", 18);
        put("622002", 18);
        put("621903", 18);
        put("622004", 18);
        put("622005", 18);
        put("622006", 18);
        put("622007", 18);
        put("622008", 18);
        put("622010", 18);
        put("622011", 18);
        put("622012", 18);
        put("621914", 18);
        put("622015", 18);
        put("622016", 18);
        put("622003", 18);
        put("622018", 18);
        put("622019", 18);
        put("622020", 18);
        put("622102", 18);
        put("622103", 18);
        put("622104", 18);
        put("622105", 18);
        put("622013", 18);
        put("622111", 18);
        put("622114", 18);
        put("622200", 19);
        put("622017", 18);
        put("622202", 19);
        put("622203", 19);
        put("622208", 19);
        put("622239", 16);
        put("622224", 16);
        put("622303", 18);
        put("622304", 18);
        put("622305", 18);
        put("622306", 18);
        put("622307", 18);
        put("622308", 18);
        put("622309", 18);
        put("622238", 16);
        put("622314", 18);
        put("622315", 18);
        put("622317", 18);
        put("622302", 18);
        put("622402", 18);
        put("622403", 18);
        put("622404", 18);
        put("622313", 18);
        put("622504", 18);
        put("622505", 18);
        put("622509", 18);
        put("622513", 18);
        put("622517", 18);
        put("622502", 18);
        put("622604", 18);
        put("622605", 18);
        put("622606", 18);
        put("622510", 18);
        put("622703", 18);
        put("622715", 18);
        put("622806", 18);
        put("622902", 18);
        put("622903", 18);
        put("622706", 18);
        put("623002", 18);
        put("623006", 18);
        put("623008", 18);
        put("623011", 18);
        put("623012", 18);
        put("622904", 18);
        put("623015", 18);
        put("623100", 18);
        put("623202", 18);
        put("623301", 18);
        put("623400", 18);
        put("623500", 18);
        put("623602", 18);
        put("623803", 18);
        put("623901", 18);
        put("623014", 18);
        put("624100", 18);
        put("624200", 18);
        put("624301", 18);
        put("624402", 18);
        put("427010", 16);
        put("427019", 16);
        put("438126", 16);
        put("489734", 16);
        put("489735", 16);
        put("489736", 16);
        put("510529", 16);
        put("620200", 18);
        put("620302", 18);
        put("620402", 18);
        put("620403", 18);
        put("620404", 18);
        put("524047", 16);
        put("622110", 18);
        put("622223", 16);
        put("622229", 16);
        put("622231", 16);
        put("622232", 16);
        put("622233", 16);
        put("622234", 16);
        put("622237", 16);
        put("623700", 18);
        put("628288", 16);
        put("624000", 18);
        put("9558", 19);
        put("628286", 16);
        put("622206", 16);
        put("621225", 19);
        put("620058", 19);
        put("621281", 19);
        put("622246", 16);
        put("900000", 19);
        put("544210", 16);
        put("548943", 16);
        put("621558", 19);
        put("621559", 19);
        put("621722", 19);
        put("621723", 19);
        put("620086", 19);
        put("621226", 19);
        put("402791", 16);
        put("427028", 16);
        put("427038", 16);
        put("548259", 16);
        put("528856", 16);
        put("621618", 19);
        put("620516", 19);
        put("621227", 19);
        put("621288", 19);
        put("621721", 19);
        put("900010", 19);
        put("625330", 16);
        put("625331", 16);
        put("625332", 16);
        put("623062", 19);
        put("622236", 16);
        put("621670", 19);
        put("524374", 16);
        put("550213", 16);
        put("621376", 16);
        put("620054", 16);
        put("620142", 16);
        put("621423", 16);
        put("621428", 16);
        put("621434", 16);
        put("621761", 16);
        put("621749", 16);
        put("620184", 16);
        put("621300", 16);
        put("621378", 16);
        put("621720", 19);
        put("621379", 19);
        put("620114", 19);
        put("620146", 19);
        put("621724", 16);
        put("621762", 16);
        put("621371", 16);
        put("620143", 19);
        put("620149", 19);
        put("621730", 19);
        put("621414", 16);
        put("621375", 16);
        put("620187", 16);
        put("621734", 16);
        put("621433", 19);
        put("621370", 19);
        put("622926", 19);
        put("622927", 16);
        put("622928", 16);
        put("622929", 16);
        put("622930", 19);
        put("622931", 19);
        put("621733", 19);
        put("621732", 19);
        put("620124", 19);
        put("620183", 19);
        put("621764", 19);
        put("621372", 19);
        put("621464", 16);
        put("621765", 16);
        put("620094", 16);
        put("620186", 19);
        put("621369", 16);
        put("621763", 16);
        put("620046", 16);
        put("621750", 16);
        put("621377", 19);
        put("620148", 19);
        put("620185", 19);
        put("621367", 16);
        put("621374", 16);
        put("621731", 16);
        put("621781", 16);
        put("625017", 16);
        put("625018", 16);
        put("625019", 16);
    }}, new LinkedHashMap<String, Integer>() {{
        put("427018", 16);
        put("427020", 16);
        put("427029", 16);
        put("427030", 16);
        put("427039", 16);
        put("438125", 16);
        put("45806", 16);
        put("451804", 16);
        put("451810", 16);
        put("451811", 16);
        put("458071", 16);
        put("427062", 16);
        put("524091", 16);
        put("427064", 16);
        put("530970", 16);
        put("53098", 16);
        put("530990", 16);
        put("558360", 16);
        put("622210", 16);
        put("622211", 16);
        put("622212", 16);
        put("622213", 16);
        put("622214", 16);
        put("622220", 16);
        put("622225", 16);
        put("625929", 16);
        put("625927", 16);
        put("625930", 16);
        put("625114", 16);
        put("622159", 16);
        put("625021", 16);
        put("625022", 16);
        put("625932", 16);
        put("625931", 16);
        put("625113", 16);
        put("625928", 16);
        put("625914", 16);
        put("625986", 16);
        put("625925", 16);
        put("625921", 16);
        put("625926", 16);
        put("625942", 16);
        put("622158", 16);
        put("625917", 16);
        put("625922", 16);
        put("625933", 16);
        put("625920", 16);
        put("625924", 16);
        put("622215", 16);
        put("622230", 16);
        put("622235", 16);
        put("622240", 16);
        put("622245", 16);
        put("62451804", 16);
        put("62451810", 16);
        put("62451811", 16);
        put("6245806", 16);
        put("62458071", 16);
        put("6253098", 16);
        put("526836", 16);
        put("513685", 16);
        put("543098", 16);
        put("458441", 16);
        put("356879", 16);
        put("356880", 16);
        put("356881", 16);
        put("356882", 16);
        put("625939", 16);
        put("625987", 16);
        put("625915", 16);
        put("625916", 16);
        put("625934", 16);
        put("525498", 16);
    }}),

    /**
     * 交通银行
     */
    COMM("交通银行", "COMM", new LinkedHashMap<String, Integer>() {{
        put("620021", 19);
        put("620521", 19);
        put("405512", 17);
        put("601428", 17);
        put("622258", 17);
        put("622259", 17);
        put("622261", 19);
        put("622284", 16);
        put("622656", 16);
        put("628216", 16);
        put("66405512", 17);
        put("622260", 19);
        put("66601428", 17);
        put("628218", 16);
        put("622262", 19);
        put("621002", 19);
        put("621069", 19);
        put("620013", 16);
        put("621436", 19);
        put("621335", 19);
    }}, new LinkedHashMap<String, Integer>() {{
        put("625028", 16);
        put("625029", 16);
        put("955593", 16);
        put("6649103", 16);
        put("6653784", 16);
        put("434910", 16);
        put("49104", 16);
        put("522964", 16);
        put("53783", 16);
        put("458123", 16);
        put("458124", 16);
        put("520169", 16);
        put("552853", 16);
        put("622250", 16);
        put("622251", 16);
        put("521899", 16);
        put("622254", 16);
        put("622255", 16);
        put("622256", 16);
        put("622257", 16);
        put("622253", 16);
        put("622252", 16);
        put("955590", 16);
        put("955591", 16);
        put("955592", 16);
    }}),

    /**
     * 招商银行
     */
    CMB("招商银行", "CMB", new LinkedHashMap<String, Integer>() {{
        put("402658", 16);
        put("410062", 16);
        put("468203", 16);
        put("512425", 16);
        put("524011", 16);
        put("622580", 16);
        put("622588", 16);
        put("622598", 16);
        put("622609", 16);
        put("95555", 16);
        put("621286", 16);
        put("620520", 19);
        put("621483", 16);
        put("621485", 16);
        put("621486", 16);
        put("628290", 16);
        put("628362", 16);
        put("628262", 16);
        put("621299", 16);
    }}, new LinkedHashMap<String, Integer>() {{
        put("356885", 16);
        put("356886", 16);
        put("356887", 16);
        put("356888", 16);
        put("356890", 16);
        put("479228", 16);
        put("479229", 16);
        put("439188", 16);
        put("439227", 16);
        put("521302", 16);
        put("356889", 16);
        put("545620", 16);
        put("545621", 16);
        put("545947", 16);
        put("545948", 16);
        put("552534", 16);
        put("552587", 16);
        put("622575", 16);
        put("622576", 16);
        put("622577", 16);
        put("622578", 16);
        put("622579", 16);
        put("545619", 16);
        put("622581", 16);
        put("622582", 16);
        put("545623", 16);
        put("439225", 16);
        put("518710", 16);
        put("518718", 16);
        put("439226", 16);
        put("625802", 16);
        put("625803", 16);
    }}),

    /**
     * 民生银行
     */
    CMBC("民生银行", "CMBC", new LinkedHashMap<String, Integer>() {{
        put("622615", 16);
        put("622616", 16);
        put("622618", 16);
        put("622622", 16);
        put("622617", 16);
        put("622619", 16);
        put("415599", 16);
        put("421393", 16);
        put("421865", 16);
        put("427570", 16);
        put("427571", 16);
        put("472067", 16);
        put("472068", 16);
        put("622620", 16);
        put("545392", 16);
        put("545393", 16);
        put("545431", 16);
        put("545447", 16);
        put("356857", 16);
        put("356856", 16);
        put("622621", 16);
        put("628258", 16);
        put("464580", 16);
        put("464581", 16);
        put("523952", 16);
        put("545217", 16);
        put("553161", 16);
        put("356858", 16);
        put("622623", 16);
        put("625912", 16);
        put("625913", 16);
        put("625911", 16);
    }}, new LinkedHashMap<String, Integer>() {{
        put("356859", 16);
        put("622603", 16);
        put("407405", 16);
        put("421869", 16);
        put("421870", 16);
        put("421871", 16);
        put("512466", 16);
        put("528948", 16);
        put("552288", 16);
        put("622600", 16);
        put("622601", 16);
        put("622602", 16);
        put("517636", 16);
        put("556610", 16);
    }}),

    /**
     * 中信银行
     */
    CITIC("中信银行", "CITIC", new LinkedHashMap<String, Integer>() {{
        put("433670", 16);
        put("433680", 16);
        put("442729", 16);
        put("442730", 16);
        put("620082", 16);
        put("622690", 16);
        put("622691", 16);
        put("622692", 16);
        put("622696", 16);
        put("622698", 16);
        put("622998", 16);
        put("622999", 16);
        put("433671", 16);
        put("968807", 16);
        put("968808", 16);
        put("968809", 16);
        put("621771", 16);
        put("621767", 16);
        put("621768", 16);
        put("621770", 16);
        put("621772", 16);
        put("621773", 16);
        put("628206", 16);
        put("628209", 16);
        put("628208", 16);
        put("356390", 16);
        put("356391", 16);
        put("356392", 16);
        put("622916", 16);
        put("622918", 16);
        put("622919", 16);
    }}, new LinkedHashMap<String, Integer>() {{
        put("556617", 16);
        put("518212", 16);
        put("400360", 16);
        put("403391", 16);
        put("403392", 16);
        put("404158", 16);
        put("404159", 16);
        put("404171", 16);
        put("404172", 16);
        put("404173", 16);
        put("404174", 16);
        put("404157", 16);
        put("433667", 16);
        put("433668", 16);
        put("433669", 16);
        put("514906", 16);
        put("403393", 16);
        put("520108", 16);
        put("433666", 16);
        put("558916", 16);
        put("622678", 16);
        put("622679", 16);
        put("622680", 16);
        put("622688", 16);
        put("622689", 16);
    }}),

    /**
     * 浦发银行
     */
    SPDB("浦发银行", "SPDB", new LinkedHashMap<String, Integer>() {{
        put("356851", 16);
        put("356852", 16);
        put("456418", 16);
        put("515672", 16);
        put("356850", 16);
        put("517650", 16);
        put("525998", 16);
        put("622177", 16);
        put("622277", 16);
        put("622516", 16);
        put("622517", 16);
        put("622518", 16);
        put("622520", 16);
        put("622521", 16);
        put("622522", 16);
        put("622523", 16);
        put("628222", 16);
        put("84301", 16);
        put("84336", 16);
        put("622500", 16);
        put("84373", 16);
        put("628221", 16);
        put("84385", 16);
        put("84390", 16);
        put("87000", 16);
        put("87010", 16);
        put("87030", 16);
        put("87040", 16);
        put("84380", 16);
        put("984301", 16);
        put("984303", 16);
        put("84361", 16);
        put("87050", 16);
        put("622176", 16);
        put("622228", 16);
        put("621352", 16);
        put("621793", 16);
        put("621795", 16);
        put("621796", 16);
        put("621351", 16);
        put("621792", 16);
        put("621791", 16);
        put("84342", 16);
        put("620530", 19);
        put("625993", 16);
        put("625831", 16);
    }}, new LinkedHashMap<String, Integer>() {{
        put("621390", 16);
        put("625957", 16);
        put("625958", 16);
        put("622519", 16);
        put("404738", 16);
        put("404739", 16);
        put("498451", 16);
        put("622276", 16);
    }}),

    /**
     * 兴业银行
     */
    CIB("兴业银行", "CIB", new LinkedHashMap<String, Integer>() {{
        put("438589", 18);
        put("90592", 16);
        put("966666", 18);
        put("622909", 18);
        put("438588", 18);
        put("622908", 18);
        put("461982", 16);
        put("486493", 16);
        put("486494", 16);
        put("528057", 16);
        put("628212", 16);
        put("625960", 16);
        put("625961", 16);
        put("625962", 16);
        put("625963", 16);
    }}, new LinkedHashMap<String, Integer>() {{
        put("625084", 16);
        put("625085", 16);
        put("625086", 16);
        put("625087", 16);
        put("486861", 16);
        put("523036", 16);
        put("451289", 16);
        put("527414", 16);
        put("622901", 16);
        put("622902", 16);
        put("622922", 16);
        put("451290", 16);
        put("524070", 16);
        put("548738", 16);
        put("549633", 16);
        put("552398", 16);
        put("625082", 16);
        put("625083", 16);
    }}),

    /**
     * 光大银行
     */
    CEB("光大银行", "CEB", new LinkedHashMap<String, Integer>() {{
        put("543159", 16);
        put("622161", 16);
        put("622570", 16);
        put("622650", 16);
        put("622655", 16);
        put("622658", 16);
        put("628201", 16);
        put("628202", 16);
        put("303", 16);
        put("620085", 16);
        put("622660", 16);
        put("622662", 16);
        put("622663", 16);
        put("622664", 16);
        put("622665", 16);
        put("622666", 16);
        put("622667", 16);
        put("622669", 16);
        put("622670", 16);
        put("622671", 16);
        put("622672", 16);
        put("622668", 16);
        put("622661", 16);
        put("622674", 16);
        put("90030", 16);
        put("622673", 16);
        put("620518", 16);
        put("621489", 16);
        put("621492", 16);
        put("620535", 19);
        put("622657", 16);
        put("622685", 16);
        put("622687", 16);
        put("625978", 16);
        put("625980", 16);
        put("625981", 16);
        put("625979", 16);
    }}, new LinkedHashMap<String, Integer>() {{
        put("622659", 16);
        put("622657", 16);
        put("622685", 16);
        put("622687", 16);
        put("625978", 16);
        put("625980", 16);
        put("625981", 16);
        put("625979", 16);
        put("625975", 16);
        put("625977", 16);
        put("356839", 16);
        put("356840", 16);
        put("406252", 16);
        put("625339", 16);
        put("625976", 16);
        put("406254", 16);
        put("425862", 16);
        put("481699", 16);
        put("524090", 16);
        put("356837", 16);
        put("356838", 16);
        put("486497", 16);
    }}),

    /**
     * 广发银行
     */
    GDB("广发银行", "GDB", new LinkedHashMap<String, Integer>() {{
        put("622555", 16);
        put("622556", 16);
        put("622557", 16);
        put("622558", 16);
        put("622559", 16);
        put("622560", 16);
        put("622568", 19);
        put("528931", 16);
        put("685800", 19);
        put("6858000", 19);
        put("6858001", 19);
        put("6858009", 19);
        put("9111", 19);
        put("558894", 16);
        put("625072", 16);
        put("625071", 16);
        put("628260", 16);
        put("628259", 16);
        put("621462", 19);
        put("625805", 16);
        put("625806", 16);
        put("625807", 16);
        put("625808", 16);
        put("625809", 16);
        put("625810", 16);
    }}, new LinkedHashMap<String, Integer>() {{
        put("406365", 16);
        put("406366", 16);
        put("428911", 16);
        put("436768", 16);
        put("436769", 16);
        put("436770", 16);
        put("487013", 16);
        put("491032", 16);
        put("491033", 16);
        put("491034", 16);
        put("491035", 16);
        put("491036", 16);
        put("491037", 16);
        put("491038", 16);
        put("436771", 16);
        put("518364", 16);
        put("520152", 16);
        put("520382", 16);
        put("541709", 16);
        put("541710", 16);
        put("548844", 16);
        put("552794", 16);
        put("493427", 16);
    }}),

    /**
     * 平安银行
     */
    PAB("平安银行", "PAB", new LinkedHashMap<String, Integer>() {{
        put("621626", 19);
        put("623058", 19);
        put("602907", 16);
        put("622986", 16);
        put("622989", 16);
        put("622298", 16);
        put("628296", 16);
        put("627069", 16);
        put("627068", 16);
        put("627066", 16);
        put("627067", 16);
    }}, new LinkedHashMap<String, Integer>() {{
        put("627069", 16);
        put("627068", 16);
        put("627066", 16);
        put("627067", 16);
        put("531659", 16);
        put("622157", 16);
        put("528020", 16);
        put("622155", 16);
        put("622156", 16);
        put("526855", 16);
        put("356869", 16);
        put("356868", 16);
        put("625360", 16);
        put("625361", 16);
    }}),

    /**
     * 北京银行
     */
    BOB("北京银行", "BOB", new LinkedHashMap<String, Integer>() {{
        put("421317", 16);
        put("422161", 16);
        put("602969", 16);
        put("422160", 16);
        put("621030", 16);
        put("621420", 16);
        put("621468", 16);
        put("623111", 16);
        put("522001", 16);
        put("628203", 16);
        put("622851", 16);
    }}, new LinkedHashMap<String, Integer>() {{
        put("622163", 16);
        put("622853", 16);
    }}),

    /**
     * 华夏银行
     */
    HXB("华夏银行", "HXB", new LinkedHashMap<String, Integer>() {{
        put("539867", 16);
        put("539868", 16);
        put("622638", 16);
        put("622630", 16);
        put("622631", 16);
        put("622632", 16);
        put("622633", 16);
        put("999999", 16);
        put("621222", 16);
        put("623020", 16);
        put("623021", 16);
        put("623022", 16);
        put("623023", 16);
    }}, new LinkedHashMap<String, Integer>() {{
        put("523959", 16);
        put("528709", 16);
        put("622637", 16);
        put("628318", 16);
        put("528708", 16);
        put("622636", 16);
        put("625967", 16);
        put("625968", 16);
        put("625969", 16);
    }}),

    /**
     * 农业银行
     */
    ABC("农业银行", "ABC", new LinkedHashMap<String, Integer>() {{
        put("514027", 16);
        put("103", 19);
        put("463758", 16);
        put("622824", 19);
        put("622826", 19);
        put("628268", 16);
        put("95595", 19);
        put("95596", 19);
        put("95597", 19);
        put("95598", 19);
        put("95599", 19);
        put("622848", 19);
        put("620059", 19);
        put("621282", 19);
        put("622828", 19);
        put("625996", 16);
        put("625998", 16);
        put("622823", 19);
        put("621336", 19);
        put("621619", 19);
        put("622821", 19);
        put("622822", 19);
        put("622825", 19);
        put("622827", 19);
        put("622845", 19);
        put("622849", 19);
        put("623018", 19);
        put("625997", 16);
        put("623206", 19);
        put("621671", 19);
        put("622840", 19);
        put("622843", 19);
        put("622844", 19);
        put("622846", 19);
        put("622847", 19);
        put("622820", 16);
        put("622830", 16);
        put("622838", 16);
        put("625336", 16);
        put("625826", 16);
        put("625827", 16);
        put("544243", 16);
        put("548478", 16);
        put("628269", 16);
        put("620501", 19);
    }}, new LinkedHashMap<String, Integer>() {{
        put("403361", 16);
        put("404117", 16);
        put("404118", 16);
        put("404119", 16);
        put("404120", 16);
        put("404121", 16);
        put("519412", 16);
        put("519413", 16);
        put("520082", 16);
        put("520083", 16);
        put("53591", 16);
        put("552599", 16);
        put("558730", 16);
        put("49102", 16);
        put("622836", 16);
        put("622837", 16);
        put("622841", 16);
        put("6349102", 16);
        put("6353591", 16);
    }}),

    /**
     * 建设银行
     */
    CCB("建设银行", "CCB", new LinkedHashMap<String, Integer>() {{
        put("621284", 19);
        put("421349", 16);
        put("434061", 16);
        put("434062", 16);
        put("436728", 16);
        put("524094", 16);
        put("526410", 16);
        put("53243", 16);
        put("544033", 16);
        put("552245", 16);
        put("589970", 19);
        put("620060", 19);
        put("621080", 16);
        put("621081", 19);
        put("621082", 16);
        put("621466", 16);
        put("621467", 19);
        put("621488", 16);
        put("621499", 16);
        put("621598", 19);
        put("621621", 19);
        put("621700", 19);
        put("622700", 19);
        put("622966", 16);
        put("622988", 16);
        put("625362", 16);
        put("625363", 16);
        put("628316", 16);
        put("628317", 16);
        put("623211", 19);
        put("436742", 19);
        put("622280", 19);
        put("356896", 16);
        put("356899", 16);
        put("356895", 16);
        put("436745", 16);
        put("436748", 16);
        put("531693", 16);
        put("532450", 16);
        put("532458", 16);
        put("544887", 16);
        put("557080", 16);
        put("622708", 16);
        put("628266", 16);
        put("628366", 16);
        put("622675", 16);
        put("622676", 16);
        put("622677", 16);
        put("622382", 16);
        put("621487", 16);
        put("621083", 16);
        put("621084", 16);
        put("620107", 16);
    }}, new LinkedHashMap<String, Integer>() {{
        put("5453242", 16);
        put("5491031", 16);
        put("5544033", 16);
        put("553242", 16);
        put("559051", 16);
        put("622166", 16);
        put("622168", 16);
        put("625964", 16);
        put("625965", 16);
        put("625966", 16);
        put("622381", 16);
        put("489592", 16);
        put("622725", 16);
        put("622728", 16);
        put("453242", 16);
        put("491031", 16);
        put("53242", 16);
        put("622707", 16);
        put("625955", 16);
        put("625956", 16);
        put("436718", 16);
        put("436738", 16);
        put("552801", 16);
        put("558895", 16);
    }}),

    /**
     * 邮政银行
     */
    PSBC("邮政银行", "PSBC", new LinkedHashMap<String, Integer>() {{
        put("621096", 19);
        put("621098", 19);
        put("622150", 19);
        put("622151", 19);
        put("622181", 19);
        put("622188", 19);
        put("622199", 19);
        put("955100", 19);
        put("621095", 19);
        put("620062", 19);
        put("621285", 19);
        put("621798", 19);
        put("621799", 19);
        put("621797", 19);
        put("620529", 19);
        put("62215049", 19);
        put("62215050", 19);
        put("62215051", 19);
        put("62218850", 19);
        put("62218851", 19);
        put("62218849", 19);
        put("621622", 19);
        put("621599", 19);
        put("621674", 19);
        put("623218", 19);
        put("623219", 19);
        put("622812", 16);
        put("628310", 16);
    }}, new LinkedHashMap<String, Integer>() {{
        put("622810", 16);
        put("622811", 16);
        put("625919", 16);
    }}),

    /**
     * 中国银行
     */
    BOC("中国银行", "BOC", new LinkedHashMap<String, Integer>() {{
        put("621660", 19);
        put("621661", 19);
        put("621662", 19);
        put("621663", 19);
        put("621665", 19);
        put("621667", 19);
        put("621668", 19);
        put("621669", 19);
        put("621666", 19);
        put("625908", 16);
        put("625910", 16);
        put("625909", 16);
        put("356833", 16);
        put("356835", 16);
        put("409665", 16);
        put("409666", 16);
        put("409670", 16);
        put("409672", 16);
        put("552742", 16);
        put("553131", 16);
        put("601382", 19);
        put("628388", 16);
        put("621256", 19);
        put("621212", 19);
        put("620514", 16);
        put("622788", 16);
        put("621283", 19);
        put("620061", 19);
        put("621725", 19);
        put("620040", 19);
        put("558869", 16);
        put("621330", 19);
        put("621331", 19);
        put("621332", 19);
        put("621333", 19);
        put("621297", 19);
        put("621568", 19);
        put("621569", 19);
        put("625905", 16);
        put("625906", 16);
        put("625907", 16);
        put("628313", 16);
        put("621672", 19);
        put("628312", 16);
        put("623208", 19);
        put("621620", 19);
        put("621756", 19);
        put("621757", 19);
        put("621758", 19);
        put("621759", 19);
        put("621785", 19);
        put("621786", 19);
        put("621787", 19);
        put("621788", 19);
        put("621789", 19);
        put("621790", 19);
        put("620025", 16);
        put("620026", 16);
        put("621293", 16);
        put("621294", 16);
        put("621342", 16);
        put("621343", 16);
        put("621364", 16);
        put("621394", 16);
        put("621648", 16);
        put("621248", 16);
        put("621215", 16);
        put("621249", 16);
        put("622273", 19);
        put("622274", 19);
        put("622771", 19);
        put("622772", 19);
        put("622770", 19);
        put("625145", 16);
        put("620531", 19);
        put("620210", 16);
        put("620211", 16);
        put("622479", 16);
        put("622480", 16);
        put("620019", 16);
        put("620035", 16);
        put("621231", 16);
        put("621638", 16);
        put("621334", 16);
        put("621395", 16);
        put("620513", 19);
        put("625055", 16);
        put("621741", 19);
        put("623040", 16);
        put("620202", 16);
        put("620203", 16);
        put("622348", 16);
    }}, new LinkedHashMap<String, Integer>() {{
        put("622750", 16);
        put("622751", 16);
        put("625140", 16);
        put("625040", 16);
        put("625042", 16);
        put("622760", 16);
        put("622346", 16);
        put("622347", 16);
        put("625141", 16);
        put("625143", 16);
        put("625333", 16);
        put("409668", 16);
        put("409669", 16);
        put("409671", 16);
        put("456351", 16);
        put("512315", 16);
        put("512316", 16);
        put("512411", 16);
        put("512412", 16);
        put("514957", 16);
        put("409667", 16);
        put("518378", 16);
        put("518379", 16);
        put("518474", 16);
        put("518475", 16);
        put("518476", 16);
        put("438088", 16);
        put("524865", 16);
        put("525745", 16);
        put("525746", 16);
        put("547766", 16);
        put("558868", 16);
        put("514958", 16);
        put("622752", 16);
        put("622753", 16);
        put("622755", 16);
        put("524864", 16);
        put("622757", 16);
        put("622758", 16);
        put("622759", 16);
        put("622761", 16);
        put("622762", 16);
        put("622763", 16);
        put("622756", 16);
        put("622754", 16);
        put("622764", 16);
        put("518377", 16);
        put("622765", 16);

    }}),

    /**
     * 宁波银行
     */
    NBCB("宁波银行", "NBCB", new LinkedHashMap<String, Integer>() {{
        put("621279", 16);
        put("622281", 16);
        put("622316", 16);
        put("940022", 16);
        put("621418", 19);
        put("512431", 16);
        put("520194", 16);
        put("622318", 16);
        put("622778", 16);
        put("628207", 16);
    }}, new LinkedHashMap<String, Integer>() {{
        put("622282", 16);
        put("625903", 16);
    }}),

    ;

    /**
     * 银行名称
     */
    private final String name;

    /**
     * 简写
     */
    private final String code;

    /**
     * 借记卡前缀
     * key: 前缀
     * value: 长度
     */
    private final Map<String, Integer> debitPrefix;

    /**
     * 信用卡前缀
     * key: 前缀
     * value: 长度
     */
    private final Map<String, Integer> creditPrefix;

    BankNameType(String name, String code, Map<String, Integer> debitPrefix, Map<String, Integer> creditPrefix) {
        this.name = name;
        this.code = code;
        this.debitPrefix = Collections.unmodifiableMap(debitPrefix);
        this.creditPrefix = Collections.unmodifiableMap(creditPrefix);
    }

    public String getName() {
        return name;
    }

    public String getCode() {
        return code;
    }

    public Map<String, Integer> getDebitPrefix() {
        return debitPrefix;
    }

    public Map<String, Integer> getCreditPrefix() {
        return creditPrefix;
    }

    public static BankNameType of(String code) {
        if (code == null) {
            return null;
        }
        for (BankNameType value : values()) {
            if (value.code.equalsIgnoreCase(code)) {
                return value;
            }
        }
        return null;
    }

}
