/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.generator.company;

import cn.orionsec.kit.generator.addres.AddressSupport;
import cn.orionsec.kit.generator.industry.IndustryGenerator;
import cn.orionsec.kit.lang.utils.Arrays1;
import cn.orionsec.kit.lang.utils.Strings;
import cn.orionsec.kit.lang.utils.random.Randoms;

public class CompanyGenerator {
    private static final String[] SUFFIX = new String[]{"\u8d23\u4efb\u6709\u9650\u516c\u53f8", "\u80a1\u4efd\u6709\u9650\u516c\u53f8", "\u53d1\u5c55\u6709\u9650\u516c\u53f8", "\u6709\u9650\u516c\u53f8", "\u516c\u53f8"};

    private CompanyGenerator() {
    }

    public static String generatorCompanyName() {
        return CompanyGenerator.generatorCompanyName(AddressSupport.randomProvinceCode(), IndustryGenerator.generatorManagementType());
    }

    public static String generatorCompanyName(int provinceCode) {
        return CompanyGenerator.generatorCompanyName(provinceCode, IndustryGenerator.generatorManagementType());
    }

    public static String generatorCompanyName(String managementType) {
        return CompanyGenerator.generatorCompanyName(AddressSupport.randomProvinceCode(), managementType);
    }

    public static String generatorCompanyName(int provinceCode, String managementType) {
        if (Strings.isBlank((String)managementType)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String provinceName = AddressSupport.getProvinceName(provinceCode);
        provinceName = provinceName.startsWith("\u9ed1\u9f99\u6c5f") || provinceName.startsWith("\u5185\u8499\u53e4") ? provinceName.substring(0, 3) : provinceName.substring(0, 2);
        sb.append(provinceName);
        if (Randoms.randomBoolean((int)2)) {
            sb.append(Strings.randomChars((int)Randoms.randomInt((int)2, (int)4)));
        }
        sb.append(managementType);
        sb.append((String)Arrays1.random((Object[])SUFFIX));
        return sb.toString();
    }
}

