/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.define.barrier;

import cn.orionsec.kit.lang.define.barrier.GenericsBarrier;
import cn.orionsec.kit.lang.utils.collect.Maps;
import java.util.Map;

public class GenericsMapBarrier<K, V>
implements GenericsBarrier<Map<K, V>> {
    private final K barrierKey;
    private final V barrierValue;

    public GenericsMapBarrier(K barrierKey) {
        this(barrierKey, null);
    }

    public GenericsMapBarrier(K barrierKey, V barrierValue) {
        this.barrierKey = barrierKey;
        this.barrierValue = barrierValue;
    }

    public static <K, V> GenericsMapBarrier<K, V> create(K barrierKey) {
        return new GenericsMapBarrier<K, V>(barrierKey);
    }

    public static <K, V> GenericsMapBarrier<K, V> create(K barrierKey, V barrierValue) {
        return new GenericsMapBarrier<K, V>(barrierKey, barrierValue);
    }

    @Override
    public void check(Map<K, V> map) {
        if (map != null && map.isEmpty()) {
            map.put(this.barrierKey, this.barrierValue);
        }
    }

    @Override
    public void remove(Map<K, V> map) {
        if (!Maps.isEmpty(map)) {
            map.remove(this.barrierKey);
        }
    }
}

