/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.define.builder;

import cn.orionsec.kit.lang.able.Buildable;
import cn.orionsec.kit.lang.utils.Objects1;
import cn.orionsec.kit.lang.utils.Strings;
import cn.orionsec.kit.lang.utils.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class StringJoiner
implements Buildable<String> {
    private String prefix;
    private String suffix;
    private String delimiter;
    private Predicate<String> filter;
    private Function<String, String> wrapper;
    private final List<String> modifiers;

    public StringJoiner() {
        this.modifiers = new ArrayList<String>();
    }

    public StringJoiner(String delimiter) {
        this(delimiter, null, null);
    }

    public StringJoiner(String delimiter, String prefix, String suffix) {
        this.delimiter = delimiter;
        this.prefix = prefix;
        this.suffix = suffix;
        this.modifiers = new ArrayList<String>();
    }

    public static StringJoiner of() {
        return new StringJoiner();
    }

    public static StringJoiner of(String delimiter) {
        return new StringJoiner(delimiter);
    }

    public static StringJoiner of(Supplier<String> delimiterSupplier) {
        Valid.notNull(delimiterSupplier, "delimiter supplier is null", new Object[0]);
        return new StringJoiner(delimiterSupplier.get());
    }

    public static StringJoiner of(String delimiter, String prefix, String suffix) {
        return new StringJoiner(delimiter, prefix, suffix);
    }

    public StringJoiner delimiter(String delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public StringJoiner delimiter(Supplier<String> delimiterSupplier) {
        Valid.notNull(delimiterSupplier, "delimiter supplier is null", new Object[0]);
        this.delimiter = delimiterSupplier.get();
        return this;
    }

    public StringJoiner prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public StringJoiner prefix(Supplier<String> prefixSupplier) {
        Valid.notNull(prefixSupplier, "prefix supplier is null", new Object[0]);
        this.prefix = prefixSupplier.get();
        return this;
    }

    public StringJoiner suffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    public StringJoiner suffix(Supplier<String> suffixSupplier) {
        Valid.notNull(suffixSupplier, "suffix supplier is null", new Object[0]);
        this.suffix = suffixSupplier.get();
        return this;
    }

    public StringJoiner skipNull() {
        this.addFilter(Objects::nonNull);
        return this;
    }

    public StringJoiner skipEmpty() {
        this.addFilter(Strings::isNotEmpty);
        return this;
    }

    public StringJoiner skipBlank() {
        this.addFilter(Strings::isNotBlank);
        return this;
    }

    public StringJoiner filter(Predicate<String> filter) {
        this.addFilter(filter);
        return this;
    }

    private void addFilter(Predicate<String> filter) {
        Valid.notNull(filter, "filter is null", new Object[0]);
        if (this.filter == null) {
            this.filter = filter;
        }
        this.filter = this.filter.and(filter);
    }

    public StringJoiner wrapper(Function<String, String> wrapper) {
        Valid.notNull(wrapper, "wrapper is null", new Object[0]);
        this.wrapper = wrapper;
        return this;
    }

    public StringJoiner with(String s) {
        this.modifiers.add(s);
        return this;
    }

    public StringJoiner with(Object o) {
        this.modifiers.add(Objects1.toString(o));
        return this;
    }

    public StringJoiner with(Supplier<String> supplier) {
        Valid.notNull(supplier, "supplier is null", new Object[0]);
        this.modifiers.add(supplier.get());
        return this;
    }

    @Override
    public String build() {
        StringBuilder builder = new StringBuilder();
        if (this.prefix != null) {
            builder.append(this.prefix);
        }
        boolean add = false;
        for (String modifier : this.modifiers) {
            if (this.filter != null && !this.filter.test(modifier)) continue;
            if (this.wrapper != null) {
                modifier = this.wrapper.apply(modifier);
            }
            builder.append(modifier);
            if (this.delimiter == null) continue;
            builder.append(this.delimiter);
            add = true;
        }
        if (add) {
            builder.deleteCharAt(builder.length() - 1);
        }
        if (this.suffix != null) {
            builder.append(this.suffix);
        }
        return builder.toString();
    }
}

