/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.define.cache;

import cn.orionsec.kit.lang.define.thread.ExecutorBuilder;
import cn.orionsec.kit.lang.utils.Objects1;
import cn.orionsec.kit.lang.utils.Threads;
import java.io.Closeable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class TimedCache
implements Closeable {
    private static final ExecutorService CHECK_EXECUTOR = ExecutorBuilder.create().namedThreadFactory("orion-cache-check-").corePoolSize(1).maxPoolSize(Integer.MAX_VALUE).keepAliveTime(60000L).workQueue(new SynchronousQueue<Runnable>()).allowCoreThreadTimeout(true).build();
    private final int expiredDelay;
    private final ConcurrentHashMap<String, Value> store;
    private final Checker checker;

    public TimedCache(int expiredDelay, int checkDelay, BiConsumer<String, Object> expiredListener) {
        this.expiredDelay = expiredDelay;
        this.store = new ConcurrentHashMap();
        this.checker = new Checker(checkDelay, this.store, expiredListener);
        CHECK_EXECUTOR.execute(this.checker);
    }

    public <V> V put(String key, Supplier<V> valueSupplier) {
        Value ref = this.store.computeIfAbsent(key, s -> this.createValue(valueSupplier.get()));
        return (V)ref.value;
    }

    public <V> V put(String key, Function<String, V> valueSupplier) {
        Value ref = this.store.computeIfAbsent(key, s -> this.createValue(valueSupplier.apply(key)));
        return (V)ref.value;
    }

    public void put(String key, Object value) {
        this.store.put(key, this.createValue(value));
    }

    public void putAll(Map<String, Object> map) {
        map.forEach((k, v) -> this.store.put((String)k, this.createValue(v)));
    }

    public <V> V get(String key) {
        return this.getOrDefault(key, null);
    }

    public <V> V getOrDefault(String key, V def) {
        Value value = this.store.get(key);
        if (value == null) {
            return def;
        }
        return (V)value.value;
    }

    public boolean containsKey(String key) {
        return this.store.containsKey(key);
    }

    public void clear() {
        this.store.clear();
    }

    public ConcurrentHashMap<String, Value> getStore() {
        return this.store;
    }

    private Value createValue(Object o) {
        return new Value(System.currentTimeMillis() + (long)this.expiredDelay, o);
    }

    @Override
    public void close() {
        this.store.clear();
        this.checker.close();
    }

    public String toString() {
        return this.store.toString();
    }

    static class Checker
    implements Runnable,
    Closeable {
        private final ConcurrentHashMap<String, Value> store;
        private final int checkDelay;
        private final BiConsumer<String, Object> expiredListener;
        private volatile boolean run = true;

        public Checker(int checkDelay, ConcurrentHashMap<String, Value> store, BiConsumer<String, Object> expiredListener) {
            this.checkDelay = checkDelay;
            this.expiredListener = expiredListener;
            this.store = store;
        }

        @Override
        public void run() {
            while (this.run) {
                Threads.sleep(this.checkDelay);
                long curr = System.currentTimeMillis();
                for (String key : this.store.keySet()) {
                    Value value = this.store.get(key);
                    if (value.expireTime >= curr) continue;
                    this.store.remove(key);
                    this.expiredListener.accept(key, value.value);
                }
            }
        }

        @Override
        public void close() {
            this.run = false;
        }
    }

    static class Value {
        private final long expireTime;
        private final Object value;

        public Value(long expireTime, Object value) {
            this.expireTime = expireTime;
            this.value = value;
        }

        public String toString() {
            return Objects1.toString(this.value);
        }
    }
}

