/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.define.collect;

import cn.orionsec.kit.lang.define.Null;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;

public class ConcurrentHashSet<E>
extends AbstractSet<E>
implements Serializable {
    private static final long serialVersionUID = -6809192700238394L;
    private static final Null VALUE = Null.VALUE;
    private final ConcurrentMap<E, Null> store;

    public ConcurrentHashSet() {
        this.store = new ConcurrentHashMap<E, Null>();
    }

    public ConcurrentHashSet(int initialCapacity) {
        this.store = new ConcurrentHashMap<E, Null>(initialCapacity);
    }

    public ConcurrentHashSet(Map<? extends E, ?> m) {
        this.store = new ConcurrentHashMap<E, Null>(m.size());
        for (E e : m.keySet()) {
            this.store.put(e, VALUE);
        }
    }

    public ConcurrentHashSet(Collection<? extends E> s) {
        this.store = new ConcurrentHashMap<E, Null>(s.size());
        for (E e : s) {
            this.store.put(e, VALUE);
        }
    }

    public static <E> ConcurrentHashSet<E> create() {
        return new ConcurrentHashSet<E>();
    }

    public static <E> ConcurrentHashSet<E> create(Map<? extends E, ?> m) {
        return new ConcurrentHashSet<E>(m);
    }

    public static <E> ConcurrentHashSet<E> create(Collection<? extends E> s) {
        return new ConcurrentHashSet<E>(s);
    }

    @Override
    public Iterator<E> iterator() {
        return this.store.keySet().iterator();
    }

    @Override
    public int size() {
        return this.store.size();
    }

    @Override
    public boolean isEmpty() {
        return this.store.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.store.containsKey(o);
    }

    @Override
    public boolean add(E e) {
        return this.store.put(e, VALUE) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.store.remove(o) == null;
    }

    @Override
    public void clear() {
        this.store.clear();
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        for (Map.Entry e : this.store.entrySet()) {
            action.accept(e.getKey());
        }
    }

    public ConcurrentMap<E, Null> getStore() {
        return this.store;
    }

    @Override
    public String toString() {
        return this.store.keySet().toString();
    }
}

