/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.define.collect;

import cn.orionsec.kit.lang.define.iterator.SingletonIterator;
import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.Objects1;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class SingletonSet<E>
extends AbstractSet<E>
implements Serializable {
    private static final long serialVersionUID = 1283912054341293L;
    private final E element;

    public SingletonSet(E obj) {
        this.element = obj;
    }

    public static <E> SingletonSet<E> create(E obj) {
        return new SingletonSet<E>(obj);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean contains(Object obj) {
        return Objects1.eq(obj, this.element);
    }

    public E get() {
        return this.element;
    }

    @Override
    public Iterator<E> iterator() {
        return new SingletonIterator<E>(this.element);
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        action.accept(this.element);
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        throw Exceptions.unsupported();
    }
}

