/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.define.collect;

import cn.orionsec.kit.lang.utils.collect.Lists;
import cn.orionsec.kit.lang.utils.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;

public class WeightRandomMap<T>
extends TreeMap<Double, T>
implements Serializable {
    private static final long serialVersionUID = -978238901200283479L;
    private final Random RANDOM = ThreadLocalRandom.current();

    public WeightRandomMap() {
    }

    public WeightRandomMap(Collection<WeightObject<T>> weights) {
        if (Lists.isNotEmpty(weights)) {
            for (WeightObject<T> w : weights) {
                this.put(w);
            }
        }
    }

    public WeightRandomMap(Map<T, Double> weights) {
        if (Maps.isNotEmpty(weights)) {
            for (Map.Entry<T, Double> e : weights.entrySet()) {
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    public static <T> WeightRandomMap<T> create() {
        return new WeightRandomMap<T>();
    }

    @Override
    public T put(Double weight, T value) {
        this.put(new WeightObject<T>(value, weight));
        return null;
    }

    @Override
    public void put(T o, double weight) {
        this.put(new WeightObject<T>(o, weight));
    }

    public void put(WeightObject<T> o) {
        if (o != null) {
            double weight = o.getWeight();
            if (o.getWeight() > 0.0) {
                double lastWeight = this.size() == 0 ? 0.0 : (Double)this.lastKey();
                super.put(weight + lastWeight, o.getObject());
            }
        }
    }

    public T next() {
        if (Maps.isEmpty(this)) {
            return null;
        }
        double randomWeight = (Double)this.lastKey() * this.RANDOM.nextDouble();
        NavigableMap tailMap = this.tailMap(randomWeight, false);
        return (T)this.get(tailMap.firstKey());
    }

    public static class WeightObject<T> {
        private T object;
        private final double weight;

        public WeightObject(T obj, double weight) {
            this.object = obj;
            this.weight = weight;
        }

        public T getObject() {
            return this.object;
        }

        public void setObject(T object) {
            this.object = object;
        }

        public double getWeight() {
            return this.weight;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.object == null ? 0 : this.object.hashCode());
            long temp = Double.doubleToLongBits(this.weight);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WeightObject other = (WeightObject)obj;
            if (this.object == null ? other.object != null : !this.object.equals(other.object)) {
                return false;
            }
            return Double.doubleToLongBits(this.weight) == Double.doubleToLongBits(other.weight);
        }
    }
}

