/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.define.io;

import cn.orionsec.kit.lang.support.progress.ByteTransferProgress;
import cn.orionsec.kit.lang.utils.Valid;
import java.io.IOException;
import java.io.OutputStream;

public class ProgressOutputStream
extends OutputStream {
    private final OutputStream wrapper;
    private ByteTransferProgress progress;

    public ProgressOutputStream(OutputStream wrapper) {
        this(wrapper, new ByteTransferProgress(0L));
    }

    public ProgressOutputStream(OutputStream wrapper, long end) {
        this(wrapper, new ByteTransferProgress(end));
    }

    public ProgressOutputStream(OutputStream wrapper, ByteTransferProgress progress) {
        this.wrapper = Valid.notNull(wrapper, "wrapper output stream is null", new Object[0]);
        this.progress = progress;
    }

    @Override
    public void write(int b) throws IOException {
        this.wrapper.write(b);
        this.progress.accept(1L);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.wrapper.write(b);
        this.progress.accept(b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.wrapper.write(b, off, len);
        this.progress.accept(len);
    }

    @Override
    public void flush() throws IOException {
        this.wrapper.flush();
    }

    @Override
    public void close() throws IOException {
        this.wrapper.close();
        this.progress.finish();
    }

    public void start() {
        this.progress.start();
    }

    public void setEnd(long end) {
        this.progress.setEnd(end);
    }

    public void finish() {
        this.finish(false);
    }

    public void finish(boolean error) {
        this.progress.finish(error);
    }

    public ByteTransferProgress getProgress() {
        return this.progress;
    }

    public void setProgress(ByteTransferProgress progress) {
        this.progress = progress;
    }
}

