/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.define.thread;

import cn.orionsec.kit.lang.utils.Valid;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;

public class ConcurrentCallable<V>
implements Callable<V> {
    private final Callable<V> c;
    private CyclicBarrier cb;
    private CountDownLatch cd;

    public ConcurrentCallable(Callable<V> c, CyclicBarrier cb) {
        Valid.notNull(c, "callable is null", new Object[0]);
        Valid.notNull(cb, "cyclicBarrier is null", new Object[0]);
        this.c = c;
        this.cb = cb;
    }

    public ConcurrentCallable(Callable<V> c, CountDownLatch cd) {
        Valid.notNull(c, "callable is null", new Object[0]);
        Valid.notNull(cd, "countDownLatch is null", new Object[0]);
        this.c = c;
        this.cd = cd;
    }

    @Override
    public V call() throws Exception {
        if (this.cb != null) {
            this.cb.await();
        } else if (this.cd != null) {
            this.cd.await();
        }
        return this.c.call();
    }
}

