/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.define.thread;

import cn.orionsec.kit.lang.able.Buildable;
import cn.orionsec.kit.lang.define.thread.NamedThreadFactory;
import cn.orionsec.kit.lang.utils.Objects1;
import cn.orionsec.kit.lang.utils.Systems;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ExecutorBuilder
implements Buildable<ThreadPoolExecutor> {
    public static final int DEFAULT_QUEUE_CAPACITY = 1024;
    private int corePoolSize;
    private int maxPoolSize = Systems.PROCESS_NUM * 2;
    private long keepAliveTime = 60000L;
    private BlockingQueue<Runnable> workQueue;
    private ThreadFactory threadFactory;
    private RejectedExecutionHandler handler;
    private boolean allowCoreThreadTimeout;
    private boolean preStartAllCoreThreads;

    public static ExecutorBuilder create() {
        return new ExecutorBuilder();
    }

    public ExecutorBuilder corePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
        return this;
    }

    public ExecutorBuilder maxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
        return this;
    }

    public ExecutorBuilder keepAliveTime(long keepAliveTime, TimeUnit unit) {
        return this.keepAliveTime(unit.toNanos(keepAliveTime));
    }

    public ExecutorBuilder keepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
        return this;
    }

    public ExecutorBuilder workQueue(BlockingQueue<Runnable> workQueue) {
        this.workQueue = workQueue;
        return this;
    }

    public ExecutorBuilder useLinkedBlockingQueue() {
        return this.workQueue(new LinkedBlockingQueue<Runnable>());
    }

    public ExecutorBuilder useLinkedBlockingQueue(int capacity) {
        return this.workQueue(new LinkedBlockingQueue<Runnable>(capacity));
    }

    public ExecutorBuilder useArrayBlockingQueue(int capacity) {
        return this.workQueue(new ArrayBlockingQueue<Runnable>(capacity));
    }

    public ExecutorBuilder useSynchronousQueue() {
        return this.workQueue(new SynchronousQueue<Runnable>(false));
    }

    public ExecutorBuilder useSynchronousQueue(boolean fair) {
        return this.workQueue(new SynchronousQueue<Runnable>(fair));
    }

    public ExecutorBuilder threadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        return this;
    }

    public ExecutorBuilder namedThreadFactory(String threadPrefix) {
        this.threadFactory = new NamedThreadFactory(threadPrefix);
        return this;
    }

    public ExecutorBuilder rejectHandler(RejectedExecutionHandler rejectHandler) {
        this.handler = rejectHandler;
        return this;
    }

    public ExecutorBuilder allowCoreThreadTimeout() {
        this.allowCoreThreadTimeout = true;
        return this;
    }

    public ExecutorBuilder allowCoreThreadTimeout(boolean allowCoreThreadTimeout) {
        this.allowCoreThreadTimeout = allowCoreThreadTimeout;
        return this;
    }

    public ExecutorBuilder preStartAllCoreThreads() {
        this.preStartAllCoreThreads = true;
        return this;
    }

    public ExecutorBuilder preStartAllCoreThreads(boolean preStartAllCoreThreads) {
        this.preStartAllCoreThreads = preStartAllCoreThreads;
        return this;
    }

    @Override
    public ThreadPoolExecutor build() {
        return ExecutorBuilder.build(this);
    }

    private static ThreadPoolExecutor build(ExecutorBuilder builder) {
        int corePoolSize = builder.corePoolSize;
        int maxPoolSize = builder.maxPoolSize;
        long keepAliveTime = builder.keepAliveTime;
        Queue<Runnable> workQueue = builder.workQueue != null ? builder.workQueue : (corePoolSize <= 0 ? new SynchronousQueue() : new LinkedBlockingQueue(1024));
        ThreadFactory threadFactory = builder.threadFactory != null ? builder.threadFactory : Executors.defaultThreadFactory();
        RejectedExecutionHandler handler = Objects1.def(builder.handler, ThreadPoolExecutor.AbortPolicy::new);
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(corePoolSize, maxPoolSize, keepAliveTime, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)workQueue, threadFactory, handler);
        threadPoolExecutor.allowCoreThreadTimeOut(builder.allowCoreThreadTimeout);
        if (builder.preStartAllCoreThreads) {
            threadPoolExecutor.prestartAllCoreThreads();
        }
        return threadPoolExecutor;
    }
}

