/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.define.wrapper;

import cn.orionsec.kit.lang.define.support.CloneSupport;
import cn.orionsec.kit.lang.define.wrapper.Wrapper;
import cn.orionsec.kit.lang.utils.Urls;
import cn.orionsec.kit.lang.utils.Xsses;
import cn.orionsec.kit.lang.utils.codec.Base64s;

public class TextWrapper
extends CloneSupport<TextWrapper>
implements Wrapper<String> {
    private static final long serialVersionUID = 5693256198048111L;
    private final StringBuilder sb;

    public TextWrapper() {
        this(new StringBuilder());
    }

    public TextWrapper(String s) {
        this(new StringBuilder(s));
    }

    public TextWrapper(StringBuilder sb) {
        this.sb = sb == null ? new StringBuilder() : sb;
    }

    public static TextWrapper get() {
        return new TextWrapper();
    }

    public static TextWrapper get(String s) {
        return new TextWrapper(s);
    }

    public static TextWrapper get(StringBuilder sb) {
        return new TextWrapper(sb);
    }

    public TextWrapper append(String s) {
        this.sb.append(s);
        return this;
    }

    public TextWrapper appendLine(String s) {
        this.sb.append(s).append("\n");
        return this;
    }

    public TextWrapper newLine() {
        this.sb.append("\n");
        return this;
    }

    public TextWrapper newLine(String eof) {
        this.sb.append(eof);
        return this;
    }

    public String encodeXss() {
        return Xsses.clean(this.sb.toString());
    }

    public String decodeXss() {
        return Xsses.recode(this.sb.toString());
    }

    public String encodeUrl() {
        return Urls.encode(this.sb.toString());
    }

    public String decodeUrl() {
        return Urls.decode(this.sb.toString());
    }

    public String encodeBase64() {
        return Base64s.encode(this.sb.toString());
    }

    public String decodeBase64() {
        return Base64s.decode(this.sb.toString());
    }

    public String text() {
        return this.sb.toString();
    }

    public String toString() {
        return this.sb.toString();
    }
}

