/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.define.wrapper;

import cn.orionsec.kit.lang.define.wrapper.HttpWrapper;
import cn.orionsec.kit.lang.define.wrapper.RpcWrapper;
import cn.orionsec.kit.lang.define.wrapper.Wrapper;
import cn.orionsec.kit.lang.utils.Strings;
import cn.orionsec.kit.lang.utils.convert.Converts;
import cn.orionsec.kit.lang.utils.json.Jsons;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WrapperAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(WrapperAdapter.class);
    private static final String[] DEFAULT_CODE = new String[]{"code"};
    private static final String[] DEFAULT_MSG = new String[]{"msg", "message"};
    private static final String[] DEFAULT_DATA = new String[]{"data", "res", "result"};

    private WrapperAdapter() {
    }

    public static HttpWrapper<Object> toHttp(String json) {
        return (HttpWrapper)WrapperAdapter.toWrapper(json, Object.class, true);
    }

    public static HttpWrapper<Object> toHttp(Map<?, ?> map) {
        return (HttpWrapper)WrapperAdapter.toWrapper(map, Object.class, true);
    }

    public static <T> HttpWrapper<T> toHttp(String json, Class<T> dataClass) {
        return (HttpWrapper)WrapperAdapter.toWrapper(json, dataClass, true);
    }

    public static <T> HttpWrapper<T> toHttp(Map<?, ?> map, Class<T> dataClass) {
        return (HttpWrapper)WrapperAdapter.toWrapper(map, dataClass, true);
    }

    public static RpcWrapper<Object> toRpc(String json) {
        return (RpcWrapper)WrapperAdapter.toWrapper(json, Object.class, false);
    }

    public static RpcWrapper<Object> toRpc(Map<?, ?> map) {
        return (RpcWrapper)WrapperAdapter.toWrapper(map, Object.class, false);
    }

    public static <T> RpcWrapper<T> toRpc(String json, Class<T> dataClass) {
        return (RpcWrapper)WrapperAdapter.toWrapper(json, dataClass, false);
    }

    public static <T> RpcWrapper<T> toRpc(Map<?, ?> map, Class<T> dataClass) {
        return (RpcWrapper)WrapperAdapter.toWrapper(map, dataClass, false);
    }

    private static <T> Wrapper<T> toWrapper(String json, Class<T> dataClass, boolean http) {
        if (Strings.isBlank(json)) {
            if (http) {
                return HttpWrapper.get();
            }
            return RpcWrapper.get();
        }
        return WrapperAdapter.toWrapper(Jsons.toMap(json), dataClass, http);
    }

    private static <T> Wrapper<T> toWrapper(Map<?, ?> map, Class<T> dataClass, boolean http) {
        if (map == null) {
            if (http) {
                return HttpWrapper.get();
            }
            return RpcWrapper.get();
        }
        String[] codeArr = new String[DEFAULT_CODE.length];
        for (int i = 0; i < DEFAULT_CODE.length; ++i) {
            Object code = map.get(DEFAULT_CODE[i]);
            if (code == null) continue;
            codeArr[i] = code.toString();
            break;
        }
        int code = WrapperAdapter.codeAdapter(codeArr);
        String[] msgArr = new String[DEFAULT_MSG.length];
        for (int i = 0; i < DEFAULT_MSG.length; ++i) {
            Object msg = map.get(DEFAULT_MSG[i]);
            if (msg == null) continue;
            msgArr[i] = msg.toString();
            break;
        }
        String msg = WrapperAdapter.msgAdapter(msgArr);
        Object[] dataArr = new Object[DEFAULT_DATA.length];
        for (int i = 0; i < DEFAULT_DATA.length; ++i) {
            Object data = map.get(DEFAULT_DATA[i]);
            if (data == null) continue;
            dataArr[i] = data;
            break;
        }
        T data = WrapperAdapter.dataAdapter(dataClass, dataArr);
        if (http) {
            return HttpWrapper.of(code, msg, data);
        }
        return RpcWrapper.of(code, msg, data);
    }

    private static int codeAdapter(String ... codes) {
        for (String code : codes) {
            if (!Strings.isNumber(code)) continue;
            return Integer.parseInt(code);
        }
        return 0;
    }

    private static String msgAdapter(String ... msgs) {
        for (String msg : msgs) {
            if (!Strings.isNoneBlank(msg)) continue;
            return msg;
        }
        return "";
    }

    private static <T> T dataAdapter(Class<T> dataClass, Object ... ds) {
        for (Object data : ds) {
            if (data == null) continue;
            try {
                if (dataClass == Byte.class) {
                    return (T)Byte.valueOf(Converts.toByte(data));
                }
                if (dataClass == Short.class) {
                    return (T)Short.valueOf(Converts.toShort(data));
                }
                if (dataClass == Integer.class) {
                    return (T)Integer.valueOf(Converts.toInt(data));
                }
                if (dataClass == Long.class) {
                    return (T)Long.valueOf(Converts.toLong(data));
                }
                if (dataClass == Float.class) {
                    return (T)Float.valueOf(Converts.toFloat(data));
                }
                if (dataClass == Double.class) {
                    return (T)Double.valueOf(Converts.toDouble(data));
                }
                if (dataClass == Boolean.class) {
                    return (T)Boolean.valueOf(Converts.toBoolean(data));
                }
                if (dataClass == Character.class) {
                    return (T)Character.valueOf(Converts.toChar(data));
                }
                if (dataClass == Date.class) {
                    return (T)Converts.toDate(data);
                }
                if (dataClass == String.class) {
                    return (T)data.toString();
                }
                return Jsons.parse(Jsons.toJson(data), dataClass);
            }
            catch (Exception e) {
                LOGGER.error("WrapperAdapter.dataAdapter parse error", (Throwable)e);
            }
        }
        return null;
    }
}

