/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.function.select;

import cn.orionsec.kit.lang.function.select.Branch;
import cn.orionsec.kit.lang.utils.Arrays1;
import cn.orionsec.kit.lang.utils.Compares;
import cn.orionsec.kit.lang.utils.Objects1;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class Branches<P> {
    private final Predicate<P> tester;

    public Branches(Predicate<P> tester) {
        this.tester = tester;
    }

    public <R> Branch<P, R> then(Function<P, R> factory) {
        return Branch.of(this.tester, factory);
    }

    public <R> Branch<P, R> then(Supplier<R> supplier) {
        return Branch.of(this.tester, r -> supplier.get());
    }

    public <R> Branch<P, R> then(R r) {
        return Branch.of(this.tester, p -> r);
    }

    public static <P> Branches<P> when(Predicate<P> tester) {
        return new Branches<P>(tester);
    }

    public static <P> Branches<P> eq(P v) {
        return new Branches<Object>(p -> Objects1.eq(p, v));
    }

    public static <P extends Comparable<P>> Branches<P> compared(P v) {
        return new Branches<Comparable>(p -> Compares.compared(p, v));
    }

    @SafeVarargs
    public static <P> Branches<P> in(P ... arr) {
        return new Branches<Object>(p -> Arrays1.some(p, arr));
    }
}

