/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.support;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class Attempt {
    private Attempt() {
    }

    public static <T, E extends Exception> Consumer<T> rethrows(UncheckedConsumer<T, E> consumer) throws E {
        return t -> {
            try {
                consumer.accept(t);
            }
            catch (Exception exception) {
                Attempt.throwAsUnchecked(exception);
            }
        };
    }

    public static <T, U, E extends Exception> BiConsumer<T, U> rethrows(UncheckedBiConsumer<T, U, E> biConsumer) throws E {
        return (t, u) -> {
            try {
                biConsumer.accept(t, u);
            }
            catch (Exception exception) {
                Attempt.throwAsUnchecked(exception);
            }
        };
    }

    public static <T, R, E extends Exception> Function<T, R> rethrows(UncheckedFunction<T, R, E> function) throws E {
        return t -> {
            try {
                return function.apply(t);
            }
            catch (Exception exception) {
                Attempt.throwAsUnchecked(exception);
                return null;
            }
        };
    }

    public static <T, E extends Exception> Supplier<T> rethrows(UncheckedSupplier<T, E> function) throws E {
        return () -> {
            try {
                return function.get();
            }
            catch (Exception exception) {
                Attempt.throwAsUnchecked(exception);
                return null;
            }
        };
    }

    public static <E extends Exception> Runnable rethrows(UncheckedRunnable<E> function) throws E {
        return () -> {
            try {
                function.run();
            }
            catch (Exception exception) {
                Attempt.throwAsUnchecked(exception);
            }
        };
    }

    public static <T, E extends Exception> void uncheck(UncheckedConsumer<T, E> consumer, T t) {
        try {
            consumer.accept(t);
        }
        catch (Exception exception) {
            Attempt.throwAsUnchecked(exception);
        }
    }

    public static <T, U, E extends Exception> void uncheck(UncheckedBiConsumer<T, U, E> biConsumer, T t, U u) {
        try {
            biConsumer.accept(t, u);
        }
        catch (Exception exception) {
            Attempt.throwAsUnchecked(exception);
        }
    }

    public static <T, R, E extends Exception> R uncheck(UncheckedFunction<T, R, E> function, T t) {
        try {
            return function.apply(t);
        }
        catch (Exception e) {
            Attempt.throwAsUnchecked(e);
            return null;
        }
    }

    public static <R, E extends Exception> R uncheck(UncheckedSupplier<R, E> supplier) {
        try {
            return supplier.get();
        }
        catch (Exception exception) {
            Attempt.throwAsUnchecked(exception);
            return null;
        }
    }

    public static <E extends Exception> void uncheck(UncheckedRunnable<E> t) {
        try {
            t.run();
        }
        catch (Exception exception) {
            Attempt.throwAsUnchecked(exception);
        }
    }

    private static <E extends Throwable> void throwAsUnchecked(Exception e) throws E {
        throw e;
    }

    @FunctionalInterface
    public static interface UncheckedRunnable<E extends Exception> {
        public void run() throws E;
    }

    @FunctionalInterface
    public static interface UncheckedSupplier<T, E extends Exception> {
        public T get() throws E;
    }

    @FunctionalInterface
    public static interface UncheckedFunction<T, R, E extends Exception> {
        public R apply(T var1) throws E;
    }

    @FunctionalInterface
    public static interface UncheckedBiConsumer<T, U, E extends Exception> {
        public void accept(T var1, U var2) throws E;
    }

    @FunctionalInterface
    public static interface UncheckedConsumer<T, E extends Exception> {
        public void accept(T var1) throws E;
    }
}

