/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.support.progress;

import cn.orionsec.kit.lang.support.progress.ByteTransferProgress;
import cn.orionsec.kit.lang.utils.Objects1;
import cn.orionsec.kit.lang.utils.Threads;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;

public class ByteTransferRateProgress
extends ByteTransferProgress {
    protected boolean computeRate;
    protected int interval;
    protected volatile long nowRate;
    private ExecutorService rateExecutor;
    private Consumer<? super ByteTransferRateProgress> rateAcceptor;

    public ByteTransferRateProgress(long end) {
        this(0L, end);
    }

    public ByteTransferRateProgress(long start, long end) {
        super(start, end);
    }

    public ByteTransferRateProgress computeRate() {
        return this.computeRate(1000);
    }

    public ByteTransferRateProgress computeRate(int interval) {
        this.computeRate = true;
        this.interval = interval;
        return this;
    }

    public ByteTransferRateProgress rateExecutor(ExecutorService rateExecutor) {
        this.rateExecutor = rateExecutor;
        return this;
    }

    public ByteTransferRateProgress rateAcceptor(Consumer<? super ByteTransferRateProgress> rateAcceptor) {
        this.rateAcceptor = rateAcceptor;
        return this;
    }

    @Override
    public void start() {
        this.startTime = System.currentTimeMillis();
        if (this.computeRate) {
            Threads.start(() -> {
                while (!this.done) {
                    long size = this.current.get();
                    Threads.sleep(this.interval);
                    this.nowRate = this.current.get() - size;
                    if (this.rateAcceptor == null) continue;
                    this.rateAcceptor.accept(this);
                }
            }, Objects1.def(this.rateExecutor, Threads.CACHE_EXECUTOR));
        }
    }

    public long getNowRate() {
        return this.nowRate;
    }
}

