/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils;

import cn.orionsec.kit.lang.utils.Strings;
import java.awt.Color;

public class Colors {
    private Colors() {
    }

    public static String toHex(Color color) {
        StringBuilder su = new StringBuilder();
        String r = Integer.toHexString(color.getRed());
        String g = Integer.toHexString(color.getGreen());
        String b = Integer.toHexString(color.getBlue());
        r = r.length() == 1 ? "0" + r : r;
        g = g.length() == 1 ? "0" + g : g;
        b = b.length() == 1 ? "0" + b : b;
        r = r.toUpperCase();
        g = g.toUpperCase();
        b = b.toUpperCase();
        su.append("#");
        su.append(r);
        su.append(g);
        su.append(b);
        return su.toString();
    }

    public static int[] toRgbColor(String hex) {
        if (hex == null) {
            return null;
        }
        try {
            int length = hex.length();
            if (length == 4) {
                char c1 = hex.charAt(1);
                char c2 = hex.charAt(2);
                char c3 = hex.charAt(3);
                hex = "#" + c1 + c1 + c2 + c2 + c3 + c3;
            }
            String str1 = hex.substring(1, 3);
            String str2 = hex.substring(3, 5);
            String str3 = hex.substring(5, 7);
            int red = Integer.parseInt(str1, 16);
            int green = Integer.parseInt(str2, 16);
            int blue = Integer.parseInt(str3, 16);
            return new int[]{red, green, blue};
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] toRgb(String hex) {
        int[] color = Colors.toRgbColor(hex);
        if (color == null) {
            return null;
        }
        return new byte[]{(byte)color[0], (byte)color[1], (byte)color[2]};
    }

    public static Color toColor(String hex) {
        int[] rgb = Colors.toRgbColor(hex);
        if (rgb == null) {
            return null;
        }
        return Colors.toColor(rgb);
    }

    public static Color toColor(byte[] bs) {
        return Colors.toColor(bs[0], bs[1], bs[2]);
    }

    public static Color toColor(int[] bs) {
        return Colors.toColor(bs[0], bs[1], bs[2]);
    }

    public static Color toColor(int r, int g, int b) {
        return new Color(r, g, b);
    }

    public static boolean isDarkColor(String hex) {
        int[] rgb = Colors.toRgbColor(hex);
        return Colors.isDarkColor(rgb[0], rgb[1], rgb[2]);
    }

    public static boolean isDarkColor(int r, int g, int b) {
        return (r * 299 + g * 587 + b * 114) / 1000 < 128;
    }

    public static String adjustColor(String hex, int range) {
        int[] rgb = Colors.toRgbColor(hex);
        StringBuilder newColor = new StringBuilder("#");
        for (int c : rgb) {
            if ((c += range) < 0) {
                c = 0;
            } else if (c > 255) {
                c = 255;
            }
            newColor.append(Strings.leftPad(Integer.toString(c, 16), 2, "0"));
        }
        return newColor.toString();
    }
}

