/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class Moneys {
    private static final char[] CN_UPPER_NUMBER = new char[]{'\u96f6', '\u58f9', '\u8d30', '\u53c1', '\u8086', '\u4f0d', '\u9646', '\u67d2', '\u634c', '\u7396'};
    private static final char[] CN_UPPER_UNIT = new char[]{'\u5206', '\u89d2', '\u5143', '\u62fe', '\u4f70', '\u4edf', '\u4e07', '\u62fe', '\u4f70', '\u4edf', '\u4ebf', '\u62fe', '\u4f70', '\u4edf', '\u5146', '\u62fe', '\u4f70', '\u4edf'};
    private static final char[] CN_UNIT = new char[]{'\u5206', '\u89d2', '\u5143', '\u62fe', '\u4f70', '\u4edf', '\u4e07', '\u4ebf', '\u5146'};
    private static final char CN_FULL = '\u6574';
    private static final char CN_NEGATIVE = '\u8d1f';
    private static final String CN_ZERO_FULL = "\u96f6\u5143\u6574";

    private Moneys() {
    }

    public static String toCurrency(BigDecimal m) {
        StringBuilder sb = new StringBuilder();
        int minus = m.signum();
        if (minus == 0) {
            return CN_ZERO_FULL;
        }
        long number = m.movePointRight(2).setScale(0, RoundingMode.UNNECESSARY).abs().longValue();
        long scale = number % 100L;
        int numIndex = 0;
        boolean getZero = false;
        if (scale <= 0L) {
            numIndex = 2;
            number /= 100L;
            getZero = true;
        }
        if (scale > 0L && scale % 10L == 0L) {
            numIndex = 1;
            number /= 10L;
            getZero = true;
        }
        int zeroSize = 0;
        while (number > 0L) {
            int numUnit = (int)(number % 10L);
            if (numUnit > 0) {
                if (numIndex == 9 && zeroSize >= 3) {
                    sb.insert(0, CN_UPPER_UNIT[6]);
                }
                if (numIndex == 13 && zeroSize >= 3) {
                    sb.insert(0, CN_UPPER_UNIT[10]);
                }
                sb.insert(0, CN_UPPER_UNIT[numIndex]);
                sb.insert(0, CN_UPPER_NUMBER[numUnit]);
                getZero = false;
                zeroSize = 0;
            } else {
                ++zeroSize;
                if (!getZero) {
                    sb.insert(0, CN_UPPER_NUMBER[numUnit]);
                }
                if (numIndex == 2) {
                    sb.insert(0, CN_UPPER_UNIT[numIndex]);
                } else if ((numIndex - 2) % 4 == 0 && number % 1000L > 0L) {
                    sb.insert(0, CN_UPPER_UNIT[numIndex]);
                }
                getZero = true;
            }
            number /= 10L;
            ++numIndex;
        }
        if (minus == -1) {
            sb.insert(0, '\u8d1f');
        }
        if (scale <= 0L) {
            sb.append('\u6574');
        }
        return sb.toString();
    }

    public static BigDecimal toDecimal(String m) {
        boolean negate = false;
        char[] chars = m.toCharArray();
        BigDecimal res = BigDecimal.ZERO;
        BigDecimal t = BigDecimal.ZERO;
        BigDecimal tmp = BigDecimal.ZERO;
        boolean lastIsUnit = true;
        for (int i = 0; i < chars.length; ++i) {
            int j;
            char c = chars[i];
            if (i == 0 && c == '\u8d1f') {
                negate = true;
                continue;
            }
            boolean isUnit = true;
            for (j = 0; j < CN_UPPER_NUMBER.length; ++j) {
                if (c != CN_UPPER_NUMBER[j]) continue;
                tmp = BigDecimal.valueOf(j);
                isUnit = false;
                lastIsUnit = false;
                break;
            }
            if (!isUnit) continue;
            if (lastIsUnit) {
                tmp = BigDecimal.ZERO;
            }
            for (j = 0; j < CN_UNIT.length; ++j) {
                if (c != CN_UNIT[j]) continue;
                switch (j) {
                    case 0: {
                        t = t.add(tmp.multiply(BigDecimal.valueOf(0.01)));
                        tmp = BigDecimal.ZERO;
                        break;
                    }
                    case 1: {
                        t = t.add(tmp.multiply(BigDecimal.valueOf(0.1)));
                        tmp = BigDecimal.ZERO;
                        break;
                    }
                    case 2: {
                        t = t.add(tmp);
                        tmp = BigDecimal.ZERO;
                        break;
                    }
                    case 3: {
                        t = t.add(tmp.multiply(BigDecimal.valueOf(10L)));
                        break;
                    }
                    case 4: {
                        t = t.add(tmp.multiply(BigDecimal.valueOf(100L)));
                        break;
                    }
                    case 5: {
                        t = t.add(tmp.multiply(BigDecimal.valueOf(1000L)));
                        break;
                    }
                    case 6: {
                        res = res.add(t.add(tmp).multiply(BigDecimal.valueOf(10000L)));
                        t = BigDecimal.ZERO;
                        tmp = BigDecimal.ZERO;
                        break;
                    }
                    case 7: {
                        res = res.add(t.add(tmp).multiply(BigDecimal.valueOf(100000000L)));
                        t = BigDecimal.ZERO;
                        tmp = BigDecimal.ZERO;
                        break;
                    }
                    case 8: {
                        res = res.add(t.add(tmp).multiply(BigDecimal.valueOf(1000000000000L)));
                        t = BigDecimal.ZERO;
                        tmp = BigDecimal.ZERO;
                        break;
                    }
                }
                break;
            }
            lastIsUnit = true;
        }
        res = res.add(t).add(tmp).setScale(2, RoundingMode.UNNECESSARY);
        return negate ? res.negate() : res;
    }
}

