/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils;

import cn.orionsec.kit.lang.utils.Strings;
import cn.orionsec.kit.lang.utils.regexp.Matches;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class Spells {
    private static final Pattern CHINESE_CHAR = Pattern.compile("[\\u4E00-\\u9FA5]+");
    private static final Pattern CHINESE_CJK = Pattern.compile("\\p{InCJK Unified Ideographs}&&\\P{Cn}");
    private static final Pattern CHINESE_REG = Pattern.compile("[\\u4E00-\\u9FBF]+");
    private static final Pattern MESSY_CODE = Pattern.compile("\\s*|\t*|\r*|\n*");

    private Spells() {
    }

    public static String getSpell(String s) {
        HanyuPinyinOutputFormat format = new HanyuPinyinOutputFormat();
        format.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        format.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        format.setVCharType(HanyuPinyinVCharType.WITH_V);
        char[] input = s.trim().toCharArray();
        StringBuilder sb = new StringBuilder();
        try {
            for (char c : input) {
                if (Matches.test(Character.toString(c), CHINESE_CHAR)) {
                    sb.append(PinyinHelper.toHanyuPinyinStringArray((char)c, (HanyuPinyinOutputFormat)format)[0]);
                    continue;
                }
                sb.append(c);
            }
        }
        catch (BadHanyuPinyinOutputFormatCombination badHanyuPinyinOutputFormatCombination) {
            // empty catch block
        }
        return sb.toString();
    }

    public static String getFirstSpell(String s) {
        StringBuilder sb = new StringBuilder();
        char[] arr = s.toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (char anArr : arr) {
            if (anArr > '\u0080') {
                try {
                    String[] temp = PinyinHelper.toHanyuPinyinStringArray((char)anArr, (HanyuPinyinOutputFormat)defaultFormat);
                    if (temp == null) continue;
                    sb.append(temp[0].charAt(0));
                }
                catch (BadHanyuPinyinOutputFormatCombination badHanyuPinyinOutputFormatCombination) {}
                continue;
            }
            sb.append(anArr);
        }
        return sb.toString().replaceAll("\\W", "").trim();
    }

    public static String getFullSpell(String s) {
        StringBuilder sb = new StringBuilder();
        char[] arr = s.toCharArray();
        HanyuPinyinOutputFormat format = new HanyuPinyinOutputFormat();
        format.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        format.setVCharType(HanyuPinyinVCharType.WITH_U_UNICODE);
        for (char anArr : arr) {
            if (anArr > '\u0080') {
                try {
                    sb.append(PinyinHelper.toHanyuPinyinStringArray((char)anArr, (HanyuPinyinOutputFormat)format)[0]);
                }
                catch (BadHanyuPinyinOutputFormatCombination badHanyuPinyinOutputFormatCombination) {}
                continue;
            }
            sb.append(anArr);
        }
        return sb.toString();
    }

    public static boolean isChineseByReg(String s) {
        if (Strings.isEmpty(s)) {
            return false;
        }
        return CHINESE_REG.matcher(s.trim()).find();
    }

    public static boolean isChineseByName(String s) {
        if (Strings.isEmpty(s)) {
            return false;
        }
        return CHINESE_CJK.matcher(s.trim()).find();
    }

    public static boolean containsChinese(String s) {
        char[] ch;
        for (char c : ch = s.toCharArray()) {
            if (!Spells.isChinese(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllChinese(String s) {
        char[] ch;
        for (char c : ch = s.toCharArray()) {
            if (Spells.isChinese(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }

    public static int getChineseLength(String s) {
        Matcher m = CHINESE_CHAR.matcher(s);
        int i = 0;
        while (m.find()) {
            String temp = m.group(0);
            i += temp.length();
        }
        return i;
    }

    public static boolean isMessyCode(String s) {
        Matcher m = MESSY_CODE.matcher(s);
        String after = m.replaceAll("");
        String temp = after.replaceAll("\\p{P}", "");
        char[] ch = temp.trim().toCharArray();
        float chLength = 0.0f;
        float count = 0.0f;
        for (char c : ch) {
            if (Character.isLetterOrDigit(c)) continue;
            if (!Spells.isChinese(c)) {
                count += 1.0f;
            }
            chLength += 1.0f;
        }
        float result = count / chLength;
        return (double)result > 0.4;
    }
}

