/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils;

import cn.orionsec.kit.lang.utils.Arrays1;
import cn.orionsec.kit.lang.utils.Charsets;
import cn.orionsec.kit.lang.utils.Objects1;
import cn.orionsec.kit.lang.utils.Systems;
import cn.orionsec.kit.lang.utils.Valid;
import cn.orionsec.kit.lang.utils.collect.Collections;
import cn.orionsec.kit.lang.utils.collect.Maps;
import cn.orionsec.kit.lang.utils.regexp.Matches;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Strings {
    public static final String EMPTY = "";
    public static final String SPACE = " ";

    private Strings() {
    }

    public static String str(Object obj) {
        return Strings.str(obj, "UTF-8");
    }

    public static String str(Object obj, String charset) {
        if (obj == null) {
            return null;
        }
        Charset cs = charset == null ? Charset.defaultCharset() : Charset.forName(charset);
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof char[]) {
            return new String((char[])obj);
        }
        if (obj instanceof byte[]) {
            return new String((byte[])obj, cs);
        }
        if (obj instanceof ByteBuffer) {
            return cs.decode((ByteBuffer)obj).toString();
        }
        return obj.toString();
    }

    public static int length(String s) {
        return s == null ? 0 : s.length();
    }

    public static int length(String s, boolean trim) {
        if (trim) {
            return s == null ? 0 : s.trim().length();
        }
        return s == null ? 0 : s.length();
    }

    public static String def(String str) {
        if (Strings.isBlank(str)) {
            return EMPTY;
        }
        return str;
    }

    public static String def(String str, String def) {
        if (Strings.isBlank(str)) {
            return def;
        }
        return str;
    }

    public static String def(String str, Supplier<String> def) {
        if (Strings.isBlank(str)) {
            return def.get();
        }
        return str;
    }

    public static String ifBlank(String s) {
        return Strings.isBlank(s) ? EMPTY : s;
    }

    public static String ifBlank(String s, String def) {
        return Strings.isBlank(s) ? def : s;
    }

    public static String ifBlank(String s, Supplier<String> def) {
        return Strings.isBlank(s) ? def.get() : s;
    }

    public static String ifEmpty(String s) {
        return Strings.isEmpty(s) ? EMPTY : s;
    }

    public static String ifEmpty(String s, String def) {
        return Strings.isEmpty(s) ? def : s;
    }

    public static String ifEmpty(String s, Supplier<String> def) {
        return Strings.isEmpty(s) ? def.get() : s;
    }

    public static void ifNotBlank(String s, Consumer<String> acceptor) {
        Valid.notNull(acceptor, "acceptor is null", new Object[0]);
        if (Strings.isBlank(s)) {
            return;
        }
        acceptor.accept(s);
    }

    public static void ifNotEmpty(String s, Consumer<String> acceptor) {
        Valid.notNull(acceptor, "acceptor is null", new Object[0]);
        if (Strings.isEmpty(s)) {
            return;
        }
        acceptor.accept(s);
    }

    public static boolean isBlank(String str) {
        return str == null || EMPTY.equals(str) || EMPTY.equals(str.trim()) || str.replaceAll("\\s", EMPTY).length() == 0;
    }

    public static boolean isNotBlank(String str) {
        return !Strings.isBlank(str);
    }

    public static boolean isAllBlank(String ... strs) {
        if (strs == null || strs.length == 0) {
            return true;
        }
        for (String str : strs) {
            if (Strings.isBlank(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAnyBlank(String ... strs) {
        if (strs == null || strs.length == 0) {
            return false;
        }
        for (String str : strs) {
            if (!Strings.isBlank(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNoneBlank(String ... strs) {
        if (strs == null || strs.length == 0) {
            return false;
        }
        for (String str : strs) {
            if (!Strings.isBlank(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence str) {
        return !Strings.isEmpty(str);
    }

    public static boolean isAllEmpty(CharSequence ... strs) {
        if (strs == null || strs.length == 0) {
            return true;
        }
        for (CharSequence str : strs) {
            if (Strings.isEmpty(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAnyEmpty(String ... strs) {
        if (strs == null || strs.length == 0) {
            return false;
        }
        for (String str : strs) {
            if (!Strings.isEmpty(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNoneEmpty(CharSequence ... strs) {
        if (strs == null || strs.length == 0) {
            return false;
        }
        for (CharSequence str : strs) {
            if (!Strings.isEmpty(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean isInteger(String str) {
        if (Strings.isBlank(str)) {
            return false;
        }
        return Matches.isInteger(str);
    }

    public static boolean isNotInteger(String str) {
        return !Strings.isInteger(str);
    }

    public static boolean isAllInteger(String ... strs) {
        if (strs == null) {
            return false;
        }
        if (strs.length == 0) {
            return false;
        }
        for (String str : strs) {
            if (!Strings.isBlank(str) && Matches.isInteger(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNoneInteger(String ... strs) {
        if (strs == null) {
            return false;
        }
        if (strs.length == 0) {
            return false;
        }
        for (String str : strs) {
            if (Strings.isBlank(str) || !Matches.isInteger(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean isIntegerASCII(String str) {
        if (Strings.isBlank(str)) {
            return false;
        }
        int i = str.length();
        while (--i > 0) {
            char chr = str.charAt(i);
            if (chr >= '0' && chr <= '9') continue;
            return false;
        }
        char chr = str.charAt(0);
        return chr >= '0' && chr <= '9' || chr == '-';
    }

    public static boolean isDouble(String str) {
        if (Strings.isBlank(str)) {
            return false;
        }
        return Matches.isDouble(str);
    }

    public static boolean isNotDouble(String str) {
        return !Strings.isDouble(str);
    }

    public static boolean isAllDouble(String ... strs) {
        if (strs == null) {
            return false;
        }
        if (strs.length == 0) {
            return false;
        }
        for (String str : strs) {
            if (!Strings.isBlank(str) && Matches.isDouble(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNoneDouble(String ... strs) {
        if (strs == null) {
            return false;
        }
        if (strs.length == 0) {
            return false;
        }
        for (String str : strs) {
            if (Strings.isBlank(str) || !Matches.isDouble(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumber(String str) {
        if (Strings.isBlank(str)) {
            return false;
        }
        return Matches.isNumber(str);
    }

    public static boolean isNotNumber(String str) {
        return !Strings.isNumber(str);
    }

    public static boolean isAllNumber(String ... strs) {
        if (strs == null) {
            return false;
        }
        if (strs.length == 0) {
            return false;
        }
        for (String str : strs) {
            if (!Strings.isBlank(str) && Strings.matcherNumber(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNoneNumber(String ... strs) {
        if (strs == null) {
            return false;
        }
        if (strs.length == 0) {
            return false;
        }
        for (String str : strs) {
            if (Strings.isBlank(str) || !Strings.matcherNumber(str)) continue;
            return false;
        }
        return true;
    }

    private static boolean matcherNumber(String str) {
        return Matches.isInteger(str) || Matches.isDouble(str);
    }

    public static boolean startWith(String s, String start) {
        return s.startsWith(start);
    }

    public static boolean endWith(String s, String end) {
        return s.endsWith(end);
    }

    public static String substringBefore(String s, String separator) {
        if (Strings.isEmpty(s) || Strings.isEmpty(separator)) {
            return s;
        }
        int pos = s.indexOf(separator);
        if (pos == -1) {
            return s;
        }
        return s.substring(0, pos);
    }

    public static String substringBeforeLast(String s, String separator) {
        if (Strings.isEmpty(s) || Strings.isEmpty(separator)) {
            return s;
        }
        int pos = s.lastIndexOf(separator);
        if (pos == -1) {
            return s;
        }
        return s.substring(0, pos);
    }

    public static String substringAfter(String s, String separator) {
        if (Strings.isEmpty(s) || Strings.isEmpty(separator)) {
            return s;
        }
        int pos = s.indexOf(separator);
        if (pos == -1) {
            return s;
        }
        return s.substring(pos + separator.length());
    }

    public static String substringAfterLast(String s, String separator) {
        if (Strings.isEmpty(s) || Strings.isEmpty(separator)) {
            return s;
        }
        int pos = s.indexOf(separator);
        if (pos == -1) {
            return s;
        }
        return s.substring(pos + separator.length());
    }

    public static void split(String str, String tokenizer, Consumer<String> consumer) {
        String[] arr;
        if (Strings.isBlank(str) || Strings.isBlank(tokenizer)) {
            return;
        }
        for (String s : arr = str.split(tokenizer)) {
            consumer.accept(s);
        }
    }

    public static String join(String ... strs) {
        if (Arrays1.length(strs) == 0) {
            return EMPTY;
        }
        StringBuilder sb = Strings.newBuilder();
        for (String str : strs) {
            sb.append(str);
        }
        return sb.toString();
    }

    public static String joinWith(String delimiter, String ... strs) {
        if (Arrays1.length(strs) == 0) {
            return EMPTY;
        }
        if (Strings.isBlank(delimiter)) {
            delimiter = EMPTY;
        }
        StringBuilder sb = Strings.newBuilder();
        for (String str : strs) {
            sb.append(str).append(delimiter);
        }
        sb.deleteCharAt(sb.length() - delimiter.length());
        return sb.toString();
    }

    public static String join(Collection<String> list, String delimiter) {
        return Strings.join(list, delimiter, EMPTY, EMPTY);
    }

    public static String join(Collection<String> list, String delimiter, String prefix, String suffix) {
        prefix = Strings.isBlank(prefix) ? EMPTY : prefix;
        suffix = Strings.isBlank(suffix) ? EMPTY : suffix;
        StringJoiner sj = new StringJoiner(delimiter, prefix, suffix);
        list.forEach(sj::add);
        return sj.toString();
    }

    public static String appendAround(String s, String prefix, String suffix) {
        prefix = Strings.isBlank(prefix) ? EMPTY : prefix;
        String string = suffix = Strings.isBlank(suffix) ? EMPTY : suffix;
        if (Strings.isBlank(s)) {
            return prefix + suffix;
        }
        return prefix + s + suffix;
    }

    public static String replace(String s, String o, String t) {
        if (s.isEmpty()) {
            return s;
        }
        return s.replace(o, t);
    }

    public static String replaceAll(String s, String reg, String t) {
        if (s.isEmpty()) {
            return s;
        }
        return s.replaceAll(reg, t);
    }

    public static String randomChar() {
        return Strings.randomChars(1);
    }

    public static String randomChars(int count) {
        StringBuilder build = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            Random random = new Random();
            int highCode = 176 + Math.abs(random.nextInt(39));
            int lowCode = 161 + Math.abs(random.nextInt(93));
            byte[] b = new byte[]{Integer.valueOf(highCode).byteValue(), Integer.valueOf(lowCode).byteValue()};
            build.append(new String(b, Charsets.GBK));
        }
        return build.toString();
    }

    public static String format(String str, Object ... args) {
        if (Strings.isBlank(str) || args == null) {
            return str;
        }
        int strLength = str.length();
        StringBuilder sb = new StringBuilder(strLength + 50);
        int handledPosition = 0;
        for (int argIndex = 0; argIndex < args.length; ++argIndex) {
            int index = str.indexOf("{}", handledPosition);
            if (index == -1) {
                if (handledPosition == 0) {
                    return str;
                }
                sb.append(str, handledPosition, strLength);
                return sb.toString();
            }
            if (index > 0 && str.charAt(index - 1) == '\\') {
                if (index > 1 && str.charAt(index - 2) == '\\') {
                    sb.append(str, handledPosition, index - 1);
                    sb.append(Strings.str(args[argIndex]));
                    handledPosition = index + 2;
                    continue;
                }
                --argIndex;
                sb.append(str, handledPosition, index - 1);
                sb.append('{');
                handledPosition = index + 1;
                continue;
            }
            sb.append(str, handledPosition, index);
            sb.append(Strings.str(args[argIndex]));
            handledPosition = index + 2;
        }
        sb.append(str, handledPosition, str.length());
        return sb.toString();
    }

    public static String format(String str, Map<?, ?> map) {
        return Strings.format(str, "$", map);
    }

    public static String format(String str, String replacement, Map<?, ?> map) {
        if (Strings.isEmpty(str) || Maps.isEmpty(map)) {
            return str;
        }
        String newReplacement = replacement.chars().mapToObj(s -> "\\" + (char)s).collect(Collectors.joining());
        Pattern p = Pattern.compile("(" + newReplacement + "\\{)(.+?)(\\})");
        Matcher matcher = p.matcher(str);
        while (matcher.find()) {
            String group = matcher.group();
            String key = group.substring(replacement.length() + 1, group.length() - 1);
            Object value = map.get(key);
            if (value == null) continue;
            str = str.replace(group, Objects1.toString(value));
        }
        return str;
    }

    public static String build(Object ... obj) {
        return Strings.build(null, obj);
    }

    public static String build(Appendable build, Object ... obj) {
        if (obj == null || obj.length == 0) {
            return EMPTY;
        }
        if (build == null) {
            build = new StringBuilder();
        }
        try {
            for (Object o : obj) {
                build.append(Strings.str(o));
            }
        }
        catch (Exception e) {
            return EMPTY;
        }
        return build.toString();
    }

    public static StringBuilder newBuilder() {
        return new StringBuilder();
    }

    public static StringBuilder newBuilder(String s) {
        return new StringBuilder(s);
    }

    public static StringBuilder newBuilder(int capacity) {
        return new StringBuilder(capacity);
    }

    public static StringBuffer newBuffer() {
        return new StringBuffer();
    }

    public static StringBuffer newBuffer(String s) {
        return new StringBuffer(s);
    }

    public static StringBuffer newBuffer(int capacity) {
        return new StringBuffer(capacity);
    }

    public static boolean eq(Object o1, Object o2) {
        String str1 = Strings.str(o1);
        String str2 = Strings.str(o2);
        return Strings.eq(str1, str2);
    }

    public static boolean trimEq(Object o1, Object o2) {
        String str1 = Strings.str(o1);
        String str2 = Strings.str(o2);
        if (str1 != null) {
            str1 = str1.trim();
        }
        if (str2 != null) {
            str2 = str2.trim();
        }
        return Strings.eq(str1, str2);
    }

    public static boolean ignoreEq(Object o1, Object o2) {
        String str1 = Strings.str(o1);
        String str2 = Strings.str(o2);
        if (str1 == null && str2 == null) {
            return true;
        }
        if (str1 != null) {
            return str1.equalsIgnoreCase(str2);
        }
        return false;
    }

    public static boolean eq(String str1, String str2) {
        return str1 == str2 || str1 != null && str1.equals(str2);
    }

    public static boolean some(String str, String ... strs) {
        if (Strings.isEmpty(str)) {
            return false;
        }
        if (Arrays1.length(strs) == 0) {
            return false;
        }
        for (String t : strs) {
            if (!Strings.eq(str, t)) continue;
            return true;
        }
        return false;
    }

    public static String firstLower(Object obj) {
        String str = Strings.str(obj);
        if (Strings.isBlank(str)) {
            return str;
        }
        char[] cs = str.toCharArray();
        if (cs[0] >= 'A' && cs[0] <= 'Z') {
            cs[0] = (char)(cs[0] + 32);
        }
        return String.valueOf(cs);
    }

    public static String firstUpper(Object obj) {
        String str = Strings.str(obj);
        if (Strings.isBlank(str)) {
            return str;
        }
        char[] cs = str.toCharArray();
        if (cs[0] >= 'a' && cs[0] <= 'z') {
            cs[0] = (char)(cs[0] - 32);
        }
        return String.valueOf(cs);
    }

    public static String fullToHalf(String s) {
        char[] c = s.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == '\u3000') {
                c[i] = 32;
                continue;
            }
            if (c[i] <= '\uff00' || c[i] >= '\uff5f') continue;
            c[i] = (char)(c[i] - 65248);
        }
        return new String(c);
    }

    public static String halfToFull(String s) {
        char[] c = s.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == ' ') {
                c[i] = 12288;
                continue;
            }
            if (c[i] >= '\u007f') continue;
            c[i] = (char)(c[i] + 65248);
        }
        return new String(c);
    }

    public static String repeat(String str, int num) {
        if (Strings.isEmpty(str)) {
            str = EMPTY;
        }
        if (num <= 0) {
            return EMPTY;
        }
        if (num == 1) {
            return str;
        }
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < num; ++i) {
            s.append(str);
        }
        return s.toString();
    }

    public static String repeat(char c, int num) {
        if (num <= 0) {
            return EMPTY;
        }
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < num; ++i) {
            s.append(c);
        }
        return s.toString();
    }

    public static char[] repeatArr(String str, int num) {
        int length = Strings.length(str);
        if (num <= 0) {
            return new char[0];
        }
        char[] chars = str.toCharArray();
        if (num == 1) {
            return chars;
        }
        char[] arr = new char[length * num];
        for (int i = 0; i < num; ++i) {
            System.arraycopy(chars, 0, arr, i * length, length);
        }
        return arr;
    }

    public static String trimPunct(String s) {
        if (Strings.isBlank(s)) {
            return s;
        }
        return s.replaceAll("[\\pP\\p{Punct}]", EMPTY).replaceAll("\uffe5", EMPTY);
    }

    public static int findNum(String s, String find) {
        return Matches.findNum(s, find);
    }

    public static String skip(String str, int skip) {
        if (Strings.isEmpty(str)) {
            return str;
        }
        int length = Strings.length(str);
        if (skip >= length) {
            return EMPTY;
        }
        char[] cs = new char[length - skip];
        System.arraycopy(str.toCharArray(), skip, cs, 0, length - skip);
        return Strings.str(cs);
    }

    public static String retain(String str, int length) {
        if (Strings.isEmpty(str)) {
            return str;
        }
        int len = str.length();
        if (len <= length) {
            return str;
        }
        return str.substring(0, length);
    }

    public static String omit(String str, int length) {
        return Strings.centerOmit(str, length, length, "...");
    }

    public static String omit(String str, int length, String omit) {
        return Strings.centerOmit(str, length, length, omit);
    }

    public static String centerOmit(String str, int leftLength, int length) {
        return Strings.centerOmit(str, leftLength, length, "...");
    }

    public static String centerOmit(String str, int leftLength, int length, String omit) {
        Valid.gte(length, leftLength, "length must >= left length", new Object[0]);
        if (Strings.isEmpty(str)) {
            return str;
        }
        int len = Strings.length(str);
        if (length >= len) {
            return str;
        }
        String left = str.substring(0, leftLength);
        int rightLen = len - leftLength;
        if (rightLen > length - leftLength + omit.length()) {
            return left + omit + str.substring(len - (length - leftLength));
        }
        return str;
    }

    public static String charset(String s, String oldCharset, String newCharset) {
        if (!Strings.isBlank(s)) {
            try {
                byte[] bytes = Strings.bytes(s, oldCharset);
                return new String(bytes, newCharset);
            }
            catch (Exception e) {
                return s;
            }
        }
        return s;
    }

    public static String charset(String s, String charset) {
        if (!Strings.isBlank(s)) {
            try {
                return new String(Strings.bytes(s), charset);
            }
            catch (Exception e) {
                return s;
            }
        }
        return s;
    }

    public static String toGBK(String s) {
        return Strings.charset(s, "GBK");
    }

    public static String toUTF8(String s) {
        return Strings.charset(s, "UTF-8");
    }

    public static String toASCII(String s) {
        return Strings.charset(s, "US-ASCII");
    }

    public static String rightPad(String str, int size) {
        return Strings.rightPad(str, size, ' ');
    }

    public static String rightPad(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        if (pads > 8192) {
            return Strings.rightPad(str, size, String.valueOf(padChar));
        }
        return str.concat(Strings.repeat(padChar, pads));
    }

    public static String rightPad(String str, int size, String padStr) {
        if (str == null) {
            return null;
        }
        if (Strings.isEmpty(padStr)) {
            padStr = SPACE;
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        if (padLen == 1 && pads <= 8192) {
            return Strings.rightPad(str, size, padStr.charAt(0));
        }
        if (pads == padLen) {
            return str.concat(padStr);
        }
        if (pads < padLen) {
            return str.concat(padStr.substring(0, pads));
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding[i] = padChars[i % padLen];
        }
        return str.concat(new String(padding));
    }

    public static String leftPad(String str, int size) {
        return Strings.leftPad(str, size, ' ');
    }

    public static String leftPad(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        if (pads > 8192) {
            return Strings.leftPad(str, size, String.valueOf(padChar));
        }
        return Strings.repeat(padChar, pads).concat(str);
    }

    public static String leftPad(String str, int size, String padStr) {
        if (str == null) {
            return null;
        }
        if (Strings.isEmpty(padStr)) {
            padStr = SPACE;
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        if (padLen == 1 && pads <= 8192) {
            return Strings.leftPad(str, size, padStr.charAt(0));
        }
        if (pads == padLen) {
            return padStr.concat(str);
        }
        if (pads < padLen) {
            return padStr.substring(0, pads).concat(str);
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding[i] = padChars[i % padLen];
        }
        return new String(padding).concat(str);
    }

    public static String centerPad(String str, int size) {
        return Strings.centerPad(str, size, ' ');
    }

    public static String centerPad(String str, int size, char padChar) {
        if (str == null || size <= 0) {
            return str;
        }
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        str = Strings.leftPad(str, strLen + pads / 2, padChar);
        str = Strings.rightPad(str, size, padChar);
        return str;
    }

    public static String centerPad(String str, int size, String padStr) {
        int strLen;
        int pads;
        if (str == null || size <= 0) {
            return str;
        }
        if (Strings.isEmpty(padStr)) {
            padStr = SPACE;
        }
        if ((pads = size - (strLen = str.length())) <= 0) {
            return str;
        }
        str = Strings.leftPad(str, strLen + pads / 2, padStr);
        str = Strings.rightPad(str, size, padStr);
        return str;
    }

    public static int[] getCodePoints(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return new int[0];
        }
        int[] result = new int[s.codePointCount(0, s.length())];
        int index = 0;
        for (int i = 0; i < result.length; ++i) {
            result[i] = s.codePointAt(index);
            index += Character.charCount(result[i]);
        }
        return result;
    }

    public static byte[] bytes(String s) {
        return Strings.bytes(s, (Charset)null);
    }

    public static byte[] bytes(String s, Charset charset) {
        if (charset != null) {
            return s.getBytes(charset);
        }
        return s.getBytes(Charsets.of(Systems.FILE_ENCODING));
    }

    public static byte[] bytes(String s, String charset) {
        if (charset != null) {
            return s.getBytes(Charsets.of(charset));
        }
        return s.getBytes(Charsets.of(Systems.FILE_ENCODING));
    }

    public static String replaceCRLF(String s) {
        return s.replaceAll("\r\n", "\n").replaceAll("\r", "\n");
    }

    public static boolean contains(String s, String contains) {
        if (s == null || contains == null) {
            return false;
        }
        return s.contains(contains);
    }

    public static boolean containsAny(String s, Collection<String> contains) {
        if (s == null || Collections.isEmpty(contains)) {
            return false;
        }
        for (String contain : contains) {
            if (!s.contains(contain)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAll(String s, Collection<String> contains) {
        if (s == null) {
            return false;
        }
        if (Collections.isEmpty(contains)) {
            return true;
        }
        for (String contain : contains) {
            if (s.contains(contain)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsNone(String s, String contains) {
        if (s == null || contains == null) {
            return true;
        }
        return !s.contains(contains);
    }

    public static boolean containsNone(String s, Collection<String> contains) {
        if (s == null || Collections.isEmpty(contains)) {
            return true;
        }
        for (String contain : contains) {
            if (!s.contains(contain)) continue;
            return false;
        }
        return true;
    }
}

