/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.ansi;

import cn.orionsec.kit.lang.utils.ansi.AnsiCtrl;
import cn.orionsec.kit.lang.utils.ansi.AnsiElement;
import cn.orionsec.kit.lang.utils.ansi.style.AnsiStyle;

public class AnsiAppender {
    private StringBuilder builder = new StringBuilder();

    public static AnsiAppender create() {
        return new AnsiAppender();
    }

    public AnsiAppender append(String text) {
        this.builder.append(text);
        return this;
    }

    public AnsiAppender append(AnsiStyle style, String text) {
        this.builder.append(style.toString()).append(text).append("\u001b[0m");
        return this;
    }

    public AnsiAppender append(AnsiElement element) {
        this.builder.append(element.toString());
        return this;
    }

    public AnsiAppender append(Object ... elements) {
        for (Object element : elements) {
            this.builder.append(element.toString());
        }
        return this;
    }

    public AnsiAppender reset() {
        this.builder.append("\u001b[0m");
        return this;
    }

    public AnsiAppender newLine() {
        this.builder.append(AnsiCtrl.CR).append(AnsiCtrl.LF);
        return this;
    }

    public void clear() {
        this.builder = new StringBuilder();
    }

    public String get() {
        return this.builder.toString();
    }

    public String getAndClear() {
        String r = this.get();
        this.clear();
        return r;
    }

    public String toString() {
        return this.get();
    }
}

