/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.awt;

import cn.orionsec.kit.lang.able.Processable;
import cn.orionsec.kit.lang.utils.Chars;
import cn.orionsec.kit.lang.utils.Colors;
import cn.orionsec.kit.lang.utils.awt.Fonts;
import cn.orionsec.kit.lang.utils.awt.Images;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;

public class ImageIcons
implements Processable<Character, BufferedImage> {
    private int size = 60;
    private Color color = Colors.toColor("#3A76BE");
    private Color fontColor = Color.WHITE;
    private Font font = new Font("\u5b8b\u4f53", 1, 45);
    private boolean square;

    public static ImageIcons create() {
        return new ImageIcons();
    }

    public String executeBase64(Character s) {
        return Images.base64Encode(this.execute(s));
    }

    public String executeBase64(Character s, String format) {
        return Images.base64Encode(this.execute(s), format);
    }

    @Override
    public BufferedImage execute(Character c) {
        BufferedImage img = Images.getTransparentImage(this.size, this.size);
        Graphics2D g2d = img.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setColor(this.color);
        if (this.square) {
            g2d.fill(new RoundRectangle2D.Float(0.0f, 0.0f, this.size, this.size, 0.0f, 0.0f));
        } else {
            g2d.fill(new RoundRectangle2D.Float(0.0f, 0.0f, this.size, this.size, this.size, this.size));
        }
        g2d.setColor(this.fontColor);
        g2d.setFont(this.font);
        int[] wh = Fonts.getWidthHeightPixel(g2d, this.font, c.toString());
        int width = wh[0];
        int height = wh[1];
        int x = (this.size - width) / 2;
        int y = Chars.isAscii(c.charValue()) ? (this.size - height) / 2 + height : (this.size - height) / 2 + height - (this.font.getSize() - height);
        g2d.drawString(c.toString(), (float)x - 2.0f, (float)(y - 2));
        g2d.dispose();
        return img;
    }

    public ImageIcons size(int size) {
        this.size = size;
        return this;
    }

    public ImageIcons color(Color color) {
        this.color = color;
        return this;
    }

    public ImageIcons font(String fontName, int fontSize) {
        this.font = new Font(fontName, 0, fontSize);
        return this;
    }

    public ImageIcons font(Font font) {
        this.font = font;
        return this;
    }

    public ImageIcons fontColor(Color fontColor) {
        this.fontColor = fontColor;
        return this;
    }

    public ImageIcons square() {
        this.square = true;
        return this;
    }

    public ImageIcons circular() {
        this.square = false;
        return this;
    }

    public int getSize() {
        return this.size;
    }

    public Color getColor() {
        return this.color;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public Font getFont() {
        return this.font;
    }

    public boolean isSquare() {
        return this.square;
    }
}

