/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.convert;

import cn.orionsec.kit.lang.define.collect.MultiConcurrentHashMap;
import cn.orionsec.kit.lang.define.iterator.ClassIterator;
import cn.orionsec.kit.lang.define.support.CloneSupport;
import cn.orionsec.kit.lang.function.Conversion;
import cn.orionsec.kit.lang.utils.Arrays1;
import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.Strings;
import cn.orionsec.kit.lang.utils.Valid;
import cn.orionsec.kit.lang.utils.collect.Sets;
import cn.orionsec.kit.lang.utils.convert.BasicTypeStoreProvider;
import cn.orionsec.kit.lang.utils.reflect.Classes;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TypeStore
extends CloneSupport<TypeStore>
implements Serializable {
    private static final long serialVersionUID = 12038041239487192L;
    public static final TypeStore STORE = new TypeStore();
    private final MultiConcurrentHashMap<Class<?>, Class<?>, Conversion<?, ?>> conversionMapping = new MultiConcurrentHashMap();

    public <T, R> void register(Class<T> source, Class<R> target, Conversion<T, R> conversion) {
        this.conversionMapping.put(source, target, conversion);
    }

    public <T, R> Conversion<T, R> get(Class<T> source, Class<R> target) {
        return (Conversion)this.conversionMapping.get(source, target);
    }

    public MultiConcurrentHashMap<Class<?>, Class<?>, Conversion<?, ?>> getConversionMapping() {
        return this.conversionMapping;
    }

    public <T, R> R to(T t, Class<R> targetClass) {
        Valid.notNull(t, "convert target object is null", new Object[0]);
        Class<?> sourceClass = t.getClass();
        targetClass = Classes.getWrapClass(targetClass);
        if (TypeStore.canDirectConvert(sourceClass, targetClass, false)) {
            return (R)t;
        }
        Conversion<?, R> conversion = this.get(sourceClass, targetClass);
        if (conversion != null) {
            return conversion.apply(t);
        }
        for (Class<?> sourceParentClass : new ClassIterator(sourceClass)) {
            conversion = this.get(sourceParentClass, targetClass);
            if (conversion == null) continue;
            return conversion.apply(t);
        }
        if (!Classes.isArray(targetClass)) {
            throw Exceptions.convert(Strings.format("unable to convert source [{}] class to target [{}] class", sourceClass, targetClass));
        }
        Class<?> baseArrayClass = Classes.getBaseArrayClass(targetClass);
        if (baseArrayClass.equals(targetClass)) {
            throw Exceptions.convert(Strings.format("unable to convert source [{}] class to target [{}] class", sourceClass, targetClass));
        }
        if (sourceClass.equals(baseArrayClass)) {
            return (R)Arrays1.wrap(t);
        }
        Conversion<?, ?> baseConvert = this.get(sourceClass, baseArrayClass);
        if (baseConvert == null) {
            throw Exceptions.convert(Strings.format("unable to convert source [{}] class to target [{}] class", sourceClass, targetClass));
        }
        Object apply = baseConvert.apply(t);
        if (apply != null) {
            return (R)Arrays1.wrap(apply);
        }
        return null;
    }

    public Set<Class<?>> getSuitableClasses(Class<?> sourceType) {
        return this.getSuitableClasses(sourceType, false);
    }

    public Set<Class<?>> getAllSuitableClasses(Class<?> sourceType) {
        return this.getSuitableClasses(sourceType, true);
    }

    protected Set<Class<?>> getSuitableClasses(Class<?> sourceType, boolean all) {
        Set<Class<?>> classes = Sets.as(this.conversionMapping.computeIfAbsent(sourceType, c -> new ConcurrentHashMap(8)).keys());
        if (all) {
            for (Class<?> parentType : new ClassIterator(sourceType)) {
                Map map = (Map)this.conversionMapping.get(parentType);
                if (map == null) continue;
                classes.addAll(map.keySet());
            }
        }
        return classes;
    }

    public Map<Class<?>, Conversion<?, ?>> getSuitableConversion(Class<?> sourceType) {
        return this.getSuitableConversion(sourceType, false);
    }

    public Map<Class<?>, Conversion<?, ?>> getAllSuitableConversion(Class<?> sourceType) {
        return this.getSuitableConversion(sourceType, true);
    }

    protected Map<Class<?>, Conversion<?, ?>> getSuitableConversion(Class<?> sourceType, boolean all) {
        Map mapping = this.conversionMapping.computeIfAbsent(sourceType, c -> new ConcurrentHashMap(8));
        if (all) {
            for (Class<?> parentType : new ClassIterator(sourceType)) {
                Map parentMapping = (Map)this.conversionMapping.get(parentType);
                if (parentMapping == null) continue;
                parentMapping.forEach(mapping::putIfAbsent);
            }
        }
        return mapping;
    }

    public static TypeStore getStore() {
        return STORE;
    }

    public static boolean canConvert(Class<?> sourceClass, Class<?> targetClass) {
        return TypeStore.canConvert(sourceClass, targetClass, STORE);
    }

    public static boolean canConvert(Class<?> sourceClass, Class<?> targetClass, TypeStore store) {
        Valid.notNull(sourceClass, "source class is null", new Object[0]);
        Valid.notNull(targetClass, "target class is null", new Object[0]);
        sourceClass = Classes.getWrapClass(sourceClass);
        targetClass = Classes.getWrapClass(targetClass);
        if (TypeStore.canDirectConvert(sourceClass, targetClass, false)) {
            return true;
        }
        if (store.get(sourceClass, targetClass) != null) {
            return true;
        }
        for (Class<?> sourceParentClass : new ClassIterator(sourceClass)) {
            if (store.get(sourceParentClass, targetClass) == null) continue;
            return true;
        }
        if (!Classes.isArray(targetClass)) {
            return false;
        }
        Class<?> baseArrayClass = Classes.getBaseArrayClass(targetClass);
        if (baseArrayClass.equals(targetClass)) {
            return false;
        }
        if (sourceClass.equals(baseArrayClass)) {
            return true;
        }
        return store.get(sourceClass, baseArrayClass) != null;
    }

    public static boolean canDirectConvert(Class<?> sourceClass, Class<?> targetClass) {
        return TypeStore.canDirectConvert(sourceClass, targetClass, true);
    }

    private static boolean canDirectConvert(Class<?> sourceClass, Class<?> targetClass, boolean wrap) {
        Valid.notNull(sourceClass, "source class is null", new Object[0]);
        Valid.notNull(targetClass, "target class is null", new Object[0]);
        if (wrap) {
            sourceClass = Classes.getWrapClass(sourceClass);
            targetClass = Classes.getWrapClass(targetClass);
        }
        if (targetClass.equals(Object.class) || targetClass.equals(sourceClass)) {
            return true;
        }
        return Classes.isImplClass(targetClass, sourceClass);
    }

    static {
        new BasicTypeStoreProvider(STORE);
    }
}

