/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.crypto;

import cn.orionsec.kit.lang.define.wrapper.Pair;
import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.Strings;
import cn.orionsec.kit.lang.utils.codec.Base64s;
import cn.orionsec.kit.lang.utils.crypto.Keys;
import cn.orionsec.kit.lang.utils.crypto.enums.CipherAlgorithm;
import cn.orionsec.kit.lang.utils.crypto.enums.RSASignature;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;

public class RSA {
    public static final KeyFactory RSA_KEY_FACTORY;

    private RSA() {
    }

    public static String encrypt(String s, String publicKey) {
        byte[] bytes = RSA.encrypt(Strings.bytes(s), (PublicKey)RSA.getPublicKey(publicKey));
        if (bytes != null) {
            return new String(bytes);
        }
        return null;
    }

    public static String encrypt(String s, PublicKey publicKey) {
        byte[] bytes = RSA.encrypt(Strings.bytes(s), publicKey);
        if (bytes != null) {
            return new String(bytes);
        }
        return null;
    }

    public static byte[] encrypt(byte[] bs, String publicKey) {
        return RSA.encrypt(bs, (PublicKey)RSA.getPublicKey(publicKey));
    }

    public static byte[] encrypt(byte[] bs, PublicKey publicKey) {
        try {
            Cipher cipher = CipherAlgorithm.RSA.getCipher();
            cipher.init(1, publicKey);
            return Base64s.encode(cipher.doFinal(bs));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String decrypt(String s, String privateKey) {
        byte[] bytes = RSA.decrypt(Strings.bytes(s), (PrivateKey)RSA.getPrivateKey(privateKey));
        if (bytes != null) {
            return new String(bytes);
        }
        return null;
    }

    public static String decrypt(String s, PrivateKey privateKey) {
        byte[] bytes = RSA.decrypt(Strings.bytes(s), privateKey);
        if (bytes != null) {
            return new String(bytes);
        }
        return null;
    }

    public static byte[] decrypt(byte[] bs, String privateKey) {
        return RSA.decrypt(bs, (PrivateKey)RSA.getPrivateKey(privateKey));
    }

    public static byte[] decrypt(byte[] bs, PrivateKey privateKey) {
        try {
            Cipher cipher = CipherAlgorithm.RSA.getCipher();
            cipher.init(2, privateKey);
            return cipher.doFinal(Base64s.decode(bs));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String sign(String s, String privateKey) {
        byte[] bytes = RSA.sign(Strings.bytes(s), (PrivateKey)RSA.getPrivateKey(privateKey), RSASignature.MD5);
        if (bytes != null) {
            return new String(bytes);
        }
        return null;
    }

    public static String sign(String s, PrivateKey privateKey) {
        byte[] bytes = RSA.sign(Strings.bytes(s), privateKey, RSASignature.MD5);
        if (bytes != null) {
            return new String(bytes);
        }
        return null;
    }

    public static byte[] sign(byte[] bs, String privateKey) {
        return RSA.sign(bs, (PrivateKey)RSA.getPrivateKey(privateKey), RSASignature.MD5);
    }

    public static byte[] sign(byte[] bs, PrivateKey privateKey) {
        return RSA.sign(bs, privateKey, RSASignature.MD5);
    }

    public static String sign(String s, String privateKey, RSASignature signModel) {
        byte[] bytes = RSA.sign(Strings.bytes(s), (PrivateKey)RSA.getPrivateKey(privateKey), signModel);
        if (bytes != null) {
            return new String(bytes);
        }
        return null;
    }

    public static String sign(String s, PrivateKey privateKey, RSASignature signModel) {
        byte[] bytes = RSA.sign(Strings.bytes(s), privateKey, signModel);
        if (bytes != null) {
            return new String(bytes);
        }
        return null;
    }

    public static byte[] sign(byte[] bs, String privateKey, RSASignature signModel) {
        return RSA.sign(bs, (PrivateKey)RSA.getPrivateKey(privateKey), signModel);
    }

    public static byte[] sign(byte[] bs, PrivateKey privateKey, RSASignature signModel) {
        try {
            Signature signature = signModel.getSignature();
            signature.initSign(privateKey);
            signature.update(bs);
            return Base64s.encode(signature.sign());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean verify(String s, String publicKey, String sign) {
        return RSA.verify(Strings.bytes(s), (PublicKey)RSA.getPublicKey(publicKey), Strings.bytes(sign), RSASignature.MD5);
    }

    public static boolean verify(String s, PublicKey publicKey, String sign) {
        return RSA.verify(Strings.bytes(s), publicKey, Strings.bytes(sign), RSASignature.MD5);
    }

    public static boolean verify(byte[] bs, String publicKey, byte[] sign) {
        return RSA.verify(bs, (PublicKey)RSA.getPublicKey(publicKey), sign, RSASignature.MD5);
    }

    public static boolean verify(byte[] bs, PublicKey publicKey, byte[] sign) {
        return RSA.verify(bs, publicKey, sign, RSASignature.MD5);
    }

    public static boolean verify(String s, String publicKey, String sign, RSASignature signModel) {
        return RSA.verify(Strings.bytes(s), (PublicKey)RSA.getPublicKey(publicKey), Strings.bytes(sign), signModel);
    }

    public static boolean verify(String s, PublicKey publicKey, String sign, RSASignature signModel) {
        return RSA.verify(Strings.bytes(s), publicKey, Strings.bytes(sign), signModel);
    }

    public static boolean verify(byte[] bs, String publicKey, byte[] sign, RSASignature signModel) {
        return RSA.verify(bs, (PublicKey)RSA.getPublicKey(publicKey), sign, signModel);
    }

    public static boolean verify(byte[] bs, PublicKey publicKey, byte[] sign, RSASignature signModel) {
        try {
            Signature signature = signModel.getSignature();
            signature.initVerify(publicKey);
            signature.update(bs);
            return signature.verify(Base64s.decode(sign));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static RSAPrivateKey getPrivateKey(File file) {
        byte[] bytes = Strings.bytes(Keys.getKey(file), StandardCharsets.ISO_8859_1);
        return RSA.getPrivateKey(bytes);
    }

    public static RSAPrivateKey getPrivateKey(String key) {
        byte[] bytes = Strings.bytes(key, StandardCharsets.ISO_8859_1);
        return RSA.getPrivateKey(bytes);
    }

    public static RSAPrivateKey getPrivateKey(byte[] key) {
        try {
            PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(Base64s.decode(key));
            return (RSAPrivateKey)RSA_KEY_FACTORY.generatePrivate(spec);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static RSAPublicKey getPublicKey(File file) {
        byte[] bytes = Strings.bytes(Keys.getKey(file), StandardCharsets.ISO_8859_1);
        return RSA.getPublicKey(bytes);
    }

    public static RSAPublicKey getPublicKey(String key) {
        byte[] bytes = Strings.bytes(key, StandardCharsets.ISO_8859_1);
        return RSA.getPublicKey(bytes);
    }

    public static RSAPublicKey getPublicKey(byte[] key) {
        try {
            X509EncodedKeySpec spec = new X509EncodedKeySpec(Base64s.decode(key));
            return (RSAPublicKey)RSA_KEY_FACTORY.generatePublic(spec);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static RSAPublicKey getPublicKey(RSAPrivateKey key) {
        try {
            RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(key.getModulus(), ((RSAPrivateCrtKey)key).getPublicExponent());
            return (RSAPublicKey)RSA_KEY_FACTORY.generatePublic(publicKeySpec);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Pair<RSAPublicKey, RSAPrivateKey> generatorKeys() {
        return RSA.generatorKeys(1024);
    }

    public static Pair<RSAPublicKey, RSAPrivateKey> generatorKeys(int length) {
        try {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA");
            keyPairGen.initialize(length, new SecureRandom());
            KeyPair keyPair = keyPairGen.generateKeyPair();
            return Pair.of((RSAPublicKey)keyPair.getPublic(), (RSAPrivateKey)keyPair.getPrivate());
        }
        catch (Exception e) {
            throw Exceptions.runtime(e);
        }
    }

    static {
        try {
            RSA_KEY_FACTORY = KeyFactory.getInstance("RSA");
        }
        catch (Exception e) {
            throw Exceptions.unsupported("unsupported RSA algorithm", e);
        }
    }
}

