/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.io.compress;

import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.io.compress.CompressType;
import cn.orionsec.kit.lang.utils.io.compress.FileCompressor;
import cn.orionsec.kit.lang.utils.io.compress.FileDecompressor;
import cn.orionsec.kit.lang.utils.io.compress.bz2.Bz2Compressor;
import cn.orionsec.kit.lang.utils.io.compress.bz2.Bz2Decompressor;
import cn.orionsec.kit.lang.utils.io.compress.gz.GzCompressor;
import cn.orionsec.kit.lang.utils.io.compress.gz.GzDecompressor;
import cn.orionsec.kit.lang.utils.io.compress.jar.JarCompressor;
import cn.orionsec.kit.lang.utils.io.compress.jar.JarDecompressor;
import cn.orionsec.kit.lang.utils.io.compress.mix.TarBz2Compressor;
import cn.orionsec.kit.lang.utils.io.compress.mix.TarBz2Decompressor;
import cn.orionsec.kit.lang.utils.io.compress.mix.TarGzCompressor;
import cn.orionsec.kit.lang.utils.io.compress.mix.TarGzDecompressor;
import cn.orionsec.kit.lang.utils.io.compress.tar.TarCompressor;
import cn.orionsec.kit.lang.utils.io.compress.tar.TarDecompressor;
import cn.orionsec.kit.lang.utils.io.compress.z7.Z7Compressor;
import cn.orionsec.kit.lang.utils.io.compress.z7.Z7Decompressor;
import cn.orionsec.kit.lang.utils.io.compress.zip.ZipCompressor;
import cn.orionsec.kit.lang.utils.io.compress.zip.ZipDecompressor;
import java.util.Optional;
import java.util.function.Supplier;

public enum CompressTypeEnum implements CompressType<FileCompressor, FileDecompressor>
{
    ZIP("zip", ZipCompressor::new, ZipDecompressor::new),
    JAR("jar", JarCompressor::new, JarDecompressor::new),
    Z7("7z", Z7Compressor::new, Z7Decompressor::new),
    TAR_GZ("tar.gz", TarGzCompressor::new, TarGzDecompressor::new),
    TAR_BZ2("tar.bz2", TarBz2Compressor::new, TarBz2Decompressor::new),
    TAR("tar", TarCompressor::new, TarDecompressor::new),
    GZ("gz", GzCompressor::new, GzDecompressor::new),
    BZ2("bz2", Bz2Compressor::new, Bz2Decompressor::new);

    private final String suffix;
    private final Supplier<FileCompressor> compressor;
    private final Supplier<FileDecompressor> decompressor;

    private CompressTypeEnum(String suffix, Supplier<FileCompressor> compressor, Supplier<FileDecompressor> decompressor) {
        this.suffix = suffix;
        this.compressor = compressor;
        this.decompressor = decompressor;
    }

    @Override
    public Supplier<FileCompressor> compressor() {
        return this.compressor;
    }

    @Override
    public Supplier<FileDecompressor> decompressor() {
        return this.decompressor;
    }

    @Override
    public String suffix() {
        return this.suffix;
    }

    public static CompressTypeEnum of(String suffix) {
        if (suffix == null) {
            return null;
        }
        for (CompressTypeEnum value : CompressTypeEnum.values()) {
            if (!suffix.endsWith(value.suffix)) continue;
            return value;
        }
        return null;
    }

    public static FileCompressor getCompress(String suffix) {
        return Optional.ofNullable(CompressTypeEnum.of(suffix)).map(CompressTypeEnum::compressor).map(Supplier::get).orElseThrow(() -> Exceptions.unsupported("unsupported compress type"));
    }

    public static FileDecompressor getDecompress(String suffix) {
        return Optional.ofNullable(CompressTypeEnum.of(suffix)).map(CompressTypeEnum::decompressor).map(Supplier::get).orElseThrow(() -> Exceptions.unsupported("unsupported decompress type"));
    }
}

