/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.reflect;

import cn.orionsec.kit.lang.define.collect.ConcurrentReferenceHashMap;
import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.Strings;
import cn.orionsec.kit.lang.utils.Valid;
import cn.orionsec.kit.lang.utils.collect.Lists;
import cn.orionsec.kit.lang.utils.convert.TypeStore;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Fields {
    private static final Map<Class<?>, List<Field>> FIELD_CACHE = new ConcurrentReferenceHashMap(16, ConcurrentReferenceHashMap.ReferenceType.SOFT);

    private Fields() {
    }

    public static List<Field> getFieldsByCache(Class<?> clazz) {
        List<Field> fields = FIELD_CACHE.get(clazz);
        if (fields == null) {
            fields = Fields.getFields(clazz);
            FIELD_CACHE.put(clazz, fields);
        }
        return fields;
    }

    public static Field getFieldByCache(Class<?> clazz, String fieldName) {
        List<Field> fields = FIELD_CACHE.get(clazz);
        if (fields == null) {
            fields = Fields.getFields(clazz);
            FIELD_CACHE.put(clazz, fields);
        }
        if (fields == null) {
            return null;
        }
        for (Field field : fields) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    public static String getFieldNameByMethod(Method method) {
        if (method == null) {
            return null;
        }
        return Fields.getFieldNameByMethod(method.getName());
    }

    public static String getFieldNameByMethod(String methodName) {
        if (Strings.isBlank(methodName)) {
            return null;
        }
        methodName = methodName.trim();
        String fieldName = null;
        int length = methodName.length();
        if (methodName.startsWith("get") || methodName.startsWith("set")) {
            if (length != 3) {
                fieldName = methodName.substring(3, length);
            }
        } else if (methodName.startsWith("is") && length != 2) {
            fieldName = methodName.substring(2, length);
        }
        if (fieldName != null) {
            return Strings.firstLower(fieldName);
        }
        return null;
    }

    public static Field getFieldByMethod(Class<?> methodClass, Method method) {
        return Fields.getFieldByMethod(methodClass, method.getName());
    }

    public static Field getFieldByMethod(Class<?> methodClass, String methodName) {
        String fieldName = Fields.getFieldNameByMethod(methodName);
        if (fieldName != null) {
            return Fields.getAccessibleField(methodClass, fieldName);
        }
        return null;
    }

    public static <E> E getFieldValue(Object obj, String fieldName) {
        Valid.notNull(obj, "invoker object is null", new Object[0]);
        Valid.notBlank(fieldName, "invoke field is null", new Object[0]);
        Field field = Fields.getAccessibleField(obj.getClass(), fieldName);
        if (field == null) {
            throw Exceptions.invoke(Strings.format("get field value not found field: {}, class {}", fieldName, obj.getClass().getName()));
        }
        return Fields.getFieldValue(obj, field);
    }

    public static <E> E getFieldValue(Object obj, Field field) {
        Valid.notNull(obj, "invoker object is null", new Object[0]);
        Valid.notNull(field, "invoke field is null", new Object[0]);
        try {
            Fields.setAccessible(field);
            return (E)field.get(obj);
        }
        catch (Exception e) {
            throw Exceptions.invoke(Strings.format("get field value error: {}, field: {}, class: {}", e.getMessage(), field.getName(), obj.getClass().getName()), e);
        }
    }

    public static <E> void setFieldValue(Object obj, String fieldName, E value) {
        Valid.notNull(obj, "invoker object is null", new Object[0]);
        Valid.notBlank(fieldName, "invoke field is null", new Object[0]);
        Field field = Fields.getAccessibleField(obj.getClass(), fieldName);
        if (field == null) {
            throw Exceptions.invoke(Strings.format("set field value not found field: {}, class {}", fieldName, obj.getClass().getName()));
        }
        Fields.setFieldValue(obj, field, value);
    }

    public static <E> void setFieldValue(Object obj, Field field, E value) {
        Valid.notNull(obj, "invoker object is null", new Object[0]);
        Valid.notNull(field, "invoke field is null", new Object[0]);
        try {
            Fields.setAccessible(field);
            field.set(obj, value);
        }
        catch (Exception e) {
            throw Exceptions.invoke(Strings.format("set field value error: {}, field: {}, class: {}", e.getMessage(), field.getName(), obj.getClass().getName(), value), e);
        }
    }

    public static <E> void setFieldValueInfer(Object obj, String fieldName, E value) {
        Valid.notNull(obj, "invoker object is null", new Object[0]);
        Valid.notNull(fieldName, "invoke field is null", new Object[0]);
        Field field = Fields.getAccessibleField(obj.getClass(), fieldName);
        if (field == null) {
            throw Exceptions.invoke(Strings.format("set field value not found field: {}, class {}", fieldName, obj.getClass().getName()));
        }
        Fields.setFieldValueInfer(obj, field, value);
    }

    public static <E> void setFieldValueInfer(Object obj, Field field, E value) {
        Valid.notNull(obj, "invoker object is null", new Object[0]);
        Valid.notNull(field, "invoke field is null", new Object[0]);
        try {
            Fields.setAccessible(field);
            if (TypeStore.canConvert(value.getClass(), field.getType())) {
                field.set(obj, TypeStore.STORE.to(value, field.getType()));
                return;
            }
            throw Exceptions.invoke(Strings.format("could infer set field value, field: {}, class: {}", field.getName(), obj.getClass().getName()));
        }
        catch (Exception e) {
            throw Exceptions.invoke(Strings.format("set field value error: {}, field: {}, class: {}", e.getMessage(), field.getName(), obj.getClass().getName()), e);
        }
    }

    public static Map<String, Field> getFieldMap(Class<?> clazz) {
        List<Field> fieldList = Fields.getFields(clazz);
        return Lists.isNotEmpty(fieldList) ? fieldList.stream().collect(Collectors.toMap(Field::getName, field -> field)) : Collections.emptyMap();
    }

    public static List<Field> getFields(Class<?> clazz) {
        Valid.notNull(clazz, "field class is null", new Object[0]);
        if (clazz.getSuperclass() != null) {
            List<Field> fieldList = Stream.of(clazz.getDeclaredFields()).filter(field -> !Modifier.isStatic(field.getModifiers())).filter(field -> !Modifier.isTransient(field.getModifiers())).collect(Collectors.toList());
            Class<?> superClass = clazz.getSuperclass();
            Map fieldMap = fieldList.stream().collect(Collectors.toMap(Field::getName, Function.identity()));
            Fields.getFields(superClass).stream().filter(field -> !fieldMap.containsKey(field.getName())).forEach(fieldList::add);
            return fieldList;
        }
        return new ArrayList<Field>();
    }

    public static List<Field> getStaticFields(Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        return Arrays.stream(fields).filter(f -> Modifier.isStatic(f.getModifiers())).filter(f -> !Modifier.isTransient(f.getModifiers())).collect(Collectors.toCollection(ArrayList::new));
    }

    public static Field getAccessibleField(Class<?> clazz, String fieldName) {
        Valid.notNull(clazz, "field class is null", new Object[0]);
        for (Class<?> superClass = clazz; superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                Field field = superClass.getDeclaredField(fieldName);
                Fields.setAccessible(field);
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    public static void setAccessible(Field field) {
        Valid.notNull(field, "set accessible field class is null", new Object[0]);
        if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
            field.setAccessible(true);
        }
    }
}

