/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.unit;

import java.math.BigDecimal;
import java.math.RoundingMode;

public enum DistStorageUnit {
    BIT{

        @Override
        public BigDecimal toBit(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u;
        }

        @Override
        public BigDecimal toByte(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).divide(BIT_8, roundingMode);
        }

        @Override
        public BigDecimal toKilobyte(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).divide(BIT_8, roundingMode).divide(UNIT, roundingMode);
        }

        @Override
        public BigDecimal toMegabyte(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).divide(BIT_8, roundingMode).divide(UNIT, roundingMode).divide(UNIT, roundingMode);
        }

        @Override
        public BigDecimal toGigabyte(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).divide(BIT_8, roundingMode).divide(UNIT, roundingMode).divide(UNIT, roundingMode).divide(UNIT, roundingMode);
        }

        @Override
        public BigDecimal toTerabyte(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).divide(BIT_8, roundingMode).divide(UNIT, roundingMode).divide(UNIT, roundingMode).divide(UNIT, roundingMode).divide(UNIT, roundingMode);
        }
    }
    ,
    B{

        @Override
        public BigDecimal toBit(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).multiply(BIT_8);
        }

        @Override
        public BigDecimal toByte(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u;
        }

        @Override
        public BigDecimal toKilobyte(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).divide(UNIT, roundingMode);
        }

        @Override
        public BigDecimal toMegabyte(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).divide(UNIT, roundingMode).divide(UNIT, roundingMode);
        }

        @Override
        public BigDecimal toGigabyte(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).divide(UNIT, roundingMode).divide(UNIT, roundingMode).divide(UNIT, roundingMode);
        }

        @Override
        public BigDecimal toTerabyte(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).divide(UNIT, roundingMode).divide(UNIT, roundingMode).divide(UNIT, roundingMode).divide(UNIT, roundingMode);
        }
    }
    ,
    KB{

        @Override
        public BigDecimal toBit(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).multiply(BIT_8).multiply(UNIT);
        }

        @Override
        public BigDecimal toByte(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).multiply(UNIT);
        }

        @Override
        public BigDecimal toKilobyte(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u;
        }

        @Override
        public BigDecimal toMegabyte(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).divide(UNIT, roundingMode);
        }

        @Override
        public BigDecimal toGigabyte(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).divide(UNIT, roundingMode).divide(UNIT, roundingMode);
        }

        @Override
        public BigDecimal toTerabyte(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).divide(UNIT, roundingMode).divide(UNIT, roundingMode).divide(UNIT, roundingMode);
        }
    }
    ,
    MB{

        @Override
        public BigDecimal toBit(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).multiply(BIT_8).multiply(UNIT).multiply(UNIT);
        }

        @Override
        public BigDecimal toByte(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).multiply(UNIT).multiply(UNIT);
        }

        @Override
        public BigDecimal toKilobyte(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).multiply(UNIT);
        }

        @Override
        public BigDecimal toMegabyte(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u;
        }

        @Override
        public BigDecimal toGigabyte(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).divide(UNIT, roundingMode);
        }

        @Override
        public BigDecimal toTerabyte(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).divide(UNIT, roundingMode).divide(UNIT, roundingMode);
        }
    }
    ,
    GB{

        @Override
        public BigDecimal toBit(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).multiply(BIT_8).multiply(UNIT).multiply(UNIT).multiply(UNIT);
        }

        @Override
        public BigDecimal toByte(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).multiply(UNIT).multiply(UNIT).multiply(UNIT);
        }

        @Override
        public BigDecimal toKilobyte(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).multiply(UNIT).multiply(UNIT);
        }

        @Override
        public BigDecimal toMegabyte(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).multiply(UNIT);
        }

        @Override
        public BigDecimal toGigabyte(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u;
        }

        @Override
        public BigDecimal toTerabyte(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).divide(UNIT, roundingMode);
        }
    }
    ,
    TB{

        @Override
        public BigDecimal toBit(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).multiply(BIT_8).multiply(UNIT).multiply(UNIT).multiply(UNIT).multiply(UNIT);
        }

        @Override
        public BigDecimal toByte(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).multiply(UNIT).multiply(UNIT).multiply(UNIT).multiply(UNIT);
        }

        @Override
        public BigDecimal toKilobyte(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).multiply(UNIT).multiply(UNIT).multiply(UNIT);
        }

        @Override
        public BigDecimal toMegabyte(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).multiply(UNIT).multiply(UNIT);
        }

        @Override
        public BigDecimal toGigabyte(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).multiply(UNIT);
        }

        @Override
        public BigDecimal toTerabyte(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u;
        }
    };

    private static final BigDecimal BIT_8;
    private static final BigDecimal UNIT;
    private static final RoundingMode DEFAULT_ROUND_MODE;
    private static final int DEFAULT_SCALE = 2;

    public BigDecimal toBit(long u) {
        return this.toBit(BigDecimal.valueOf(u), 2, DEFAULT_ROUND_MODE);
    }

    public BigDecimal toBit(long u, int scale, RoundingMode roundingMode) {
        return this.toBit(BigDecimal.valueOf(u), scale, roundingMode);
    }

    public BigDecimal toBit(BigDecimal u) {
        return this.toBit(u, 2, DEFAULT_ROUND_MODE);
    }

    public abstract BigDecimal toBit(BigDecimal var1, int var2, RoundingMode var3);

    public BigDecimal toByte(long u) {
        return this.toByte(BigDecimal.valueOf(u), 2, DEFAULT_ROUND_MODE);
    }

    public BigDecimal toByte(long u, int scale, RoundingMode roundingMode) {
        return this.toByte(BigDecimal.valueOf(u), scale, roundingMode);
    }

    public BigDecimal toByte(BigDecimal u) {
        return this.toByte(u, 2, DEFAULT_ROUND_MODE);
    }

    public abstract BigDecimal toByte(BigDecimal var1, int var2, RoundingMode var3);

    public BigDecimal toKilobyte(long u) {
        return this.toKilobyte(BigDecimal.valueOf(u), 2, DEFAULT_ROUND_MODE);
    }

    public BigDecimal toKilobyte(long u, int scale, RoundingMode roundingMode) {
        return this.toKilobyte(BigDecimal.valueOf(u), scale, roundingMode);
    }

    public BigDecimal toKilobyte(BigDecimal u) {
        return this.toKilobyte(u, 2, DEFAULT_ROUND_MODE);
    }

    public abstract BigDecimal toKilobyte(BigDecimal var1, int var2, RoundingMode var3);

    public BigDecimal toMegabyte(long u) {
        return this.toMegabyte(BigDecimal.valueOf(u), 2, DEFAULT_ROUND_MODE);
    }

    public BigDecimal toMegabyte(long u, int scale, RoundingMode roundingMode) {
        return this.toMegabyte(BigDecimal.valueOf(u), scale, roundingMode);
    }

    public BigDecimal toMegabyte(BigDecimal u) {
        return this.toMegabyte(u, 2, DEFAULT_ROUND_MODE);
    }

    public abstract BigDecimal toMegabyte(BigDecimal var1, int var2, RoundingMode var3);

    public BigDecimal toGigabyte(long u) {
        return this.toGigabyte(BigDecimal.valueOf(u), 2, DEFAULT_ROUND_MODE);
    }

    public BigDecimal toGigabyte(long u, int scale, RoundingMode roundingMode) {
        return this.toGigabyte(BigDecimal.valueOf(u), scale, roundingMode);
    }

    public BigDecimal toGigabyte(BigDecimal u) {
        return this.toGigabyte(u, 2, DEFAULT_ROUND_MODE);
    }

    public abstract BigDecimal toGigabyte(BigDecimal var1, int var2, RoundingMode var3);

    public BigDecimal toTerabyte(long u) {
        return this.toTerabyte(BigDecimal.valueOf(u), 2, DEFAULT_ROUND_MODE);
    }

    public BigDecimal toTerabyte(long u, int scale, RoundingMode roundingMode) {
        return this.toTerabyte(BigDecimal.valueOf(u), scale, roundingMode);
    }

    public BigDecimal toTerabyte(BigDecimal u) {
        return this.toTerabyte(u, 2, DEFAULT_ROUND_MODE);
    }

    public abstract BigDecimal toTerabyte(BigDecimal var1, int var2, RoundingMode var3);

    static {
        BIT_8 = BigDecimal.valueOf(8L);
        UNIT = BigDecimal.valueOf(1024L);
        DEFAULT_ROUND_MODE = RoundingMode.FLOOR;
    }
}

