/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.define.cache;

import cn.orionsec.kit.lang.define.collect.ConcurrentReferenceHashMap;
import cn.orionsec.kit.lang.utils.Objects1;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;

public class SoftCache<K, V>
implements Iterable<Map.Entry<K, V>>,
Serializable {
    private final ConcurrentReferenceHashMap<K, V> CACHE = new ConcurrentReferenceHashMap(ConcurrentReferenceHashMap.ReferenceType.SOFT);
    private AtomicLong count;
    private AtomicLong hit;
    private boolean useHit;

    public SoftCache() {
        this(false);
    }

    public SoftCache(boolean useHit) {
        if (useHit) {
            this.count = new AtomicLong();
            this.hit = new AtomicLong();
            this.useHit = true;
        }
    }

    public SoftCache(Map<K, V> m) {
        this(false);
        this.CACHE.putAll(m);
    }

    public SoftCache(Map<K, V> m, boolean useHit) {
        this(useHit);
        this.CACHE.putAll(m);
    }

    public static <K, V> SoftCache<K, V> create() {
        return new SoftCache<K, V>();
    }

    public static <K, V> SoftCache<K, V> create(boolean useHit) {
        return new SoftCache<K, V>(useHit);
    }

    public static <K, V> SoftCache<K, V> create(Map<K, V> m) {
        return new SoftCache<K, V>(m);
    }

    public static <K, V> SoftCache<K, V> create(Map<K, V> m, boolean useHit) {
        return new SoftCache<K, V>(m, useHit);
    }

    public V get(K key) {
        V v = this.CACHE.get(key);
        if (this.useHit) {
            this.count.incrementAndGet();
            if (v != null) {
                this.hit.incrementAndGet();
            }
        }
        return v;
    }

    public V get(K key, V def) {
        return Objects1.def(this.get(key), def);
    }

    public V put(K key, V value) {
        return this.CACHE.put(key, value);
    }

    public V remove(K key) {
        return this.CACHE.remove(key);
    }

    public void clear() {
        this.CACHE.clear();
    }

    public long getCounts() {
        return this.useHit ? this.count.get() : 0L;
    }

    public long getHits() {
        return this.useHit ? this.hit.get() : 0L;
    }

    public double getHitsRate() {
        return this.useHit ? (double)this.hit.get() / (double)this.count.get() : 0.0;
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.CACHE.entrySet().iterator();
    }

    @Override
    public void forEach(Consumer<? super Map.Entry<K, V>> action) {
        this.CACHE.entrySet().forEach(action);
    }
}

