/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.define.cache.key;

import cn.orionsec.kit.lang.define.cache.key.struct.CacheStruct;
import cn.orionsec.kit.lang.define.cache.key.struct.RedisCacheStruct;
import cn.orionsec.kit.lang.utils.Strings;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class CacheKeyDefine
implements Serializable {
    protected static final CacheStruct DEFAULT_STRUCT = RedisCacheStruct.STRING;
    protected static final long DEFAULT_TIMEOUT = 0L;
    protected static final TimeUnit DEFAULT_UNIT = TimeUnit.MILLISECONDS;
    private final String key;
    private final String desc;
    private final Class<?> type;
    private final CacheStruct struct;
    private long timeout;
    private TimeUnit unit;

    public CacheKeyDefine(String key) {
        this(key, "", null, DEFAULT_STRUCT, 0L, DEFAULT_UNIT);
    }

    public CacheKeyDefine(String key, String desc, Class<?> type, CacheStruct struct, long timeout, TimeUnit unit) {
        this.key = key;
        this.desc = desc;
        this.type = type;
        this.struct = struct;
        this.timeout = timeout;
        this.unit = unit;
    }

    public String format(Object ... param) {
        return Strings.format(this.key, param);
    }

    public String format(Map<?, ?> map) {
        return Strings.format(this.key, map);
    }

    public String getKey() {
        return this.key;
    }

    public String getDesc() {
        return this.desc;
    }

    public Class<?> getType() {
        return this.type;
    }

    public CacheStruct getStruct() {
        return this.struct;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public void setUnit(TimeUnit unit) {
        this.unit = unit;
    }

    public String toString() {
        return this.struct + " " + this.key + " (" + this.desc + ") [" + this.type.getSimpleName() + "] timeout: " + this.timeout + " " + this.unit.name();
    }
}

