/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.define.collect;

import cn.orionsec.kit.lang.constant.Const;
import cn.orionsec.kit.lang.utils.Valid;
import java.io.Serializable;
import java.util.concurrent.ConcurrentLinkedDeque;

public class FixedDeque<E>
extends ConcurrentLinkedDeque<E>
implements Serializable {
    private static final long serialVersionUID = 923412312354068942L;
    private final int maxSize;

    public FixedDeque(int maxSize) {
        this.maxSize = Valid.gt(maxSize, Const.N_0);
    }

    public static <E> FixedDeque<E> create(int maxSize) {
        return new FixedDeque<E>(maxSize);
    }

    @Override
    public boolean offerFirst(E s) {
        if (this.isFull()) {
            this.pollLast();
        }
        return super.offerFirst(s);
    }

    @Override
    public boolean offerLast(E s) {
        if (this.isFull()) {
            this.pollFirst();
        }
        return super.offerLast(s);
    }

    public boolean isFull() {
        return this.size() >= this.maxSize;
    }
}

