/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.define.iterator;

import cn.orionsec.kit.lang.utils.Arrays1;
import cn.orionsec.kit.lang.utils.Exceptions;
import java.io.Serializable;
import java.util.Iterator;

public class ArrayIterator<E>
implements Iterator<E>,
Iterable<E>,
Serializable {
    private static final long serialVersionUID = 1832735384832234L;
    private final E[] array;
    private int startIndex;
    private int endIndex;
    private int index;

    public ArrayIterator(E[] array) {
        this(array, 0);
    }

    public ArrayIterator(E[] array, int startIndex) {
        this(array, startIndex, -1);
    }

    public ArrayIterator(E[] array, int startIndex, int endIndex) {
        this.endIndex = Arrays1.length(array);
        if (endIndex > 0 && endIndex < this.endIndex) {
            this.endIndex = endIndex;
        }
        if (startIndex >= 0 && startIndex < this.endIndex) {
            this.startIndex = startIndex;
        }
        this.array = array;
        this.index = this.startIndex;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.endIndex;
    }

    @Override
    public E next() {
        if (this.hasNext()) {
            return this.array[this.index++];
        }
        throw Exceptions.noSuchElement();
    }

    @Override
    public void remove() {
        throw Exceptions.unsupported("this is a read-only iterator");
    }

    public void reset() {
        this.index = this.startIndex;
    }

    @Override
    public Iterator<E> iterator() {
        return this;
    }

    public E[] getArray() {
        return this.array;
    }
}

