/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.define.wrapper;

import cn.orionsec.kit.lang.KitLangConfiguration;
import cn.orionsec.kit.lang.able.ILogObject;
import cn.orionsec.kit.lang.able.IMapObject;
import cn.orionsec.kit.lang.config.KitConfig;
import cn.orionsec.kit.lang.define.support.CloneSupport;
import cn.orionsec.kit.lang.define.wrapper.CodeInfo;
import cn.orionsec.kit.lang.define.wrapper.RpcWrapper;
import cn.orionsec.kit.lang.define.wrapper.Wrapper;
import cn.orionsec.kit.lang.utils.Objects1;
import cn.orionsec.kit.lang.utils.Strings;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class HttpWrapper<T>
extends CloneSupport<HttpWrapper<T>>
implements Wrapper<T>,
ILogObject,
IMapObject<String, Object> {
    private static final long serialVersionUID = 7048691672612601L;
    public static final Integer HTTP_OK_CODE = (Integer)KitConfig.get(KitLangConfiguration.CONFIG.HTTP_OK_CODE);
    public static final String HTTP_OK_MESSAGE = (String)KitConfig.get(KitLangConfiguration.CONFIG.HTTP_OK_MESSAGE);
    public static final Integer HTTP_ERROR_CODE = (Integer)KitConfig.get(KitLangConfiguration.CONFIG.HTTP_ERROR_CODE);
    public static final String HTTP_ERROR_MESSAGE = (String)KitConfig.get(KitLangConfiguration.CONFIG.HTTP_ERROR_MESSAGE);
    @JSONField(ordinal=0)
    private int code;
    @JSONField(ordinal=1)
    private String msg;
    @JSONField(ordinal=2)
    private T data;

    public HttpWrapper() {
        this(HTTP_OK_CODE, HTTP_OK_MESSAGE, null);
    }

    public HttpWrapper(int code) {
        this(code, HTTP_OK_MESSAGE, null);
    }

    public HttpWrapper(int code, String msg) {
        this(code, msg, null);
    }

    public HttpWrapper(int code, String msg, T data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public HttpWrapper(CodeInfo info) {
        this(info.code(), info.message(), null);
    }

    public HttpWrapper(CodeInfo info, T data) {
        this(info.code(), info.message(), data);
    }

    public static <T> HttpWrapper<T> get() {
        return new HttpWrapper<T>();
    }

    public static <T> HttpWrapper<T> of(CodeInfo info) {
        return new HttpWrapper<T>(info.code(), info.message());
    }

    public static <T> HttpWrapper<T> of(CodeInfo info, T data) {
        return new HttpWrapper<T>(info.code(), info.message(), data);
    }

    public static <T> HttpWrapper<T> of(int code, String msg) {
        return new HttpWrapper<T>(code, msg);
    }

    public static <T> HttpWrapper<T> of(int code, String msg, T data) {
        return new HttpWrapper<T>(code, msg, data);
    }

    public static <T> HttpWrapper<T> ok() {
        return new HttpWrapper<T>(HTTP_OK_CODE, HTTP_OK_MESSAGE);
    }

    public static <T> HttpWrapper<T> ok(T data) {
        return new HttpWrapper<T>(HTTP_OK_CODE, HTTP_OK_MESSAGE, data);
    }

    public static <T> HttpWrapper<T> error() {
        return new HttpWrapper<T>(HTTP_ERROR_CODE, HTTP_ERROR_MESSAGE);
    }

    public static <T> HttpWrapper<T> error(String msg) {
        return new HttpWrapper<T>(HTTP_ERROR_CODE, msg);
    }

    public static <T> HttpWrapper<T> error(String msg, Object ... params) {
        return new HttpWrapper<T>(HTTP_ERROR_CODE, Strings.format(msg, params));
    }

    public static <T> HttpWrapper<T> error(Throwable t) {
        if (t == null) {
            return new HttpWrapper<T>(HTTP_ERROR_CODE, HTTP_ERROR_MESSAGE);
        }
        return new HttpWrapper<T>(HTTP_ERROR_CODE, t.getMessage());
    }

    public HttpWrapper<T> code(int code) {
        this.code = code;
        return this;
    }

    public HttpWrapper<T> msg(String msg) {
        this.msg = msg;
        return this;
    }

    public HttpWrapper<T> data(T data) {
        this.data = data;
        return this;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setData(T data) {
        this.data = data;
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public boolean isOk() {
        return HTTP_OK_CODE.equals(this.code);
    }

    public String toString() {
        return this.toJsonString();
    }

    @Override
    public String toLogString() {
        return "HttpWrapper:\n  code ==> " + this.code + "\n   msg ==> " + this.msg + "\n  data ==> " + Objects1.toString(this.data);
    }

    @Override
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("code", this.code);
        map.put("msg", this.msg);
        map.put("data", this.data);
        return map;
    }

    public <E> HttpWrapper<E> map(Function<T, E> mapping) {
        HttpWrapper<T> result = new HttpWrapper<T>();
        result.code = this.code;
        result.msg = this.msg;
        result.data = Objects1.map(this.data, mapping);
        return result;
    }

    public RpcWrapper<T> toRpcWrapper() {
        return new RpcWrapper<T>(this.code, this.msg, this.data);
    }

    public Optional<T> optional() {
        return Optional.of(this).filter(HttpWrapper::isOk).map(HttpWrapper::getData);
    }
}

