/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.define.wrapper;

import cn.orionsec.kit.lang.KitLangConfiguration;
import cn.orionsec.kit.lang.able.IJsonObject;
import cn.orionsec.kit.lang.config.KitConfig;
import cn.orionsec.kit.lang.define.iterator.EmptyIterator;
import cn.orionsec.kit.lang.define.support.CloneSupport;
import cn.orionsec.kit.lang.define.wrapper.DataGrid;
import cn.orionsec.kit.lang.define.wrapper.IPageRequest;
import cn.orionsec.kit.lang.utils.collect.Lists;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

public class Pager<T>
extends CloneSupport<Pager<T>>
implements Serializable,
IJsonObject,
Iterable<T> {
    private static final long serialVersionUID = 6354348839019830L;
    private static final int DEFAULT_LIMIT = (Integer)KitConfig.get(KitLangConfiguration.CONFIG.PAGER_DEFAULT_LIMIT);
    private int page;
    private int limit;
    private List<T> rows;
    private int offset;
    private int pages;
    private int total;
    private int prePage;
    private int nextPage;
    private String sql;

    public Pager() {
        this(1, DEFAULT_LIMIT);
    }

    public Pager(int page) {
        this(page, DEFAULT_LIMIT);
    }

    public Pager(IPageRequest request) {
        this(request.getPage(), request.getLimit());
    }

    public Pager(int page, int limit) {
        this.page = page;
        this.limit = limit;
        this.prePage = 1;
        this.nextPage = 1;
        this.resetOffset();
    }

    public static <T> Pager<T> of() {
        return new Pager<T>(1, DEFAULT_LIMIT);
    }

    public static <T> Pager<T> of(int page) {
        return new Pager<T>(page, DEFAULT_LIMIT);
    }

    public static <T> Pager<T> of(int page, int limit) {
        return new Pager<T>(page, limit);
    }

    public static <T> Pager<T> of(IPageRequest request) {
        return new Pager<T>(request);
    }

    public static boolean hasMoreData(int count, Pager<?> pager) {
        if (pager == null) {
            return count != 0;
        }
        return pager.offset < count;
    }

    public boolean hasMoreData() {
        return Pager.hasMoreData(this.total, this);
    }

    public boolean hasMoreData(int count) {
        return Pager.hasMoreData(count, this);
    }

    public List<T> getRows() {
        return this.rows;
    }

    public void setRows(List<T> rows) {
        this.rows = rows;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
        this.resetOffset();
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
        this.resetOffset();
    }

    public int getPages() {
        return this.pages;
    }

    public void setPages(int pages) {
        this.pages = pages;
        this.prePage = this.page - 1;
        this.nextPage = this.page + 1;
        if (this.page <= 1) {
            this.prePage = 1;
        }
        if (this.page >= this.pages) {
            this.nextPage = this.pages;
        }
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
        if (total != 0) {
            this.setPages(total % this.limit == 0 ? total / this.limit : total / this.limit + 1);
        }
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
        this.sql = "LIMIT " + offset + ", " + this.limit;
    }

    public int getPrePage() {
        return this.prePage;
    }

    public void setPrePage(int prePage) {
        this.prePage = prePage;
    }

    public int getNextPage() {
        return this.nextPage;
    }

    public void setNextPage(int nextPage) {
        this.nextPage = nextPage;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public Pager<T> toNextPage() {
        this.setPages(this.page + 1);
        return this;
    }

    public Pager<T> toNextPage(int nextPage) {
        this.setPages(this.page + nextPage);
        return this;
    }

    private void resetOffset() {
        this.setOffset((this.page - 1) * this.limit);
    }

    public DataGrid<T> toDataGrid() {
        return new DataGrid(this);
    }

    public static int getPages(int total, Pager<?> pager) {
        if (pager == null) {
            return total >= 1 ? 1 : 0;
        }
        int limit = pager.getLimit();
        if (limit == 0) {
            return total >= 1 ? 1 : 0;
        }
        return total % limit == 0 ? total / limit : total / limit + 1;
    }

    public static int getPages(int total, int limit) {
        if (limit == 0) {
            return total >= 1 ? 1 : 0;
        }
        return total % limit == 0 ? total / limit : total / limit + 1;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public boolean isEmpty() {
        return Lists.isEmpty(this.rows);
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public boolean isNotEmpty() {
        return Lists.isNotEmpty(this.rows);
    }

    public Stream<T> stream() {
        if (this.isEmpty()) {
            return Stream.empty();
        }
        return this.rows.stream();
    }

    public <E> Pager<E> map(Function<T, E> mapping) {
        Pager<T> result = new Pager<T>();
        result.page = this.page;
        result.limit = this.limit;
        result.offset = this.offset;
        result.pages = this.pages;
        result.total = this.total;
        result.prePage = this.prePage;
        result.nextPage = this.nextPage;
        result.sql = this.sql;
        result.rows = Lists.map(this.rows, mapping);
        return result;
    }

    public String toString() {
        return this.sql;
    }

    @Override
    public Iterator<T> iterator() {
        if (!this.isEmpty()) {
            return this.rows.iterator();
        }
        return new EmptyIterator();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        if (!this.isEmpty()) {
            this.rows.forEach(action);
        }
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.rows.spliterator();
    }
}

