/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.id;

import cn.orionsec.kit.lang.able.IdGenerator;
import cn.orionsec.kit.lang.utils.random.Randoms;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;

public class ObjectIdWorker
implements IdGenerator<String> {
    private final AtomicInteger seq;
    private final int machineCode;

    public ObjectIdWorker(int machineCode) {
        this.machineCode = machineCode;
        this.seq = new AtomicInteger(Randoms.randomInt());
    }

    public byte[] nextBytes() {
        ByteBuffer bb = ByteBuffer.wrap(new byte[12]);
        bb.putInt((int)(System.currentTimeMillis() / 1000L));
        bb.putInt(this.machineCode);
        bb.putInt(this.seq.getAndIncrement());
        return bb.array();
    }

    @Override
    public String nextId() {
        return this.nextId(false);
    }

    public String nextId(boolean symbol) {
        byte[] array = this.nextBytes();
        StringBuilder buf = new StringBuilder(symbol ? 26 : 24);
        for (int i = 0; i < array.length; ++i) {
            int t;
            if (symbol && i % 4 == 0 && i != 0) {
                buf.append("-");
            }
            if ((t = array[i] & 0xFF) < 16) {
                buf.append('0');
            }
            buf.append(Integer.toHexString(t));
        }
        return buf.toString();
    }

    public int getMachineCode() {
        return this.machineCode;
    }
}

